/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.impl.client.cache.URIExtractor;

@ThreadSafe
class CacheInvalidator {
    private final HttpCacheStorage storage;
    private final URIExtractor uriExtractor;
    private final Log log = LogFactory.getLog(this.getClass());

    public CacheInvalidator(URIExtractor uriExtractor, HttpCacheStorage storage) {
        this.uriExtractor = uriExtractor;
        this.storage = storage;
    }

    public void flushInvalidatedCacheEntries(HttpHost host, HttpRequest req) throws IOException {
        if (this.requestShouldNotBeCached(req)) {
            Header lHdr;
            String contentLocation;
            URL reqURL;
            this.log.debug((Object)"Request should not be cached");
            String theUri = this.uriExtractor.getURI(host, req);
            HttpCacheEntry parent = this.storage.getEntry(theUri);
            this.log.debug((Object)("parent entry: " + parent));
            if (parent != null) {
                for (String variantURI : parent.getVariantURIs()) {
                    this.storage.removeEntry(variantURI);
                }
                this.storage.removeEntry(theUri);
            }
            try {
                reqURL = new URL(theUri);
            }
            catch (MalformedURLException mue) {
                this.log.error((Object)"Couldn't transform request into valid URL");
                return;
            }
            Header clHdr = req.getFirstHeader("Content-Location");
            if (clHdr != null && !this.flushAbsoluteUriFromSameHost(reqURL, contentLocation = clHdr.getValue())) {
                this.flushRelativeUriFromSameHost(reqURL, contentLocation);
            }
            if ((lHdr = req.getFirstHeader("Location")) != null) {
                this.flushAbsoluteUriFromSameHost(reqURL, lHdr.getValue());
            }
        }
    }

    protected void flushUriIfSameHost(URL requestURL, URL targetURL) throws IOException {
        URL canonicalTarget = new URL(this.uriExtractor.canonicalizeUri(targetURL.toString()));
        if (canonicalTarget.getAuthority().equalsIgnoreCase(requestURL.getAuthority())) {
            this.storage.removeEntry(canonicalTarget.toString());
        }
    }

    protected void flushRelativeUriFromSameHost(URL reqURL, String relUri) throws IOException {
        URL relURL;
        try {
            relURL = new URL(reqURL, relUri);
        }
        catch (MalformedURLException e) {
            this.log.debug((Object)"Invalid relative URI", (Throwable)e);
            return;
        }
        this.flushUriIfSameHost(reqURL, relURL);
    }

    protected boolean flushAbsoluteUriFromSameHost(URL reqURL, String uri) throws IOException {
        URL absURL;
        try {
            absURL = new URL(uri);
        }
        catch (MalformedURLException mue) {
            return false;
        }
        this.flushUriIfSameHost(reqURL, absURL);
        return true;
    }

    protected boolean requestShouldNotBeCached(HttpRequest req) {
        String method = req.getRequestLine().getMethod();
        return this.notGetOrHeadRequest(method);
    }

    private boolean notGetOrHeadRequest(String method) {
        return !"GET".equals(method) && !"HEAD".equals(method);
    }
}

