/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.Immutable;
import org.apache.http.impl.client.cache.CachingHttpClient;
import org.apache.http.impl.cookie.DateParseException;
import org.apache.http.impl.cookie.DateUtils;

@Immutable
public class ResponseCachingPolicy {
    private final int maxObjectSizeBytes;
    private final Log log = LogFactory.getLog(this.getClass());

    public ResponseCachingPolicy(int maxObjectSizeBytes) {
        this.maxObjectSizeBytes = maxObjectSizeBytes;
    }

    public boolean isResponseCacheable(String httpMethod, HttpResponse response) {
        int contentLengthValue;
        boolean cacheable = false;
        if (!"GET".equals(httpMethod)) {
            this.log.debug((Object)"Response was not cacheable.");
            return false;
        }
        switch (response.getStatusLine().getStatusCode()) {
            case 200: 
            case 203: 
            case 300: 
            case 301: 
            case 410: {
                cacheable = true;
                this.log.debug((Object)"Response was cacheable");
                break;
            }
            case 206: {
                this.log.debug((Object)"Response was not cacheable (Partial Content)");
                return cacheable;
            }
            default: {
                this.log.debug((Object)"Response was not cacheable (Unknown Status code)");
                return cacheable;
            }
        }
        Header contentLength = response.getFirstHeader("Content-Length");
        if (contentLength != null && (contentLengthValue = Integer.parseInt(contentLength.getValue())) > this.maxObjectSizeBytes) {
            return false;
        }
        Header[] ageHeaders = response.getHeaders("Age");
        if (ageHeaders.length > 1) {
            return false;
        }
        Header[] expiresHeaders = response.getHeaders("Expires");
        if (expiresHeaders.length > 1) {
            return false;
        }
        Header[] dateHeaders = response.getHeaders("Date");
        if (dateHeaders.length != 1) {
            return false;
        }
        try {
            DateUtils.parseDate((String)dateHeaders[0].getValue());
        }
        catch (DateParseException dpe) {
            return false;
        }
        for (Header varyHdr : response.getHeaders("Vary")) {
            for (HeaderElement elem : varyHdr.getElements()) {
                if (!"*".equals(elem.getName())) continue;
                return false;
            }
        }
        if (this.isExplicitlyNonCacheable(response)) {
            return false;
        }
        return cacheable || this.isExplicitlyCacheable(response);
    }

    protected boolean isExplicitlyNonCacheable(HttpResponse response) {
        Header[] cacheControlHeaders;
        for (Header header : cacheControlHeaders = response.getHeaders("Cache-Control")) {
            for (HeaderElement elem : header.getElements()) {
                if (!"no-store".equals(elem.getName()) && !"no-cache".equals(elem.getName()) && !"private".equals(elem.getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isExplicitlyCacheable(HttpResponse response) {
        Header[] cacheControlHeaders;
        if (response.getFirstHeader("Expires") != null) {
            return true;
        }
        for (Header header : cacheControlHeaders = response.getHeaders("Cache-Control")) {
            for (HeaderElement elem : header.getElements()) {
                if (!"max-age".equals(elem.getName()) && !"s-maxage".equals(elem.getName()) && !"must-revalidate".equals(elem.getName()) && !"proxy-revalidate".equals(elem.getName()) && !"public".equals(elem.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isResponseCacheable(HttpRequest request, HttpResponse response) {
        if (this.requestProtocolGreaterThanAccepted(request)) {
            this.log.debug((Object)"Response was not cacheable.");
            return false;
        }
        if (request.getRequestLine().getUri().contains("?") && !this.isExplicitlyCacheable(response)) {
            this.log.debug((Object)"Response was not cacheable.");
            return false;
        }
        String method = request.getRequestLine().getMethod();
        return this.isResponseCacheable(method, response);
    }

    private boolean requestProtocolGreaterThanAccepted(HttpRequest req) {
        return req.getProtocolVersion().compareToVersion(CachingHttpClient.HTTP_1_1) > 0;
    }
}

