/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.IOException;
import java.io.InputStream;

class CombinedInputStream
extends InputStream {
    private final InputStream inputStream1;
    private final InputStream inputStream2;

    public CombinedInputStream(InputStream inputStream1, InputStream inputStream2) {
        if (inputStream1 == null) {
            throw new IllegalArgumentException("inputStream1 cannot be null");
        }
        if (inputStream2 == null) {
            throw new IllegalArgumentException("inputStream2 cannot be null");
        }
        this.inputStream1 = inputStream1;
        this.inputStream2 = inputStream2;
    }

    public int available() throws IOException {
        return this.inputStream1.available() + this.inputStream2.available();
    }

    public int read() throws IOException {
        int result = this.inputStream1.read();
        if (result == -1) {
            result = this.inputStream2.read();
        }
        return result;
    }
}

