/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.client.methods;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.HttpAsyncResponseConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpAsyncResponseConsumer<T>
implements HttpAsyncResponseConsumer<T> {
    private volatile HttpResponse response;
    private volatile Exception ex;
    private volatile boolean completed;
    private volatile T result;

    protected abstract void onResponseReceived(HttpResponse var1);

    protected abstract void onContentReceived(ContentDecoder var1, IOControl var2) throws IOException;

    protected abstract void onCleanup();

    protected abstract T buildResult() throws Exception;

    void releaseResources() {
        this.onCleanup();
    }

    @Override
    public synchronized void responseReceived(HttpResponse response) throws IOException, HttpException {
        if (this.response != null) {
            throw new IllegalStateException("HTTP response already set");
        }
        this.response = response;
        this.onResponseReceived(this.response);
    }

    @Override
    public synchronized void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        this.onContentReceived(decoder, ioctrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void responseCompleted() {
        if (this.completed) {
            return;
        }
        this.completed = true;
        try {
            this.result = this.buildResult();
        }
        catch (Exception ex) {
            this.ex = ex;
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    public synchronized void cancel() {
        if (this.completed) {
            return;
        }
        this.completed = true;
        this.response = null;
        this.releaseResources();
    }

    @Override
    public synchronized void failed(Exception ex) {
        if (this.completed) {
            return;
        }
        this.completed = true;
        this.ex = ex;
        this.response = null;
        this.releaseResources();
    }

    @Override
    public Exception getException() {
        return this.ex;
    }

    @Override
    public T getResult() {
        return this.result;
    }
}

