/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.conn;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.RouteTracker;
import org.apache.http.impl.nio.pool.PoolEntry;
import org.apache.http.nio.reactor.IOSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpPoolEntry
extends PoolEntry<HttpRoute> {
    private final Log log;
    private final RouteTracker tracker;

    HttpPoolEntry(Log log, HttpRoute route, IOSession session, long timeToLive, TimeUnit tunit) {
        super(route, session, timeToLive, tunit);
        this.log = log;
        this.tracker = new RouteTracker(route);
    }

    @Override
    public IOSession getIOSession() {
        return super.getIOSession();
    }

    public HttpRoute getPlannedRoute() {
        return (HttpRoute)super.getRoute();
    }

    @Override
    public Object getState() {
        return super.getState();
    }

    @Override
    public void setState(Object state) {
        super.setState(state);
    }

    protected RouteTracker getTracker() {
        return this.tracker;
    }

    public HttpRoute getEffectiveRoute() {
        return this.tracker.toRoute();
    }

    @Override
    public boolean isExpired(long now) {
        boolean expired = super.isExpired(now);
        if (expired && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Connection " + this + " expired @ " + new Date(this.getExpiry())));
        }
        return expired;
    }
}

