/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.win;

import com.sun.jna.platform.win32.Secur32;
import com.sun.jna.platform.win32.Secur32Util;
import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.SspiUtil;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.ptr.IntByReference;
import java.security.Principal;
import org.apache.commons.codec.binary.Base64;
import org.apache.hc.client5.http.RouteInfo;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthSchemes;
import org.apache.hc.client5.http.auth.AuthenticationException;
import org.apache.hc.client5.http.auth.BasicUserPrincipal;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.MalformedChallengeException;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Experimental;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class WindowsNegotiateScheme
implements AuthScheme {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String scheme;
    private final String servicePrincipalName;
    private ChallengeType challengeType;
    private String challenge;
    private Sspi.CredHandle clientCred;
    private Sspi.CtxtHandle sspiContext;
    private boolean continueNeeded;

    WindowsNegotiateScheme(String scheme, String servicePrincipalName) {
        this.scheme = scheme == null ? AuthSchemes.SPNEGO.ident : scheme;
        this.continueNeeded = true;
        this.servicePrincipalName = servicePrincipalName;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created WindowsNegotiateScheme using " + this.scheme);
        }
    }

    public void dispose() {
        int rc;
        if (this.clientCred != null && !this.clientCred.isNull() && 0 != (rc = Secur32.INSTANCE.FreeCredentialsHandle(this.clientCred))) {
            throw new Win32Exception(rc);
        }
        if (this.sspiContext != null && !this.sspiContext.isNull() && 0 != (rc = Secur32.INSTANCE.DeleteSecurityContext(this.sspiContext))) {
            throw new Win32Exception(rc);
        }
        this.continueNeeded = true;
        this.clientCred = null;
        this.sspiContext = null;
    }

    public String getName() {
        return this.scheme;
    }

    public boolean isConnectionBased() {
        return true;
    }

    public String getRealm() {
        return null;
    }

    public void processChallenge(AuthChallenge authChallenge, HttpContext context) throws MalformedChallengeException {
        Args.notNull((Object)authChallenge, (String)"AuthChallenge");
        if (authChallenge.getValue() == null) {
            throw new MalformedChallengeException("Missing auth challenge");
        }
        this.challengeType = authChallenge.getChallengeType();
        this.challenge = authChallenge.getValue();
        if (this.challenge.isEmpty() && this.clientCred != null) {
            this.dispose();
            if (this.continueNeeded) {
                throw new IllegalStateException("Unexpected token");
            }
        }
    }

    public boolean isResponseReady(HttpHost host, CredentialsProvider credentialsProvider, HttpContext context) throws AuthenticationException {
        return true;
    }

    public static String getCurrentUsername() {
        return Secur32Util.getUserNameEx((int)2);
    }

    public Principal getPrincipal() {
        return new BasicUserPrincipal(WindowsNegotiateScheme.getCurrentUsername());
    }

    public String generateAuthResponse(HttpHost host, HttpRequest request, HttpContext context) throws AuthenticationException {
        String response;
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        if (this.clientCred == null) {
            try {
                String username = WindowsNegotiateScheme.getCurrentUsername();
                Sspi.TimeStamp lifetime = new Sspi.TimeStamp();
                this.clientCred = new Sspi.CredHandle();
                int rc = Secur32.INSTANCE.AcquireCredentialsHandle(username, this.scheme, 2, null, null, null, null, this.clientCred, lifetime);
                if (0 != rc) {
                    throw new Win32Exception(rc);
                }
                String targetName = this.getServicePrincipalName(request, clientContext);
                response = this.getToken(null, null, targetName);
            }
            catch (RuntimeException ex) {
                this.failAuthCleanup();
                if (ex instanceof Win32Exception) {
                    throw new AuthenticationException("Authentication Failed", (Throwable)ex);
                }
                throw ex;
            }
        }
        if (this.challenge == null || this.challenge.isEmpty()) {
            this.failAuthCleanup();
            throw new AuthenticationException("Authentication Failed");
        }
        try {
            byte[] continueTokenBytes = Base64.decodeBase64((String)this.challenge);
            SspiUtil.ManagedSecBufferDesc continueTokenBuffer = new SspiUtil.ManagedSecBufferDesc(2, continueTokenBytes);
            String targetName = this.getServicePrincipalName(request, clientContext);
            response = this.getToken(this.sspiContext, (Sspi.SecBufferDesc)continueTokenBuffer, targetName);
        }
        catch (RuntimeException ex) {
            this.failAuthCleanup();
            if (ex instanceof Win32Exception) {
                throw new AuthenticationException("Authentication Failed", (Throwable)ex);
            }
            throw ex;
        }
        return this.scheme + " " + response;
    }

    private void failAuthCleanup() {
        this.dispose();
        this.continueNeeded = false;
    }

    private String getServicePrincipalName(HttpRequest request, HttpClientContext clientContext) {
        RouteInfo route;
        URIAuthority authority;
        RouteInfo route2;
        String spn = null;
        spn = this.servicePrincipalName != null ? this.servicePrincipalName : (this.challengeType == ChallengeType.PROXY ? ((route2 = clientContext.getHttpRoute()) != null ? "HTTP/" + route2.getProxyHost().getHostName() : null) : ((authority = request.getAuthority()) != null ? "HTTP/" + authority.getHostName() : ((route = clientContext.getHttpRoute()) != null ? "HTTP/" + route.getTargetHost().getHostName() : null)));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Using SPN: " + spn);
        }
        return spn;
    }

    String getToken(Sspi.CtxtHandle continueCtx, Sspi.SecBufferDesc continueToken, String targetName) {
        IntByReference attr = new IntByReference();
        SspiUtil.ManagedSecBufferDesc token = new SspiUtil.ManagedSecBufferDesc(2, 12288);
        this.sspiContext = new Sspi.CtxtHandle();
        int rc = Secur32.INSTANCE.InitializeSecurityContext(this.clientCred, continueCtx, targetName, 3, 0, 16, continueToken, 0, this.sspiContext, (Sspi.SecBufferDesc)token, attr, null);
        switch (rc) {
            case 590610: {
                this.continueNeeded = true;
                break;
            }
            case 0: {
                this.dispose();
                this.continueNeeded = false;
                break;
            }
            default: {
                this.dispose();
                throw new Win32Exception(rc);
            }
        }
        return Base64.encodeBase64String((byte[])token.getBuffer(0).getBytes());
    }

    public boolean isChallengeComplete() {
        return !this.continueNeeded;
    }
}

