/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheInvalidator;
import org.apache.hc.client5.http.cache.HttpCacheStorage;
import org.apache.hc.client5.http.impl.cache.CacheKeyGenerator;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
class DefaultCacheInvalidator
implements HttpCacheInvalidator {
    private final HttpCacheStorage storage;
    private final CacheKeyGenerator cacheKeyGenerator;
    private final Logger log = LogManager.getLogger(this.getClass());

    public DefaultCacheInvalidator(CacheKeyGenerator cacheKeyGenerator, HttpCacheStorage storage) {
        this.cacheKeyGenerator = cacheKeyGenerator;
        this.storage = storage;
    }

    private static URI parse(String uri) {
        if (uri == null) {
            return null;
        }
        try {
            return new URI(uri);
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    @Override
    public void flushInvalidatedCacheEntries(HttpHost host, HttpRequest req) {
        String key = this.cacheKeyGenerator.generateKey(host, req);
        HttpCacheEntry parent = this.getEntry(key);
        if (this.requestShouldNotBeCached(req) || this.shouldInvalidateHeadCacheEntry(req, parent)) {
            Header lHdr;
            URI contentLocation;
            URI uri;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Invalidating parent cache entry: " + parent);
            }
            if (parent != null) {
                for (String variantURI : parent.getVariantMap().values()) {
                    this.flushEntry(variantURI);
                }
                this.flushEntry(key);
            }
            if ((uri = DefaultCacheInvalidator.parse(key)) == null) {
                this.log.error("Couldn't transform request into valid URI");
                return;
            }
            Header clHdr = req.getFirstHeader("Content-Location");
            if (clHdr != null && (contentLocation = DefaultCacheInvalidator.parse(clHdr.getValue())) != null && !this.flushAbsoluteUriFromSameHost(uri, contentLocation)) {
                this.flushRelativeUriFromSameHost(uri, contentLocation);
            }
            if ((lHdr = req.getFirstHeader("Location")) != null) {
                this.flushAbsoluteUriFromSameHost(uri, DefaultCacheInvalidator.parse(lHdr.getValue()));
            }
        }
    }

    private boolean shouldInvalidateHeadCacheEntry(HttpRequest req, HttpCacheEntry parentCacheEntry) {
        return this.requestIsGet(req) && this.isAHeadCacheEntry(parentCacheEntry);
    }

    private boolean requestIsGet(HttpRequest req) {
        return req.getMethod().equals("GET");
    }

    private boolean isAHeadCacheEntry(HttpCacheEntry parentCacheEntry) {
        return parentCacheEntry != null && parentCacheEntry.getRequestMethod().equals("HEAD");
    }

    private void flushEntry(String uri) {
        try {
            this.storage.removeEntry(uri);
        }
        catch (IOException ioe) {
            this.log.warn("unable to flush cache entry", (Throwable)ioe);
        }
    }

    private HttpCacheEntry getEntry(String theUri) {
        try {
            return this.storage.getEntry(theUri);
        }
        catch (IOException ioe) {
            this.log.warn("could not retrieve entry from storage", (Throwable)ioe);
            return null;
        }
    }

    protected void flushUriIfSameHost(URI requestURI, URI targetURI) {
        URI canonicalTarget = DefaultCacheInvalidator.parse(this.cacheKeyGenerator.generateKey(targetURI));
        if (canonicalTarget == null) {
            return;
        }
        if (canonicalTarget.getAuthority().equalsIgnoreCase(requestURI.getAuthority())) {
            this.flushEntry(canonicalTarget.toString());
        }
    }

    protected void flushRelativeUriFromSameHost(URI requestUri, URI uri) {
        URI resolvedUri;
        URI uRI = resolvedUri = uri != null ? URIUtils.resolve((URI)requestUri, (URI)uri) : null;
        if (resolvedUri != null) {
            this.flushUriIfSameHost(requestUri, resolvedUri);
        }
    }

    protected boolean flushAbsoluteUriFromSameHost(URI requestUri, URI uri) {
        if (uri != null && uri.isAbsolute()) {
            this.flushUriIfSameHost(requestUri, uri);
            return true;
        }
        return false;
    }

    protected boolean requestShouldNotBeCached(HttpRequest req) {
        String method = req.getMethod();
        return this.notGetOrHeadRequest(method);
    }

    private boolean notGetOrHeadRequest(String method) {
        return !"GET".equals(method) && !"HEAD".equals(method);
    }

    @Override
    public void flushInvalidatedCacheEntries(HttpHost host, HttpRequest request, HttpResponse response) {
        URI location;
        int status = response.getCode();
        if (status < 200 || status > 299) {
            return;
        }
        URI uri = DefaultCacheInvalidator.parse(this.cacheKeyGenerator.generateKey(host, request));
        if (uri == null) {
            return;
        }
        URI contentLocation = this.getContentLocationURI(uri, response);
        if (contentLocation != null) {
            this.flushLocationCacheEntry(uri, response, contentLocation);
        }
        if ((location = this.getLocationURI(uri, response)) != null) {
            this.flushLocationCacheEntry(uri, response, location);
        }
    }

    private void flushLocationCacheEntry(URI requestUri, HttpResponse response, URI location) {
        String cacheKey = this.cacheKeyGenerator.generateKey(location);
        HttpCacheEntry entry = this.getEntry(cacheKey);
        if (entry == null) {
            return;
        }
        if (this.responseDateOlderThanEntryDate(response, entry)) {
            return;
        }
        if (!this.responseAndEntryEtagsDiffer(response, entry)) {
            return;
        }
        this.flushUriIfSameHost(requestUri, location);
    }

    private static URI getLocationURI(URI requestUri, HttpResponse response, String headerName) {
        Header h = response.getFirstHeader(headerName);
        if (h == null) {
            return null;
        }
        URI locationUri = DefaultCacheInvalidator.parse(h.getValue());
        if (locationUri == null) {
            return requestUri;
        }
        if (locationUri.isAbsolute()) {
            return locationUri;
        }
        return URIUtils.resolve((URI)requestUri, (URI)locationUri);
    }

    private URI getContentLocationURI(URI requestUri, HttpResponse response) {
        return DefaultCacheInvalidator.getLocationURI(requestUri, response, "Content-Location");
    }

    private URI getLocationURI(URI requestUri, HttpResponse response) {
        return DefaultCacheInvalidator.getLocationURI(requestUri, response, "Location");
    }

    private boolean responseAndEntryEtagsDiffer(HttpResponse response, HttpCacheEntry entry) {
        Header entryEtag = entry.getFirstHeader("ETag");
        Header responseEtag = response.getFirstHeader("ETag");
        if (entryEtag == null || responseEtag == null) {
            return false;
        }
        return !entryEtag.getValue().equals(responseEtag.getValue());
    }

    private boolean responseDateOlderThanEntryDate(HttpResponse response, HttpCacheEntry entry) {
        Header entryDateHeader = entry.getFirstHeader("Date");
        Header responseDateHeader = response.getFirstHeader("Date");
        if (entryDateHeader == null || responseDateHeader == null) {
            return false;
        }
        Date entryDate = DateUtils.parseDate((String)entryDateHeader.getValue());
        Date responseDate = DateUtils.parseDate((String)responseDateHeader.getValue());
        if (entryDate == null || responseDate == null) {
            return false;
        }
        return responseDate.before(entryDate);
    }
}

