/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.Date;
import java.util.Iterator;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.message.MessageSupport;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
class CacheValidityPolicy {
    public static final long MAX_AGE = 0x80000000L;

    CacheValidityPolicy() {
    }

    public long getCurrentAgeSecs(HttpCacheEntry entry, Date now) {
        return this.getCorrectedInitialAgeSecs(entry) + this.getResidentTimeSecs(entry, now);
    }

    public long getFreshnessLifetimeSecs(HttpCacheEntry entry) {
        long maxage = this.getMaxAge(entry);
        if (maxage > -1L) {
            return maxage;
        }
        Date dateValue = entry.getDate();
        if (dateValue == null) {
            return 0L;
        }
        Date expiry = this.getExpirationDate(entry);
        if (expiry == null) {
            return 0L;
        }
        long diff = expiry.getTime() - dateValue.getTime();
        return diff / 1000L;
    }

    public boolean isResponseFresh(HttpCacheEntry entry, Date now) {
        return this.getCurrentAgeSecs(entry, now) < this.getFreshnessLifetimeSecs(entry);
    }

    public boolean isResponseHeuristicallyFresh(HttpCacheEntry entry, Date now, float coefficient, long defaultLifetime) {
        return this.getCurrentAgeSecs(entry, now) < this.getHeuristicFreshnessLifetimeSecs(entry, coefficient, defaultLifetime);
    }

    public long getHeuristicFreshnessLifetimeSecs(HttpCacheEntry entry, float coefficient, long defaultLifetime) {
        Date dateValue = entry.getDate();
        Date lastModifiedValue = this.getLastModifiedValue(entry);
        if (dateValue != null && lastModifiedValue != null) {
            long diff = dateValue.getTime() - lastModifiedValue.getTime();
            if (diff < 0L) {
                return 0L;
            }
            return (long)(coefficient * (float)(diff / 1000L));
        }
        return defaultLifetime;
    }

    public boolean isRevalidatable(HttpCacheEntry entry) {
        return entry.getFirstHeader("ETag") != null || entry.getFirstHeader("Last-Modified") != null;
    }

    public boolean mustRevalidate(HttpCacheEntry entry) {
        return this.hasCacheControlDirective(entry, "must-revalidate");
    }

    public boolean proxyRevalidate(HttpCacheEntry entry) {
        return this.hasCacheControlDirective(entry, "proxy-revalidate");
    }

    public boolean mayReturnStaleWhileRevalidating(HttpCacheEntry entry, Date now) {
        Iterator it = MessageSupport.iterate((MessageHeaders)entry, (String)"Cache-Control");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (!"stale-while-revalidate".equalsIgnoreCase(elt.getName())) continue;
            try {
                int allowedStalenessLifetime = Integer.parseInt(elt.getValue());
                if (this.getStalenessSecs(entry, now) > (long)allowedStalenessLifetime) continue;
                return true;
            }
            catch (NumberFormatException nfe) {
            }
        }
        return false;
    }

    public boolean mayReturnStaleIfError(HttpRequest request, HttpCacheEntry entry, Date now) {
        long stalenessSecs = this.getStalenessSecs(entry, now);
        return this.mayReturnStaleIfError((MessageHeaders)request, "Cache-Control", stalenessSecs) || this.mayReturnStaleIfError(entry, "Cache-Control", stalenessSecs);
    }

    private boolean mayReturnStaleIfError(MessageHeaders headers, String name, long stalenessSecs) {
        boolean result = false;
        Iterator it = MessageSupport.iterate((MessageHeaders)headers, (String)name);
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (!"stale-if-error".equals(elt.getName())) continue;
            try {
                int staleIfErrorSecs = Integer.parseInt(elt.getValue());
                if (stalenessSecs > (long)staleIfErrorSecs) continue;
                result = true;
                break;
            }
            catch (NumberFormatException nfe) {
            }
        }
        return result;
    }

    protected Date getLastModifiedValue(HttpCacheEntry entry) {
        Header dateHdr = entry.getFirstHeader("Last-Modified");
        if (dateHdr == null) {
            return null;
        }
        return DateUtils.parseDate((String)dateHdr.getValue());
    }

    protected boolean contentLengthHeaderMatchesActualLength(HttpCacheEntry entry) {
        Header h = entry.getFirstHeader("Content-Length");
        if (h != null) {
            try {
                long responseLen = Long.parseLong(h.getValue());
                Resource resource = entry.getResource();
                if (resource == null) {
                    return false;
                }
                long resourceLen = resource.length();
                return responseLen == resourceLen;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        return true;
    }

    protected long getApparentAgeSecs(HttpCacheEntry entry) {
        Date dateValue = entry.getDate();
        if (dateValue == null) {
            return 0x80000000L;
        }
        long diff = entry.getResponseDate().getTime() - dateValue.getTime();
        if (diff < 0L) {
            return 0L;
        }
        return diff / 1000L;
    }

    protected long getAgeValue(HttpCacheEntry entry) {
        long ageValue = 0L;
        for (Header hdr : entry.getHeaders("Age")) {
            long hdrAge;
            try {
                hdrAge = Long.parseLong(hdr.getValue());
                if (hdrAge < 0L) {
                    hdrAge = 0x80000000L;
                }
            }
            catch (NumberFormatException nfe) {
                hdrAge = 0x80000000L;
            }
            ageValue = hdrAge > ageValue ? hdrAge : ageValue;
        }
        return ageValue;
    }

    protected long getCorrectedReceivedAgeSecs(HttpCacheEntry entry) {
        long ageValue;
        long apparentAge = this.getApparentAgeSecs(entry);
        return apparentAge > (ageValue = this.getAgeValue(entry)) ? apparentAge : ageValue;
    }

    protected long getResponseDelaySecs(HttpCacheEntry entry) {
        long diff = entry.getResponseDate().getTime() - entry.getRequestDate().getTime();
        return diff / 1000L;
    }

    protected long getCorrectedInitialAgeSecs(HttpCacheEntry entry) {
        return this.getCorrectedReceivedAgeSecs(entry) + this.getResponseDelaySecs(entry);
    }

    protected long getResidentTimeSecs(HttpCacheEntry entry, Date now) {
        long diff = now.getTime() - entry.getResponseDate().getTime();
        return diff / 1000L;
    }

    protected long getMaxAge(HttpCacheEntry entry) {
        long maxage = -1L;
        Iterator it = MessageSupport.iterate((MessageHeaders)entry, (String)"Cache-Control");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (!"max-age".equals(elt.getName()) && !"s-maxage".equals(elt.getName())) continue;
            try {
                long currMaxAge = Long.parseLong(elt.getValue());
                if (maxage != -1L && currMaxAge >= maxage) continue;
                maxage = currMaxAge;
            }
            catch (NumberFormatException nfe) {
                maxage = 0L;
            }
        }
        return maxage;
    }

    protected Date getExpirationDate(HttpCacheEntry entry) {
        Header expiresHeader = entry.getFirstHeader("Expires");
        if (expiresHeader == null) {
            return null;
        }
        return DateUtils.parseDate((String)expiresHeader.getValue());
    }

    public boolean hasCacheControlDirective(HttpCacheEntry entry, String directive) {
        Iterator it = MessageSupport.iterate((MessageHeaders)entry, (String)"Cache-Control");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (!directive.equalsIgnoreCase(elt.getName())) continue;
            return true;
        }
        return false;
    }

    public long getStalenessSecs(HttpCacheEntry entry, Date now) {
        long freshness;
        long age = this.getCurrentAgeSecs(entry, now);
        if (age <= (freshness = this.getFreshnessLifetimeSecs(entry))) {
            return 0L;
        }
        return age - freshness;
    }
}

