/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheStorage;
import org.apache.hc.client5.http.cache.HttpCacheUpdateCallback;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CacheMap;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;

@Contract(threading=ThreadingBehavior.SAFE)
public class BasicHttpCacheStorage
implements HttpCacheStorage {
    private final CacheMap entries;

    public BasicHttpCacheStorage(CacheConfig config) {
        this.entries = new CacheMap(config.getMaxCacheEntries());
    }

    @Override
    public synchronized void putEntry(String url, HttpCacheEntry entry) throws ResourceIOException {
        this.entries.put(url, entry);
    }

    @Override
    public synchronized HttpCacheEntry getEntry(String url) throws ResourceIOException {
        return (HttpCacheEntry)this.entries.get(url);
    }

    @Override
    public synchronized void removeEntry(String url) throws ResourceIOException {
        this.entries.remove(url);
    }

    @Override
    public synchronized void updateEntry(String url, HttpCacheUpdateCallback callback) throws ResourceIOException {
        HttpCacheEntry existingEntry = (HttpCacheEntry)this.entries.get(url);
        this.entries.put(url, callback.update(existingEntry));
    }
}

