/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheInvalidator;
import org.apache.hc.client5.http.cache.HttpCacheStorage;
import org.apache.hc.client5.http.cache.HttpCacheUpdateCallback;
import org.apache.hc.client5.http.cache.HttpCacheUpdateException;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.client5.http.cache.ResourceFactory;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.impl.cache.BasicHttpCacheStorage;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CacheEntryUpdater;
import org.apache.hc.client5.http.impl.cache.CacheKeyGenerator;
import org.apache.hc.client5.http.impl.cache.DefaultCacheInvalidator;
import org.apache.hc.client5.http.impl.cache.HeapResourceFactory;
import org.apache.hc.client5.http.impl.cache.HttpCache;
import org.apache.hc.client5.http.impl.cache.Variant;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class BasicHttpCache
implements HttpCache {
    private static final Set<String> safeRequestMethods = new HashSet<String>(Arrays.asList("HEAD", "GET", "OPTIONS", "TRACE"));
    private final CacheKeyGenerator uriExtractor;
    private final ResourceFactory resourceFactory;
    private final CacheEntryUpdater cacheEntryUpdater;
    private final HttpCacheInvalidator cacheInvalidator;
    private final HttpCacheStorage storage;
    private final Logger log = LogManager.getLogger(this.getClass());

    public BasicHttpCache(ResourceFactory resourceFactory, HttpCacheStorage storage, CacheKeyGenerator uriExtractor, HttpCacheInvalidator cacheInvalidator) {
        this.resourceFactory = resourceFactory;
        this.uriExtractor = uriExtractor;
        this.cacheEntryUpdater = new CacheEntryUpdater(resourceFactory);
        this.storage = storage;
        this.cacheInvalidator = cacheInvalidator;
    }

    public BasicHttpCache(ResourceFactory resourceFactory, HttpCacheStorage storage, CacheKeyGenerator uriExtractor) {
        this(resourceFactory, storage, uriExtractor, new DefaultCacheInvalidator(uriExtractor, storage));
    }

    public BasicHttpCache(ResourceFactory resourceFactory, HttpCacheStorage storage) {
        this(resourceFactory, storage, new CacheKeyGenerator());
    }

    public BasicHttpCache(CacheConfig config) {
        this(new HeapResourceFactory(), new BasicHttpCacheStorage(config));
    }

    public BasicHttpCache() {
        this(CacheConfig.DEFAULT);
    }

    @Override
    public void flushCacheEntriesFor(HttpHost host, HttpRequest request) throws ResourceIOException {
        if (!safeRequestMethods.contains(request.getMethod())) {
            String uri = this.uriExtractor.generateKey(host, request);
            this.storage.removeEntry(uri);
        }
    }

    @Override
    public void flushInvalidatedCacheEntriesFor(HttpHost host, HttpRequest request, HttpResponse response) {
        if (!safeRequestMethods.contains(request.getMethod())) {
            this.cacheInvalidator.flushInvalidatedCacheEntries(host, request, response);
        }
    }

    void storeInCache(HttpHost target, HttpRequest request, HttpCacheEntry entry) throws ResourceIOException {
        if (entry.hasVariants()) {
            this.storeVariantEntry(target, request, entry);
        } else {
            this.storeNonVariantEntry(target, request, entry);
        }
    }

    void storeNonVariantEntry(HttpHost target, HttpRequest req, HttpCacheEntry entry) throws ResourceIOException {
        String uri = this.uriExtractor.generateKey(target, req);
        this.storage.putEntry(uri, entry);
    }

    void storeVariantEntry(HttpHost target, final HttpRequest req, final HttpCacheEntry entry) throws ResourceIOException {
        String parentURI = this.uriExtractor.generateKey(target, req);
        final String variantURI = this.uriExtractor.generateVariantURI(target, req, entry);
        this.storage.putEntry(variantURI, entry);
        HttpCacheUpdateCallback callback = new HttpCacheUpdateCallback(){

            @Override
            public HttpCacheEntry update(HttpCacheEntry existing) throws ResourceIOException {
                return BasicHttpCache.this.doGetUpdatedParentEntry(req.getRequestUri(), existing, entry, BasicHttpCache.this.uriExtractor.generateVariantKey(req, entry), variantURI);
            }
        };
        try {
            this.storage.updateEntry(parentURI, callback);
        }
        catch (HttpCacheUpdateException e) {
            this.log.warn("Could not processChallenge key [" + parentURI + "]", (Throwable)e);
        }
    }

    @Override
    public void reuseVariantEntryFor(HttpHost target, final HttpRequest req, Variant variant) throws ResourceIOException {
        String parentCacheKey = this.uriExtractor.generateKey(target, req);
        final HttpCacheEntry entry = variant.getEntry();
        final String variantKey = this.uriExtractor.generateVariantKey(req, entry);
        final String variantCacheKey = variant.getCacheKey();
        HttpCacheUpdateCallback callback = new HttpCacheUpdateCallback(){

            @Override
            public HttpCacheEntry update(HttpCacheEntry existing) throws ResourceIOException {
                return BasicHttpCache.this.doGetUpdatedParentEntry(req.getRequestUri(), existing, entry, variantKey, variantCacheKey);
            }
        };
        try {
            this.storage.updateEntry(parentCacheKey, callback);
        }
        catch (HttpCacheUpdateException e) {
            this.log.warn("Could not processChallenge key [" + parentCacheKey + "]", (Throwable)e);
        }
    }

    HttpCacheEntry doGetUpdatedParentEntry(String requestId, HttpCacheEntry existing, HttpCacheEntry entry, String variantKey, String variantCacheKey) throws ResourceIOException {
        HttpCacheEntry src = existing;
        if (src == null) {
            src = entry;
        }
        Resource resource = null;
        if (src.getResource() != null) {
            resource = this.resourceFactory.copy(requestId, src.getResource());
        }
        HashMap<String, String> variantMap = new HashMap<String, String>(src.getVariantMap());
        variantMap.put(variantKey, variantCacheKey);
        return new HttpCacheEntry(src.getRequestDate(), src.getResponseDate(), src.getStatus(), src.getAllHeaders(), resource, variantMap);
    }

    @Override
    public HttpCacheEntry updateCacheEntry(HttpHost target, HttpRequest request, HttpCacheEntry stale, HttpResponse originResponse, Date requestSent, Date responseReceived) throws ResourceIOException {
        HttpCacheEntry updatedEntry = this.cacheEntryUpdater.updateCacheEntry(request.getRequestUri(), stale, requestSent, responseReceived, originResponse);
        this.storeInCache(target, request, updatedEntry);
        return updatedEntry;
    }

    @Override
    public HttpCacheEntry updateVariantCacheEntry(HttpHost target, HttpRequest request, HttpCacheEntry stale, HttpResponse originResponse, Date requestSent, Date responseReceived, String cacheKey) throws ResourceIOException {
        HttpCacheEntry updatedEntry = this.cacheEntryUpdater.updateCacheEntry(request.getRequestUri(), stale, requestSent, responseReceived, originResponse);
        this.storage.putEntry(cacheKey, updatedEntry);
        return updatedEntry;
    }

    @Override
    public HttpCacheEntry createCacheEntry(HttpHost host, HttpRequest request, HttpResponse originResponse, ByteArrayBuffer content, Date requestSent, Date responseReceived) throws ResourceIOException {
        Resource resource = content != null ? this.resourceFactory.generate(request.getRequestUri(), content.array(), 0, content.length()) : null;
        HttpCacheEntry entry = new HttpCacheEntry(requestSent, responseReceived, originResponse.getCode(), originResponse.getAllHeaders(), resource);
        this.storeInCache(host, request, entry);
        return entry;
    }

    @Override
    public HttpCacheEntry getCacheEntry(HttpHost host, HttpRequest request) throws ResourceIOException {
        HttpCacheEntry root = this.storage.getEntry(this.uriExtractor.generateKey(host, request));
        if (root == null) {
            return null;
        }
        if (!root.hasVariants()) {
            return root;
        }
        String variantCacheKey = root.getVariantMap().get(this.uriExtractor.generateVariantKey(request, root));
        if (variantCacheKey == null) {
            return null;
        }
        return this.storage.getEntry(variantCacheKey);
    }

    @Override
    public void flushInvalidatedCacheEntriesFor(HttpHost host, HttpRequest request) throws ResourceIOException {
        this.cacheInvalidator.flushInvalidatedCacheEntries(host, request);
    }

    @Override
    public Map<String, Variant> getVariantCacheEntriesWithEtags(HttpHost host, HttpRequest request) throws ResourceIOException {
        HashMap<String, Variant> variants = new HashMap<String, Variant>();
        HttpCacheEntry root = this.storage.getEntry(this.uriExtractor.generateKey(host, request));
        if (root == null || !root.hasVariants()) {
            return variants;
        }
        for (Map.Entry<String, String> variant : root.getVariantMap().entrySet()) {
            String variantKey = variant.getKey();
            String variantCacheKey = variant.getValue();
            this.addVariantWithEtag(variantKey, variantCacheKey, variants);
        }
        return variants;
    }

    private void addVariantWithEtag(String variantKey, String variantCacheKey, Map<String, Variant> variants) throws ResourceIOException {
        HttpCacheEntry entry = this.storage.getEntry(variantCacheKey);
        if (entry == null) {
            return;
        }
        Header etagHeader = entry.getFirstHeader("ETag");
        if (etagHeader == null) {
            return;
        }
        variants.put(etagHeader.getValue(), new Variant(variantKey, variantCacheKey, entry));
    }
}

