/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.Date;
import org.apache.hc.client5.http.impl.cache.WarningValue;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.junit.Assert;
import org.junit.Test;

public class TestWarningValue {
    @Test
    public void testParseSingleWarnValue() {
        BasicHeader h = new BasicHeader("Warning", (Object)"110 fred \"stale\"");
        WarningValue[] result = WarningValue.getWarningValues((Header)h);
        Assert.assertEquals((long)1L, (long)result.length);
        WarningValue wv = result[0];
        Assert.assertEquals((long)110L, (long)wv.getWarnCode());
        Assert.assertEquals((Object)"fred", (Object)wv.getWarnAgent());
        Assert.assertEquals((Object)"\"stale\"", (Object)wv.getWarnText());
        Assert.assertNull((Object)wv.getWarnDate());
    }

    @Test
    public void testParseMultipleWarnValues() {
        BasicHeader h = new BasicHeader("Warning", (Object)"110 fred \"stale\", 111 wilma \"other\"");
        WarningValue[] result = WarningValue.getWarningValues((Header)h);
        Assert.assertEquals((long)2L, (long)result.length);
        WarningValue wv = result[0];
        Assert.assertEquals((long)110L, (long)wv.getWarnCode());
        Assert.assertEquals((Object)"fred", (Object)wv.getWarnAgent());
        Assert.assertEquals((Object)"\"stale\"", (Object)wv.getWarnText());
        Assert.assertNull((Object)wv.getWarnDate());
        wv = result[1];
        Assert.assertEquals((long)111L, (long)wv.getWarnCode());
        Assert.assertEquals((Object)"wilma", (Object)wv.getWarnAgent());
        Assert.assertEquals((Object)"\"other\"", (Object)wv.getWarnText());
        Assert.assertNull((Object)wv.getWarnDate());
    }

    @Test
    public void testMidHeaderParseErrorRecovery() {
        BasicHeader h = new BasicHeader("Warning", (Object)"110 fred \"stale\", bogus, 111 wilma \"other\"");
        WarningValue[] result = WarningValue.getWarningValues((Header)h);
        Assert.assertEquals((long)2L, (long)result.length);
        WarningValue wv = result[0];
        Assert.assertEquals((long)110L, (long)wv.getWarnCode());
        Assert.assertEquals((Object)"fred", (Object)wv.getWarnAgent());
        Assert.assertEquals((Object)"\"stale\"", (Object)wv.getWarnText());
        Assert.assertNull((Object)wv.getWarnDate());
        wv = result[1];
        Assert.assertEquals((long)111L, (long)wv.getWarnCode());
        Assert.assertEquals((Object)"wilma", (Object)wv.getWarnAgent());
        Assert.assertEquals((Object)"\"other\"", (Object)wv.getWarnText());
        Assert.assertNull((Object)wv.getWarnDate());
    }

    @Test
    public void testTrickyCommaMidHeaderParseErrorRecovery() {
        BasicHeader h = new BasicHeader("Warning", (Object)"110 fred \"stale\", \"bogus, dude\", 111 wilma \"other\"");
        WarningValue[] result = WarningValue.getWarningValues((Header)h);
        Assert.assertEquals((long)2L, (long)result.length);
        WarningValue wv = result[0];
        Assert.assertEquals((long)110L, (long)wv.getWarnCode());
        Assert.assertEquals((Object)"fred", (Object)wv.getWarnAgent());
        Assert.assertEquals((Object)"\"stale\"", (Object)wv.getWarnText());
        Assert.assertNull((Object)wv.getWarnDate());
        wv = result[1];
        Assert.assertEquals((long)111L, (long)wv.getWarnCode());
        Assert.assertEquals((Object)"wilma", (Object)wv.getWarnAgent());
        Assert.assertEquals((Object)"\"other\"", (Object)wv.getWarnText());
        Assert.assertNull((Object)wv.getWarnDate());
    }

    @Test
    public void testParseErrorRecoveryAtEndOfHeader() {
        BasicHeader h = new BasicHeader("Warning", (Object)"110 fred \"stale\", 111 wilma \"other\", \"bogus, dude\"");
        WarningValue[] result = WarningValue.getWarningValues((Header)h);
        Assert.assertEquals((long)2L, (long)result.length);
        WarningValue wv = result[0];
        Assert.assertEquals((long)110L, (long)wv.getWarnCode());
        Assert.assertEquals((Object)"fred", (Object)wv.getWarnAgent());
        Assert.assertEquals((Object)"\"stale\"", (Object)wv.getWarnText());
        Assert.assertNull((Object)wv.getWarnDate());
        wv = result[1];
        Assert.assertEquals((long)111L, (long)wv.getWarnCode());
        Assert.assertEquals((Object)"wilma", (Object)wv.getWarnAgent());
        Assert.assertEquals((Object)"\"other\"", (Object)wv.getWarnText());
        Assert.assertNull((Object)wv.getWarnDate());
    }

    @Test
    public void testConstructSingleWarnValue() {
        WarningValue impl = new WarningValue("110 fred \"stale\"");
        Assert.assertEquals((long)110L, (long)impl.getWarnCode());
        Assert.assertEquals((Object)"fred", (Object)impl.getWarnAgent());
        Assert.assertEquals((Object)"\"stale\"", (Object)impl.getWarnText());
        Assert.assertNull((Object)impl.getWarnDate());
    }

    @Test
    public void testConstructWarnValueWithIPv4Address() {
        WarningValue impl = new WarningValue("110 192.168.1.1 \"stale\"");
        Assert.assertEquals((long)110L, (long)impl.getWarnCode());
        Assert.assertEquals((Object)"192.168.1.1", (Object)impl.getWarnAgent());
        Assert.assertEquals((Object)"\"stale\"", (Object)impl.getWarnText());
        Assert.assertNull((Object)impl.getWarnDate());
    }

    @Test
    public void testConstructWarnValueWithHostname() {
        WarningValue impl = new WarningValue("110 foo.example.com \"stale\"");
        Assert.assertEquals((long)110L, (long)impl.getWarnCode());
        Assert.assertEquals((Object)"foo.example.com", (Object)impl.getWarnAgent());
        Assert.assertEquals((Object)"\"stale\"", (Object)impl.getWarnText());
        Assert.assertNull((Object)impl.getWarnDate());
    }

    @Test
    public void testConstructWarnValueWithHostnameAndPort() {
        WarningValue impl = new WarningValue("110 foo.example.com:8080 \"stale\"");
        Assert.assertEquals((long)110L, (long)impl.getWarnCode());
        Assert.assertEquals((Object)"foo.example.com:8080", (Object)impl.getWarnAgent());
        Assert.assertEquals((Object)"\"stale\"", (Object)impl.getWarnText());
        Assert.assertNull((Object)impl.getWarnDate());
    }

    @Test
    public void testConstructWarnValueWithIPv4AddressAndPort() {
        WarningValue impl = new WarningValue("110 192.168.1.1:8080 \"stale\"");
        Assert.assertEquals((long)110L, (long)impl.getWarnCode());
        Assert.assertEquals((Object)"192.168.1.1:8080", (Object)impl.getWarnAgent());
        Assert.assertEquals((Object)"\"stale\"", (Object)impl.getWarnText());
        Assert.assertNull((Object)impl.getWarnDate());
    }

    @Test
    public void testConstructWarnValueWithPseudonym() {
        WarningValue impl = new WarningValue("110 ca$hm0ney \"stale\"");
        Assert.assertEquals((long)110L, (long)impl.getWarnCode());
        Assert.assertEquals((Object)"ca$hm0ney", (Object)impl.getWarnAgent());
        Assert.assertEquals((Object)"\"stale\"", (Object)impl.getWarnText());
        Assert.assertNull((Object)impl.getWarnDate());
    }

    @Test
    public void testConstructWarnValueWithTextWithSpaces() {
        WarningValue impl = new WarningValue("110 fred \"stale stuff\"");
        Assert.assertEquals((long)110L, (long)impl.getWarnCode());
        Assert.assertEquals((Object)"fred", (Object)impl.getWarnAgent());
        Assert.assertEquals((Object)"\"stale stuff\"", (Object)impl.getWarnText());
        Assert.assertNull((Object)impl.getWarnDate());
    }

    @Test
    public void testConstructWarnValueWithTextWithCommas() {
        WarningValue impl = new WarningValue("110 fred \"stale, stuff\"");
        Assert.assertEquals((long)110L, (long)impl.getWarnCode());
        Assert.assertEquals((Object)"fred", (Object)impl.getWarnAgent());
        Assert.assertEquals((Object)"\"stale, stuff\"", (Object)impl.getWarnText());
        Assert.assertNull((Object)impl.getWarnDate());
    }

    @Test
    public void testConstructWarnValueWithTextWithEscapedQuotes() {
        WarningValue impl = new WarningValue("110 fred \"stale\\\" stuff\"");
        Assert.assertEquals((long)110L, (long)impl.getWarnCode());
        Assert.assertEquals((Object)"fred", (Object)impl.getWarnAgent());
        Assert.assertEquals((Object)"\"stale\\\" stuff\"", (Object)impl.getWarnText());
        Assert.assertNull((Object)impl.getWarnDate());
    }

    @Test
    public void testConstructWarnValueWithAscTimeWarnDate() throws Exception {
        WarningValue impl = new WarningValue("110 fred \"stale\" \"Sun Nov  6 08:49:37 1994\"");
        Assert.assertEquals((long)110L, (long)impl.getWarnCode());
        Assert.assertEquals((Object)"fred", (Object)impl.getWarnAgent());
        Assert.assertEquals((Object)"\"stale\"", (Object)impl.getWarnText());
        Date target = DateUtils.parseDate((String)"Sun Nov  6 08:49:37 1994");
        Assert.assertEquals((Object)target, (Object)impl.getWarnDate());
    }

    @Test
    public void testConstructWarnValueWithRFC850WarnDate() throws Exception {
        WarningValue impl = new WarningValue("110 fred \"stale\" \"Sunday, 06-Nov-94 08:49:37 GMT\"");
        Assert.assertEquals((long)110L, (long)impl.getWarnCode());
        Assert.assertEquals((Object)"fred", (Object)impl.getWarnAgent());
        Assert.assertEquals((Object)"\"stale\"", (Object)impl.getWarnText());
        Date target = DateUtils.parseDate((String)"Sunday, 06-Nov-94 08:49:37 GMT");
        Assert.assertEquals((Object)target, (Object)impl.getWarnDate());
    }

    @Test
    public void testConstructWarnValueWithRFC1123WarnDate() throws Exception {
        WarningValue impl = new WarningValue("110 fred \"stale\" \"Sun, 06 Nov 1994 08:49:37 GMT\"");
        Assert.assertEquals((long)110L, (long)impl.getWarnCode());
        Assert.assertEquals((Object)"fred", (Object)impl.getWarnAgent());
        Assert.assertEquals((Object)"\"stale\"", (Object)impl.getWarnText());
        Date target = DateUtils.parseDate((String)"Sun, 06 Nov 1994 08:49:37 GMT");
        Assert.assertEquals((Object)target, (Object)impl.getWarnDate());
    }
}

