/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.Date;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.cache.ResponseProtocolCompliance;
import org.apache.hc.client5.http.impl.classic.ClassicRequestCopier;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.junit.Before;
import org.junit.Test;

public class TestResponseProtocolCompliance {
    private ResponseProtocolCompliance impl;

    @Before
    public void setUp() {
        this.impl = new ResponseProtocolCompliance();
    }

    private void setMinimalResponseHeaders(HttpResponse resp) {
        resp.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        resp.setHeader("Server", (Object)"MyServer/1.0");
    }

    private HttpResponse makePartialResponse(int nbytes) {
        BasicHttpResponse resp = new BasicHttpResponse(206, "Partial Content");
        this.setMinimalResponseHeaders((HttpResponse)resp);
        resp.setHeader("Content-Length", (Object)("" + nbytes));
        resp.setHeader("Content-Range", (Object)"0-127/256");
        return resp;
    }

    @Test(expected=ClientProtocolException.class)
    public void throwsExceptionIfOriginReturnsPartialResponseWhenNotRequested() throws Exception {
        HttpGet req = new HttpGet("http://foo.example.com/");
        ClassicHttpRequest wrapper = ClassicRequestCopier.INSTANCE.copy((ClassicHttpRequest)req);
        int nbytes = 128;
        HttpResponse resp = this.makePartialResponse(128);
        this.impl.ensureProtocolCompliance((HttpRequest)wrapper, (HttpRequest)req, resp);
    }
}

