/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.Date;
import java.util.Random;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.impl.cache.ResponseCachingPolicy;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestResponseCachingPolicy {
    private static final ProtocolVersion HTTP_1_1 = new ProtocolVersion("HTTP", 1, 1);
    private ResponseCachingPolicy policy;
    private HttpResponse response;
    private HttpRequest request;
    private final int[] acceptableCodes = new int[]{200, 203, 300, 301, 410};
    private Date now;
    private Date tenSecondsFromNow;
    private Date sixSecondsAgo;

    @Before
    public void setUp() throws Exception {
        this.now = new Date();
        this.sixSecondsAgo = new Date(this.now.getTime() - 6000L);
        this.tenSecondsFromNow = new Date(this.now.getTime() + 10000L);
        this.policy = new ResponseCachingPolicy(0L, true, false, false);
        this.request = new BasicHttpRequest("GET", "/");
        this.response = new BasicHttpResponse(200, "");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        this.response.setHeader("Content-Length", (Object)"0");
    }

    @Test
    public void testIsGetCacheable() {
        Assert.assertTrue((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testIsHeadCacheable() {
        this.policy = new ResponseCachingPolicy(0L, true, false, false);
        Assert.assertTrue((boolean)this.policy.isResponseCacheable("HEAD", this.response));
    }

    @Test
    public void testResponsesToRequestsWithAuthorizationHeadersAreNotCacheableBySharedCache() {
        this.request = new BasicHttpRequest("GET", "/");
        this.request.setHeader("Authorization", (Object)"Basic dXNlcjpwYXNzd2Q=");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void testResponsesToRequestsWithAuthorizationHeadersAreCacheableByNonSharedCache() {
        this.policy = new ResponseCachingPolicy(0L, false, false, false);
        this.request = new BasicHttpRequest("GET", "/");
        this.request.setHeader("Authorization", (Object)"Basic dXNlcjpwYXNzd2Q=");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void testAuthorizedResponsesWithSMaxAgeAreCacheable() {
        this.request = new BasicHttpRequest("GET", "/");
        this.request.setHeader("Authorization", (Object)"Basic dXNlcjpwYXNzd2Q=");
        this.response.setHeader("Cache-Control", (Object)"s-maxage=3600");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void testAuthorizedResponsesWithMustRevalidateAreCacheable() {
        this.request = new BasicHttpRequest("GET", "/");
        this.request.setHeader("Authorization", (Object)"Basic dXNlcjpwYXNzd2Q=");
        this.response.setHeader("Cache-Control", (Object)"must-revalidate");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void testAuthorizedResponsesWithCacheControlPublicAreCacheable() {
        this.request = new BasicHttpRequest("GET", "/");
        this.request.setHeader("Authorization", (Object)"Basic dXNlcjpwYXNzd2Q=");
        this.response.setHeader("Cache-Control", (Object)"public");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void testAuthorizedResponsesWithCacheControlMaxAgeAreNotCacheable() {
        this.request = new BasicHttpRequest("GET", "/");
        this.request.setHeader("Authorization", (Object)"Basic dXNlcjpwYXNzd2Q=");
        this.response.setHeader("Cache-Control", (Object)"max-age=3600");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void test203ResponseCodeIsCacheable() {
        this.response.setCode(203);
        Assert.assertTrue((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void test206ResponseCodeIsNotCacheable() {
        this.response.setCode(206);
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void test206ResponseCodeIsNotCacheableUsingSharedPublicCache() {
        this.policy = new ResponseCachingPolicy(0L, true, false, false);
        this.request.setHeader("Authorization", (Object)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        this.response.setCode(206);
        this.response.setHeader("Cache-Control", (Object)"public");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void test300ResponseCodeIsCacheable() {
        this.response.setCode(300);
        Assert.assertTrue((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void test301ResponseCodeIsCacheable() {
        this.response.setCode(301);
        Assert.assertTrue((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void test410ResponseCodeIsCacheable() {
        this.response.setCode(410);
        Assert.assertTrue((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testPlain302ResponseCodeIsNotCacheable() {
        this.response.setCode(302);
        this.response.removeHeaders("Expires");
        this.response.removeHeaders("Cache-Control");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testPlain303ResponseCodeIsNotCacheableUnderDefaultBehavior() {
        this.response.setCode(303);
        this.response.removeHeaders("Expires");
        this.response.removeHeaders("Cache-Control");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testPlain303ResponseCodeIsNotCacheableEvenIf303CachingEnabled() {
        this.policy = new ResponseCachingPolicy(0L, true, false, true);
        this.response.setCode(303);
        this.response.removeHeaders("Expires");
        this.response.removeHeaders("Cache-Control");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testPlain307ResponseCodeIsNotCacheable() {
        this.response.setCode(307);
        this.response.removeHeaders("Expires");
        this.response.removeHeaders("Cache-Control");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testNon206WithExplicitExpiresIsCacheable() {
        int status = this.getRandomStatus();
        this.response.setCode(status);
        this.response.setHeader("Expires", (Object)DateUtils.formatDate((Date)new Date()));
        Assert.assertTrue((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testNon206WithMaxAgeIsCacheable() {
        int status = this.getRandomStatus();
        this.response.setCode(status);
        this.response.setHeader("Cache-Control", (Object)"max-age=0");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testNon206WithSMaxAgeIsCacheable() {
        int status = this.getRandomStatus();
        this.response.setCode(status);
        this.response.setHeader("Cache-Control", (Object)"s-maxage=0");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testNon206WithMustRevalidateIsCacheable() {
        int status = this.getRandomStatus();
        this.response.setCode(status);
        this.response.setHeader("Cache-Control", (Object)"must-revalidate");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testNon206WithProxyRevalidateIsCacheable() {
        int status = this.getRandomStatus();
        this.response.setCode(status);
        this.response.setHeader("Cache-Control", (Object)"proxy-revalidate");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testNon206WithPublicCacheControlIsCacheable() {
        int status = this.getRandomStatus();
        this.response.setCode(status);
        this.response.setHeader("Cache-Control", (Object)"public");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testNon206WithPrivateCacheControlIsNotCacheableBySharedCache() {
        int status = this.getRandomStatus();
        this.response.setCode(status);
        this.response.setHeader("Cache-Control", (Object)"private");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void test200ResponseWithPrivateCacheControlIsCacheableByNonSharedCache() {
        this.policy = new ResponseCachingPolicy(0L, false, false, false);
        this.response.setCode(200);
        this.response.setHeader("Cache-Control", (Object)"private");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testIsGetWithNoCacheCacheable() {
        this.response.addHeader("Cache-Control", (Object)"no-cache");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testIsHeadWithNoCacheCacheable() {
        this.response.addHeader("Cache-Control", (Object)"no-cache");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("HEAD", this.response));
    }

    @Test
    public void testIsGetWithNoStoreCacheable() {
        this.response.addHeader("Cache-Control", (Object)"no-store");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testIsHeadWithNoStoreCacheable() {
        this.response.addHeader("Cache-Control", (Object)"no-store");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("HEAD", this.response));
    }

    @Test
    public void testIsGetWithNoStoreEmbeddedInListCacheable() {
        this.response.addHeader("Cache-Control", (Object)"public, no-store");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testIsHeadWithNoStoreEmbeddedInListCacheable() {
        this.response.addHeader("Cache-Control", (Object)"public, no-store");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("HEAD", this.response));
    }

    @Test
    public void testIsGetWithNoCacheEmbeddedInListCacheable() {
        this.response.addHeader("Cache-Control", (Object)"public, no-cache");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testIsHeadWithNoCacheEmbeddedInListCacheable() {
        this.response.addHeader("Cache-Control", (Object)"public, no-cache");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("HEAD", this.response));
    }

    @Test
    public void testIsGetWithNoCacheEmbeddedInListAfterFirstHeaderCacheable() {
        this.response.addHeader("Cache-Control", (Object)"max-age=20");
        this.response.addHeader("Cache-Control", (Object)"public, no-cache");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testIsHeadWithNoCacheEmbeddedInListAfterFirstHeaderCacheable() {
        this.response.addHeader("Cache-Control", (Object)"max-age=20");
        this.response.addHeader("Cache-Control", (Object)"public, no-cache");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("HEAD", this.response));
    }

    @Test
    public void testIsGetWithNoStoreEmbeddedInListAfterFirstHeaderCacheable() {
        this.response.addHeader("Cache-Control", (Object)"max-age=20");
        this.response.addHeader("Cache-Control", (Object)"public, no-store");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testIsHeadWithNoStoreEmbeddedInListAfterFirstHeaderCacheable() {
        this.response.addHeader("Cache-Control", (Object)"max-age=20");
        this.response.addHeader("Cache-Control", (Object)"public, no-store");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("HEAD", this.response));
    }

    @Test
    public void testIsGetWithAnyCacheControlCacheable() {
        this.response.addHeader("Cache-Control", (Object)"max=10");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable("GET", this.response));
        this.response = new BasicHttpResponse(200, "");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        this.response.addHeader("Cache-Control", (Object)"no-transform");
        this.response.setHeader("Content-Length", (Object)"0");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testIsHeadWithAnyCacheControlCacheable() {
        this.policy = new ResponseCachingPolicy(0L, true, false, false);
        this.response.addHeader("Cache-Control", (Object)"max=10");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable("HEAD", this.response));
        this.response = new BasicHttpResponse(200, "");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        this.response.addHeader("Cache-Control", (Object)"no-transform");
        this.response.setHeader("Content-Length", (Object)"0");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable("HEAD", this.response));
    }

    @Test
    public void testIsGetWithout200Cacheable() {
        BasicHttpResponse response404 = new BasicHttpResponse(404, "");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("GET", (HttpResponse)response404));
        response404 = new BasicHttpResponse(504, "");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("GET", (HttpResponse)response404));
    }

    @Test
    public void testIsHeadWithout200Cacheable() {
        BasicHttpResponse response404 = new BasicHttpResponse(404, "");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("HEAD", (HttpResponse)response404));
        response404 = new BasicHttpResponse(504, "");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("HEAD", (HttpResponse)response404));
    }

    @Test
    public void testVaryStarIsNotCacheable() {
        this.response.setHeader("Vary", (Object)"*");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testVaryStarIsNotCacheableUsingSharedPublicCache() {
        this.policy = new ResponseCachingPolicy(0L, true, false, false);
        this.request.setHeader("Authorization", (Object)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        this.response.setHeader("Cache-Control", (Object)"public");
        this.response.setHeader("Vary", (Object)"*");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void testIsGetWithVaryHeaderCacheable() {
        this.response.addHeader("Vary", (Object)"Accept-Encoding");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testIsHeadWithVaryHeaderCacheable() {
        this.policy = new ResponseCachingPolicy(0L, true, false, false);
        this.response.addHeader("Vary", (Object)"Accept-Encoding");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable("HEAD", this.response));
    }

    @Test
    public void testIsArbitraryMethodCacheable() {
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("PUT", this.response));
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("get", this.response));
    }

    @Test
    public void testIsArbitraryMethodCacheableUsingSharedPublicCache() {
        this.policy = new ResponseCachingPolicy(0L, true, false, false);
        this.request = new HttpOptions("http://foo.example.com/");
        this.request.setHeader("Authorization", (Object)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        this.response.setCode(204);
        this.response.setHeader("Cache-Control", (Object)"public");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void testResponsesToRequestsWithNoStoreAreNotCacheable() {
        this.request.setHeader("Cache-Control", (Object)"no-store");
        this.response.setHeader("Cache-Control", (Object)"public");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void testResponsesWithMultipleAgeHeadersAreNotCacheable() {
        this.response.addHeader("Age", (Object)"3");
        this.response.addHeader("Age", (Object)"5");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testResponsesWithMultipleAgeHeadersAreNotCacheableUsingSharedPublicCache() {
        this.policy = new ResponseCachingPolicy(0L, true, false, false);
        this.request.setHeader("Authorization", (Object)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        this.response.setHeader("Cache-Control", (Object)"public");
        this.response.addHeader("Age", (Object)"3");
        this.response.addHeader("Age", (Object)"5");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void testResponsesWithMultipleDateHeadersAreNotCacheable() {
        this.response.addHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.addHeader("Date", (Object)DateUtils.formatDate((Date)this.sixSecondsAgo));
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testResponsesWithMultipleDateHeadersAreNotCacheableUsingSharedPublicCache() {
        this.policy = new ResponseCachingPolicy(0L, true, false, false);
        this.request.setHeader("Authorization", (Object)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        this.response.setHeader("Cache-Control", (Object)"public");
        this.response.addHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.addHeader("Date", (Object)DateUtils.formatDate((Date)this.sixSecondsAgo));
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void testResponsesWithMalformedDateHeadersAreNotCacheable() {
        this.response.addHeader("Date", (Object)"garbage");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testResponsesWithMalformedDateHeadersAreNotCacheableUsingSharedPublicCache() {
        this.policy = new ResponseCachingPolicy(0L, true, false, false);
        this.request.setHeader("Authorization", (Object)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        this.response.setHeader("Cache-Control", (Object)"public");
        this.response.addHeader("Date", (Object)"garbage");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void testResponsesWithMultipleExpiresHeadersAreNotCacheable() {
        this.response.addHeader("Expires", (Object)DateUtils.formatDate((Date)this.now));
        this.response.addHeader("Expires", (Object)DateUtils.formatDate((Date)this.sixSecondsAgo));
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testResponsesWithMultipleExpiresHeadersAreNotCacheableUsingSharedPublicCache() {
        this.policy = new ResponseCachingPolicy(0L, true, false, false);
        this.request.setHeader("Authorization", (Object)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        this.response.setHeader("Cache-Control", (Object)"public");
        this.response.addHeader("Expires", (Object)DateUtils.formatDate((Date)this.now));
        this.response.addHeader("Expires", (Object)DateUtils.formatDate((Date)this.sixSecondsAgo));
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void testResponsesWithoutDateHeadersAreNotCacheable() {
        this.response.removeHeaders("Date");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testResponseThatHasTooMuchContentIsNotCacheable() {
        this.response.setHeader("Content-Length", (Object)"9000");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testResponseThatHasTooMuchContentIsNotCacheableUsingSharedPublicCache() {
        this.policy = new ResponseCachingPolicy(0L, true, false, false);
        this.request.setHeader("Authorization", (Object)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        this.response.setHeader("Cache-Control", (Object)"public");
        this.response.setHeader("Content-Length", (Object)"9000");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void testResponsesThatAreSmallEnoughAreCacheable() {
        this.response.setHeader("Content-Length", (Object)"0");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable("GET", this.response));
    }

    @Test
    public void testResponsesToGETWithQueryParamsButNoExplicitCachingAreNotCacheable() {
        this.request = new BasicHttpRequest("GET", "/foo?s=bar");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void testResponsesToHEADWithQueryParamsButNoExplicitCachingAreNotCacheable() {
        this.request = new BasicHttpRequest("HEAD", "/foo?s=bar");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void testResponsesToGETWithQueryParamsButNoExplicitCachingAreNotCacheableEvenWhen1_0QueryCachingDisabled() {
        this.policy = new ResponseCachingPolicy(0L, true, true, false);
        this.request = new BasicHttpRequest("GET", "/foo?s=bar");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void testResponsesToHEADWithQueryParamsButNoExplicitCachingAreNotCacheableEvenWhen1_0QueryCachingDisabled() {
        this.policy = new ResponseCachingPolicy(0L, true, true, false);
        this.request = new BasicHttpRequest("HEAD", "/foo?s=bar");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void testResponsesToGETWithQueryParamsAndExplicitCachingAreCacheable() {
        this.request = new BasicHttpRequest("GET", "/foo?s=bar");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.tenSecondsFromNow));
        Assert.assertTrue((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void testResponsesToHEADWithQueryParamsAndExplicitCachingAreCacheable() {
        this.policy = new ResponseCachingPolicy(0L, true, false, false);
        this.request = new BasicHttpRequest("HEAD", "/foo?s=bar");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.tenSecondsFromNow));
        Assert.assertTrue((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void testResponsesToGETWithQueryParamsAndExplicitCachingAreCacheableEvenWhen1_0QueryCachingDisabled() {
        this.policy = new ResponseCachingPolicy(0L, true, true, false);
        this.request = new BasicHttpRequest("GET", "/foo?s=bar");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.tenSecondsFromNow));
        Assert.assertTrue((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void testResponsesToHEADWithQueryParamsAndExplicitCachingAreCacheableEvenWhen1_0QueryCachingDisabled() {
        this.policy = new ResponseCachingPolicy(0L, true, true, false);
        this.request = new BasicHttpRequest("HEAD", "/foo?s=bar");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.tenSecondsFromNow));
        Assert.assertTrue((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void getsWithQueryParametersDirectlyFrom1_0OriginsAreNotCacheable() {
        this.request = new BasicHttpRequest("GET", "/foo?s=bar");
        this.response = new BasicHttpResponse(200, "OK");
        this.response.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void headsWithQueryParametersDirectlyFrom1_0OriginsAreNotCacheable() {
        this.request = new BasicHttpRequest("HEAD", "/foo?s=bar");
        this.response = new BasicHttpResponse(200, "OK");
        this.response.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void getsWithQueryParametersDirectlyFrom1_0OriginsAreNotCacheableEvenWithSetting() {
        this.policy = new ResponseCachingPolicy(0L, true, true, false);
        this.request = new BasicHttpRequest("GET", "/foo?s=bar");
        this.response = new BasicHttpResponse(200, "OK");
        this.response.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void headsWithQueryParametersDirectlyFrom1_0OriginsAreNotCacheableEvenWithSetting() {
        this.policy = new ResponseCachingPolicy(0L, true, true, false);
        this.request = new BasicHttpRequest("HEAD", "/foo?s=bar");
        this.response = new BasicHttpResponse(200, "OK");
        this.response.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void getsWithQueryParametersDirectlyFrom1_0OriginsAreCacheableWithExpires() {
        this.request = new BasicHttpRequest("GET", "/foo?s=bar");
        this.response = new BasicHttpResponse(200, "OK");
        this.response.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.tenSecondsFromNow));
        Assert.assertTrue((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void headsWithQueryParametersDirectlyFrom1_0OriginsAreCacheableWithExpires() {
        this.policy = new ResponseCachingPolicy(0L, true, false, false);
        this.request = new BasicHttpRequest("HEAD", "/foo?s=bar");
        this.response = new BasicHttpResponse(200, "OK");
        this.response.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.tenSecondsFromNow));
        Assert.assertTrue((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void getsWithQueryParametersDirectlyFrom1_0OriginsCanBeNotCacheableEvenWithExpires() {
        this.policy = new ResponseCachingPolicy(0L, true, true, false);
        this.request = new BasicHttpRequest("GET", "/foo?s=bar");
        this.response = new BasicHttpResponse(200, "OK");
        this.response.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.tenSecondsFromNow));
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void headsWithQueryParametersDirectlyFrom1_0OriginsCanBeNotCacheableEvenWithExpires() {
        this.policy = new ResponseCachingPolicy(0L, true, true, false);
        this.request = new BasicHttpRequest("HEAD", "/foo?s=bar");
        this.response = new BasicHttpResponse(200, "OK");
        this.response.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.tenSecondsFromNow));
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void getsWithQueryParametersFrom1_0OriginsViaProxiesAreNotCacheable() {
        this.request = new BasicHttpRequest("GET", "/foo?s=bar");
        this.response.setHeader("Via", (Object)"1.0 someproxy");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void headsWithQueryParametersFrom1_0OriginsViaProxiesAreNotCacheable() {
        this.request = new BasicHttpRequest("HEAD", "/foo?s=bar");
        this.response.setHeader("Via", (Object)"1.0 someproxy");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void getsWithQueryParametersFrom1_0OriginsViaProxiesAreCacheableWithExpires() {
        this.request = new BasicHttpRequest("GET", "/foo?s=bar");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.tenSecondsFromNow));
        this.response.setHeader("Via", (Object)"1.0 someproxy");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void headsWithQueryParametersFrom1_0OriginsViaProxiesAreCacheableWithExpires() {
        this.policy = new ResponseCachingPolicy(0L, true, false, false);
        this.request = new BasicHttpRequest("HEAD", "/foo?s=bar");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.tenSecondsFromNow));
        this.response.setHeader("Via", (Object)"1.0 someproxy");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void getsWithQueryParametersFrom1_0OriginsViaProxiesCanNotBeCacheableEvenWithExpires() {
        this.policy = new ResponseCachingPolicy(0L, true, true, true);
        this.request = new BasicHttpRequest("GET", "/foo?s=bar");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.tenSecondsFromNow));
        this.response.setHeader("Via", (Object)"1.0 someproxy");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void headsWithQueryParametersFrom1_0OriginsViaProxiesCanNotBeCacheableEvenWithExpires() {
        this.policy = new ResponseCachingPolicy(0L, true, true, true);
        this.request = new BasicHttpRequest("HEAD", "/foo?s=bar");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.tenSecondsFromNow));
        this.response.setHeader("Via", (Object)"1.0 someproxy");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void getsWithQueryParametersFrom1_0OriginsViaExplicitProxiesAreCacheableWithExpires() {
        this.request = new BasicHttpRequest("GET", "/foo?s=bar");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.tenSecondsFromNow));
        this.response.setHeader("Via", (Object)"HTTP/1.0 someproxy");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void headsWithQueryParametersFrom1_0OriginsViaExplicitProxiesAreCacheableWithExpires() {
        this.policy = new ResponseCachingPolicy(0L, true, false, false);
        this.request = new BasicHttpRequest("HEAD", "/foo?s=bar");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.tenSecondsFromNow));
        this.response.setHeader("Via", (Object)"HTTP/1.0 someproxy");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void getsWithQueryParametersFrom1_0OriginsViaExplicitProxiesCanNotBeCacheableEvenWithExpires() {
        this.policy = new ResponseCachingPolicy(0L, true, true, true);
        this.request = new BasicHttpRequest("GET", "/foo?s=bar");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.tenSecondsFromNow));
        this.response.setHeader("Via", (Object)"HTTP/1.0 someproxy");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void headsWithQueryParametersFrom1_0OriginsViaExplicitProxiesCanNotBeCacheableEvenWithExpires() {
        this.policy = new ResponseCachingPolicy(0L, true, true, true);
        this.request = new BasicHttpRequest("HEAD", "/foo?s=bar");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.tenSecondsFromNow));
        this.response.setHeader("Via", (Object)"HTTP/1.0 someproxy");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void getsWithQueryParametersFrom1_1OriginsVia1_0ProxiesAreCacheableWithExpires() {
        this.request = new BasicHttpRequest("GET", "/foo?s=bar");
        this.response = new BasicHttpResponse(200, "OK");
        this.response.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.tenSecondsFromNow));
        this.response.setHeader("Via", (Object)"1.1 someproxy");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void headsWithQueryParametersFrom1_1OriginsVia1_0ProxiesAreCacheableWithExpires() {
        this.policy = new ResponseCachingPolicy(0L, true, false, false);
        this.request = new BasicHttpRequest("HEAD", "/foo?s=bar");
        this.response = new BasicHttpResponse(200, "OK");
        this.response.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.tenSecondsFromNow));
        this.response.setHeader("Via", (Object)"1.1 someproxy");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void notCacheableIfExpiresEqualsDateAndNoCacheControl() {
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.now));
        this.response.removeHeaders("Cache-Control");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void notCacheableIfExpiresPrecedesDateAndNoCacheControl() {
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.sixSecondsAgo));
        this.response.removeHeaders("Cache-Control");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void test302WithExplicitCachingHeaders() {
        this.response.setCode(302);
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Cache-Control", (Object)"max-age=300");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void test303WithExplicitCachingHeadersUnderDefaultBehavior() {
        this.response.setCode(303);
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Cache-Control", (Object)"max-age=300");
        Assert.assertFalse((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void test303WithExplicitCachingHeadersWhenPermittedByConfig() {
        this.policy = new ResponseCachingPolicy(0L, true, false, true);
        this.response.setCode(303);
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Cache-Control", (Object)"max-age=300");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void test307WithExplicitCachingHeaders() {
        this.response.setCode(307);
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Cache-Control", (Object)"max-age=300");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    @Test
    public void otherStatusCodesAreCacheableWithExplicitCachingHeaders() {
        this.response.setCode(404);
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.response.setHeader("Cache-Control", (Object)"max-age=300");
        Assert.assertTrue((boolean)this.policy.isResponseCacheable(this.request, this.response));
    }

    private int getRandomStatus() {
        int rnd = new Random().nextInt(this.acceptableCodes.length);
        return this.acceptableCodes[rnd];
    }
}

