/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.Arrays;
import org.apache.hc.client5.http.impl.RequestCopier;
import org.apache.hc.client5.http.impl.cache.HttpTestUtils;
import org.apache.hc.client5.http.impl.cache.RequestProtocolCompliance;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRequestProtocolCompliance {
    private RequestProtocolCompliance impl;

    @Before
    public void setUp() {
        this.impl = new RequestProtocolCompliance(false);
    }

    @Test
    public void testRequestWithWeakETagAndRange() throws Exception {
        BasicHttpRequest req = new BasicHttpRequest("GET", "/");
        req.setHeader("Range", (Object)"bytes=0-499");
        req.setHeader("If-Range", (Object)"W/\"weak\"");
        Assert.assertEquals((long)1L, (long)this.impl.requestIsFatallyNonCompliant((HttpRequest)req).size());
    }

    @Test
    public void testRequestWithWeekETagForPUTOrDELETEIfMatch() throws Exception {
        BasicHttpRequest req = new BasicHttpRequest("PUT", "http://example.com/");
        req.setHeader("If-Match", (Object)"W/\"weak\"");
        Assert.assertEquals((long)1L, (long)this.impl.requestIsFatallyNonCompliant((HttpRequest)req).size());
    }

    @Test
    public void testRequestWithWeekETagForPUTOrDELETEIfMatchAllowed() throws Exception {
        BasicHttpRequest req = new BasicHttpRequest("PUT", "http://example.com/");
        req.setHeader("If-Match", (Object)"W/\"weak\"");
        this.impl = new RequestProtocolCompliance(true);
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)this.impl.requestIsFatallyNonCompliant((HttpRequest)req));
    }

    @Test
    public void testRequestContainsNoCacheDirectiveWithFieldName() throws Exception {
        BasicHttpRequest req = new BasicHttpRequest("GET", "/");
        req.setHeader("Cache-Control", (Object)"no-cache=false");
        Assert.assertEquals((long)1L, (long)this.impl.requestIsFatallyNonCompliant((HttpRequest)req).size());
    }

    @Test
    public void doesNotModifyACompliantRequest() throws Exception {
        BasicHttpRequest req = new BasicHttpRequest("GET", "/");
        HttpRequest wrapper = RequestCopier.INSTANCE.copy((HttpRequest)req);
        this.impl.makeRequestCompliant(wrapper);
        Assert.assertTrue((boolean)HttpTestUtils.equivalent((HttpRequest)req, wrapper));
    }

    @Test
    public void upgrades1_0RequestTo1_1() throws Exception {
        BasicHttpRequest req = new BasicHttpRequest("GET", "/");
        req.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        HttpRequest wrapper = RequestCopier.INSTANCE.copy((HttpRequest)req);
        this.impl.makeRequestCompliant(wrapper);
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)wrapper.getVersion());
    }

    @Test
    public void downgrades1_2RequestTo1_1() throws Exception {
        BasicHttpRequest req = new BasicHttpRequest("GET", "/");
        req.setVersion(new ProtocolVersion("HTTP", 1, 2));
        HttpRequest wrapper = RequestCopier.INSTANCE.copy((HttpRequest)req);
        this.impl.makeRequestCompliant(wrapper);
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)wrapper.getVersion());
    }

    @Test
    public void stripsMinFreshFromRequestIfNoCachePresent() throws Exception {
        BasicHttpRequest req = new BasicHttpRequest("GET", "/");
        req.setHeader("Cache-Control", (Object)"no-cache, min-fresh=10");
        HttpRequest wrapper = RequestCopier.INSTANCE.copy((HttpRequest)req);
        this.impl.makeRequestCompliant(wrapper);
        Assert.assertEquals((Object)"no-cache", (Object)wrapper.getFirstHeader("Cache-Control").getValue());
    }

    @Test
    public void stripsMaxFreshFromRequestIfNoCachePresent() throws Exception {
        BasicHttpRequest req = new BasicHttpRequest("GET", "/");
        req.setHeader("Cache-Control", (Object)"no-cache, max-stale=10");
        HttpRequest wrapper = RequestCopier.INSTANCE.copy((HttpRequest)req);
        this.impl.makeRequestCompliant(wrapper);
        Assert.assertEquals((Object)"no-cache", (Object)wrapper.getFirstHeader("Cache-Control").getValue());
    }

    @Test
    public void stripsMaxAgeFromRequestIfNoCachePresent() throws Exception {
        BasicHttpRequest req = new BasicHttpRequest("GET", "/");
        req.setHeader("Cache-Control", (Object)"no-cache, max-age=10");
        HttpRequest wrapper = RequestCopier.INSTANCE.copy((HttpRequest)req);
        this.impl.makeRequestCompliant(wrapper);
        Assert.assertEquals((Object)"no-cache", (Object)wrapper.getFirstHeader("Cache-Control").getValue());
    }

    @Test
    public void doesNotStripMinFreshFromRequestWithoutNoCache() throws Exception {
        BasicHttpRequest req = new BasicHttpRequest("GET", "/");
        req.setHeader("Cache-Control", (Object)"min-fresh=10");
        HttpRequest wrapper = RequestCopier.INSTANCE.copy((HttpRequest)req);
        this.impl.makeRequestCompliant(wrapper);
        Assert.assertEquals((Object)"min-fresh=10", (Object)wrapper.getFirstHeader("Cache-Control").getValue());
    }

    @Test
    public void correctlyStripsMinFreshFromMiddleIfNoCache() throws Exception {
        BasicHttpRequest req = new BasicHttpRequest("GET", "/");
        req.setHeader("Cache-Control", (Object)"no-cache,min-fresh=10,no-store");
        HttpRequest wrapper = RequestCopier.INSTANCE.copy((HttpRequest)req);
        this.impl.makeRequestCompliant(wrapper);
        Assert.assertEquals((Object)"no-cache,no-store", (Object)wrapper.getFirstHeader("Cache-Control").getValue());
    }
}

