/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import org.apache.hc.client5.http.impl.cache.AbstractProtocolTest;
import org.apache.hc.client5.http.impl.cache.BasicHttpCache;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CachingExec;
import org.apache.hc.client5.http.impl.cache.ConsumableInputStream;
import org.apache.hc.client5.http.impl.cache.HttpCache;
import org.apache.hc.client5.http.impl.cache.HttpTestUtils;
import org.apache.hc.client5.http.impl.cache.WarningValue;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestRFC5861Compliance
extends AbstractProtocolTest {
    @Test
    public void testStaleIfErrorInResponseIsTrueReturnsStaleEntryWithWarning() throws Exception {
        Date tenSecondsAgo = new Date(new Date().getTime() - 10000L);
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response(tenSecondsAgo, "public, max-age=5, stale-if-error=60");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp2 = HttpTestUtils.make500Response();
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute(req1);
        ClassicHttpResponse result = this.execute(req2);
        this.verifyMocks();
        HttpTestUtils.assert110WarningFound((HttpResponse)result);
    }

    @Test
    public void testConsumesErrorResponseWhenServingStale() throws Exception {
        Date tenSecondsAgo = new Date(new Date().getTime() - 10000L);
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response(tenSecondsAgo, "public, max-age=5, stale-if-error=60");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp2 = HttpTestUtils.make500Response();
        byte[] body101 = HttpTestUtils.getRandomBytes(101);
        ByteArrayInputStream buf = new ByteArrayInputStream(body101);
        ConsumableInputStream cis = new ConsumableInputStream(buf);
        InputStreamEntity entity = new InputStreamEntity((InputStream)cis, 101L);
        resp2.setEntity((HttpEntity)entity);
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute(req1);
        this.execute(req2);
        this.verifyMocks();
        Assert.assertTrue((boolean)cis.wasClosed());
    }

    @Test
    public void testStaleIfErrorInResponseYieldsToMustRevalidate() throws Exception {
        Date tenSecondsAgo = new Date(new Date().getTime() - 10000L);
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response(tenSecondsAgo, "public, max-age=5, stale-if-error=60, must-revalidate");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp2 = HttpTestUtils.make500Response();
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute(req1);
        ClassicHttpResponse result = this.execute(req2);
        this.verifyMocks();
        Assert.assertTrue((200 != result.getCode() ? 1 : 0) != 0);
    }

    @Test
    public void testStaleIfErrorInResponseYieldsToProxyRevalidateForSharedCache() throws Exception {
        Assert.assertTrue((boolean)this.config.isSharedCache());
        Date tenSecondsAgo = new Date(new Date().getTime() - 10000L);
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response(tenSecondsAgo, "public, max-age=5, stale-if-error=60, proxy-revalidate");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp2 = HttpTestUtils.make500Response();
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute(req1);
        ClassicHttpResponse result = this.execute(req2);
        this.verifyMocks();
        Assert.assertTrue((200 != result.getCode() ? 1 : 0) != 0);
    }

    @Test
    public void testStaleIfErrorInResponseNeedNotYieldToProxyRevalidateForPrivateCache() throws Exception {
        CacheConfig configUnshared = CacheConfig.custom().setSharedCache(false).build();
        this.impl = new CachingExec((HttpCache)new BasicHttpCache(configUnshared), configUnshared);
        Date tenSecondsAgo = new Date(new Date().getTime() - 10000L);
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response(tenSecondsAgo, "public, max-age=5, stale-if-error=60, proxy-revalidate");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp2 = HttpTestUtils.make500Response();
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute(req1);
        ClassicHttpResponse result = this.execute(req2);
        this.verifyMocks();
        HttpTestUtils.assert110WarningFound((HttpResponse)result);
    }

    @Test
    public void testStaleIfErrorInResponseYieldsToExplicitFreshnessRequest() throws Exception {
        Date tenSecondsAgo = new Date(new Date().getTime() - 10000L);
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response(tenSecondsAgo, "public, max-age=5, stale-if-error=60");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        req2.setHeader("Cache-Control", (Object)"min-fresh=2");
        ClassicHttpResponse resp2 = HttpTestUtils.make500Response();
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute(req1);
        ClassicHttpResponse result = this.execute(req2);
        this.verifyMocks();
        Assert.assertTrue((200 != result.getCode() ? 1 : 0) != 0);
    }

    @Test
    public void testStaleIfErrorInRequestIsTrueReturnsStaleEntryWithWarning() throws Exception {
        Date tenSecondsAgo = new Date(new Date().getTime() - 10000L);
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response(tenSecondsAgo, "public, max-age=5");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        req2.setHeader("Cache-Control", (Object)"public, stale-if-error=60");
        ClassicHttpResponse resp2 = HttpTestUtils.make500Response();
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute(req1);
        ClassicHttpResponse result = this.execute(req2);
        this.verifyMocks();
        HttpTestUtils.assert110WarningFound((HttpResponse)result);
    }

    @Test
    public void testStaleIfErrorInRequestIsTrueReturnsStaleNonRevalidatableEntryWithWarning() throws Exception {
        Date tenSecondsAgo = new Date(new Date().getTime() - 10000L);
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=5");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        req2.setHeader("Cache-Control", (Object)"public, stale-if-error=60");
        ClassicHttpResponse resp2 = HttpTestUtils.make500Response();
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute(req1);
        ClassicHttpResponse result = this.execute(req2);
        this.verifyMocks();
        HttpTestUtils.assert110WarningFound((HttpResponse)result);
    }

    @Test
    public void testStaleIfErrorInResponseIsFalseReturnsError() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response(tenSecondsAgo, "public, max-age=5, stale-if-error=2");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp2 = HttpTestUtils.make500Response();
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute(req1);
        ClassicHttpResponse result = this.execute(req2);
        this.verifyMocks();
        Assert.assertEquals((long)500L, (long)result.getCode());
    }

    @Test
    public void testStaleIfErrorInRequestIsFalseReturnsError() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response(tenSecondsAgo, "public, max-age=5");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        req2.setHeader("Cache-Control", (Object)"stale-if-error=2");
        ClassicHttpResponse resp2 = HttpTestUtils.make500Response();
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute(req1);
        ClassicHttpResponse result = this.execute(req2);
        this.verifyMocks();
        Assert.assertEquals((long)500L, (long)result.getCode());
    }

    @Test
    @Ignore
    public void testStaleWhileRevalidateReturnsStaleEntryWithWarning() throws Exception {
        this.config = CacheConfig.custom().setMaxCacheEntries(100).setMaxObjectSize(1024L).setAsynchronousWorkersMax(1).build();
        this.impl = new CachingExec(this.cache, this.config);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        resp1.setHeader("Cache-Control", (Object)"public, max-age=5, stale-while-revalidate=15");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        this.backendExpectsAnyRequestAndReturn(resp1).times(1, 2);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result.getCode());
        boolean warning110Found = false;
        block0: for (Header h : result.getHeaders("Warning")) {
            for (WarningValue wv : WarningValue.getWarningValues((Header)h)) {
                if (wv.getWarnCode() != 110) continue;
                warning110Found = true;
                continue block0;
            }
        }
        Assert.assertTrue((boolean)warning110Found);
    }

    @Test
    public void testHTTPCLIENT1470() {
        this.impl = new CachingExec(this.cache, null);
    }

    @Test
    @Ignore
    public void testStaleWhileRevalidateReturnsStaleNonRevalidatableEntryWithWarning() throws Exception {
        this.config = CacheConfig.custom().setMaxCacheEntries(100).setMaxObjectSize(1024L).setAsynchronousWorkersMax(1).build();
        this.impl = new CachingExec(this.cache, this.config);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        resp1.setHeader("Cache-Control", (Object)"public, max-age=5, stale-while-revalidate=15");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        this.backendExpectsAnyRequestAndReturn(resp1).times(1, 2);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result.getCode());
        boolean warning110Found = false;
        block0: for (Header h : result.getHeaders("Warning")) {
            for (WarningValue wv : WarningValue.getWarningValues((Header)h)) {
                if (wv.getWarnCode() != 110) continue;
                warning110Found = true;
                continue block0;
            }
        }
        Assert.assertTrue((boolean)warning110Found);
    }

    @Test
    @Ignore
    public void testCanAlsoServeStale304sWhileRevalidating() throws Exception {
        this.config = CacheConfig.custom().setMaxCacheEntries(100).setMaxObjectSize(1024L).setAsynchronousWorkersMax(1).setSharedCache(false).build();
        this.impl = new CachingExec(this.cache, this.config);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        resp1.setHeader("Cache-Control", (Object)"private, stale-while-revalidate=15");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        this.backendExpectsAnyRequestAndReturn(resp1).times(1, 2);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("If-None-Match", (Object)"\"etag\"");
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)304L, (long)result.getCode());
        boolean warning110Found = false;
        block0: for (Header h : result.getHeaders("Warning")) {
            for (WarningValue wv : WarningValue.getWarningValues((Header)h)) {
                if (wv.getWarnCode() != 110) continue;
                warning110Found = true;
                continue block0;
            }
        }
        Assert.assertTrue((boolean)warning110Found);
    }

    @Test
    public void testStaleWhileRevalidateYieldsToMustRevalidate() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        this.config = CacheConfig.custom().setMaxCacheEntries(100).setMaxObjectSize(1024L).setAsynchronousWorkersMax(1).build();
        this.impl = new CachingExec(this.cache, this.config);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"public, max-age=5, stale-while-revalidate=15, must-revalidate");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        this.backendExpectsAnyRequestAndReturn(resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("Cache-Control", (Object)"public, max-age=5, stale-while-revalidate=15, must-revalidate");
        resp2.setHeader("ETag", (Object)"\"etag\"");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result.getCode());
        boolean warning110Found = false;
        block0: for (Header h : result.getHeaders("Warning")) {
            for (WarningValue wv : WarningValue.getWarningValues((Header)h)) {
                if (wv.getWarnCode() != 110) continue;
                warning110Found = true;
                continue block0;
            }
        }
        Assert.assertFalse((boolean)warning110Found);
    }

    @Test
    public void testStaleWhileRevalidateYieldsToProxyRevalidateForSharedCache() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        this.config = CacheConfig.custom().setMaxCacheEntries(100).setMaxObjectSize(1024L).setAsynchronousWorkersMax(1).setSharedCache(true).build();
        this.impl = new CachingExec(this.cache, this.config);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"public, max-age=5, stale-while-revalidate=15, proxy-revalidate");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        this.backendExpectsAnyRequestAndReturn(resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("Cache-Control", (Object)"public, max-age=5, stale-while-revalidate=15, proxy-revalidate");
        resp2.setHeader("ETag", (Object)"\"etag\"");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result.getCode());
        boolean warning110Found = false;
        block0: for (Header h : result.getHeaders("Warning")) {
            for (WarningValue wv : WarningValue.getWarningValues((Header)h)) {
                if (wv.getWarnCode() != 110) continue;
                warning110Found = true;
                continue block0;
            }
        }
        Assert.assertFalse((boolean)warning110Found);
    }

    @Test
    public void testStaleWhileRevalidateYieldsToExplicitFreshnessRequest() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        this.config = CacheConfig.custom().setMaxCacheEntries(100).setMaxObjectSize(1024L).setAsynchronousWorkersMax(1).setSharedCache(true).build();
        this.impl = new CachingExec(this.cache, this.config);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"public, max-age=5, stale-while-revalidate=15");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        this.backendExpectsAnyRequestAndReturn(resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Cache-Control", (Object)"min-fresh=2");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("Cache-Control", (Object)"public, max-age=5, stale-while-revalidate=15");
        resp2.setHeader("ETag", (Object)"\"etag\"");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result.getCode());
        boolean warning110Found = false;
        block0: for (Header h : result.getHeaders("Warning")) {
            for (WarningValue wv : WarningValue.getWarningValues((Header)h)) {
                if (wv.getWarnCode() != 110) continue;
                warning110Found = true;
                continue block0;
            }
        }
        Assert.assertFalse((boolean)warning110Found);
    }
}

