/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.impl.cache.AbstractProtocolTest;
import org.apache.hc.client5.http.impl.cache.CachingExec;
import org.apache.hc.client5.http.impl.cache.HttpTestUtils;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.entity.BasicHttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestProtocolRequirements
extends AbstractProtocolTest {
    @Test
    public void testCacheMissOnGETUsesOriginResponse() throws Exception {
        EasyMock.expect((Object)this.mockExecChain.proceed(TestProtocolRequirements.eqRequest(this.request), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertTrue((boolean)HttpTestUtils.semanticallyTransparent(this.originResponse, result));
    }

    @Test
    public void testHigherMajorProtocolVersionsOnRequestSwitchToTunnelBehavior() throws Exception {
        this.request = new BasicClassicHttpRequest("GET", "/foo");
        this.request.setVersion(new ProtocolVersion("HTTP", 2, 13));
        EasyMock.expect((Object)this.mockExecChain.proceed(TestProtocolRequirements.eqRequest(this.request), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertSame((Object)this.originResponse, (Object)result);
    }

    @Test
    public void testHigher1_XProtocolVersionsDowngradeTo1_1() throws Exception {
        this.request = new BasicClassicHttpRequest("GET", "/foo");
        this.request.setVersion(new ProtocolVersion("HTTP", 1, 2));
        BasicClassicHttpRequest downgraded = new BasicClassicHttpRequest("GET", "/foo");
        downgraded.setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        EasyMock.expect((Object)this.mockExecChain.proceed(TestProtocolRequirements.eqRequest((ClassicHttpRequest)downgraded), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertTrue((boolean)HttpTestUtils.semanticallyTransparent(this.originResponse, result));
    }

    @Test
    public void testRequestsWithLowerProtocolVersionsGetUpgradedTo1_1() throws Exception {
        this.request = new BasicClassicHttpRequest("GET", "/foo");
        this.request.setVersion(new ProtocolVersion("HTTP", 1, 0));
        BasicClassicHttpRequest upgraded = new BasicClassicHttpRequest("GET", "/foo");
        upgraded.setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        EasyMock.expect((Object)this.mockExecChain.proceed(TestProtocolRequirements.eqRequest((ClassicHttpRequest)upgraded), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertTrue((boolean)HttpTestUtils.semanticallyTransparent(this.originResponse, result));
    }

    @Test
    public void testLowerOriginResponsesUpgradedToOurVersion1_1() throws Exception {
        this.originResponse = new BasicClassicHttpResponse(200, "OK");
        this.originResponse.setVersion(new ProtocolVersion("HTTP", 1, 2));
        this.originResponse.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        this.originResponse.setHeader("Server", (Object)"MockOrigin/1.0");
        this.originResponse.setEntity(this.body);
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)result.getVersion());
    }

    @Test
    public void testResponseToA1_0RequestShouldUse1_1() throws Exception {
        this.request = new BasicClassicHttpRequest("GET", "/foo");
        this.request.setVersion(new ProtocolVersion("HTTP", 1, 0));
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)result.getVersion());
    }

    @Test
    public void testForwardsUnknownHeadersOnRequestsFromHigherProtocolVersions() throws Exception {
        this.request = new BasicClassicHttpRequest("GET", "/foo");
        this.request.setVersion(new ProtocolVersion("HTTP", 1, 2));
        this.request.removeHeaders("Connection");
        this.request.addHeader("X-Unknown-Header", (Object)"some-value");
        BasicClassicHttpRequest downgraded = new BasicClassicHttpRequest("GET", "/foo");
        downgraded.setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        downgraded.removeHeaders("Connection");
        downgraded.addHeader("X-Unknown-Header", (Object)"some-value");
        EasyMock.expect((Object)this.mockExecChain.proceed(TestProtocolRequirements.eqRequest((ClassicHttpRequest)downgraded), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute(this.request);
        this.verifyMocks();
    }

    @Test
    public void testTransferCodingsAreNotSentToAnHTTP_1_0Client() throws Exception {
        this.originResponse.setHeader("Transfer-Encoding", (Object)"identity");
        BasicClassicHttpRequest originalRequest = new BasicClassicHttpRequest("GET", "/foo");
        originalRequest.setVersion(new ProtocolVersion("HTTP", 1, 0));
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)originalRequest);
        this.verifyMocks();
        Assert.assertNull((Object)result.getFirstHeader("TE"));
        Assert.assertNull((Object)result.getFirstHeader("Transfer-Encoding"));
    }

    private void testOrderOfMultipleHeadersIsPreservedOnRequests(String h, ClassicHttpRequest request) throws Exception {
        Capture reqCapture = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)reqCapture), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute(request);
        this.verifyMocks();
        ClassicHttpRequest forwarded = (ClassicHttpRequest)reqCapture.getValue();
        Assert.assertNotNull((Object)forwarded);
        String expected = HttpTestUtils.getCanonicalHeaderValue((HttpMessage)request, h);
        String actual = HttpTestUtils.getCanonicalHeaderValue((HttpMessage)forwarded, h);
        if (!actual.contains(expected)) {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    public void testOrderOfMultipleAcceptHeaderValuesIsPreservedOnRequests() throws Exception {
        this.request.addHeader("Accept", (Object)"audio/*; q=0.2, audio/basic");
        this.request.addHeader("Accept", (Object)"text/*, text/html, text/html;level=1, */*");
        this.testOrderOfMultipleHeadersIsPreservedOnRequests("Accept", this.request);
    }

    @Test
    public void testOrderOfMultipleAcceptCharsetHeadersIsPreservedOnRequests() throws Exception {
        this.request.addHeader("Accept-Charset", (Object)"iso-8859-5");
        this.request.addHeader("Accept-Charset", (Object)"unicode-1-1;q=0.8");
        this.testOrderOfMultipleHeadersIsPreservedOnRequests("Accept-Charset", this.request);
    }

    @Test
    public void testOrderOfMultipleAcceptEncodingHeadersIsPreservedOnRequests() throws Exception {
        this.request.addHeader("Accept-Encoding", (Object)"identity");
        this.request.addHeader("Accept-Encoding", (Object)"compress, gzip");
        this.testOrderOfMultipleHeadersIsPreservedOnRequests("Accept-Encoding", this.request);
    }

    @Test
    public void testOrderOfMultipleAcceptLanguageHeadersIsPreservedOnRequests() throws Exception {
        this.request.addHeader("Accept-Language", (Object)"da, en-gb;q=0.8, en;q=0.7");
        this.request.addHeader("Accept-Language", (Object)"i-cherokee");
        this.testOrderOfMultipleHeadersIsPreservedOnRequests("Accept-Encoding", this.request);
    }

    @Test
    public void testOrderOfMultipleAllowHeadersIsPreservedOnRequests() throws Exception {
        BasicClassicHttpRequest put = new BasicClassicHttpRequest("PUT", "/");
        put.setEntity(this.body);
        put.addHeader("Allow", (Object)"GET, HEAD");
        put.addHeader("Allow", (Object)"DELETE");
        put.addHeader("Content-Length", (Object)"128");
        this.testOrderOfMultipleHeadersIsPreservedOnRequests("Allow", (ClassicHttpRequest)put);
    }

    @Test
    public void testOrderOfMultipleCacheControlHeadersIsPreservedOnRequests() throws Exception {
        this.request.addHeader("Cache-Control", (Object)"max-age=5");
        this.request.addHeader("Cache-Control", (Object)"min-fresh=10");
        this.testOrderOfMultipleHeadersIsPreservedOnRequests("Cache-Control", this.request);
    }

    @Test
    public void testOrderOfMultipleContentEncodingHeadersIsPreservedOnRequests() throws Exception {
        BasicClassicHttpRequest post = new BasicClassicHttpRequest("POST", "/");
        post.setEntity(this.body);
        post.addHeader("Content-Encoding", (Object)"gzip");
        post.addHeader("Content-Encoding", (Object)"compress");
        post.addHeader("Content-Length", (Object)"128");
        this.testOrderOfMultipleHeadersIsPreservedOnRequests("Content-Encoding", (ClassicHttpRequest)post);
    }

    @Test
    public void testOrderOfMultipleContentLanguageHeadersIsPreservedOnRequests() throws Exception {
        BasicClassicHttpRequest post = new BasicClassicHttpRequest("POST", "/");
        post.setEntity(this.body);
        post.addHeader("Content-Language", (Object)"mi");
        post.addHeader("Content-Language", (Object)"en");
        post.addHeader("Content-Length", (Object)"128");
        this.testOrderOfMultipleHeadersIsPreservedOnRequests("Content-Language", (ClassicHttpRequest)post);
    }

    @Test
    public void testOrderOfMultipleExpectHeadersIsPreservedOnRequests() throws Exception {
        BasicClassicHttpRequest post = new BasicClassicHttpRequest("POST", "/");
        post.setEntity(this.body);
        post.addHeader("Expect", (Object)"100-continue");
        post.addHeader("Expect", (Object)"x-expect=true");
        post.addHeader("Content-Length", (Object)"128");
        this.testOrderOfMultipleHeadersIsPreservedOnRequests("Expect", (ClassicHttpRequest)post);
    }

    @Test
    public void testOrderOfMultiplePragmaHeadersIsPreservedOnRequests() throws Exception {
        this.request.addHeader("Pragma", (Object)"no-cache");
        this.request.addHeader("Pragma", (Object)"x-pragma-1, x-pragma-2");
        this.testOrderOfMultipleHeadersIsPreservedOnRequests("Pragma", this.request);
    }

    @Test
    public void testOrderOfMultipleViaHeadersIsPreservedOnRequests() throws Exception {
        this.request.addHeader("Via", (Object)"1.0 fred, 1.1 nowhere.com (Apache/1.1)");
        this.request.addHeader("Via", (Object)"1.0 ricky, 1.1 mertz, 1.0 lucy");
        this.testOrderOfMultipleHeadersIsPreservedOnRequests("Via", this.request);
    }

    @Test
    public void testOrderOfMultipleWarningHeadersIsPreservedOnRequests() throws Exception {
        this.request.addHeader("Warning", (Object)"199 fred \"bargle\"");
        this.request.addHeader("Warning", (Object)"199 barney \"bungle\"");
        this.testOrderOfMultipleHeadersIsPreservedOnRequests("Warning", this.request);
    }

    private void testOrderOfMultipleHeadersIsPreservedOnResponses(String h) throws Exception {
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)HttpTestUtils.getCanonicalHeaderValue((HttpMessage)this.originResponse, h), (Object)HttpTestUtils.getCanonicalHeaderValue((HttpMessage)result, h));
    }

    @Test
    public void testOrderOfMultipleAllowHeadersIsPreservedOnResponses() throws Exception {
        this.originResponse = new BasicClassicHttpResponse(405, "Method Not Allowed");
        this.originResponse.addHeader("Allow", (Object)"HEAD");
        this.originResponse.addHeader("Allow", (Object)"DELETE");
        this.testOrderOfMultipleHeadersIsPreservedOnResponses("Allow");
    }

    @Test
    public void testOrderOfMultipleCacheControlHeadersIsPreservedOnResponses() throws Exception {
        this.originResponse.addHeader("Cache-Control", (Object)"max-age=0");
        this.originResponse.addHeader("Cache-Control", (Object)"no-store, must-revalidate");
        this.testOrderOfMultipleHeadersIsPreservedOnResponses("Cache-Control");
    }

    @Test
    public void testOrderOfMultipleContentEncodingHeadersIsPreservedOnResponses() throws Exception {
        this.originResponse.addHeader("Content-Encoding", (Object)"gzip");
        this.originResponse.addHeader("Content-Encoding", (Object)"compress");
        this.testOrderOfMultipleHeadersIsPreservedOnResponses("Content-Encoding");
    }

    @Test
    public void testOrderOfMultipleContentLanguageHeadersIsPreservedOnResponses() throws Exception {
        this.originResponse.addHeader("Content-Language", (Object)"mi");
        this.originResponse.addHeader("Content-Language", (Object)"en");
        this.testOrderOfMultipleHeadersIsPreservedOnResponses("Content-Language");
    }

    @Test
    public void testOrderOfMultiplePragmaHeadersIsPreservedOnResponses() throws Exception {
        this.originResponse.addHeader("Pragma", (Object)"no-cache, x-pragma-2");
        this.originResponse.addHeader("Pragma", (Object)"x-pragma-1");
        this.testOrderOfMultipleHeadersIsPreservedOnResponses("Pragma");
    }

    @Test
    public void testOrderOfMultipleViaHeadersIsPreservedOnResponses() throws Exception {
        this.originResponse.addHeader("Via", (Object)"1.0 fred, 1.1 nowhere.com (Apache/1.1)");
        this.originResponse.addHeader("Via", (Object)"1.0 ricky, 1.1 mertz, 1.0 lucy");
        this.testOrderOfMultipleHeadersIsPreservedOnResponses("Via");
    }

    @Test
    public void testOrderOfMultipleWWWAuthenticateHeadersIsPreservedOnResponses() throws Exception {
        this.originResponse.addHeader("WWW-Authenticate", (Object)"x-challenge-1");
        this.originResponse.addHeader("WWW-Authenticate", (Object)"x-challenge-2");
        this.testOrderOfMultipleHeadersIsPreservedOnResponses("WWW-Authenticate");
    }

    private void testUnknownResponseStatusCodeIsNotCached(int code) throws Exception {
        this.emptyMockCacheExpectsNoPuts();
        this.originResponse = new BasicClassicHttpResponse(code, "Moo");
        this.originResponse.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        this.originResponse.setHeader("Server", (Object)"MockOrigin/1.0");
        this.originResponse.setHeader("Cache-Control", (Object)"max-age=3600");
        this.originResponse.setEntity(this.body);
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute(this.request);
        this.verifyMocks();
    }

    @Test
    public void testUnknownResponseStatusCodesAreNotCached() throws Exception {
        int i;
        for (i = 102; i <= 199; ++i) {
            this.testUnknownResponseStatusCodeIsNotCached(i);
        }
        for (i = 207; i <= 299; ++i) {
            this.testUnknownResponseStatusCodeIsNotCached(i);
        }
        for (i = 308; i <= 399; ++i) {
            this.testUnknownResponseStatusCodeIsNotCached(i);
        }
        for (i = 418; i <= 499; ++i) {
            this.testUnknownResponseStatusCodeIsNotCached(i);
        }
        for (i = 506; i <= 999; ++i) {
            this.testUnknownResponseStatusCodeIsNotCached(i);
        }
    }

    @Test
    public void testUnknownHeadersOnRequestsAreForwarded() throws Exception {
        this.request.addHeader("X-Unknown-Header", (Object)"blahblah");
        Capture reqCap = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)reqCap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute(this.request);
        this.verifyMocks();
        ClassicHttpRequest forwarded = (ClassicHttpRequest)reqCap.getValue();
        Header[] hdrs = forwarded.getHeaders("X-Unknown-Header");
        Assert.assertEquals((long)1L, (long)hdrs.length);
        Assert.assertEquals((Object)"blahblah", (Object)hdrs[0].getValue());
    }

    @Test
    public void testUnknownHeadersOnResponsesAreForwarded() throws Exception {
        this.originResponse.addHeader("X-Unknown-Header", (Object)"blahblah");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Header[] hdrs = result.getHeaders("X-Unknown-Header");
        Assert.assertEquals((long)1L, (long)hdrs.length);
        Assert.assertEquals((Object)"blahblah", (Object)hdrs[0].getValue());
    }

    @Test
    public void testRequestsExpecting100ContinueBehaviorShouldSetExpectHeader() throws Exception {
        BasicClassicHttpRequest post = new BasicClassicHttpRequest("POST", "/");
        post.setHeader("Expect", (Object)"100-continue");
        post.setHeader("Content-Length", (Object)"128");
        post.setEntity((HttpEntity)new BasicHttpEntity());
        Capture reqCap = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)reqCap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute((ClassicHttpRequest)post);
        this.verifyMocks();
        ClassicHttpRequest forwarded = (ClassicHttpRequest)reqCap.getValue();
        boolean foundExpect = false;
        Iterator it = MessageSupport.iterate((MessageHeaders)forwarded, (String)"Expect");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (!"100-continue".equalsIgnoreCase(elt.getName())) continue;
            foundExpect = true;
            break;
        }
        Assert.assertTrue((boolean)foundExpect);
    }

    @Test
    public void testRequestsNotExpecting100ContinueBehaviorShouldNotSetExpectContinueHeader() throws Exception {
        BasicClassicHttpRequest post = new BasicClassicHttpRequest("POST", "/");
        post.setHeader("Content-Length", (Object)"128");
        post.setEntity((HttpEntity)new BasicHttpEntity());
        Capture reqCap = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)reqCap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute((ClassicHttpRequest)post);
        this.verifyMocks();
        ClassicHttpRequest forwarded = (ClassicHttpRequest)reqCap.getValue();
        boolean foundExpect = false;
        Iterator it = MessageSupport.iterate((MessageHeaders)forwarded, (String)"Expect");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (!"100-continue".equalsIgnoreCase(elt.getName())) continue;
            foundExpect = true;
            break;
        }
        Assert.assertFalse((boolean)foundExpect);
    }

    @Test
    public void testExpectHeadersAreForwardedOnRequests() throws Exception {
    }

    @Test
    public void test100ContinueResponsesAreNotForwardedTo1_0ClientsWhoDidNotAskForThem() throws Exception {
        BasicClassicHttpRequest post = new BasicClassicHttpRequest("POST", "/");
        post.setVersion(new ProtocolVersion("HTTP", 1, 0));
        post.setEntity(this.body);
        post.setHeader("Content-Length", (Object)"128");
        this.originResponse = new BasicClassicHttpResponse(100, "Continue");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        try {
            this.execute((ClassicHttpRequest)post);
            Assert.fail((String)"should have thrown an exception");
        }
        catch (ClientProtocolException clientProtocolException) {
            // empty catch block
        }
        this.verifyMocks();
    }

    @Test
    public void testResponsesToOPTIONSAreNotCacheable() throws Exception {
        this.emptyMockCacheExpectsNoPuts();
        this.request = new BasicClassicHttpRequest("OPTIONS", "/");
        this.originResponse.addHeader("Cache-Control", (Object)"max-age=3600");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute(this.request);
        this.verifyMocks();
    }

    @Test
    public void test200ResponseToOPTIONSWithNoBodyShouldIncludeContentLengthZero() throws Exception {
        this.request = new BasicClassicHttpRequest("OPTIONS", "/");
        this.originResponse.setEntity(null);
        this.originResponse.setHeader("Content-Length", (Object)"0");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Header contentLength = result.getFirstHeader("Content-Length");
        Assert.assertNotNull((Object)contentLength);
        Assert.assertEquals((Object)"0", (Object)contentLength.getValue());
    }

    @Test
    public void testDoesNotForwardOPTIONSWhenMaxForwardsIsZeroOnAbsoluteURIRequest() throws Exception {
        this.request = new BasicClassicHttpRequest("OPTIONS", "*");
        this.request.setHeader("Max-Forwards", (Object)"0");
        this.replayMocks();
        this.execute(this.request);
        this.verifyMocks();
    }

    @Test
    public void testDecrementsMaxForwardsWhenForwardingOPTIONSRequest() throws Exception {
        this.request = new BasicClassicHttpRequest("OPTIONS", "*");
        this.request.setHeader("Max-Forwards", (Object)"7");
        Capture cap = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute(this.request);
        this.verifyMocks();
        ClassicHttpRequest captured = (ClassicHttpRequest)cap.getValue();
        Assert.assertEquals((Object)"6", (Object)captured.getFirstHeader("Max-Forwards").getValue());
    }

    @Test
    public void testDoesNotAddAMaxForwardsHeaderToForwardedOPTIONSRequests() throws Exception {
        this.request = new BasicClassicHttpRequest("OPTIONS", "/");
        Capture reqCap = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)reqCap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute(this.request);
        this.verifyMocks();
        ClassicHttpRequest forwarded = (ClassicHttpRequest)reqCap.getValue();
        Assert.assertNull((Object)forwarded.getFirstHeader("Max-Forwards"));
    }

    @Test
    public void testResponseToAHEADRequestMustNotHaveABody() throws Exception {
        this.request = new BasicClassicHttpRequest("HEAD", "/");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertTrue((result.getEntity() == null || result.getEntity().getContentLength() == 0L ? 1 : 0) != 0);
    }

    private void testHEADResponseWithUpdatedEntityFieldsMakeACacheEntryStale(String eHeader, String oldVal, String newVal) throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.addHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader(eHeader, (Object)oldVal);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("HEAD", "/");
        req2.addHeader("Cache-Control", (Object)"no-cache");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setEntity(null);
        resp2.setHeader(eHeader, (Object)newVal);
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        req3.addHeader("Cache-Control", (Object)"max-stale=0");
        ClassicHttpResponse resp3 = HttpTestUtils.make200Response();
        resp3.setHeader(eHeader, (Object)newVal);
        EasyMock.expect((Object)this.mockExecChain.proceed(TestProtocolRequirements.eqRequest((ClassicHttpRequest)req1), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        EasyMock.expect((Object)this.mockExecChain.proceed(TestProtocolRequirements.eqRequest((ClassicHttpRequest)req2), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp3);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
    }

    @Test
    public void testHEADResponseWithUpdatedContentLengthFieldMakeACacheEntryStale() throws Exception {
        this.testHEADResponseWithUpdatedEntityFieldsMakeACacheEntryStale("Content-Length", "128", "127");
    }

    @Test
    public void testHEADResponseWithUpdatedContentMD5FieldMakeACacheEntryStale() throws Exception {
        this.testHEADResponseWithUpdatedEntityFieldsMakeACacheEntryStale("Content-MD5", "Q2hlY2sgSW50ZWdyaXR5IQ==", "Q2hlY2sgSW50ZWdyaXR5IR==");
    }

    @Test
    public void testHEADResponseWithUpdatedETagFieldMakeACacheEntryStale() throws Exception {
        this.testHEADResponseWithUpdatedEntityFieldsMakeACacheEntryStale("ETag", "\"etag1\"", "\"etag2\"");
    }

    @Test
    public void testHEADResponseWithUpdatedLastModifiedFieldMakeACacheEntryStale() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        Date sixSecondsAgo = new Date(now.getTime() - 6000L);
        this.testHEADResponseWithUpdatedEntityFieldsMakeACacheEntryStale("Last-Modified", DateUtils.formatDate((Date)tenSecondsAgo), DateUtils.formatDate((Date)sixSecondsAgo));
    }

    @Test
    public void testResponsesToPOSTWithoutCacheControlOrExpiresAreNotCached() throws Exception {
        this.emptyMockCacheExpectsNoPuts();
        BasicClassicHttpRequest post = new BasicClassicHttpRequest("POST", "/");
        post.setHeader("Content-Length", (Object)"128");
        post.setEntity(HttpTestUtils.makeBody(128));
        this.originResponse.removeHeaders("Cache-Control");
        this.originResponse.removeHeaders("Expires");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute((ClassicHttpRequest)post);
        this.verifyMocks();
    }

    @Test
    public void testResponsesToPUTsAreNotCached() throws Exception {
        this.emptyMockCacheExpectsNoPuts();
        BasicClassicHttpRequest put = new BasicClassicHttpRequest("PUT", "/");
        put.setEntity(HttpTestUtils.makeBody(128));
        put.addHeader("Content-Length", (Object)"128");
        this.originResponse.setHeader("Cache-Control", (Object)"max-age=3600");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute((ClassicHttpRequest)put);
        this.verifyMocks();
    }

    @Test
    public void testResponsesToDELETEsAreNotCached() throws Exception {
        this.emptyMockCacheExpectsNoPuts();
        this.request = new BasicClassicHttpRequest("DELETE", "/");
        this.originResponse.setHeader("Cache-Control", (Object)"max-age=3600");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute(this.request);
        this.verifyMocks();
    }

    @Test
    public void testResponsesToTRACEsAreNotCached() throws Exception {
        this.emptyMockCacheExpectsNoPuts();
        this.request = new BasicClassicHttpRequest("TRACE", "/");
        this.originResponse.setHeader("Cache-Control", (Object)"max-age=3600");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute(this.request);
        this.verifyMocks();
    }

    @Test
    public void test204ResponsesDoNotContainMessageBodies() throws Exception {
        this.originResponse = new BasicClassicHttpResponse(204, "No Content");
        this.originResponse.setEntity(HttpTestUtils.makeBody(this.entityLength));
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
    }

    @Test
    public void test206ResponseGeneratedFromCacheMustHaveContentRangeOrMultipartByteRangesContentType() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Range", (Object)"bytes=0-50");
        this.backendExpectsAnyRequestAndReturn(resp1).times(1, 2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        if (206 == result.getCode() && result.getFirstHeader("Content-Range") == null) {
            HeaderElement elt = MessageSupport.parse((Header)result.getFirstHeader("Content-Type"))[0];
            Assert.assertTrue((boolean)"multipart/byteranges".equalsIgnoreCase(elt.getName()));
            Assert.assertNotNull((Object)elt.getParameterByName("boundary"));
            Assert.assertNotNull((Object)elt.getParameterByName("boundary").getValue());
            Assert.assertFalse((boolean)"".equals(elt.getParameterByName("boundary").getValue().trim()));
        }
    }

    @Test
    public void test206ResponseGeneratedFromCacheMustHaveABodyThatMatchesContentLengthHeaderIfPresent() throws Exception {
        Header h;
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Range", (Object)"bytes=0-50");
        this.backendExpectsAnyRequestAndReturn(resp1).times(1, 2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        if (206 == result.getCode() && (h = result.getFirstHeader("Content-Length")) != null) {
            int contentLength = Integer.parseInt(h.getValue());
            int bytesRead = 0;
            InputStream i = result.getEntity().getContent();
            while (i.read() != -1) {
                ++bytesRead;
            }
            i.close();
            Assert.assertEquals((long)contentLength, (long)bytesRead);
        }
    }

    @Test
    public void test206ResponseGeneratedFromCacheMustHaveDateHeader() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Range", (Object)"bytes=0-50");
        this.backendExpectsAnyRequestAndReturn(resp1).times(1, 2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        if (206 == result.getCode()) {
            Assert.assertNotNull((Object)result.getFirstHeader("Date"));
        }
    }

    @Test
    public void test206ResponseReturnedToClientMustHaveDateHeader() throws Exception {
        this.request.addHeader("Range", (Object)"bytes=0-50");
        this.originResponse = new BasicClassicHttpResponse(206, "Partial Content");
        this.originResponse.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        this.originResponse.setHeader("Server", (Object)"MockOrigin/1.0");
        this.originResponse.setEntity(HttpTestUtils.makeBody(500));
        this.originResponse.setHeader("Content-Range", (Object)"bytes 0-499/1234");
        this.originResponse.removeHeaders("Date");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        Assert.assertTrue((result.getCode() != 206 || result.getFirstHeader("Date") != null ? 1 : 0) != 0);
        this.verifyMocks();
    }

    @Test
    public void test206ContainsETagIfA200ResponseWouldHaveIncludedIt() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        this.originResponse.addHeader("Cache-Control", (Object)"max-age=3600");
        this.originResponse.addHeader("ETag", (Object)"\"etag1\"");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.addHeader("Range", (Object)"bytes=0-50");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse).times(1, 2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        if (result.getCode() == 206) {
            Assert.assertNotNull((Object)result.getFirstHeader("ETag"));
        }
    }

    @Test
    public void test206ContainsContentLocationIfA200ResponseWouldHaveIncludedIt() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        this.originResponse.addHeader("Cache-Control", (Object)"max-age=3600");
        this.originResponse.addHeader("Content-Location", (Object)"http://foo.example.com/other/url");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.addHeader("Range", (Object)"bytes=0-50");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse).times(1, 2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        if (result.getCode() == 206) {
            Assert.assertNotNull((Object)result.getFirstHeader("Content-Location"));
        }
    }

    @Test
    public void test206ResponseIncludesVariantHeadersIfValueMightDiffer() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        req1.addHeader("Accept-Encoding", (Object)"gzip");
        Date now = new Date();
        Date inOneHour = new Date(now.getTime() + 3600000L);
        this.originResponse.addHeader("Cache-Control", (Object)"max-age=3600");
        this.originResponse.addHeader("Expires", (Object)DateUtils.formatDate((Date)inOneHour));
        this.originResponse.addHeader("Vary", (Object)"Accept-Encoding");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.addHeader("Cache-Control", (Object)"no-cache");
        req2.addHeader("Accept-Encoding", (Object)"gzip");
        Date nextSecond = new Date(now.getTime() + 1000L);
        Date inTwoHoursPlusASec = new Date(now.getTime() + 0x6DDD00L + 1000L);
        ClassicHttpResponse originResponse2 = HttpTestUtils.make200Response();
        originResponse2.setHeader("Date", (Object)DateUtils.formatDate((Date)nextSecond));
        originResponse2.setHeader("Cache-Control", (Object)"max-age=7200");
        originResponse2.setHeader("Expires", (Object)DateUtils.formatDate((Date)inTwoHoursPlusASec));
        originResponse2.setHeader("Vary", (Object)"Accept-Encoding");
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        req3.addHeader("Range", (Object)"bytes=0-50");
        req3.addHeader("Accept-Encoding", (Object)"gzip");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.backendExpectsAnyRequestAndReturn(originResponse2).times(1, 2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
        if (result.getCode() == 206) {
            Assert.assertNotNull((Object)result.getFirstHeader("Expires"));
            Assert.assertNotNull((Object)result.getFirstHeader("Cache-Control"));
            Assert.assertNotNull((Object)result.getFirstHeader("Vary"));
        }
    }

    @Test
    public void test206ResponseToConditionalRangeRequestDoesNotIncludeOtherEntityHeaders() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        Date now = new Date();
        Date oneHourAgo = new Date(now.getTime() - 3600000L);
        this.originResponse = HttpTestUtils.make200Response();
        this.originResponse.addHeader("Allow", (Object)"GET,HEAD");
        this.originResponse.addHeader("Cache-Control", (Object)"max-age=3600");
        this.originResponse.addHeader("Content-Language", (Object)"en");
        this.originResponse.addHeader("Content-Encoding", (Object)"x-coding");
        this.originResponse.addHeader("Content-MD5", (Object)"Q2hlY2sgSW50ZWdyaXR5IQ==");
        this.originResponse.addHeader("Content-Length", (Object)"128");
        this.originResponse.addHeader("Content-Type", (Object)"application/octet-stream");
        this.originResponse.addHeader("Last-Modified", (Object)DateUtils.formatDate((Date)oneHourAgo));
        this.originResponse.addHeader("ETag", (Object)"W/\"weak-tag\"");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.addHeader("If-Range", (Object)"W/\"weak-tag\"");
        req2.addHeader("Range", (Object)"bytes=0-50");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse).times(1, 2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        if (result.getCode() == 206) {
            Assert.assertNull((Object)result.getFirstHeader("Allow"));
            Assert.assertNull((Object)result.getFirstHeader("Content-Encoding"));
            Assert.assertNull((Object)result.getFirstHeader("Content-Language"));
            Assert.assertNull((Object)result.getFirstHeader("Content-MD5"));
            Assert.assertNull((Object)result.getFirstHeader("Last-Modified"));
        }
    }

    @Test
    public void test206ResponseToIfRangeWithStrongValidatorReturnsAllEntityHeaders() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        Date now = new Date();
        Date oneHourAgo = new Date(now.getTime() - 3600000L);
        this.originResponse.addHeader("Allow", (Object)"GET,HEAD");
        this.originResponse.addHeader("Cache-Control", (Object)"max-age=3600");
        this.originResponse.addHeader("Content-Language", (Object)"en");
        this.originResponse.addHeader("Content-Encoding", (Object)"x-coding");
        this.originResponse.addHeader("Content-MD5", (Object)"Q2hlY2sgSW50ZWdyaXR5IQ==");
        this.originResponse.addHeader("Content-Length", (Object)"128");
        this.originResponse.addHeader("Content-Type", (Object)"application/octet-stream");
        this.originResponse.addHeader("Last-Modified", (Object)DateUtils.formatDate((Date)oneHourAgo));
        this.originResponse.addHeader("ETag", (Object)"\"strong-tag\"");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.addHeader("If-Range", (Object)"\"strong-tag\"");
        req2.addHeader("Range", (Object)"bytes=0-50");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse).times(1, 2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        if (result.getCode() == 206) {
            Assert.assertEquals((Object)"GET,HEAD", (Object)result.getFirstHeader("Allow").getValue());
            Assert.assertEquals((Object)"max-age=3600", (Object)result.getFirstHeader("Cache-Control").getValue());
            Assert.assertEquals((Object)"en", (Object)result.getFirstHeader("Content-Language").getValue());
            Assert.assertEquals((Object)"x-coding", (Object)result.getFirstHeader("Content-Encoding").getValue());
            Assert.assertEquals((Object)"Q2hlY2sgSW50ZWdyaXR5IQ==", (Object)result.getFirstHeader("Content-MD5").getValue());
            Assert.assertEquals((Object)this.originResponse.getFirstHeader("Last-Modified").getValue(), (Object)result.getFirstHeader("Last-Modified").getValue());
        }
    }

    @Test
    public void test206ResponseIsNotCombinedWithPreviousContentIfETagDoesNotMatch() throws Exception {
        int b;
        Date now = new Date();
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("ETag", (Object)"\"etag1\"");
        byte[] bytes1 = new byte[128];
        for (int i = 0; i < bytes1.length; ++i) {
            bytes1[i] = 1;
        }
        resp1.setEntity((HttpEntity)new ByteArrayEntity(bytes1));
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Cache-Control", (Object)"no-cache");
        req2.setHeader("Range", (Object)"bytes=0-50");
        Date inOneSecond = new Date(now.getTime() + 1000L);
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(206, "Partial Content");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)inOneSecond));
        resp2.setHeader("Server", (Object)resp1.getFirstHeader("Server").getValue());
        resp2.setHeader("ETag", (Object)"\"etag2\"");
        resp2.setHeader("Content-Range", (Object)"bytes 0-50/128");
        byte[] bytes2 = new byte[51];
        for (int i = 0; i < bytes2.length; ++i) {
            bytes2[i] = 2;
        }
        resp2.setEntity((HttpEntity)new ByteArrayEntity(bytes2));
        Date inTwoSeconds = new Date(now.getTime() + 2000L);
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp3 = HttpTestUtils.make200Response();
        resp3.setHeader("Date", (Object)DateUtils.formatDate((Date)inTwoSeconds));
        resp3.setHeader("Cache-Control", (Object)"max-age=3600");
        resp3.setHeader("ETag", (Object)"\"etag2\"");
        byte[] bytes3 = new byte[128];
        for (int i = 0; i < bytes3.length; ++i) {
            bytes3[i] = 2;
        }
        resp3.setEntity((HttpEntity)new ByteArrayEntity(bytes3));
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp1);
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp2);
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp3).times(0, 1);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
        InputStream i = result.getEntity().getContent();
        boolean found1 = false;
        boolean found2 = false;
        while ((b = i.read()) != -1) {
            if (b == 1) {
                found1 = true;
            }
            if (b != 2) continue;
            found2 = true;
        }
        i.close();
        Assert.assertFalse((found1 && found2 ? 1 : 0) != 0);
    }

    @Test
    public void test206ResponseIsNotCombinedWithPreviousContentIfLastModifiedDoesNotMatch() throws Exception {
        int b;
        Date now = new Date();
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        Date oneHourAgo = new Date(now.getTime() - 3600L);
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Last-Modified", (Object)DateUtils.formatDate((Date)oneHourAgo));
        byte[] bytes1 = new byte[128];
        for (int i = 0; i < bytes1.length; ++i) {
            bytes1[i] = 1;
        }
        resp1.setEntity((HttpEntity)new ByteArrayEntity(bytes1));
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Cache-Control", (Object)"no-cache");
        req2.setHeader("Range", (Object)"bytes=0-50");
        Date inOneSecond = new Date(now.getTime() + 1000L);
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(206, "Partial Content");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)inOneSecond));
        resp2.setHeader("Server", (Object)resp1.getFirstHeader("Server").getValue());
        resp2.setHeader("Last-Modified", (Object)DateUtils.formatDate((Date)now));
        resp2.setHeader("Content-Range", (Object)"bytes 0-50/128");
        byte[] bytes2 = new byte[51];
        for (int i = 0; i < bytes2.length; ++i) {
            bytes2[i] = 2;
        }
        resp2.setEntity((HttpEntity)new ByteArrayEntity(bytes2));
        Date inTwoSeconds = new Date(now.getTime() + 2000L);
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp3 = HttpTestUtils.make200Response();
        resp3.setHeader("Date", (Object)DateUtils.formatDate((Date)inTwoSeconds));
        resp3.setHeader("Cache-Control", (Object)"max-age=3600");
        resp3.setHeader("ETag", (Object)"\"etag2\"");
        byte[] bytes3 = new byte[128];
        for (int i = 0; i < bytes3.length; ++i) {
            bytes3[i] = 2;
        }
        resp3.setEntity((HttpEntity)new ByteArrayEntity(bytes3));
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp1);
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp2);
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp3).times(0, 1);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
        InputStream i = result.getEntity().getContent();
        boolean found1 = false;
        boolean found2 = false;
        while ((b = i.read()) != -1) {
            if (b == 1) {
                found1 = true;
            }
            if (b != 2) continue;
            found2 = true;
        }
        i.close();
        Assert.assertFalse((found1 && found2 ? 1 : 0) != 0);
    }

    @Test
    public void test206ResponsesAreNotCachedIfTheCacheDoesNotSupportRangeAndContentRangeHeaders() throws Exception {
        if (!this.supportsRangeAndContentRangeHeaders(this.impl)) {
            this.emptyMockCacheExpectsNoPuts();
            this.request = new BasicClassicHttpRequest("GET", "/");
            this.request.addHeader("Range", (Object)"bytes=0-50");
            this.originResponse = new BasicClassicHttpResponse(206, "Partial Content");
            this.originResponse.setHeader("Content-Range", (Object)"bytes 0-50/128");
            this.originResponse.setHeader("Cache-Control", (Object)"max-age=3600");
            byte[] bytes = new byte[51];
            new Random().nextBytes(bytes);
            this.originResponse.setEntity((HttpEntity)new ByteArrayEntity(bytes));
            EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
            this.replayMocks();
            this.execute(this.request);
            this.verifyMocks();
        }
    }

    @Test
    public void test303ResponsesAreNotCached() throws Exception {
        this.emptyMockCacheExpectsNoPuts();
        this.request = new BasicClassicHttpRequest("GET", "/");
        this.originResponse = new BasicClassicHttpResponse(303, "See Other");
        this.originResponse.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        this.originResponse.setHeader("Server", (Object)"MockServer/1.0");
        this.originResponse.setHeader("Cache-Control", (Object)"max-age=3600");
        this.originResponse.setHeader("Content-Type", (Object)"application/x-cachingclient-test");
        this.originResponse.setHeader("Location", (Object)"http://foo.example.com/other");
        this.originResponse.setEntity(HttpTestUtils.makeBody(this.entityLength));
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute(this.request);
        this.verifyMocks();
    }

    @Test
    public void test304ResponseDoesNotContainABody() throws Exception {
        this.request.setHeader("If-None-Match", (Object)"\"etag\"");
        this.originResponse = new BasicClassicHttpResponse(304, "Not Modified");
        this.originResponse.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        this.originResponse.setHeader("Server", (Object)"MockServer/1.0");
        this.originResponse.setHeader("Content-Length", (Object)"128");
        this.originResponse.setEntity(HttpTestUtils.makeBody(this.entityLength));
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
    }

    @Test
    public void test304ResponseWithDateHeaderForwardedFromOriginIncludesDateHeader() throws Exception {
        this.request.setHeader("If-None-Match", (Object)"\"etag\"");
        this.originResponse = new BasicClassicHttpResponse(304, "Not Modified");
        this.originResponse.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        this.originResponse.setHeader("Server", (Object)"MockServer/1.0");
        this.originResponse.setHeader("ETag", (Object)"\"etag\"");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertNotNull((Object)result.getFirstHeader("Date"));
    }

    @Test
    public void test304ResponseGeneratedFromCacheIncludesDateHeader() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        this.originResponse.setHeader("Cache-Control", (Object)"max-age=3600");
        this.originResponse.setHeader("ETag", (Object)"\"etag\"");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("If-None-Match", (Object)"\"etag\"");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse).times(1, 2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        if (result.getCode() == 304) {
            Assert.assertNotNull((Object)result.getFirstHeader("Date"));
        }
    }

    @Test
    public void test304ResponseGeneratedFromCacheIncludesEtagIfOriginResponseDid() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        this.originResponse.setHeader("Cache-Control", (Object)"max-age=3600");
        this.originResponse.setHeader("ETag", (Object)"\"etag\"");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("If-None-Match", (Object)"\"etag\"");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse).times(1, 2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        if (result.getCode() == 304) {
            Assert.assertNotNull((Object)result.getFirstHeader("ETag"));
        }
    }

    @Test
    public void test304ResponseGeneratedFromCacheIncludesContentLocationIfOriginResponseDid() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        this.originResponse.setHeader("Cache-Control", (Object)"max-age=3600");
        this.originResponse.setHeader("Content-Location", (Object)"http://foo.example.com/other");
        this.originResponse.setHeader("ETag", (Object)"\"etag\"");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("If-None-Match", (Object)"\"etag\"");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse).times(1, 2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        if (result.getCode() == 304) {
            Assert.assertNotNull((Object)result.getFirstHeader("Content-Location"));
        }
    }

    @Test
    public void test304ResponseGeneratedFromCacheIncludesExpiresCacheControlAndOrVaryIfResponseMightDiffer() throws Exception {
        Date now = new Date();
        Date inTwoHours = new Date(now.getTime() + 0x6DDD00L);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        req1.setHeader("Accept-Encoding", (Object)"gzip");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("ETag", (Object)"\"v1\"");
        resp1.setHeader("Cache-Control", (Object)"max-age=7200");
        resp1.setHeader("Expires", (Object)DateUtils.formatDate((Date)inTwoHours));
        resp1.setHeader("Vary", (Object)"Accept-Encoding");
        resp1.setEntity(HttpTestUtils.makeBody(this.entityLength));
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req1.setHeader("Accept-Encoding", (Object)"gzip");
        req1.setHeader("Cache-Control", (Object)"no-cache");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("ETag", (Object)"\"v2\"");
        resp2.setHeader("Cache-Control", (Object)"max-age=3600");
        resp2.setHeader("Expires", (Object)DateUtils.formatDate((Date)inTwoHours));
        resp2.setHeader("Vary", (Object)"Accept-Encoding");
        resp2.setEntity(HttpTestUtils.makeBody(this.entityLength));
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        req3.setHeader("Accept-Encoding", (Object)"gzip");
        req3.setHeader("If-None-Match", (Object)"\"v2\"");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp1);
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp2).times(1, 2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
        if (result.getCode() == 304) {
            Assert.assertNotNull((Object)result.getFirstHeader("Expires"));
            Assert.assertNotNull((Object)result.getFirstHeader("Cache-Control"));
            Assert.assertNotNull((Object)result.getFirstHeader("Vary"));
        }
    }

    @Test
    public void test304GeneratedFromCacheOnWeakValidatorDoesNotIncludeOtherEntityHeaders() throws Exception {
        Date now = new Date();
        Date oneHourAgo = new Date(now.getTime() - 3600000L);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("ETag", (Object)"W/\"v1\"");
        resp1.setHeader("Allow", (Object)"GET,HEAD");
        resp1.setHeader("Content-Encoding", (Object)"x-coding");
        resp1.setHeader("Content-Language", (Object)"en");
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("Content-MD5", (Object)"Q2hlY2sgSW50ZWdyaXR5IQ==");
        resp1.setHeader("Content-Type", (Object)"application/octet-stream");
        resp1.setHeader("Last-Modified", (Object)DateUtils.formatDate((Date)oneHourAgo));
        resp1.setHeader("Cache-Control", (Object)"max-age=7200");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("If-None-Match", (Object)"W/\"v1\"");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp1).times(1, 2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        if (result.getCode() == 304) {
            Assert.assertNull((Object)result.getFirstHeader("Allow"));
            Assert.assertNull((Object)result.getFirstHeader("Content-Encoding"));
            Assert.assertNull((Object)result.getFirstHeader("Content-Length"));
            Assert.assertNull((Object)result.getFirstHeader("Content-MD5"));
            Assert.assertNull((Object)result.getFirstHeader("Content-Type"));
            Assert.assertNull((Object)result.getFirstHeader("Last-Modified"));
        }
    }

    @Test
    public void testNotModifiedOfNonCachedEntityShouldRevalidateWithUnconditionalGET() throws Exception {
        Date now = new Date();
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("ETag", (Object)"\"etag1\"");
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Cache-Control", (Object)"max-age=0,max-stale=0");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(304, "Not Modified");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp2.setHeader("Server", (Object)"MockServer/1.0");
        resp2.setHeader("ETag", (Object)"\"etag2\"");
        BasicClassicHttpRequest conditionalValidation = new BasicClassicHttpRequest("GET", "/");
        conditionalValidation.setHeader("If-None-Match", (Object)"\"etag1\"");
        BasicClassicHttpRequest unconditionalValidation = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp3 = HttpTestUtils.make200Response();
        resp1.setHeader("ETag", (Object)"\"etag2\"");
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp1);
        EasyMock.expect((Object)this.mockExecChain.proceed(TestProtocolRequirements.eqRequest((ClassicHttpRequest)conditionalValidation), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp2).times(0, 1);
        EasyMock.expect((Object)this.mockExecChain.proceed(TestProtocolRequirements.eqRequest((ClassicHttpRequest)unconditionalValidation), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp3);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
    }

    @Test
    public void testCacheEntryIsUpdatedWithNewFieldValuesIn304Response() throws Exception {
        Date now = new Date();
        Date inFiveSeconds = new Date(now.getTime() + 5000L);
        BasicClassicHttpRequest initialRequest = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse cachedResponse = HttpTestUtils.make200Response();
        cachedResponse.setHeader("Cache-Control", (Object)"max-age=3600");
        cachedResponse.setHeader("ETag", (Object)"\"etag\"");
        BasicClassicHttpRequest secondRequest = new BasicClassicHttpRequest("GET", "/");
        secondRequest.setHeader("Cache-Control", (Object)"max-age=0,max-stale=0");
        BasicClassicHttpRequest conditionalValidationRequest = new BasicClassicHttpRequest("GET", "/");
        conditionalValidationRequest.setHeader("If-None-Match", (Object)"\"etag\"");
        BasicClassicHttpRequest unconditionalValidationRequest = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse conditionalResponse = HttpTestUtils.make304Response();
        conditionalResponse.setHeader("Date", (Object)DateUtils.formatDate((Date)inFiveSeconds));
        conditionalResponse.setHeader("Server", (Object)"MockUtils/1.0");
        conditionalResponse.setHeader("ETag", (Object)"\"etag\"");
        conditionalResponse.setHeader("X-Extra", (Object)"junk");
        ClassicHttpResponse unconditionalResponse = HttpTestUtils.make200Response();
        unconditionalResponse.setHeader("Date", (Object)DateUtils.formatDate((Date)inFiveSeconds));
        unconditionalResponse.setHeader("ETag", (Object)"\"etag\"");
        Capture cap1 = new Capture();
        Capture cap2 = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)cachedResponse);
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.and((Object)TestProtocolRequirements.eqRequest((ClassicHttpRequest)conditionalValidationRequest), (Object)EasyMock.capture((Capture)cap1)), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)conditionalResponse).times(0, 1);
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.and((Object)TestProtocolRequirements.eqRequest((ClassicHttpRequest)unconditionalValidationRequest), (Object)EasyMock.capture((Capture)cap2)), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)unconditionalResponse).times(0, 1);
        this.replayMocks();
        this.execute((ClassicHttpRequest)initialRequest);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)secondRequest);
        this.verifyMocks();
        Assert.assertTrue((cap1.hasCaptured() && !cap2.hasCaptured() || !cap1.hasCaptured() && cap2.hasCaptured() ? 1 : 0) != 0);
        if (cap1.hasCaptured()) {
            Assert.assertEquals((Object)DateUtils.formatDate((Date)inFiveSeconds), (Object)result.getFirstHeader("Date").getValue());
            Assert.assertEquals((Object)"junk", (Object)result.getFirstHeader("X-Extra").getValue());
        }
    }

    @Test
    public void testMustIncludeWWWAuthenticateHeaderOnAnOrigin401Response() throws Exception {
        this.originResponse = new BasicClassicHttpResponse(401, "Unauthorized");
        this.originResponse.setHeader("WWW-Authenticate", (Object)"x-scheme x-param");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        if (result.getCode() == 401) {
            Assert.assertNotNull((Object)result.getFirstHeader("WWW-Authenticate"));
        }
        this.verifyMocks();
    }

    @Test
    public void testMustIncludeAllowHeaderFromAnOrigin405Response() throws Exception {
        this.originResponse = new BasicClassicHttpResponse(405, "Method Not Allowed");
        this.originResponse.setHeader("Allow", (Object)"GET, HEAD");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        if (result.getCode() == 405) {
            Assert.assertNotNull((Object)result.getFirstHeader("Allow"));
        }
        this.verifyMocks();
    }

    @Test
    public void testMustIncludeProxyAuthenticateHeaderFromAnOrigin407Response() throws Exception {
        this.originResponse = new BasicClassicHttpResponse(407, "Proxy Authentication Required");
        this.originResponse.setHeader("Proxy-Authenticate", (Object)"x-scheme x-param");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        if (result.getCode() == 407) {
            Assert.assertNotNull((Object)result.getFirstHeader("Proxy-Authenticate"));
        }
        this.verifyMocks();
    }

    @Test
    public void testMustNotAddMultipartByteRangeContentTypeTo416Response() throws Exception {
        this.originResponse = new BasicClassicHttpResponse(416, "Requested Range Not Satisfiable");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        if (result.getCode() == 416) {
            Iterator it = MessageSupport.iterate((MessageHeaders)result, (String)"Content-Type");
            while (it.hasNext()) {
                HeaderElement elt = (HeaderElement)it.next();
                Assert.assertFalse((boolean)"multipart/byteranges".equalsIgnoreCase(elt.getName()));
            }
        }
    }

    @Test
    public void testMustNotUseMultipartByteRangeContentTypeOnCacheGenerated416Responses() throws Exception {
        this.originResponse.setEntity(HttpTestUtils.makeBody(this.entityLength));
        this.originResponse.setHeader("Content-Length", (Object)"128");
        this.originResponse.setHeader("Cache-Control", (Object)"max-age=3600");
        BasicClassicHttpRequest rangeReq = new BasicClassicHttpRequest("GET", "/");
        rangeReq.setHeader("Range", (Object)"bytes=1000-1200");
        BasicClassicHttpResponse orig416 = new BasicClassicHttpResponse(416, "Requested Range Not Satisfiable");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)orig416).times(0, 1);
        this.replayMocks();
        this.execute(this.request);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)rangeReq);
        this.verifyMocks();
        if (result.getCode() == 416) {
            Iterator it = MessageSupport.iterate((MessageHeaders)result, (String)"Content-Type");
            while (it.hasNext()) {
                HeaderElement elt = (HeaderElement)it.next();
                Assert.assertFalse((boolean)"multipart/byteranges".equalsIgnoreCase(elt.getName()));
            }
        }
    }

    @Test
    public void testMustReturnACacheEntryIfItCanRevalidateIt() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        Date nineSecondsAgo = new Date(now.getTime() - 9000L);
        Date eightSecondsAgo = new Date(now.getTime() - 8000L);
        Header[] hdrs = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)nineSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=0"), new BasicHeader("ETag", (Object)"\"etag\""), new BasicHeader("Content-Length", (Object)"128")};
        byte[] bytes = new byte[128];
        new Random().nextBytes(bytes);
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(tenSecondsAgo, eightSecondsAgo, hdrs, bytes);
        this.impl = new CachingExec(this.mockCache, this.config);
        this.request = new BasicClassicHttpRequest("GET", "/thing");
        BasicClassicHttpRequest validate = new BasicClassicHttpRequest("GET", "/thing");
        validate.setHeader("If-None-Match", (Object)"\"etag\"");
        BasicClassicHttpResponse notModified = new BasicClassicHttpResponse(304, "Not Modified");
        notModified.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        notModified.setHeader("ETag", (Object)"\"etag\"");
        EasyMock.expect((Object)this.mockCache.getCacheEntry((HttpHost)EasyMock.eq((Object)this.host), (HttpRequest)TestProtocolRequirements.eqRequest(this.request))).andReturn((Object)entry);
        EasyMock.expect((Object)this.mockExecChain.proceed(TestProtocolRequirements.eqRequest((ClassicHttpRequest)validate), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)notModified);
        EasyMock.expect((Object)this.mockCache.updateCacheEntry((HttpHost)EasyMock.eq((Object)this.host), (HttpRequest)TestProtocolRequirements.eqRequest(this.request), (HttpCacheEntry)EasyMock.eq((Object)entry), TestProtocolRequirements.eqResponse((HttpResponse)notModified), (Date)EasyMock.isA(Date.class), (Date)EasyMock.isA(Date.class))).andReturn((Object)HttpTestUtils.makeCacheEntry());
        this.replayMocks();
        this.execute(this.request);
        this.verifyMocks();
    }

    @Test
    public void testMustReturnAFreshEnoughCacheEntryIfItHasIt() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        Date nineSecondsAgo = new Date(now.getTime() - 9000L);
        Date eightSecondsAgo = new Date(now.getTime() - 8000L);
        Header[] hdrs = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)nineSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=3600"), new BasicHeader("Content-Length", (Object)"128")};
        byte[] bytes = new byte[128];
        new Random().nextBytes(bytes);
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(tenSecondsAgo, eightSecondsAgo, hdrs, bytes);
        this.impl = new CachingExec(this.mockCache, this.config);
        this.request = new BasicClassicHttpRequest("GET", "/thing");
        EasyMock.expect((Object)this.mockCache.getCacheEntry((HttpHost)EasyMock.eq((Object)this.host), (HttpRequest)TestProtocolRequirements.eqRequest(this.request))).andReturn((Object)entry);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result.getCode());
    }

    @Test
    public void testMustServeAppropriateErrorOrWarningIfNoOriginCommunicationPossible() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        Date nineSecondsAgo = new Date(now.getTime() - 9000L);
        Date eightSecondsAgo = new Date(now.getTime() - 8000L);
        Header[] hdrs = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)nineSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=0"), new BasicHeader("Content-Length", (Object)"128"), new BasicHeader("Last-Modified", (Object)DateUtils.formatDate((Date)tenSecondsAgo))};
        byte[] bytes = new byte[128];
        new Random().nextBytes(bytes);
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(tenSecondsAgo, eightSecondsAgo, hdrs, bytes);
        this.impl = new CachingExec(this.mockCache, this.config);
        this.request = new BasicClassicHttpRequest("GET", "/thing");
        EasyMock.expect((Object)this.mockCache.getCacheEntry((HttpHost)EasyMock.eq((Object)this.host), (HttpRequest)TestProtocolRequirements.eqRequest(this.request))).andReturn((Object)entry);
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andThrow((Throwable)new IOException("can't talk to origin!")).anyTimes();
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        int status = result.getCode();
        if (status == 200) {
            boolean foundWarning = false;
            for (Header h : result.getHeaders("Warning")) {
                if (!h.getValue().split(" ")[0].equals("111")) continue;
                foundWarning = true;
            }
            Assert.assertTrue((boolean)foundWarning);
        } else {
            Assert.assertTrue((status >= 500 && status <= 599 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAttachesWarningHeaderWhenGeneratingStaleResponse() throws Exception {
    }

    @Test
    public void test1xxWarningsAreDeletedAfterSuccessfulRevalidation() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 25000L);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Cache-Control", (Object)"max-age=5");
        resp1.setHeader("Warning", (Object)"110 squid \"stale stuff\"");
        resp1.setHeader("Via", (Object)"1.1 fred");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        BasicClassicHttpRequest validate = new BasicClassicHttpRequest("GET", "/");
        validate.setHeader("If-None-Match", (Object)"\"etag\"");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(304, "Not Modified");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp2.setHeader("Server", (Object)"MockServer/1.0");
        resp2.setHeader("ETag", (Object)"\"etag\"");
        resp2.setHeader("Via", (Object)"1.1 fred");
        this.backendExpectsAnyRequestAndReturn(resp1);
        EasyMock.expect((Object)this.mockExecChain.proceed(TestProtocolRequirements.eqRequest((ClassicHttpRequest)validate), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp2);
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        this.replayMocks();
        ClassicHttpResponse stale = this.execute((ClassicHttpRequest)req1);
        Assert.assertNotNull((Object)stale.getFirstHeader("Warning"));
        ClassicHttpResponse result1 = this.execute((ClassicHttpRequest)req2);
        ClassicHttpResponse result2 = this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
        boolean found1xxWarning = false;
        Iterator it = MessageSupport.iterate((MessageHeaders)result1, (String)"Warning");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (!elt.getName().startsWith("1")) continue;
            found1xxWarning = true;
        }
        Iterator it2 = MessageSupport.iterate((MessageHeaders)result2, (String)"Warning");
        while (it2.hasNext()) {
            HeaderElement elt = (HeaderElement)it2.next();
            if (!elt.getName().startsWith("1")) continue;
            found1xxWarning = true;
        }
        Assert.assertFalse((boolean)found1xxWarning);
    }

    @Test
    public void test2xxWarningsAreNotDeletedAfterSuccessfulRevalidation() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Cache-Control", (Object)"max-age=5");
        resp1.setHeader("Via", (Object)"1.1 xproxy");
        resp1.setHeader("Warning", (Object)"214 xproxy \"transformed stuff\"");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        BasicClassicHttpRequest validate = new BasicClassicHttpRequest("GET", "/");
        validate.setHeader("If-None-Match", (Object)"\"etag\"");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(304, "Not Modified");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp2.setHeader("Server", (Object)"MockServer/1.0");
        resp2.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Via", (Object)"1.1 xproxy");
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        this.backendExpectsAnyRequestAndReturn(resp1);
        EasyMock.expect((Object)this.mockExecChain.proceed(TestProtocolRequirements.eqRequest((ClassicHttpRequest)validate), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp2);
        this.replayMocks();
        ClassicHttpResponse stale = this.execute((ClassicHttpRequest)req1);
        Assert.assertNotNull((Object)stale.getFirstHeader("Warning"));
        ClassicHttpResponse result1 = this.execute((ClassicHttpRequest)req2);
        ClassicHttpResponse result2 = this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
        boolean found214Warning = false;
        Iterator it = MessageSupport.iterate((MessageHeaders)result1, (String)"Warning");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            String[] parts = elt.getName().split(" ");
            if (!"214".equals(parts[0])) continue;
            found214Warning = true;
        }
        Assert.assertTrue((boolean)found214Warning);
        found214Warning = false;
        Iterator it2 = MessageSupport.iterate((MessageHeaders)result2, (String)"Warning");
        while (it2.hasNext()) {
            HeaderElement elt = (HeaderElement)it2.next();
            String[] parts = elt.getName().split(" ");
            if (!"214".equals(parts[0])) continue;
            found214Warning = true;
        }
        Assert.assertTrue((boolean)found214Warning);
    }

    @Test
    public void testAgeHeaderPopulatedFromCacheEntryCurrentAge() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        Date nineSecondsAgo = new Date(now.getTime() - 9000L);
        Date eightSecondsAgo = new Date(now.getTime() - 8000L);
        Header[] hdrs = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)nineSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=3600"), new BasicHeader("Content-Length", (Object)"128")};
        byte[] bytes = new byte[128];
        new Random().nextBytes(bytes);
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(tenSecondsAgo, eightSecondsAgo, hdrs, bytes);
        this.impl = new CachingExec(this.mockCache, this.config);
        this.request = new BasicClassicHttpRequest("GET", "/thing");
        EasyMock.expect((Object)this.mockCache.getCacheEntry((HttpHost)EasyMock.eq((Object)this.host), (HttpRequest)TestProtocolRequirements.eqRequest(this.request))).andReturn((Object)entry);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result.getCode());
        Assert.assertEquals((Object)"11", (Object)result.getFirstHeader("Age").getValue());
    }

    @Test
    public void testHeuristicCacheOlderThan24HoursHasWarningAttached() throws Exception {
        Date now = new Date();
        Date thirtySixHoursAgo = new Date(now.getTime() - 129600000L);
        Date oneYearAgo = new Date(now.getTime() - 31536000000L);
        Date requestTime = new Date(thirtySixHoursAgo.getTime() - 1000L);
        Date responseTime = new Date(thirtySixHoursAgo.getTime() + 1000L);
        Header[] hdrs = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)thirtySixHoursAgo)), new BasicHeader("Cache-Control", (Object)"public"), new BasicHeader("Last-Modified", (Object)DateUtils.formatDate((Date)oneYearAgo)), new BasicHeader("Content-Length", (Object)"128")};
        byte[] bytes = new byte[128];
        new Random().nextBytes(bytes);
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(requestTime, responseTime, hdrs, bytes);
        this.impl = new CachingExec(this.mockCache, this.config);
        this.request = new BasicClassicHttpRequest("GET", "/thing");
        ClassicHttpResponse validated = HttpTestUtils.make200Response();
        validated.setHeader("Cache-Control", (Object)"public");
        validated.setHeader("Last-Modified", (Object)DateUtils.formatDate((Date)oneYearAgo));
        validated.setHeader("Content-Length", (Object)"128");
        validated.setEntity((HttpEntity)new ByteArrayEntity(bytes));
        HttpCacheEntry cacheEntry = HttpTestUtils.makeCacheEntry();
        Capture cap = new Capture();
        this.mockCache.flushInvalidatedCacheEntriesFor((HttpHost)EasyMock.isA(HttpHost.class), (HttpRequest)EasyMock.isA(ClassicHttpRequest.class), (HttpResponse)EasyMock.isA(ClassicHttpResponse.class));
        EasyMock.expect((Object)this.mockCache.getCacheEntry((HttpHost)EasyMock.eq((Object)this.host), (HttpRequest)TestProtocolRequirements.eqRequest(this.request))).andReturn((Object)entry);
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)validated).times(0, 1);
        EasyMock.expect((Object)this.mockCache.getCacheEntry((HttpHost)EasyMock.isA(HttpHost.class), (HttpRequest)EasyMock.isA(ClassicHttpRequest.class))).andReturn((Object)entry).times(0, 1);
        EasyMock.expect((Object)this.mockCache.createCacheEntry((HttpHost)EasyMock.isA(HttpHost.class), (HttpRequest)EasyMock.isA(ClassicHttpRequest.class), (HttpResponse)TestProtocolRequirements.eqCloseableResponse(validated), (ByteArrayBuffer)EasyMock.isA(ByteArrayBuffer.class), (Date)EasyMock.isA(Date.class), (Date)EasyMock.isA(Date.class))).andReturn((Object)cacheEntry).times(0, 1);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result.getCode());
        if (!cap.hasCaptured()) {
            boolean found113Warning = false;
            Iterator it = MessageSupport.iterate((MessageHeaders)result, (String)"Warning");
            while (it.hasNext()) {
                HeaderElement elt = (HeaderElement)it.next();
                String[] parts = elt.getName().split(" ");
                if (!"113".equals(parts[0])) continue;
                found113Warning = true;
                break;
            }
            Assert.assertTrue((boolean)found113Warning);
        }
    }

    @Test
    public void testKeepsMostRecentDateHeaderForFreshResponse() throws Exception {
        Date now = new Date();
        Date inFiveSecond = new Date(now.getTime() + 5000L);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)inFiveSecond));
        resp1.setHeader("ETag", (Object)"\"etag1\"");
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Content-Length", (Object)"128");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Cache-Control", (Object)"no-cache");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp2.setHeader("ETag", (Object)"\"etag2\"");
        resp2.setHeader("Cache-Control", (Object)"max-age=3600");
        resp2.setHeader("Content-Length", (Object)"128");
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        EasyMock.expect((Object)this.mockExecChain.proceed(TestProtocolRequirements.eqRequest((ClassicHttpRequest)req1), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp1);
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
        Assert.assertEquals((Object)"\"etag1\"", (Object)result.getFirstHeader("ETag").getValue());
    }

    private ClassicHttpResponse testRequestWithWeakETagValidatorIsNotAllowed(String header) throws Exception {
        ClassicHttpRequest forwarded;
        Header h;
        Capture cap = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse).times(0, 1);
        this.replayMocks();
        ClassicHttpResponse response = this.execute(this.request);
        this.verifyMocks();
        if (cap.hasCaptured() && (h = (forwarded = (ClassicHttpRequest)cap.getValue()).getFirstHeader(header)) != null) {
            Assert.assertFalse((boolean)h.getValue().startsWith("W/"));
        }
        return response;
    }

    @Test
    public void testSubrangeGETWithWeakETagIsNotAllowed() throws Exception {
        this.request = new BasicClassicHttpRequest("GET", "/");
        this.request.setHeader("Range", (Object)"bytes=0-500");
        this.request.setHeader("If-Range", (Object)"W/\"etag\"");
        ClassicHttpResponse response = this.testRequestWithWeakETagValidatorIsNotAllowed("If-Range");
        Assert.assertTrue((response.getCode() == 400 ? 1 : 0) != 0);
    }

    @Test
    public void testPUTWithIfMatchWeakETagIsNotAllowed() throws Exception {
        BasicClassicHttpRequest put = new BasicClassicHttpRequest("PUT", "/");
        put.setEntity(HttpTestUtils.makeBody(128));
        put.setHeader("Content-Length", (Object)"128");
        put.setHeader("If-Match", (Object)"W/\"etag\"");
        this.request = put;
        this.testRequestWithWeakETagValidatorIsNotAllowed("If-Match");
    }

    @Test
    public void testPUTWithIfNoneMatchWeakETagIsNotAllowed() throws Exception {
        BasicClassicHttpRequest put = new BasicClassicHttpRequest("PUT", "/");
        put.setEntity(HttpTestUtils.makeBody(128));
        put.setHeader("Content-Length", (Object)"128");
        put.setHeader("If-None-Match", (Object)"W/\"etag\"");
        this.request = put;
        this.testRequestWithWeakETagValidatorIsNotAllowed("If-None-Match");
    }

    @Test
    public void testDELETEWithIfMatchWeakETagIsNotAllowed() throws Exception {
        this.request = new BasicClassicHttpRequest("DELETE", "/");
        this.request.setHeader("If-Match", (Object)"W/\"etag\"");
        this.testRequestWithWeakETagValidatorIsNotAllowed("If-Match");
    }

    @Test
    public void testDELETEWithIfNoneMatchWeakETagIsNotAllowed() throws Exception {
        this.request = new BasicClassicHttpRequest("DELETE", "/");
        this.request.setHeader("If-None-Match", (Object)"W/\"etag\"");
        this.testRequestWithWeakETagValidatorIsNotAllowed("If-None-Match");
    }

    @Test
    public void testSubrangeGETMustUseStrongComparisonForCachedResponse() throws Exception {
        Date now = new Date();
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Range", (Object)"bytes=0-50");
        req2.setHeader("If-Range", (Object)"W/\"etag\"");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp1).times(1, 2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertFalse((206 == result.getCode() ? 1 : 0) != 0);
    }

    @Test
    public void testValidationMustUseETagIfProvidedByOriginServer() throws Exception {
        String[] conditionalHeaders;
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Last-Modified", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("ETag", (Object)"W/\"etag\"");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Cache-Control", (Object)"max-age=0,max-stale=0");
        Capture cap = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp1);
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp1);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        ClassicHttpRequest validation = (ClassicHttpRequest)cap.getValue();
        boolean isConditional = false;
        for (String ch : conditionalHeaders = new String[]{"If-Range", "If-Modified-Since", "If-Unmodified-Since", "If-Match", "If-None-Match"}) {
            if (validation.getFirstHeader(ch) == null) continue;
            isConditional = true;
            break;
        }
        if (isConditional) {
            boolean foundETag = false;
            Iterator it = MessageSupport.iterate((MessageHeaders)validation, (String)"If-Match");
            while (it.hasNext()) {
                HeaderElement elt = (HeaderElement)it.next();
                if (!"W/\"etag\"".equals(elt.getName())) continue;
                foundETag = true;
            }
            Iterator it2 = MessageSupport.iterate((MessageHeaders)validation, (String)"If-None-Match");
            while (it2.hasNext()) {
                HeaderElement elt = (HeaderElement)it2.next();
                if (!"W/\"etag\"".equals(elt.getName())) continue;
                foundETag = true;
            }
            Assert.assertTrue((boolean)foundETag);
        }
    }

    @Test
    public void testConditionalRequestWhereNotAllValidatorsMatchCannotBeServedFromCache() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        Date twentySecondsAgo = new Date(now.getTime() - 20000L);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Last-Modified", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("ETag", (Object)"W/\"etag\"");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("If-None-Match", (Object)"W/\"etag\"");
        req2.setHeader("If-Modified-Since", (Object)DateUtils.formatDate((Date)twentySecondsAgo));
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp1).times(2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertFalse((304 == result.getCode() ? 1 : 0) != 0);
    }

    @Test
    public void testConditionalRequestWhereAllValidatorsMatchMayBeServedFromCache() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Last-Modified", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("ETag", (Object)"W/\"etag\"");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("If-None-Match", (Object)"W/\"etag\"");
        req2.setHeader("If-Modified-Since", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp1).times(1, 2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
    }

    @Test
    public void testCacheWithoutSupportForRangeAndContentRangeHeadersDoesNotCacheA206Response() throws Exception {
        if (!this.supportsRangeAndContentRangeHeaders(this.impl)) {
            this.emptyMockCacheExpectsNoPuts();
            BasicClassicHttpRequest req = new BasicClassicHttpRequest("GET", "/");
            req.setHeader("Range", (Object)"bytes=0-50");
            BasicClassicHttpResponse resp = new BasicClassicHttpResponse(206, "Partial Content");
            resp.setHeader("Content-Range", (Object)"bytes 0-50/128");
            resp.setHeader("ETag", (Object)"\"etag\"");
            resp.setHeader("Cache-Control", (Object)"max-age=3600");
            EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp);
            this.replayMocks();
            this.execute((ClassicHttpRequest)req);
            this.verifyMocks();
        }
    }

    @Test
    public void test302ResponseWithoutExplicitCacheabilityIsNotReturnedFromCache() throws Exception {
        this.originResponse = new BasicClassicHttpResponse(302, "Temporary Redirect");
        this.originResponse.setHeader("Location", (Object)"http://foo.example.com/other");
        this.originResponse.removeHeaders("Expires");
        this.originResponse.removeHeaders("Cache-Control");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse).times(2);
        this.replayMocks();
        this.execute(this.request);
        this.execute(this.request);
        this.verifyMocks();
    }

    private void testDoesNotModifyHeaderFromOrigin(String header, String value) throws Exception {
        this.originResponse = HttpTestUtils.make200Response();
        this.originResponse.setHeader(header, (Object)value);
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertEquals((Object)value, (Object)result.getFirstHeader(header).getValue());
    }

    @Test
    public void testDoesNotModifyContentLocationHeaderFromOrigin() throws Exception {
        String url = "http://foo.example.com/other";
        this.testDoesNotModifyHeaderFromOrigin("Content-Location", "http://foo.example.com/other");
    }

    @Test
    public void testDoesNotModifyContentMD5HeaderFromOrigin() throws Exception {
        this.testDoesNotModifyHeaderFromOrigin("Content-MD5", "Q2hlY2sgSW50ZWdyaXR5IQ==");
    }

    @Test
    public void testDoesNotModifyEtagHeaderFromOrigin() throws Exception {
        this.testDoesNotModifyHeaderFromOrigin("Etag", "\"the-etag\"");
    }

    @Test
    public void testDoesNotModifyLastModifiedHeaderFromOrigin() throws Exception {
        String lm = DateUtils.formatDate((Date)new Date());
        this.testDoesNotModifyHeaderFromOrigin("Last-Modified", lm);
    }

    private void testDoesNotAddHeaderToOriginResponse(String header) throws Exception {
        this.originResponse.removeHeaders(header);
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertNull((Object)result.getFirstHeader(header));
    }

    @Test
    public void testDoesNotAddContentLocationToOriginResponse() throws Exception {
        this.testDoesNotAddHeaderToOriginResponse("Content-Location");
    }

    @Test
    public void testDoesNotAddContentMD5ToOriginResponse() throws Exception {
        this.testDoesNotAddHeaderToOriginResponse("Content-MD5");
    }

    @Test
    public void testDoesNotAddEtagToOriginResponse() throws Exception {
        this.testDoesNotAddHeaderToOriginResponse("ETag");
    }

    @Test
    public void testDoesNotAddLastModifiedToOriginResponse() throws Exception {
        this.testDoesNotAddHeaderToOriginResponse("Last-Modified");
    }

    private void testDoesNotModifyHeaderFromOriginOnCacheHit(String header, String value) throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        this.originResponse = HttpTestUtils.make200Response();
        this.originResponse.setHeader("Cache-Control", (Object)"max-age=3600");
        this.originResponse.setHeader(header, (Object)value);
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((Object)value, (Object)result.getFirstHeader(header).getValue());
    }

    @Test
    public void testDoesNotModifyContentLocationFromOriginOnCacheHit() throws Exception {
        String url = "http://foo.example.com/other";
        this.testDoesNotModifyHeaderFromOriginOnCacheHit("Content-Location", "http://foo.example.com/other");
    }

    @Test
    public void testDoesNotModifyContentMD5FromOriginOnCacheHit() throws Exception {
        this.testDoesNotModifyHeaderFromOriginOnCacheHit("Content-MD5", "Q2hlY2sgSW50ZWdyaXR5IQ==");
    }

    @Test
    public void testDoesNotModifyEtagFromOriginOnCacheHit() throws Exception {
        this.testDoesNotModifyHeaderFromOriginOnCacheHit("Etag", "\"the-etag\"");
    }

    @Test
    public void testDoesNotModifyLastModifiedFromOriginOnCacheHit() throws Exception {
        String lm = DateUtils.formatDate((Date)new Date(System.currentTimeMillis() - 10000L));
        this.testDoesNotModifyHeaderFromOriginOnCacheHit("Last-Modified", lm);
    }

    private void testDoesNotAddHeaderOnCacheHit(String header) throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        this.originResponse.addHeader("Cache-Control", (Object)"max-age=3600");
        this.originResponse.removeHeaders(header);
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertNull((Object)result.getFirstHeader(header));
    }

    @Test
    public void testDoesNotAddContentLocationHeaderOnCacheHit() throws Exception {
        this.testDoesNotAddHeaderOnCacheHit("Content-Location");
    }

    @Test
    public void testDoesNotAddContentMD5HeaderOnCacheHit() throws Exception {
        this.testDoesNotAddHeaderOnCacheHit("Content-MD5");
    }

    @Test
    public void testDoesNotAddETagHeaderOnCacheHit() throws Exception {
        this.testDoesNotAddHeaderOnCacheHit("ETag");
    }

    @Test
    public void testDoesNotAddLastModifiedHeaderOnCacheHit() throws Exception {
        this.testDoesNotAddHeaderOnCacheHit("Last-Modified");
    }

    private void testDoesNotModifyHeaderOnRequest(String header, String value) throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("POST", "/");
        req.setEntity(HttpTestUtils.makeBody(128));
        req.setHeader("Content-Length", (Object)"128");
        req.setHeader(header, (Object)value);
        Capture cap = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req);
        this.verifyMocks();
        ClassicHttpRequest captured = (ClassicHttpRequest)cap.getValue();
        Assert.assertEquals((Object)value, (Object)captured.getFirstHeader(header).getValue());
    }

    @Test
    public void testDoesNotModifyContentLocationHeaderOnRequest() throws Exception {
        String url = "http://foo.example.com/other";
        this.testDoesNotModifyHeaderOnRequest("Content-Location", "http://foo.example.com/other");
    }

    @Test
    public void testDoesNotModifyContentMD5HeaderOnRequest() throws Exception {
        this.testDoesNotModifyHeaderOnRequest("Content-MD5", "Q2hlY2sgSW50ZWdyaXR5IQ==");
    }

    @Test
    public void testDoesNotModifyETagHeaderOnRequest() throws Exception {
        this.testDoesNotModifyHeaderOnRequest("ETag", "\"etag\"");
    }

    @Test
    public void testDoesNotModifyLastModifiedHeaderOnRequest() throws Exception {
        long tenSecondsAgo = System.currentTimeMillis() - 10000L;
        String lm = DateUtils.formatDate((Date)new Date(tenSecondsAgo));
        this.testDoesNotModifyHeaderOnRequest("Last-Modified", lm);
    }

    private void testDoesNotAddHeaderToRequestIfNotPresent(String header) throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("POST", "/");
        req.setEntity(HttpTestUtils.makeBody(128));
        req.setHeader("Content-Length", (Object)"128");
        req.removeHeaders(header);
        Capture cap = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req);
        this.verifyMocks();
        ClassicHttpRequest captured = (ClassicHttpRequest)cap.getValue();
        Assert.assertNull((Object)captured.getFirstHeader(header));
    }

    @Test
    public void testDoesNotAddContentLocationToRequestIfNotPresent() throws Exception {
        this.testDoesNotAddHeaderToRequestIfNotPresent("Content-Location");
    }

    @Test
    public void testDoesNotAddContentMD5ToRequestIfNotPresent() throws Exception {
        this.testDoesNotAddHeaderToRequestIfNotPresent("Content-MD5");
    }

    @Test
    public void testDoesNotAddETagToRequestIfNotPresent() throws Exception {
        this.testDoesNotAddHeaderToRequestIfNotPresent("ETag");
    }

    @Test
    public void testDoesNotAddLastModifiedToRequestIfNotPresent() throws Exception {
        this.testDoesNotAddHeaderToRequestIfNotPresent("Last-Modified");
    }

    @Test
    public void testDoesNotModifyExpiresHeaderFromOrigin() throws Exception {
        long inTenSeconds = System.currentTimeMillis() + 10000L;
        String expires = DateUtils.formatDate((Date)new Date(inTenSeconds));
        this.testDoesNotModifyHeaderFromOrigin("Expires", expires);
    }

    @Test
    public void testDoesNotModifyExpiresHeaderFromOriginOnCacheHit() throws Exception {
        long inTenSeconds = System.currentTimeMillis() + 10000L;
        String expires = DateUtils.formatDate((Date)new Date(inTenSeconds));
        this.testDoesNotModifyHeaderFromOriginOnCacheHit("Expires", expires);
    }

    @Test
    public void testExpiresHeaderMatchesDateIfAddedToOriginResponse() throws Exception {
        this.originResponse.removeHeaders("Expires");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Header expHdr = result.getFirstHeader("Expires");
        if (expHdr != null) {
            Assert.assertEquals((Object)result.getFirstHeader("Date").getValue(), (Object)expHdr.getValue());
        }
    }

    @Test
    public void testExpiresHeaderMatchesDateIfAddedToCacheHit() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        this.originResponse.setHeader("Cache-Control", (Object)"max-age=3600");
        this.originResponse.removeHeaders("Expires");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Header expHdr = result.getFirstHeader("Expires");
        if (expHdr != null) {
            Assert.assertEquals((Object)result.getFirstHeader("Date").getValue(), (Object)expHdr.getValue());
        }
    }

    private void testDoesNotModifyHeaderFromOriginResponseWithNoTransform(String header, String value) throws Exception {
        this.originResponse.addHeader("Cache-Control", (Object)"no-transform");
        this.originResponse.setHeader(header, (Object)value);
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertEquals((Object)value, (Object)result.getFirstHeader(header).getValue());
    }

    @Test
    public void testDoesNotModifyContentEncodingHeaderFromOriginResponseWithNoTransform() throws Exception {
        this.testDoesNotModifyHeaderFromOriginResponseWithNoTransform("Content-Encoding", "gzip");
    }

    @Test
    public void testDoesNotModifyContentRangeHeaderFromOriginResponseWithNoTransform() throws Exception {
        this.request.setHeader("If-Range", (Object)"\"etag\"");
        this.request.setHeader("Range", (Object)"bytes=0-49");
        this.originResponse = new BasicClassicHttpResponse(206, "Partial Content");
        this.originResponse.setEntity(HttpTestUtils.makeBody(50));
        this.testDoesNotModifyHeaderFromOriginResponseWithNoTransform("Content-Range", "bytes 0-49/128");
    }

    @Test
    public void testDoesNotModifyContentTypeHeaderFromOriginResponseWithNoTransform() throws Exception {
        this.testDoesNotModifyHeaderFromOriginResponseWithNoTransform("Content-Type", "text/html;charset=utf-8");
    }

    private void testDoesNotModifyHeaderOnCachedResponseWithNoTransform(String header, String value) throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        this.originResponse.addHeader("Cache-Control", (Object)"max-age=3600, no-transform");
        this.originResponse.setHeader(header, (Object)value);
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((Object)value, (Object)result.getFirstHeader(header).getValue());
    }

    @Test
    public void testDoesNotModifyContentEncodingHeaderOnCachedResponseWithNoTransform() throws Exception {
        this.testDoesNotModifyHeaderOnCachedResponseWithNoTransform("Content-Encoding", "gzip");
    }

    @Test
    public void testDoesNotModifyContentTypeHeaderOnCachedResponseWithNoTransform() throws Exception {
        this.testDoesNotModifyHeaderOnCachedResponseWithNoTransform("Content-Type", "text/html;charset=utf-8");
    }

    @Test
    public void testDoesNotModifyContentRangeHeaderOnCachedResponseWithNoTransform() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        req1.setHeader("If-Range", (Object)"\"etag\"");
        req1.setHeader("Range", (Object)"bytes=0-49");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("If-Range", (Object)"\"etag\"");
        req2.setHeader("Range", (Object)"bytes=0-49");
        this.originResponse.addHeader("Cache-Control", (Object)"max-age=3600, no-transform");
        this.originResponse.setHeader("Content-Range", (Object)"bytes 0-49/128");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse).times(1, 2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((Object)"bytes 0-49/128", (Object)result.getFirstHeader("Content-Range").getValue());
    }

    @Test
    public void testDoesNotAddContentEncodingHeaderToOriginResponseWithNoTransformIfNotPresent() throws Exception {
        this.originResponse.addHeader("Cache-Control", (Object)"no-transform");
        this.testDoesNotAddHeaderToOriginResponse("Content-Encoding");
    }

    @Test
    public void testDoesNotAddContentRangeHeaderToOriginResponseWithNoTransformIfNotPresent() throws Exception {
        this.originResponse.addHeader("Cache-Control", (Object)"no-transform");
        this.testDoesNotAddHeaderToOriginResponse("Content-Range");
    }

    @Test
    public void testDoesNotAddContentTypeHeaderToOriginResponseWithNoTransformIfNotPresent() throws Exception {
        this.originResponse.addHeader("Cache-Control", (Object)"no-transform");
        this.testDoesNotAddHeaderToOriginResponse("Content-Type");
    }

    @Test
    public void testDoesNotAddContentEncodingHeaderToCachedResponseWithNoTransformIfNotPresent() throws Exception {
        this.originResponse.addHeader("Cache-Control", (Object)"no-transform");
        this.testDoesNotAddHeaderOnCacheHit("Content-Encoding");
    }

    @Test
    public void testDoesNotAddContentRangeHeaderToCachedResponseWithNoTransformIfNotPresent() throws Exception {
        this.originResponse.addHeader("Cache-Control", (Object)"no-transform");
        this.testDoesNotAddHeaderOnCacheHit("Content-Range");
    }

    @Test
    public void testDoesNotAddContentTypeHeaderToCachedResponseWithNoTransformIfNotPresent() throws Exception {
        this.originResponse.addHeader("Cache-Control", (Object)"no-transform");
        this.testDoesNotAddHeaderOnCacheHit("Content-Type");
    }

    @Test
    public void testDoesNotAddContentEncodingToRequestIfNotPresent() throws Exception {
        this.testDoesNotAddHeaderToRequestIfNotPresent("Content-Encoding");
    }

    @Test
    public void testDoesNotAddContentRangeToRequestIfNotPresent() throws Exception {
        this.testDoesNotAddHeaderToRequestIfNotPresent("Content-Range");
    }

    @Test
    public void testDoesNotAddContentTypeToRequestIfNotPresent() throws Exception {
        this.testDoesNotAddHeaderToRequestIfNotPresent("Content-Type");
    }

    @Test
    public void testDoesNotAddContentEncodingHeaderToRequestIfNotPresent() throws Exception {
        this.testDoesNotAddHeaderToRequestIfNotPresent("Content-Encoding");
    }

    @Test
    public void testDoesNotAddContentRangeHeaderToRequestIfNotPresent() throws Exception {
        this.testDoesNotAddHeaderToRequestIfNotPresent("Content-Range");
    }

    @Test
    public void testDoesNotAddContentTypeHeaderToRequestIfNotPresent() throws Exception {
        this.testDoesNotAddHeaderToRequestIfNotPresent("Content-Type");
    }

    public void testCachedEntityBodyIsUsedForResponseAfter304Validation() throws Exception {
        int b2;
        int b1;
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Cache-Control", (Object)"max-age=0, max-stale=0");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(304, "Not Modified");
        this.backendExpectsAnyRequestAndReturn(resp1);
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        InputStream i1 = resp1.getEntity().getContent();
        InputStream i2 = result.getEntity().getContent();
        while ((b1 = i1.read()) != -1) {
            b2 = i2.read();
            Assert.assertEquals((long)b1, (long)b2);
        }
        b2 = i2.read();
        Assert.assertEquals((long)-1L, (long)b2);
        i1.close();
        i2.close();
    }

    private void decorateWithEndToEndHeaders(ClassicHttpResponse r) {
        r.setHeader("Allow", (Object)"GET");
        r.setHeader("Content-Encoding", (Object)"gzip");
        r.setHeader("Content-Language", (Object)"en");
        r.setHeader("Content-Length", (Object)"128");
        r.setHeader("Content-Location", (Object)"http://foo.example.com/other");
        r.setHeader("Content-MD5", (Object)"Q2hlY2sgSW50ZWdyaXR5IQ==");
        r.setHeader("Content-Type", (Object)"text/html;charset=utf-8");
        r.setHeader("Expires", (Object)DateUtils.formatDate((Date)new Date(System.currentTimeMillis() + 10000L)));
        r.setHeader("Last-Modified", (Object)DateUtils.formatDate((Date)new Date(System.currentTimeMillis() - 10000L)));
        r.setHeader("Location", (Object)"http://foo.example.com/other2");
        r.setHeader("Pragma", (Object)"x-pragma");
        r.setHeader("Retry-After", (Object)"180");
    }

    @Test
    public void testResponseIncludesCacheEntryEndToEndHeadersForResponseAfter304Validation() throws Exception {
        String[] endToEndHeaders;
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        this.decorateWithEndToEndHeaders(resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Cache-Control", (Object)"max-age=0, max-stale=0");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(304, "Not Modified");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        resp2.setHeader("Server", (Object)"MockServer/1.0");
        this.backendExpectsAnyRequestAndReturn(resp1);
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        for (String h : endToEndHeaders = new String[]{"Cache-Control", "ETag", "Allow", "Content-Encoding", "Content-Language", "Content-Length", "Content-Location", "Content-MD5", "Content-Type", "Expires", "Last-Modified", "Location", "Pragma", "Retry-After"}) {
            Assert.assertEquals((Object)HttpTestUtils.getCanonicalHeaderValue((HttpMessage)resp1, h), (Object)HttpTestUtils.getCanonicalHeaderValue((HttpMessage)result, h));
        }
    }

    @Test
    public void testUpdatedEndToEndHeadersFrom304ArePassedOnResponseAndUpdatedInCacheEntry() throws Exception {
        String[] endToEndHeaders;
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        this.decorateWithEndToEndHeaders(resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Cache-Control", (Object)"max-age=0, max-stale=0");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(304, "Not Modified");
        resp2.setHeader("Cache-Control", (Object)"max-age=1800");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        resp2.setHeader("Server", (Object)"MockServer/1.0");
        resp2.setHeader("Allow", (Object)"GET,HEAD");
        resp2.setHeader("Content-Language", (Object)"en,en-us");
        resp2.setHeader("Content-Location", (Object)"http://foo.example.com/new");
        resp2.setHeader("Content-Type", (Object)"text/html");
        resp2.setHeader("Expires", (Object)DateUtils.formatDate((Date)new Date(System.currentTimeMillis() + 5000L)));
        resp2.setHeader("Location", (Object)"http://foo.example.com/new2");
        resp2.setHeader("Pragma", (Object)"x-new-pragma");
        resp2.setHeader("Retry-After", (Object)"120");
        this.backendExpectsAnyRequestAndReturn(resp1);
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result1 = this.execute((ClassicHttpRequest)req2);
        ClassicHttpResponse result2 = this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
        for (String h : endToEndHeaders = new String[]{"Date", "Cache-Control", "Allow", "Content-Language", "Content-Location", "Content-Type", "Expires", "Location", "Pragma", "Retry-After"}) {
            Assert.assertEquals((Object)HttpTestUtils.getCanonicalHeaderValue((HttpMessage)resp2, h), (Object)HttpTestUtils.getCanonicalHeaderValue((HttpMessage)result1, h));
            Assert.assertEquals((Object)HttpTestUtils.getCanonicalHeaderValue((HttpMessage)resp2, h), (Object)HttpTestUtils.getCanonicalHeaderValue((HttpMessage)result2, h));
        }
    }

    @Test
    public void testMultiHeadersAreSuccessfullyReplacedOn304Validation() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.addHeader("Cache-Control", (Object)"max-age=3600");
        resp1.addHeader("Cache-Control", (Object)"public");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Cache-Control", (Object)"max-age=0, max-stale=0");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(304, "Not Modified");
        resp2.setHeader("Cache-Control", (Object)"max-age=1800");
        this.backendExpectsAnyRequestAndReturn(resp1);
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result1 = this.execute((ClassicHttpRequest)req2);
        ClassicHttpResponse result2 = this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
        String h = "Cache-Control";
        Assert.assertEquals((Object)HttpTestUtils.getCanonicalHeaderValue((HttpMessage)resp2, "Cache-Control"), (Object)HttpTestUtils.getCanonicalHeaderValue((HttpMessage)result1, "Cache-Control"));
        Assert.assertEquals((Object)HttpTestUtils.getCanonicalHeaderValue((HttpMessage)resp2, "Cache-Control"), (Object)HttpTestUtils.getCanonicalHeaderValue((HttpMessage)result2, "Cache-Control"));
    }

    @Test
    public void testCannotCombinePartialResponseIfIncomingResponseDoesNotHaveACacheValidator() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        req1.setHeader("Range", (Object)"bytes=0-49");
        Date now = new Date();
        Date oneSecondAgo = new Date(now.getTime() - 1000L);
        Date twoSecondsAgo = new Date(now.getTime() - 2000L);
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(206, "Partial Content");
        resp1.setEntity(HttpTestUtils.makeBody(50));
        resp1.setHeader("Server", (Object)"MockServer/1.0");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)twoSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Content-Range", (Object)"bytes 0-49/128");
        resp1.setHeader("ETag", (Object)"\"etag1\"");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Range", (Object)"bytes=50-127");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(206, "Partial Content");
        resp2.setEntity(HttpTestUtils.makeBody(78));
        resp2.setHeader("Cache-Control", (Object)"max-age=3600");
        resp2.setHeader("Content-Range", (Object)"bytes 50-127/128");
        resp2.setHeader("Server", (Object)"MockServer/1.0");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)oneSecondAgo));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        BasicClassicHttpResponse resp3 = new BasicClassicHttpResponse(200, "OK");
        resp3.setEntity(HttpTestUtils.makeBody(128));
        resp3.setHeader("Server", (Object)"MockServer/1.0");
        resp3.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp3);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
    }

    @Test
    public void testCannotCombinePartialResponseIfCacheEntryDoesNotHaveACacheValidator() throws Exception {
        Date now = new Date();
        Date oneSecondAgo = new Date(now.getTime() - 1000L);
        Date twoSecondsAgo = new Date(now.getTime() - 2000L);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        req1.setHeader("Range", (Object)"bytes=0-49");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(206, "Partial Content");
        resp1.setEntity(HttpTestUtils.makeBody(50));
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Content-Range", (Object)"bytes 0-49/128");
        resp1.setHeader("Server", (Object)"MockServer/1.0");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)twoSecondsAgo));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Range", (Object)"bytes=50-127");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(206, "Partial Content");
        resp2.setEntity(HttpTestUtils.makeBody(78));
        resp2.setHeader("Cache-Control", (Object)"max-age=3600");
        resp2.setHeader("Content-Range", (Object)"bytes 50-127/128");
        resp2.setHeader("ETag", (Object)"\"etag1\"");
        resp2.setHeader("Server", (Object)"MockServer/1.0");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)oneSecondAgo));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        BasicClassicHttpResponse resp3 = new BasicClassicHttpResponse(200, "OK");
        resp3.setEntity(HttpTestUtils.makeBody(128));
        resp3.setHeader("Server", (Object)"MockServer/1.0");
        resp3.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp3);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
    }

    @Test
    public void testCannotCombinePartialResponseIfCacheValidatorsDoNotStronglyMatch() throws Exception {
        Date now = new Date();
        Date oneSecondAgo = new Date(now.getTime() - 1000L);
        Date twoSecondsAgo = new Date(now.getTime() - 2000L);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        req1.setHeader("Range", (Object)"bytes=0-49");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(206, "Partial Content");
        resp1.setEntity(HttpTestUtils.makeBody(50));
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Content-Range", (Object)"bytes 0-49/128");
        resp1.setHeader("ETag", (Object)"\"etag1\"");
        resp1.setHeader("Server", (Object)"MockServer/1.0");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)twoSecondsAgo));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Range", (Object)"bytes=50-127");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(206, "Partial Content");
        resp2.setEntity(HttpTestUtils.makeBody(78));
        resp2.setHeader("Cache-Control", (Object)"max-age=3600");
        resp2.setHeader("Content-Range", (Object)"bytes 50-127/128");
        resp2.setHeader("ETag", (Object)"\"etag2\"");
        resp2.setHeader("Server", (Object)"MockServer/1.0");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)oneSecondAgo));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        BasicClassicHttpResponse resp3 = new BasicClassicHttpResponse(200, "OK");
        resp3.setEntity(HttpTestUtils.makeBody(128));
        resp3.setHeader("Server", (Object)"MockServer/1.0");
        resp3.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp3);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
    }

    @Test
    public void testMustDiscardLeastRecentPartialResponseIfIncomingRequestDoesNotHaveCacheValidator() throws Exception {
        Date now = new Date();
        Date oneSecondAgo = new Date(now.getTime() - 1000L);
        Date twoSecondsAgo = new Date(now.getTime() - 2000L);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        req1.setHeader("Range", (Object)"bytes=0-49");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(206, "Partial Content");
        resp1.setEntity(HttpTestUtils.makeBody(50));
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Content-Range", (Object)"bytes 0-49/128");
        resp1.setHeader("ETag", (Object)"\"etag1\"");
        resp1.setHeader("Server", (Object)"MockServer/1.0");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)twoSecondsAgo));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Range", (Object)"bytes=50-127");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(206, "Partial Content");
        resp2.setEntity(HttpTestUtils.makeBody(78));
        resp2.setHeader("Cache-Control", (Object)"max-age=3600");
        resp2.setHeader("Content-Range", (Object)"bytes 50-127/128");
        resp2.setHeader("Server", (Object)"MockServer/1.0");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)oneSecondAgo));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        req3.setHeader("Range", (Object)"bytes=0-49");
        BasicClassicHttpResponse resp3 = new BasicClassicHttpResponse(200, "OK");
        resp3.setEntity(HttpTestUtils.makeBody(128));
        resp3.setHeader("Server", (Object)"MockServer/1.0");
        resp3.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp3);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
    }

    @Test
    public void testMustDiscardLeastRecentPartialResponseIfCachedResponseDoesNotHaveCacheValidator() throws Exception {
        Date now = new Date();
        Date oneSecondAgo = new Date(now.getTime() - 1000L);
        Date twoSecondsAgo = new Date(now.getTime() - 2000L);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        req1.setHeader("Range", (Object)"bytes=0-49");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(206, "Partial Content");
        resp1.setEntity(HttpTestUtils.makeBody(50));
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Content-Range", (Object)"bytes 0-49/128");
        resp1.setHeader("Server", (Object)"MockServer/1.0");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)twoSecondsAgo));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Range", (Object)"bytes=50-127");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(206, "Partial Content");
        resp2.setEntity(HttpTestUtils.makeBody(78));
        resp2.setHeader("Cache-Control", (Object)"max-age=3600");
        resp2.setHeader("Content-Range", (Object)"bytes 50-127/128");
        resp2.setHeader("ETag", (Object)"\"etag1\"");
        resp2.setHeader("Server", (Object)"MockServer/1.0");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)oneSecondAgo));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        req3.setHeader("Range", (Object)"bytes=0-49");
        BasicClassicHttpResponse resp3 = new BasicClassicHttpResponse(200, "OK");
        resp3.setEntity(HttpTestUtils.makeBody(128));
        resp3.setHeader("Server", (Object)"MockServer/1.0");
        resp3.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp3);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
    }

    @Test
    public void testMustDiscardLeastRecentPartialResponseIfCacheValidatorsDoNotStronglyMatch() throws Exception {
        Date now = new Date();
        Date oneSecondAgo = new Date(now.getTime() - 1000L);
        Date twoSecondsAgo = new Date(now.getTime() - 2000L);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        req1.setHeader("Range", (Object)"bytes=0-49");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(206, "Partial Content");
        resp1.setEntity(HttpTestUtils.makeBody(50));
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Content-Range", (Object)"bytes 0-49/128");
        resp1.setHeader("Etag", (Object)"\"etag1\"");
        resp1.setHeader("Server", (Object)"MockServer/1.0");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)twoSecondsAgo));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Range", (Object)"bytes=50-127");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(206, "Partial Content");
        resp2.setEntity(HttpTestUtils.makeBody(78));
        resp2.setHeader("Cache-Control", (Object)"max-age=3600");
        resp2.setHeader("Content-Range", (Object)"bytes 50-127/128");
        resp2.setHeader("ETag", (Object)"\"etag2\"");
        resp2.setHeader("Server", (Object)"MockServer/1.0");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)oneSecondAgo));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        req3.setHeader("Range", (Object)"bytes=0-49");
        BasicClassicHttpResponse resp3 = new BasicClassicHttpResponse(200, "OK");
        resp3.setEntity(HttpTestUtils.makeBody(128));
        resp3.setHeader("Server", (Object)"MockServer/1.0");
        resp3.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp3);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
    }

    @Test
    public void testMustDiscardLeastRecentPartialResponseIfCacheValidatorsDoNotStronglyMatchEvenIfResponsesOutOfOrder() throws Exception {
        Date now = new Date();
        Date oneSecondAgo = new Date(now.getTime() - 1000L);
        Date twoSecondsAgo = new Date(now.getTime() - 2000L);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        req1.setHeader("Range", (Object)"bytes=0-49");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(206, "Partial Content");
        resp1.setEntity(HttpTestUtils.makeBody(50));
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Content-Range", (Object)"bytes 0-49/128");
        resp1.setHeader("Etag", (Object)"\"etag1\"");
        resp1.setHeader("Server", (Object)"MockServer/1.0");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)oneSecondAgo));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Range", (Object)"bytes=50-127");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(206, "Partial Content");
        resp2.setEntity(HttpTestUtils.makeBody(78));
        resp2.setHeader("Cache-Control", (Object)"max-age=3600");
        resp2.setHeader("Content-Range", (Object)"bytes 50-127/128");
        resp2.setHeader("ETag", (Object)"\"etag2\"");
        resp2.setHeader("Server", (Object)"MockServer/1.0");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)twoSecondsAgo));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        req3.setHeader("Range", (Object)"bytes=50-127");
        BasicClassicHttpResponse resp3 = new BasicClassicHttpResponse(200, "OK");
        resp3.setEntity(HttpTestUtils.makeBody(128));
        resp3.setHeader("Server", (Object)"MockServer/1.0");
        resp3.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp3);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
    }

    @Test
    public void testMustDiscardCachedPartialResponseIfCacheValidatorsDoNotStronglyMatchAndDateHeadersAreEqual() throws Exception {
        Date now = new Date();
        Date oneSecondAgo = new Date(now.getTime() - 1000L);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        req1.setHeader("Range", (Object)"bytes=0-49");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(206, "Partial Content");
        resp1.setEntity(HttpTestUtils.makeBody(50));
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Content-Range", (Object)"bytes 0-49/128");
        resp1.setHeader("Etag", (Object)"\"etag1\"");
        resp1.setHeader("Server", (Object)"MockServer/1.0");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)oneSecondAgo));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Range", (Object)"bytes=50-127");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(206, "Partial Content");
        resp2.setEntity(HttpTestUtils.makeBody(78));
        resp2.setHeader("Cache-Control", (Object)"max-age=3600");
        resp2.setHeader("Content-Range", (Object)"bytes 50-127/128");
        resp2.setHeader("ETag", (Object)"\"etag2\"");
        resp2.setHeader("Server", (Object)"MockServer/1.0");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)oneSecondAgo));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        req3.setHeader("Range", (Object)"bytes=0-49");
        BasicClassicHttpResponse resp3 = new BasicClassicHttpResponse(200, "OK");
        resp3.setEntity(HttpTestUtils.makeBody(128));
        resp3.setHeader("Server", (Object)"MockServer/1.0");
        resp3.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp3);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
    }

    @Test
    public void testCannotUseVariantCacheEntryIfNotAllSelectingRequestHeadersMatch() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        req1.setHeader("Accept-Encoding", (Object)"gzip");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("ETag", (Object)"\"etag1\"");
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Vary", (Object)"Accept-Encoding");
        this.backendExpectsAnyRequestAndReturn(resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.removeHeaders("Accept-Encoding");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("ETag", (Object)"\"etag1\"");
        resp2.setHeader("Cache-Control", (Object)"max-age=3600");
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
    }

    @Test
    public void testCannotServeFromCacheForVaryStar() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("ETag", (Object)"\"etag1\"");
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Vary", (Object)"*");
        this.backendExpectsAnyRequestAndReturn(resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("ETag", (Object)"\"etag1\"");
        resp2.setHeader("Cache-Control", (Object)"max-age=3600");
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
    }

    @Test
    public void testNonmatchingVariantCannotBeServedFromCacheUnlessConditionallyValidated() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        req1.setHeader("User-Agent", (Object)"MyBrowser/1.0");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("ETag", (Object)"\"etag1\"");
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Vary", (Object)"User-Agent");
        resp1.setHeader("Content-Type", (Object)"application/octet-stream");
        this.backendExpectsAnyRequestAndReturn(resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("User-Agent", (Object)"MyBrowser/1.5");
        BasicClassicHttpRequest conditional = new BasicClassicHttpRequest("GET", "/");
        conditional.setHeader("User-Agent", (Object)"MyBrowser/1.5");
        conditional.setHeader("If-None-Match", (Object)"\"etag1\"");
        ClassicHttpResponse resp200 = HttpTestUtils.make200Response();
        resp200.setHeader("ETag", (Object)"\"etag1\"");
        resp200.setHeader("Vary", (Object)"User-Agent");
        BasicClassicHttpResponse resp304 = new BasicClassicHttpResponse(304, "Not Modified");
        resp304.setHeader("ETag", (Object)"\"etag1\"");
        resp304.setHeader("Vary", (Object)"User-Agent");
        Capture condCap = new Capture();
        Capture uncondCap = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.and((Object)TestProtocolRequirements.eqRequest((ClassicHttpRequest)conditional), (Object)EasyMock.capture((Capture)condCap)), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp304).times(0, 1);
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.and((Object)TestProtocolRequirements.eqRequest((ClassicHttpRequest)req2), (Object)EasyMock.capture((Capture)uncondCap)), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp200).times(0, 1);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        if (200 == result.getCode()) {
            Assert.assertTrue((condCap.hasCaptured() || uncondCap.hasCaptured() ? 1 : 0) != 0);
            if (uncondCap.hasCaptured()) {
                Assert.assertTrue((boolean)HttpTestUtils.semanticallyTransparent(resp200, result));
            }
        }
    }

    protected void testUnsafeOperationInvalidatesCacheForThatUri(ClassicHttpRequest unsafeReq) throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"public, max-age=3600");
        this.backendExpectsAnyRequestAndReturn(resp1);
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(204, "No Content");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp3 = HttpTestUtils.make200Response();
        resp3.setHeader("Cache-Control", (Object)"public, max-age=3600");
        this.backendExpectsAnyRequestAndReturn(resp3);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute(unsafeReq);
        this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
    }

    @Test
    public void testPutToUriInvalidatesCacheForThatUri() throws Exception {
        ClassicHttpRequest req = this.makeRequestWithBody("PUT", "/");
        this.testUnsafeOperationInvalidatesCacheForThatUri(req);
    }

    @Test
    public void testDeleteToUriInvalidatesCacheForThatUri() throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("DELETE", "/");
        this.testUnsafeOperationInvalidatesCacheForThatUri((ClassicHttpRequest)req);
    }

    @Test
    public void testPostToUriInvalidatesCacheForThatUri() throws Exception {
        ClassicHttpRequest req = this.makeRequestWithBody("POST", "/");
        this.testUnsafeOperationInvalidatesCacheForThatUri(req);
    }

    protected void testUnsafeMethodInvalidatesCacheForHeaderUri(ClassicHttpRequest unsafeReq) throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/content");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"public, max-age=3600");
        this.backendExpectsAnyRequestAndReturn(resp1);
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(204, "No Content");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/content");
        ClassicHttpResponse resp3 = HttpTestUtils.make200Response();
        resp3.setHeader("Cache-Control", (Object)"public, max-age=3600");
        this.backendExpectsAnyRequestAndReturn(resp3);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute(unsafeReq);
        this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
    }

    protected void testUnsafeMethodInvalidatesCacheForUriInContentLocationHeader(ClassicHttpRequest unsafeReq) throws Exception {
        unsafeReq.setHeader("Content-Location", (Object)"http://foo.example.com/content");
        this.testUnsafeMethodInvalidatesCacheForHeaderUri(unsafeReq);
    }

    protected void testUnsafeMethodInvalidatesCacheForRelativeUriInContentLocationHeader(ClassicHttpRequest unsafeReq) throws Exception {
        unsafeReq.setHeader("Content-Location", (Object)"/content");
        this.testUnsafeMethodInvalidatesCacheForHeaderUri(unsafeReq);
    }

    protected void testUnsafeMethodInvalidatesCacheForUriInLocationHeader(ClassicHttpRequest unsafeReq) throws Exception {
        unsafeReq.setHeader("Location", (Object)"http://foo.example.com/content");
        this.testUnsafeMethodInvalidatesCacheForHeaderUri(unsafeReq);
    }

    @Test
    public void testPutInvalidatesCacheForThatUriInContentLocationHeader() throws Exception {
        ClassicHttpRequest req2 = this.makeRequestWithBody("PUT", "/");
        this.testUnsafeMethodInvalidatesCacheForUriInContentLocationHeader(req2);
    }

    @Test
    public void testPutInvalidatesCacheForThatUriInLocationHeader() throws Exception {
        ClassicHttpRequest req = this.makeRequestWithBody("PUT", "/");
        this.testUnsafeMethodInvalidatesCacheForUriInLocationHeader(req);
    }

    @Test
    public void testPutInvalidatesCacheForThatUriInRelativeContentLocationHeader() throws Exception {
        ClassicHttpRequest req = this.makeRequestWithBody("PUT", "/");
        this.testUnsafeMethodInvalidatesCacheForRelativeUriInContentLocationHeader(req);
    }

    @Test
    public void testDeleteInvalidatesCacheForThatUriInContentLocationHeader() throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("DELETE", "/");
        this.testUnsafeMethodInvalidatesCacheForUriInContentLocationHeader((ClassicHttpRequest)req);
    }

    @Test
    public void testDeleteInvalidatesCacheForThatUriInRelativeContentLocationHeader() throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("DELETE", "/");
        this.testUnsafeMethodInvalidatesCacheForRelativeUriInContentLocationHeader((ClassicHttpRequest)req);
    }

    @Test
    public void testDeleteInvalidatesCacheForThatUriInLocationHeader() throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("DELETE", "/");
        this.testUnsafeMethodInvalidatesCacheForUriInLocationHeader((ClassicHttpRequest)req);
    }

    @Test
    public void testPostInvalidatesCacheForThatUriInContentLocationHeader() throws Exception {
        ClassicHttpRequest req = this.makeRequestWithBody("POST", "/");
        this.testUnsafeMethodInvalidatesCacheForUriInContentLocationHeader(req);
    }

    @Test
    public void testPostInvalidatesCacheForThatUriInLocationHeader() throws Exception {
        ClassicHttpRequest req = this.makeRequestWithBody("POST", "/");
        this.testUnsafeMethodInvalidatesCacheForUriInLocationHeader(req);
    }

    @Test
    public void testPostInvalidatesCacheForRelativeUriInContentLocationHeader() throws Exception {
        ClassicHttpRequest req = this.makeRequestWithBody("POST", "/");
        this.testUnsafeMethodInvalidatesCacheForRelativeUriInContentLocationHeader(req);
    }

    protected void testUnsafeMethodDoesNotInvalidateCacheForHeaderUri(ClassicHttpRequest unsafeReq) throws Exception {
        HttpHost otherHost = new HttpHost("bar.example.com", 80);
        HttpRoute otherRoute = new HttpRoute(otherHost);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/content");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"public, max-age=3600");
        this.backendExpectsAnyRequestAndReturn(resp1);
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(204, "No Content");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/content");
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute(unsafeReq);
        this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
    }

    protected void testUnsafeMethodDoesNotInvalidateCacheForUriInContentLocationHeadersFromOtherHosts(ClassicHttpRequest unsafeReq) throws Exception {
        unsafeReq.setHeader("Content-Location", (Object)"http://bar.example.com/content");
        this.testUnsafeMethodDoesNotInvalidateCacheForHeaderUri(unsafeReq);
    }

    protected void testUnsafeMethodDoesNotInvalidateCacheForUriInLocationHeadersFromOtherHosts(ClassicHttpRequest unsafeReq) throws Exception {
        unsafeReq.setHeader("Location", (Object)"http://bar.example.com/content");
        this.testUnsafeMethodDoesNotInvalidateCacheForHeaderUri(unsafeReq);
    }

    protected ClassicHttpRequest makeRequestWithBody(String method, String requestUri) {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest(method, requestUri);
        int nbytes = 128;
        req.setEntity(HttpTestUtils.makeBody(128));
        req.setHeader("Content-Length", (Object)"128");
        return req;
    }

    @Test
    public void testPutDoesNotInvalidateCacheForUriInContentLocationHeadersFromOtherHosts() throws Exception {
        ClassicHttpRequest req = this.makeRequestWithBody("PUT", "/");
        this.testUnsafeMethodDoesNotInvalidateCacheForUriInContentLocationHeadersFromOtherHosts(req);
    }

    @Test
    public void testPutDoesNotInvalidateCacheForUriInLocationHeadersFromOtherHosts() throws Exception {
        ClassicHttpRequest req = this.makeRequestWithBody("PUT", "/");
        this.testUnsafeMethodDoesNotInvalidateCacheForUriInLocationHeadersFromOtherHosts(req);
    }

    @Test
    public void testPostDoesNotInvalidateCacheForUriInContentLocationHeadersFromOtherHosts() throws Exception {
        ClassicHttpRequest req = this.makeRequestWithBody("POST", "/");
        this.testUnsafeMethodDoesNotInvalidateCacheForUriInContentLocationHeadersFromOtherHosts(req);
    }

    @Test
    public void testPostDoesNotInvalidateCacheForUriInLocationHeadersFromOtherHosts() throws Exception {
        ClassicHttpRequest req = this.makeRequestWithBody("POST", "/");
        this.testUnsafeMethodDoesNotInvalidateCacheForUriInLocationHeadersFromOtherHosts(req);
    }

    @Test
    public void testDeleteDoesNotInvalidateCacheForUriInContentLocationHeadersFromOtherHosts() throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("DELETE", "/");
        this.testUnsafeMethodDoesNotInvalidateCacheForUriInContentLocationHeadersFromOtherHosts((ClassicHttpRequest)req);
    }

    @Test
    public void testDeleteDoesNotInvalidateCacheForUriInLocationHeadersFromOtherHosts() throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("DELETE", "/");
        this.testUnsafeMethodDoesNotInvalidateCacheForUriInLocationHeadersFromOtherHosts((ClassicHttpRequest)req);
    }

    private void testRequestIsWrittenThroughToOrigin(ClassicHttpRequest req) throws Exception {
        BasicClassicHttpResponse resp = new BasicClassicHttpResponse(204, "No Content");
        ClassicHttpRequest wrapper = req;
        EasyMock.expect((Object)this.mockExecChain.proceed(TestProtocolRequirements.eqRequest(wrapper), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp);
        this.replayMocks();
        this.execute(wrapper);
        this.verifyMocks();
    }

    @Test
    @Ignore
    public void testOPTIONSRequestsAreWrittenThroughToOrigin() throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("OPTIONS", "*");
        this.testRequestIsWrittenThroughToOrigin((ClassicHttpRequest)req);
    }

    @Test
    public void testPOSTRequestsAreWrittenThroughToOrigin() throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("POST", "/");
        req.setEntity(HttpTestUtils.makeBody(128));
        req.setHeader("Content-Length", (Object)"128");
        this.testRequestIsWrittenThroughToOrigin((ClassicHttpRequest)req);
    }

    @Test
    public void testPUTRequestsAreWrittenThroughToOrigin() throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("PUT", "/");
        req.setEntity(HttpTestUtils.makeBody(128));
        req.setHeader("Content-Length", (Object)"128");
        this.testRequestIsWrittenThroughToOrigin((ClassicHttpRequest)req);
    }

    @Test
    public void testDELETERequestsAreWrittenThroughToOrigin() throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("DELETE", "/");
        this.testRequestIsWrittenThroughToOrigin((ClassicHttpRequest)req);
    }

    @Test
    public void testTRACERequestsAreWrittenThroughToOrigin() throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("TRACE", "/");
        this.testRequestIsWrittenThroughToOrigin((ClassicHttpRequest)req);
    }

    @Test
    public void testCONNECTRequestsAreWrittenThroughToOrigin() throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("CONNECT", "/");
        this.testRequestIsWrittenThroughToOrigin((ClassicHttpRequest)req);
    }

    @Test
    public void testUnknownMethodRequestsAreWrittenThroughToOrigin() throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("UNKNOWN", "/");
        this.testRequestIsWrittenThroughToOrigin((ClassicHttpRequest)req);
    }

    @Test
    public void testTransmitsAgeHeaderIfIncomingAgeHeaderTooBig() throws Exception {
        String reallyOldAge = "19223372036854775807";
        this.originResponse.setHeader("Age", (Object)"19223372036854775807");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertEquals((Object)"2147483648", (Object)result.getFirstHeader("Age").getValue());
    }

    @Test
    public void testDoesNotModifyAllowHeaderWithUnknownMethods() throws Exception {
        String allowHeaderValue = "GET, HEAD, FOOBAR";
        this.originResponse.setHeader("Allow", (Object)"GET, HEAD, FOOBAR");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertEquals((Object)HttpTestUtils.getCanonicalHeaderValue((HttpMessage)this.originResponse, "Allow"), (Object)HttpTestUtils.getCanonicalHeaderValue((HttpMessage)result, "Allow"));
    }

    protected void testSharedCacheRevalidatesAuthorizedResponse(ClassicHttpResponse authorizedResponse, int minTimes, int maxTimes) throws Exception {
        if (this.config.isSharedCache()) {
            String authorization = "Basic dXNlcjpwYXNzd2Q=";
            BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
            req1.setHeader("Authorization", (Object)"Basic dXNlcjpwYXNzd2Q=");
            this.backendExpectsAnyRequestAndReturn(authorizedResponse);
            BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
            ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
            resp2.setHeader("Cache-Control", (Object)"max-age=3600");
            if (maxTimes > 0) {
                this.backendExpectsAnyRequest().andReturn((Object)resp2).times(minTimes, maxTimes);
            }
            this.replayMocks();
            this.execute((ClassicHttpRequest)req1);
            this.execute((ClassicHttpRequest)req2);
            this.verifyMocks();
        }
    }

    @Test
    public void testSharedCacheMustNotNormallyCacheAuthorizedResponses() throws Exception {
        ClassicHttpResponse resp = HttpTestUtils.make200Response();
        resp.setHeader("Cache-Control", (Object)"max-age=3600");
        resp.setHeader("ETag", (Object)"\"etag\"");
        this.testSharedCacheRevalidatesAuthorizedResponse(resp, 1, 1);
    }

    @Test
    public void testSharedCacheMayCacheAuthorizedResponsesWithSMaxAgeHeader() throws Exception {
        ClassicHttpResponse resp = HttpTestUtils.make200Response();
        resp.setHeader("Cache-Control", (Object)"s-maxage=3600");
        resp.setHeader("ETag", (Object)"\"etag\"");
        this.testSharedCacheRevalidatesAuthorizedResponse(resp, 0, 1);
    }

    @Test
    public void testSharedCacheMustRevalidateAuthorizedResponsesWhenSMaxAgeIsZero() throws Exception {
        ClassicHttpResponse resp = HttpTestUtils.make200Response();
        resp.setHeader("Cache-Control", (Object)"s-maxage=0");
        resp.setHeader("ETag", (Object)"\"etag\"");
        this.testSharedCacheRevalidatesAuthorizedResponse(resp, 1, 1);
    }

    @Test
    public void testSharedCacheMayCacheAuthorizedResponsesWithMustRevalidate() throws Exception {
        ClassicHttpResponse resp = HttpTestUtils.make200Response();
        resp.setHeader("Cache-Control", (Object)"must-revalidate");
        resp.setHeader("ETag", (Object)"\"etag\"");
        this.testSharedCacheRevalidatesAuthorizedResponse(resp, 0, 1);
    }

    @Test
    public void testSharedCacheMayCacheAuthorizedResponsesWithCacheControlPublic() throws Exception {
        ClassicHttpResponse resp = HttpTestUtils.make200Response();
        resp.setHeader("Cache-Control", (Object)"public");
        this.testSharedCacheRevalidatesAuthorizedResponse(resp, 0, 1);
    }

    protected void testSharedCacheMustUseNewRequestHeadersWhenRevalidatingAuthorizedResponse(ClassicHttpResponse authorizedResponse) throws Exception {
        if (this.config.isSharedCache()) {
            String authorization1 = "Basic dXNlcjpwYXNzd2Q=";
            String authorization2 = "Basic dXNlcjpwYXNzd2Qy";
            BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
            req1.setHeader("Authorization", (Object)"Basic dXNlcjpwYXNzd2Q=");
            this.backendExpectsAnyRequestAndReturn(authorizedResponse);
            BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
            req2.setHeader("Authorization", (Object)"Basic dXNlcjpwYXNzd2Qy");
            ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
            Capture cap = new Capture();
            EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp2);
            this.replayMocks();
            this.execute((ClassicHttpRequest)req1);
            this.execute((ClassicHttpRequest)req2);
            this.verifyMocks();
            ClassicHttpRequest captured = (ClassicHttpRequest)cap.getValue();
            Assert.assertEquals((Object)HttpTestUtils.getCanonicalHeaderValue((HttpMessage)req2, "Authorization"), (Object)HttpTestUtils.getCanonicalHeaderValue((HttpMessage)captured, "Authorization"));
        }
    }

    @Test
    public void testSharedCacheMustUseNewRequestHeadersWhenRevalidatingAuthorizedResponsesWithSMaxAge() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Cache-Control", (Object)"s-maxage=5");
        this.testSharedCacheMustUseNewRequestHeadersWhenRevalidatingAuthorizedResponse(resp1);
    }

    @Test
    public void testSharedCacheMustUseNewRequestHeadersWhenRevalidatingAuthorizedResponsesWithMustRevalidate() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Cache-Control", (Object)"maxage=5, must-revalidate");
        this.testSharedCacheMustUseNewRequestHeadersWhenRevalidatingAuthorizedResponse(resp1);
    }

    @Test
    public void testWarning110IsAddedToStaleResponses() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"max-age=5");
        resp1.setHeader("Etag", (Object)"\"etag\"");
        this.backendExpectsAnyRequestAndReturn(resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Cache-Control", (Object)"max-stale=60");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        Capture cap = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp2).times(0, 1);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        if (!cap.hasCaptured()) {
            boolean found110Warning = false;
            Iterator it = MessageSupport.iterate((MessageHeaders)result, (String)"Warning");
            while (it.hasNext()) {
                HeaderElement elt = (HeaderElement)it.next();
                String[] parts = elt.getName().split("\\s");
                if (!"110".equals(parts[0])) continue;
                found110Warning = true;
                break;
            }
            Assert.assertTrue((boolean)found110Warning);
        }
    }

    @Test
    public void testDoesNotTransmitNoCacheDirectivesWithFieldsDownstream() throws Exception {
        this.request.setHeader("Cache-Control", (Object)"no-cache=\"X-Field\"");
        Capture cap = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse).times(0, 1);
        this.replayMocks();
        try {
            this.execute(this.request);
        }
        catch (ClientProtocolException acceptable) {
            // empty catch block
        }
        this.verifyMocks();
        if (cap.hasCaptured()) {
            ClassicHttpRequest captured = (ClassicHttpRequest)cap.getValue();
            Iterator it = MessageSupport.iterate((MessageHeaders)captured, (String)"Cache-Control");
            while (it.hasNext()) {
                HeaderElement elt = (HeaderElement)it.next();
                if (!"no-cache".equals(elt.getName())) continue;
                Assert.assertNull((Object)elt.getValue());
            }
        }
    }

    protected void testCacheIsNotUsedWhenRespondingToRequest(ClassicHttpRequest req) throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Etag", (Object)"\"etag\"");
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("Etag", (Object)"\"etag2\"");
        resp2.setHeader("Cache-Control", (Object)"max-age=1200");
        Capture cap = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute(req);
        this.verifyMocks();
        Assert.assertTrue((boolean)HttpTestUtils.semanticallyTransparent(resp2, result));
        ClassicHttpRequest captured = (ClassicHttpRequest)cap.getValue();
        Assert.assertTrue((boolean)HttpTestUtils.equivalent((HttpRequest)req, (HttpRequest)captured));
    }

    @Test
    public void testCacheIsNotUsedWhenRespondingToRequestWithCacheControlNoCache() throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("GET", "/");
        req.setHeader("Cache-Control", (Object)"no-cache");
        this.testCacheIsNotUsedWhenRespondingToRequest((ClassicHttpRequest)req);
    }

    @Test
    public void testCacheIsNotUsedWhenRespondingToRequestWithPragmaNoCache() throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("GET", "/");
        req.setHeader("Pragma", (Object)"no-cache");
        this.testCacheIsNotUsedWhenRespondingToRequest((ClassicHttpRequest)req);
    }

    protected void testStaleCacheResponseMustBeRevalidatedWithOrigin(ClassicHttpResponse staleResponse) throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        this.backendExpectsAnyRequestAndReturn(staleResponse);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Cache-Control", (Object)"max-stale=3600");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("ETag", (Object)"\"etag2\"");
        resp2.setHeader("Cache-Control", (Object)"max-age=5, must-revalidate");
        Capture cap = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        ClassicHttpRequest reval = (ClassicHttpRequest)cap.getValue();
        boolean foundMaxAge0 = false;
        Iterator it = MessageSupport.iterate((MessageHeaders)reval, (String)"Cache-Control");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (!"max-age".equalsIgnoreCase(elt.getName()) || !"0".equals(elt.getValue())) continue;
            foundMaxAge0 = true;
        }
        Assert.assertTrue((boolean)foundMaxAge0);
    }

    @Test
    public void testStaleEntryWithMustRevalidateIsNotUsedWithoutRevalidatingWithOrigin() throws Exception {
        ClassicHttpResponse response = HttpTestUtils.make200Response();
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        response.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        response.setHeader("ETag", (Object)"\"etag1\"");
        response.setHeader("Cache-Control", (Object)"max-age=5, must-revalidate");
        this.testStaleCacheResponseMustBeRevalidatedWithOrigin(response);
    }

    protected void testGenerates504IfCannotRevalidateStaleResponse(ClassicHttpResponse staleResponse) throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        this.backendExpectsAnyRequestAndReturn(staleResponse);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        this.backendExpectsAnyRequest().andThrow((Throwable)new SocketTimeoutException());
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)504L, (long)result.getCode());
    }

    @Test
    public void testGenerates504IfCannotRevalidateAMustRevalidateEntry() throws Exception {
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"max-age=5,must-revalidate");
        this.testGenerates504IfCannotRevalidateStaleResponse(resp1);
    }

    @Test
    public void testStaleEntryWithProxyRevalidateOnSharedCacheIsNotUsedWithoutRevalidatingWithOrigin() throws Exception {
        if (this.config.isSharedCache()) {
            ClassicHttpResponse response = HttpTestUtils.make200Response();
            Date now = new Date();
            Date tenSecondsAgo = new Date(now.getTime() - 10000L);
            response.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
            response.setHeader("ETag", (Object)"\"etag1\"");
            response.setHeader("Cache-Control", (Object)"max-age=5, proxy-revalidate");
            this.testStaleCacheResponseMustBeRevalidatedWithOrigin(response);
        }
    }

    @Test
    public void testGenerates504IfSharedCacheCannotRevalidateAProxyRevalidateEntry() throws Exception {
        if (this.config.isSharedCache()) {
            ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
            Date now = new Date();
            Date tenSecondsAgo = new Date(now.getTime() - 10000L);
            resp1.setHeader("ETag", (Object)"\"etag\"");
            resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
            resp1.setHeader("Cache-Control", (Object)"max-age=5,proxy-revalidate");
            this.testGenerates504IfCannotRevalidateStaleResponse(resp1);
        }
    }

    @Test
    public void testCacheControlPrivateIsNotCacheableBySharedCache() throws Exception {
        if (this.config.isSharedCache()) {
            BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
            ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
            resp1.setHeader("Cache-Control", (Object)"private,max-age=3600");
            this.backendExpectsAnyRequestAndReturn(resp1);
            BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
            ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
            this.backendExpectsAnyRequestAndReturn(resp2);
            this.replayMocks();
            this.execute((ClassicHttpRequest)req1);
            this.execute((ClassicHttpRequest)req2);
            this.verifyMocks();
        }
    }

    @Test
    public void testCacheControlPrivateOnFieldIsNotReturnedBySharedCache() throws Exception {
        if (this.config.isSharedCache()) {
            BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
            ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
            resp1.setHeader("X-Personal", (Object)"stuff");
            resp1.setHeader("Cache-Control", (Object)"private=\"X-Personal\",s-maxage=3600");
            this.backendExpectsAnyRequestAndReturn(resp1);
            BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
            ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
            this.backendExpectsAnyRequestAndReturn(resp2).times(0, 1);
            this.replayMocks();
            this.execute((ClassicHttpRequest)req1);
            ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
            this.verifyMocks();
            Assert.assertNull((Object)result.getFirstHeader("X-Personal"));
        }
    }

    @Test
    public void testNoCacheCannotSatisfyASubsequentRequestWithoutRevalidation() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Cache-Control", (Object)"no-cache");
        this.backendExpectsAnyRequestAndReturn(resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
    }

    @Test
    public void testNoCacheCannotSatisfyASubsequentRequestWithoutRevalidationEvenWithContraryIndications() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Cache-Control", (Object)"no-cache,s-maxage=3600");
        this.backendExpectsAnyRequestAndReturn(resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Cache-Control", (Object)"max-stale=7200");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
    }

    @Test
    public void testNoCacheOnFieldIsNotReturnedWithoutRevalidation() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("X-Stuff", (Object)"things");
        resp1.setHeader("Cache-Control", (Object)"no-cache=\"X-Stuff\", max-age=3600");
        this.backendExpectsAnyRequestAndReturn(resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("ETag", (Object)"\"etag\"");
        resp2.setHeader("X-Stuff", (Object)"things");
        resp2.setHeader("Cache-Control", (Object)"no-cache=\"X-Stuff\",max-age=3600");
        Capture cap = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp2).times(0, 1);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        if (!cap.hasCaptured()) {
            Assert.assertNull((Object)result.getFirstHeader("X-Stuff"));
        }
    }

    @Test
    public void testNoStoreOnRequestIsNotStoredInCache() throws Exception {
        this.emptyMockCacheExpectsNoPuts();
        this.request.setHeader("Cache-Control", (Object)"no-store");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute(this.request);
        this.verifyMocks();
    }

    @Test
    public void testNoStoreOnRequestIsNotStoredInCacheEvenIfResponseMarkedCacheable() throws Exception {
        this.emptyMockCacheExpectsNoPuts();
        this.request.setHeader("Cache-Control", (Object)"no-store");
        this.originResponse.setHeader("Cache-Control", (Object)"max-age=3600");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute(this.request);
        this.verifyMocks();
    }

    @Test
    public void testNoStoreOnResponseIsNotStoredInCache() throws Exception {
        this.emptyMockCacheExpectsNoPuts();
        this.originResponse.setHeader("Cache-Control", (Object)"no-store");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute(this.request);
        this.verifyMocks();
    }

    @Test
    public void testNoStoreOnResponseIsNotStoredInCacheEvenWithContraryIndicators() throws Exception {
        this.emptyMockCacheExpectsNoPuts();
        this.originResponse.setHeader("Cache-Control", (Object)"no-store,max-age=3600");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute(this.request);
        this.verifyMocks();
    }

    @Test
    public void testOrderOfMultipleContentEncodingHeaderValuesIsPreserved() throws Exception {
        this.originResponse.addHeader("Content-Encoding", (Object)"gzip");
        this.originResponse.addHeader("Content-Encoding", (Object)"deflate");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        int total_encodings = 0;
        Iterator it = MessageSupport.iterate((MessageHeaders)result, (String)"Content-Encoding");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            switch (total_encodings) {
                case 0: {
                    Assert.assertEquals((Object)"gzip", (Object)elt.getName());
                    break;
                }
                case 1: {
                    Assert.assertEquals((Object)"deflate", (Object)elt.getName());
                    break;
                }
                default: {
                    Assert.fail((String)"too many encodings");
                }
            }
            ++total_encodings;
        }
        Assert.assertEquals((long)2L, (long)total_encodings);
    }

    @Test
    public void testOrderOfMultipleParametersInContentEncodingHeaderIsPreserved() throws Exception {
        this.originResponse.addHeader("Content-Encoding", (Object)"gzip,deflate");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        int total_encodings = 0;
        Iterator it = MessageSupport.iterate((MessageHeaders)result, (String)"Content-Encoding");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            switch (total_encodings) {
                case 0: {
                    Assert.assertEquals((Object)"gzip", (Object)elt.getName());
                    break;
                }
                case 1: {
                    Assert.assertEquals((Object)"deflate", (Object)elt.getName());
                    break;
                }
                default: {
                    Assert.fail((String)"too many encodings");
                }
            }
            ++total_encodings;
        }
        Assert.assertEquals((long)2L, (long)total_encodings);
    }

    @Test
    public void testCacheDoesNotAssumeContentLocationHeaderIndicatesAnotherCacheableResource() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/foo");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"public,max-age=3600");
        resp1.setHeader("Etag", (Object)"\"etag\"");
        resp1.setHeader("Content-Location", (Object)"http://foo.example.com/bar");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/bar");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("Cache-Control", (Object)"public,max-age=3600");
        resp2.setHeader("Etag", (Object)"\"etag\"");
        this.backendExpectsAnyRequestAndReturn(resp1);
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
    }

    @Test
    public void testCachedResponsesWithMissingDateHeadersShouldBeAssignedOne() throws Exception {
        this.originResponse.removeHeaders("Date");
        this.originResponse.setHeader("Cache-Control", (Object)"public");
        this.originResponse.setHeader("ETag", (Object)"\"etag\"");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertNotNull((Object)result.getFirstHeader("Date"));
    }

    private void testInvalidExpiresHeaderIsTreatedAsStale(String expiresHeader) throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"public");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Expires", (Object)expiresHeader);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        this.backendExpectsAnyRequestAndReturn(resp1);
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
    }

    @Test
    public void testMalformedExpiresHeaderIsTreatedAsStale() throws Exception {
        this.testInvalidExpiresHeaderIsTreatedAsStale("garbage");
    }

    @Test
    public void testExpiresZeroHeaderIsTreatedAsStale() throws Exception {
        this.testInvalidExpiresHeaderIsTreatedAsStale("0");
    }

    @Test
    public void testExpiresHeaderEqualToDateHeaderIsTreatedAsStale() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"public");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Expires", (Object)resp1.getFirstHeader("Date").getValue());
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        this.backendExpectsAnyRequestAndReturn(resp1);
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
    }

    @Test
    public void testDoesNotModifyServerResponseHeader() throws Exception {
        String server = "MockServer/1.0";
        this.originResponse.setHeader("Server", (Object)"MockServer/1.0");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertEquals((Object)"MockServer/1.0", (Object)result.getFirstHeader("Server").getValue());
    }

    @Test
    public void testOrderOfMultipleTransferEncodingHeadersIsPreserved() throws Exception {
        this.originResponse.addHeader("Transfer-Encoding", (Object)"chunked");
        this.originResponse.addHeader("Transfer-Encoding", (Object)"x-transfer");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        int transfer_encodings = 0;
        Iterator it = MessageSupport.iterate((MessageHeaders)result, (String)"Transfer-Encoding");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            switch (transfer_encodings) {
                case 0: {
                    Assert.assertEquals((Object)"chunked", (Object)elt.getName());
                    break;
                }
                case 1: {
                    Assert.assertEquals((Object)"x-transfer", (Object)elt.getName());
                    break;
                }
                default: {
                    Assert.fail((String)"too many transfer encodings");
                }
            }
            ++transfer_encodings;
        }
        Assert.assertEquals((long)2L, (long)transfer_encodings);
    }

    @Test
    public void testOrderOfMultipleTransferEncodingsInSingleHeadersIsPreserved() throws Exception {
        this.originResponse.addHeader("Transfer-Encoding", (Object)"chunked, x-transfer");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        int transfer_encodings = 0;
        Iterator it = MessageSupport.iterate((MessageHeaders)result, (String)"Transfer-Encoding");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            switch (transfer_encodings) {
                case 0: {
                    Assert.assertEquals((Object)"chunked", (Object)elt.getName());
                    break;
                }
                case 1: {
                    Assert.assertEquals((Object)"x-transfer", (Object)elt.getName());
                    break;
                }
                default: {
                    Assert.fail((String)"too many transfer encodings");
                }
            }
            ++transfer_encodings;
        }
        Assert.assertEquals((long)2L, (long)transfer_encodings);
    }

    @Test
    public void testVaryStarIsNotGeneratedByProxy() throws Exception {
        this.request.setHeader("User-Agent", (Object)"my-agent/1.0");
        this.originResponse.setHeader("Cache-Control", (Object)"public, max-age=3600");
        this.originResponse.setHeader("Vary", (Object)"User-Agent");
        this.originResponse.setHeader("ETag", (Object)"\"etag\"");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Iterator it = MessageSupport.iterate((MessageHeaders)result, (String)"Vary");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            Assert.assertFalse((boolean)"*".equals(elt.getName()));
        }
    }

    @Test
    public void testProperlyFormattedViaHeaderIsAddedToRequests() throws Exception {
        Capture cap = new Capture();
        this.request.removeHeaders("Via");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute(this.request);
        this.verifyMocks();
        ClassicHttpRequest captured = (ClassicHttpRequest)cap.getValue();
        String via = captured.getFirstHeader("Via").getValue();
        this.assertValidViaHeader(via);
    }

    @Test
    public void testProperlyFormattedViaHeaderIsAddedToResponses() throws Exception {
        this.originResponse.removeHeaders("Via");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        this.assertValidViaHeader(result.getFirstHeader("Via").getValue());
    }

    private void assertValidViaHeader(String via) {
        String[] parts = via.split("\\s+");
        Assert.assertTrue((parts.length >= 2 ? 1 : 0) != 0);
        String receivedProtocol = parts[0];
        String[] protocolParts = receivedProtocol.split("/");
        Assert.assertTrue((protocolParts.length >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((protocolParts.length <= 2 ? 1 : 0) != 0);
        String tokenRegexp = "[^\\p{Cntrl}()<>@,;:\\\\\"/\\[\\]?={} \\t]+";
        for (String protocolPart : protocolParts) {
            Assert.assertTrue((boolean)Pattern.matches("[^\\p{Cntrl}()<>@,;:\\\\\"/\\[\\]?={} \\t]+", protocolPart));
        }
        if (!Pattern.matches("[^\\p{Cntrl}()<>@,;:\\\\\"/\\[\\]?={} \\t]+", parts[1])) {
            new HttpHost(parts[1]);
        }
        if (parts.length > 2) {
            StringBuilder buf = new StringBuilder(parts[2]);
            for (int i = 3; i < parts.length; ++i) {
                buf.append(" ");
                buf.append(parts[i]);
            }
            Assert.assertTrue((boolean)this.isValidComment(buf.toString()));
        }
    }

    private boolean isValidComment(String s) {
        String leafComment = "^\\(([^\\p{Cntrl}()]|\\\\\\p{ASCII})*\\)$";
        String nestedPrefix = "^\\(([^\\p{Cntrl}()]|\\\\\\p{ASCII})*\\(";
        String nestedSuffix = "\\)([^\\p{Cntrl}()]|\\\\\\p{ASCII})*\\)$";
        if (Pattern.matches("^\\(([^\\p{Cntrl}()]|\\\\\\p{ASCII})*\\)$", s)) {
            return true;
        }
        Matcher pref = Pattern.compile("^\\(([^\\p{Cntrl}()]|\\\\\\p{ASCII})*\\(").matcher(s);
        Matcher suff = Pattern.compile("\\)([^\\p{Cntrl}()]|\\\\\\p{ASCII})*\\)$").matcher(s);
        if (!pref.find()) {
            return false;
        }
        if (!suff.find()) {
            return false;
        }
        return this.isValidComment(s.substring(pref.end() - 1, suff.start() + 1));
    }

    @Test
    public void testViaHeaderOnRequestProperlyRecordsClientProtocol() throws Exception {
        BasicClassicHttpRequest originalRequest = new BasicClassicHttpRequest("GET", "/");
        originalRequest.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        this.request = originalRequest;
        this.request.removeHeaders("Via");
        Capture cap = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute(this.request);
        this.verifyMocks();
        ClassicHttpRequest captured = (ClassicHttpRequest)cap.getValue();
        String via = captured.getFirstHeader("Via").getValue();
        String protocol = via.split("\\s+")[0];
        String[] protoParts = protocol.split("/");
        if (protoParts.length > 1) {
            Assert.assertTrue((boolean)"http".equalsIgnoreCase(protoParts[0]));
        }
        Assert.assertEquals((Object)"1.0", (Object)protoParts[protoParts.length - 1]);
    }

    @Test
    public void testViaHeaderOnResponseProperlyRecordsOriginProtocol() throws Exception {
        this.originResponse = new BasicClassicHttpResponse(204, "No Content");
        this.originResponse.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        String via = result.getFirstHeader("Via").getValue();
        String protocol = via.split("\\s+")[0];
        String[] protoParts = protocol.split("/");
        Assert.assertTrue((protoParts.length >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((protoParts.length <= 2 ? 1 : 0) != 0);
        if (protoParts.length > 1) {
            Assert.assertTrue((boolean)"http".equalsIgnoreCase(protoParts[0]));
        }
        Assert.assertEquals((Object)"1.0", (Object)protoParts[protoParts.length - 1]);
    }

    @Test
    public void testRetainsWarningHeadersReceivedFromUpstream() throws Exception {
        this.originResponse.removeHeaders("Warning");
        String warning = "199 fred \"misc\"";
        this.originResponse.addHeader("Warning", (Object)"199 fred \"misc\"");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertEquals((Object)"199 fred \"misc\"", (Object)result.getFirstHeader("Warning").getValue());
    }

    @Test
    public void testUpdatesWarningHeadersOnValidation() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        Date now = new Date();
        Date twentySecondsAgo = new Date(now.getTime() - 20000L);
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)twentySecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"public,max-age=5");
        resp1.setHeader("ETag", (Object)"\"etag1\"");
        String oldWarning = "113 wilma \"stale\"";
        resp1.setHeader("Warning", (Object)"113 wilma \"stale\"");
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(304, "Not Modified");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp2.setHeader("ETag", (Object)"\"etag1\"");
        String newWarning = "113 betty \"stale too\"";
        resp2.setHeader("Warning", (Object)"113 betty \"stale too\"");
        this.backendExpectsAnyRequestAndReturn(resp1);
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        boolean oldWarningFound = false;
        boolean newWarningFound = false;
        for (Header h : result.getHeaders("Warning")) {
            for (String warnValue : h.getValue().split("\\s*,\\s*")) {
                if ("113 wilma \"stale\"".equals(warnValue)) {
                    oldWarningFound = true;
                    continue;
                }
                if (!"113 betty \"stale too\"".equals(warnValue)) continue;
                newWarningFound = true;
            }
        }
        Assert.assertFalse((boolean)oldWarningFound);
        Assert.assertTrue((boolean)newWarningFound);
    }

    @Test
    public void testWarnDatesAreAddedToWarningsOnLowerProtocolVersions() throws Exception {
        String dateHdr = DateUtils.formatDate((Date)new Date());
        String origWarning = "110 fred \"stale\"";
        this.originResponse.setCode(200);
        this.originResponse.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        this.originResponse.addHeader("Warning", (Object)"110 fred \"stale\"");
        this.originResponse.setHeader("Date", (Object)dateHdr);
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        if (HttpVersion.HTTP_1_0.greaterEquals(result.getVersion())) {
            Assert.assertEquals((Object)dateHdr, (Object)result.getFirstHeader("Date").getValue());
            boolean warningFound = false;
            String targetWarning = "110 fred \"stale\" \"" + dateHdr + "\"";
            block0: for (Header h : result.getHeaders("Warning")) {
                for (String warning : h.getValue().split("\\s*,\\s*")) {
                    if (!targetWarning.equals(warning)) continue;
                    warningFound = true;
                    continue block0;
                }
            }
            Assert.assertTrue((boolean)warningFound);
        }
    }

    @Test
    public void testStripsBadlyDatedWarningsFromForwardedResponses() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        this.originResponse.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        this.originResponse.addHeader("Warning", (Object)("110 fred \"stale\", 110 wilma \"stale\" \"" + DateUtils.formatDate((Date)tenSecondsAgo) + "\""));
        this.originResponse.setHeader("Cache-Control", (Object)"no-cache,no-store");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        for (Header h : result.getHeaders("Warning")) {
            Assert.assertFalse((boolean)h.getValue().contains("wilma"));
        }
    }

    @Test
    public void testStripsBadlyDatedWarningsFromStoredResponses() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        this.originResponse.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        this.originResponse.addHeader("Warning", (Object)("110 fred \"stale\", 110 wilma \"stale\" \"" + DateUtils.formatDate((Date)tenSecondsAgo) + "\""));
        this.originResponse.setHeader("Cache-Control", (Object)"public,max-age=3600");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        for (Header h : result.getHeaders("Warning")) {
            Assert.assertFalse((boolean)h.getValue().contains("wilma"));
        }
    }

    @Test
    public void testRemovesWarningHeaderIfAllWarnValuesAreBadlyDated() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        this.originResponse.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        this.originResponse.addHeader("Warning", (Object)("110 wilma \"stale\" \"" + DateUtils.formatDate((Date)tenSecondsAgo) + "\""));
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Header[] warningHeaders = result.getHeaders("Warning");
        Assert.assertTrue((warningHeaders == null || warningHeaders.length == 0 ? 1 : 0) != 0);
    }
}

