/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.cache.AbstractProtocolTest;
import org.apache.hc.client5.http.impl.cache.HttpTestUtils;
import org.apache.hc.client5.http.impl.cache.WarningValue;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.message.MessageSupport;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestProtocolRecommendations
extends AbstractProtocolTest {
    private Date now;
    private Date tenSecondsAgo;
    private Date twoMinutesAgo;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.now = new Date();
        this.tenSecondsAgo = new Date(this.now.getTime() - 10000L);
        this.twoMinutesAgo = new Date(this.now.getTime() - 120000L);
    }

    @Test
    public void testIdentityCodingIsNotUsedInContentEncodingHeader() throws Exception {
        this.originResponse.setHeader("Content-Encoding", (Object)"identity");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        boolean foundIdentity = false;
        Iterator it = MessageSupport.iterate((MessageHeaders)result, (String)"Content-Encoding");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (!"identity".equalsIgnoreCase(elt.getName())) continue;
            foundIdentity = true;
        }
        Assert.assertFalse((boolean)foundIdentity);
    }

    private void cacheGenerated304ForValidatorShouldNotContainEntityHeader(String headerName, String headerValue, String validatorHeader, String validator, String conditionalHeader) throws Exception {
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader(validatorHeader, (Object)validator);
        resp1.setHeader(headerName, (Object)headerValue);
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        req2.setHeader(conditionalHeader, (Object)validator);
        this.replayMocks();
        this.execute(req1);
        ClassicHttpResponse result = this.execute(req2);
        this.verifyMocks();
        if (304 == result.getCode()) {
            Assert.assertNull((Object)result.getFirstHeader(headerName));
        }
    }

    private void cacheGenerated304ForStrongETagValidatorShouldNotContainEntityHeader(String headerName, String headerValue) throws Exception {
        this.cacheGenerated304ForValidatorShouldNotContainEntityHeader(headerName, headerValue, "ETag", "\"etag\"", "If-None-Match");
    }

    private void cacheGenerated304ForStrongDateValidatorShouldNotContainEntityHeader(String headerName, String headerValue) throws Exception {
        this.cacheGenerated304ForValidatorShouldNotContainEntityHeader(headerName, headerValue, "Last-Modified", DateUtils.formatDate((Date)this.twoMinutesAgo), "If-Modified-Since");
    }

    @Test
    public void cacheGenerated304ForStrongEtagValidatorShouldNotContainAllow() throws Exception {
        this.cacheGenerated304ForStrongETagValidatorShouldNotContainEntityHeader("Allow", "GET,HEAD");
    }

    @Test
    public void cacheGenerated304ForStrongDateValidatorShouldNotContainAllow() throws Exception {
        this.cacheGenerated304ForStrongDateValidatorShouldNotContainEntityHeader("Allow", "GET,HEAD");
    }

    @Test
    public void cacheGenerated304ForStrongEtagValidatorShouldNotContainContentEncoding() throws Exception {
        this.cacheGenerated304ForStrongETagValidatorShouldNotContainEntityHeader("Content-Encoding", "gzip");
    }

    @Test
    public void cacheGenerated304ForStrongDateValidatorShouldNotContainContentEncoding() throws Exception {
        this.cacheGenerated304ForStrongDateValidatorShouldNotContainEntityHeader("Content-Encoding", "gzip");
    }

    @Test
    public void cacheGenerated304ForStrongEtagValidatorShouldNotContainContentLanguage() throws Exception {
        this.cacheGenerated304ForStrongETagValidatorShouldNotContainEntityHeader("Content-Language", "en");
    }

    @Test
    public void cacheGenerated304ForStrongDateValidatorShouldNotContainContentLanguage() throws Exception {
        this.cacheGenerated304ForStrongDateValidatorShouldNotContainEntityHeader("Content-Language", "en");
    }

    @Test
    public void cacheGenerated304ForStrongValidatorShouldNotContainContentLength() throws Exception {
        this.cacheGenerated304ForStrongETagValidatorShouldNotContainEntityHeader("Content-Length", "128");
    }

    @Test
    public void cacheGenerated304ForStrongDateValidatorShouldNotContainContentLength() throws Exception {
        this.cacheGenerated304ForStrongDateValidatorShouldNotContainEntityHeader("Content-Length", "128");
    }

    @Test
    public void cacheGenerated304ForStrongValidatorShouldNotContainContentMD5() throws Exception {
        this.cacheGenerated304ForStrongETagValidatorShouldNotContainEntityHeader("Content-MD5", "Q2hlY2sgSW50ZWdyaXR5IQ==");
    }

    @Test
    public void cacheGenerated304ForStrongDateValidatorShouldNotContainContentMD5() throws Exception {
        this.cacheGenerated304ForStrongDateValidatorShouldNotContainEntityHeader("Content-MD5", "Q2hlY2sgSW50ZWdyaXR5IQ==");
    }

    private void cacheGenerated304ForStrongValidatorShouldNotContainContentRange(String validatorHeader, String validator, String conditionalHeader) throws Exception {
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        req1.setHeader("Range", (Object)"bytes=0-127");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(206, "Partial Content");
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader(validatorHeader, (Object)validator);
        resp1.setHeader("Content-Range", (Object)"bytes 0-127/256");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        req2.setHeader("If-Range", (Object)validator);
        req2.setHeader("Range", (Object)"bytes=0-127");
        req2.setHeader(conditionalHeader, (Object)validator);
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(304, "Not Modified");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        resp2.setHeader(validatorHeader, (Object)validator);
        Capture cap = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp2).times(0, 1);
        this.replayMocks();
        this.execute(req1);
        ClassicHttpResponse result = this.execute(req2);
        this.verifyMocks();
        if (!cap.hasCaptured() && 304 == result.getCode()) {
            Assert.assertNull((Object)result.getFirstHeader("Content-Range"));
        }
    }

    @Test
    public void cacheGenerated304ForStrongEtagValidatorShouldNotContainContentRange() throws Exception {
        this.cacheGenerated304ForStrongValidatorShouldNotContainContentRange("ETag", "\"etag\"", "If-None-Match");
    }

    @Test
    public void cacheGenerated304ForStrongDateValidatorShouldNotContainContentRange() throws Exception {
        this.cacheGenerated304ForStrongValidatorShouldNotContainContentRange("Last-Modified", DateUtils.formatDate((Date)this.twoMinutesAgo), "If-Modified-Since");
    }

    @Test
    public void cacheGenerated304ForStrongEtagValidatorShouldNotContainContentType() throws Exception {
        this.cacheGenerated304ForStrongETagValidatorShouldNotContainEntityHeader("Content-Type", "text/html");
    }

    @Test
    public void cacheGenerated304ForStrongDateValidatorShouldNotContainContentType() throws Exception {
        this.cacheGenerated304ForStrongDateValidatorShouldNotContainEntityHeader("Content-Type", "text/html");
    }

    @Test
    public void cacheGenerated304ForStrongEtagValidatorShouldNotContainLastModified() throws Exception {
        this.cacheGenerated304ForStrongETagValidatorShouldNotContainEntityHeader("Last-Modified", DateUtils.formatDate((Date)this.tenSecondsAgo));
    }

    @Test
    public void cacheGenerated304ForStrongDateValidatorShouldNotContainLastModified() throws Exception {
        this.cacheGenerated304ForStrongDateValidatorShouldNotContainEntityHeader("Last-Modified", DateUtils.formatDate((Date)this.twoMinutesAgo));
    }

    private void shouldStripEntityHeaderFromOrigin304ResponseToStrongValidation(String entityHeader, String entityHeaderValue) throws Exception {
        ClassicHttpRequest req = HttpTestUtils.makeDefaultRequest();
        req.setHeader("If-None-Match", (Object)"\"etag\"");
        BasicClassicHttpResponse resp = new BasicClassicHttpResponse(304, "Not Modified");
        resp.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        resp.setHeader("Etag", (Object)"\"etag\"");
        resp.setHeader(entityHeader, (Object)entityHeaderValue);
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(req);
        this.verifyMocks();
        Assert.assertNull((Object)result.getFirstHeader(entityHeader));
    }

    @Test
    public void shouldStripAllowFromOrigin304ResponseToStrongValidation() throws Exception {
        this.shouldStripEntityHeaderFromOrigin304ResponseToStrongValidation("Allow", "GET,HEAD");
    }

    @Test
    public void shouldStripContentEncodingFromOrigin304ResponseToStrongValidation() throws Exception {
        this.shouldStripEntityHeaderFromOrigin304ResponseToStrongValidation("Content-Encoding", "gzip");
    }

    @Test
    public void shouldStripContentLanguageFromOrigin304ResponseToStrongValidation() throws Exception {
        this.shouldStripEntityHeaderFromOrigin304ResponseToStrongValidation("Content-Language", "en");
    }

    @Test
    public void shouldStripContentLengthFromOrigin304ResponseToStrongValidation() throws Exception {
        this.shouldStripEntityHeaderFromOrigin304ResponseToStrongValidation("Content-Length", "128");
    }

    @Test
    public void shouldStripContentMD5FromOrigin304ResponseToStrongValidation() throws Exception {
        this.shouldStripEntityHeaderFromOrigin304ResponseToStrongValidation("Content-MD5", "Q2hlY2sgSW50ZWdyaXR5IQ==");
    }

    @Test
    public void shouldStripContentTypeFromOrigin304ResponseToStrongValidation() throws Exception {
        this.shouldStripEntityHeaderFromOrigin304ResponseToStrongValidation("Content-Type", "text/html;charset=utf-8");
    }

    @Test
    public void shouldStripContentRangeFromOrigin304ResponseToStringValidation() throws Exception {
        ClassicHttpRequest req = HttpTestUtils.makeDefaultRequest();
        req.setHeader("If-Range", (Object)"\"etag\"");
        req.setHeader("Range", (Object)"bytes=0-127");
        BasicClassicHttpResponse resp = new BasicClassicHttpResponse(304, "Not Modified");
        resp.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        resp.setHeader("ETag", (Object)"\"etag\"");
        resp.setHeader("Content-Range", (Object)"bytes 0-127/256");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(req);
        this.verifyMocks();
        Assert.assertNull((Object)result.getFirstHeader("Content-Range"));
    }

    @Test
    public void shouldStripLastModifiedFromOrigin304ResponseToStrongValidation() throws Exception {
        this.shouldStripEntityHeaderFromOrigin304ResponseToStrongValidation("Last-Modified", DateUtils.formatDate((Date)this.twoMinutesAgo));
    }

    private ClassicHttpRequest requestToPopulateStaleCacheEntry() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"public,max-age=5");
        resp1.setHeader("Etag", (Object)"\"etag\"");
        this.backendExpectsAnyRequestAndReturn(resp1);
        return req1;
    }

    private void testDoesNotReturnStaleResponseOnError(ClassicHttpRequest req2) throws Exception {
        ClassicHttpRequest req1 = this.requestToPopulateStaleCacheEntry();
        this.backendExpectsAnyRequest().andThrow((Throwable)new IOException());
        this.replayMocks();
        this.execute(req1);
        ClassicHttpResponse result = null;
        try {
            result = this.execute(req2);
        }
        catch (IOException acceptable) {
            // empty catch block
        }
        this.verifyMocks();
        if (result != null) {
            Assert.assertFalse((result.getCode() == 200 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDoesNotReturnStaleResponseIfClientExplicitlyRequestsFirstHandOneWithCacheControl() throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("GET", "/");
        req.setHeader("Cache-Control", (Object)"no-cache");
        this.testDoesNotReturnStaleResponseOnError((ClassicHttpRequest)req);
    }

    @Test
    public void testDoesNotReturnStaleResponseIfClientExplicitlyRequestsFirstHandOneWithPragma() throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("GET", "/");
        req.setHeader("Pragma", (Object)"no-cache");
        this.testDoesNotReturnStaleResponseOnError((ClassicHttpRequest)req);
    }

    @Test
    public void testDoesNotReturnStaleResponseIfClientExplicitlyRequestsFreshWithMaxAge() throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("GET", "/");
        req.setHeader("Cache-Control", (Object)"max-age=0");
        this.testDoesNotReturnStaleResponseOnError((ClassicHttpRequest)req);
    }

    @Test
    public void testDoesNotReturnStaleResponseIfClientExplicitlySpecifiesLargerMaxAge() throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("GET", "/");
        req.setHeader("Cache-Control", (Object)"max-age=20");
        this.testDoesNotReturnStaleResponseOnError((ClassicHttpRequest)req);
    }

    @Test
    public void testDoesNotReturnStaleResponseIfClientExplicitlyRequestsFreshWithMinFresh() throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("GET", "/");
        req.setHeader("Cache-Control", (Object)"min-fresh=2");
        this.testDoesNotReturnStaleResponseOnError((ClassicHttpRequest)req);
    }

    @Test
    public void testDoesNotReturnStaleResponseIfClientExplicitlyRequestsFreshWithMaxStale() throws Exception {
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("GET", "/");
        req.setHeader("Cache-Control", (Object)"max-stale=2");
        this.testDoesNotReturnStaleResponseOnError((ClassicHttpRequest)req);
    }

    @Test
    public void testMayReturnStaleResponseIfClientExplicitlySpecifiesAcceptableMaxStale() throws Exception {
        ClassicHttpRequest req1 = this.requestToPopulateStaleCacheEntry();
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("Cache-Control", (Object)"max-stale=20");
        this.backendExpectsAnyRequest().andThrow((Throwable)new IOException()).times(0, 1);
        this.replayMocks();
        this.execute(req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result.getCode());
        Assert.assertNotNull((Object)result.getFirstHeader("Warning"));
    }

    @Test
    public void testReturnsCachedResponsesAppropriatelyWhenNoOriginCommunication() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"public, max-age=5");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo));
        this.backendExpectsAnyRequestAndReturn(resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        this.backendExpectsAnyRequest().andThrow((Throwable)new IOException()).anyTimes();
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result.getCode());
        boolean warning111Found = false;
        block0: for (Header h : result.getHeaders("Warning")) {
            for (WarningValue wv : WarningValue.getWarningValues((Header)h)) {
                if (wv.getWarnCode() != 111) continue;
                warning111Found = true;
                continue block0;
            }
        }
        Assert.assertTrue((boolean)warning111Found);
    }

    @Test
    public void testDoesNotAddNewWarningHeaderIfResponseArrivesStale() throws Exception {
        this.originResponse.setHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo));
        this.originResponse.setHeader("Cache-Control", (Object)"public, max-age=5");
        this.originResponse.setHeader("ETag", (Object)"\"etag\"");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertNull((Object)result.getFirstHeader("Warning"));
    }

    @Test
    public void testForwardsExistingWarningHeadersOnResponseThatArrivesStale() throws Exception {
        this.originResponse.setHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo));
        this.originResponse.setHeader("Cache-Control", (Object)"public, max-age=5");
        this.originResponse.setHeader("ETag", (Object)"\"etag\"");
        this.originResponse.addHeader("Age", (Object)"10");
        String warning = "110 fred \"Response is stale\"";
        this.originResponse.addHeader("Warning", (Object)"110 fred \"Response is stale\"");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertEquals((Object)"110 fred \"Response is stale\"", (Object)result.getFirstHeader("Warning").getValue());
    }

    private void testDoesNotModifyHeaderOnResponses(String headerName) throws Exception {
        String headerValue = HttpTestUtils.getCanonicalHeaderValue((HttpMessage)this.originResponse, headerName);
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertEquals((Object)headerValue, (Object)result.getFirstHeader(headerName).getValue());
    }

    private void testDoesNotModifyHeaderOnRequests(String headerName) throws Exception {
        String headerValue = HttpTestUtils.getCanonicalHeaderValue((HttpMessage)this.request, headerName);
        Capture cap = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        this.execute(this.request);
        this.verifyMocks();
        Assert.assertEquals((Object)headerValue, (Object)HttpTestUtils.getCanonicalHeaderValue((HttpMessage)cap.getValue(), headerName));
    }

    @Test
    public void testDoesNotModifyAcceptRangesOnResponses() throws Exception {
        String headerName = "Accept-Ranges";
        this.originResponse.setHeader("Accept-Ranges", (Object)"bytes");
        this.testDoesNotModifyHeaderOnResponses("Accept-Ranges");
    }

    @Test
    public void testDoesNotModifyAuthorizationOnRequests() throws Exception {
        this.request.setHeader("Authorization", (Object)"Basic dXNlcjpwYXNzd2Q=");
        this.testDoesNotModifyHeaderOnRequests("Authorization");
    }

    @Test
    public void testDoesNotModifyContentLengthOnRequests() throws Exception {
        BasicClassicHttpRequest post = new BasicClassicHttpRequest("POST", "/");
        post.setEntity(HttpTestUtils.makeBody(128));
        post.setHeader("Content-Length", (Object)"128");
        this.request = post;
        this.testDoesNotModifyHeaderOnRequests("Content-Length");
    }

    @Test
    public void testDoesNotModifyContentLengthOnResponses() throws Exception {
        this.originResponse.setEntity(HttpTestUtils.makeBody(128));
        this.originResponse.setHeader("Content-Length", (Object)"128");
        this.testDoesNotModifyHeaderOnResponses("Content-Length");
    }

    @Test
    public void testDoesNotModifyContentMD5OnRequests() throws Exception {
        BasicClassicHttpRequest post = new BasicClassicHttpRequest("POST", "/");
        post.setEntity(HttpTestUtils.makeBody(128));
        post.setHeader("Content-Length", (Object)"128");
        post.setHeader("Content-MD5", (Object)"Q2hlY2sgSW50ZWdyaXR5IQ==");
        this.request = post;
        this.testDoesNotModifyHeaderOnRequests("Content-MD5");
    }

    @Test
    public void testDoesNotModifyContentMD5OnResponses() throws Exception {
        this.originResponse.setEntity(HttpTestUtils.makeBody(128));
        this.originResponse.setHeader("Content-MD5", (Object)"Q2hlY2sgSW50ZWdyaXR5IQ==");
        this.testDoesNotModifyHeaderOnResponses("Content-MD5");
    }

    @Test
    public void testDoesNotModifyContentRangeOnRequests() throws Exception {
        BasicClassicHttpRequest put = new BasicClassicHttpRequest("PUT", "/");
        put.setEntity(HttpTestUtils.makeBody(128));
        put.setHeader("Content-Length", (Object)"128");
        put.setHeader("Content-Range", (Object)"bytes 0-127/256");
        this.request = put;
        this.testDoesNotModifyHeaderOnRequests("Content-Range");
    }

    @Test
    public void testDoesNotModifyContentRangeOnResponses() throws Exception {
        this.request.setHeader("Range", (Object)"bytes=0-128");
        this.originResponse.setCode(206);
        this.originResponse.setReasonPhrase("Partial Content");
        this.originResponse.setEntity(HttpTestUtils.makeBody(128));
        this.originResponse.setHeader("Content-Range", (Object)"bytes 0-127/256");
        this.testDoesNotModifyHeaderOnResponses("Content-Range");
    }

    @Test
    public void testDoesNotModifyContentTypeOnRequests() throws Exception {
        BasicClassicHttpRequest post = new BasicClassicHttpRequest("POST", "/");
        post.setEntity(HttpTestUtils.makeBody(128));
        post.setHeader("Content-Length", (Object)"128");
        post.setHeader("Content-Type", (Object)"application/octet-stream");
        this.request = post;
        this.testDoesNotModifyHeaderOnRequests("Content-Type");
    }

    @Test
    public void testDoesNotModifyContentTypeOnResponses() throws Exception {
        this.originResponse.setHeader("Content-Type", (Object)"application/octet-stream");
        this.testDoesNotModifyHeaderOnResponses("Content-Type");
    }

    @Test
    public void testDoesNotModifyDateOnRequests() throws Exception {
        this.request.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        this.testDoesNotModifyHeaderOnRequests("Date");
    }

    @Test
    public void testDoesNotModifyDateOnResponses() throws Exception {
        this.originResponse.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        this.testDoesNotModifyHeaderOnResponses("Date");
    }

    @Test
    public void testDoesNotModifyETagOnResponses() throws Exception {
        this.originResponse.setHeader("ETag", (Object)"\"random-etag\"");
        this.testDoesNotModifyHeaderOnResponses("ETag");
    }

    @Test
    public void testDoesNotModifyExpiresOnResponses() throws Exception {
        this.originResponse.setHeader("Expires", (Object)DateUtils.formatDate((Date)new Date()));
        this.testDoesNotModifyHeaderOnResponses("Expires");
    }

    @Test
    public void testDoesNotModifyFromOnRequests() throws Exception {
        this.request.setHeader("From", (Object)"foo@example.com");
        this.testDoesNotModifyHeaderOnRequests("From");
    }

    @Test
    public void testDoesNotModifyIfMatchOnRequests() throws Exception {
        this.request = new BasicClassicHttpRequest("DELETE", "/");
        this.request.setHeader("If-Match", (Object)"\"etag\"");
        this.testDoesNotModifyHeaderOnRequests("If-Match");
    }

    @Test
    public void testDoesNotModifyIfModifiedSinceOnRequests() throws Exception {
        this.request.setHeader("If-Modified-Since", (Object)DateUtils.formatDate((Date)new Date()));
        this.testDoesNotModifyHeaderOnRequests("If-Modified-Since");
    }

    @Test
    public void testDoesNotModifyIfNoneMatchOnRequests() throws Exception {
        this.request.setHeader("If-None-Match", (Object)"\"etag\"");
        this.testDoesNotModifyHeaderOnRequests("If-None-Match");
    }

    @Test
    public void testDoesNotModifyIfRangeOnRequests() throws Exception {
        this.request.setHeader("Range", (Object)"bytes=0-128");
        this.request.setHeader("If-Range", (Object)"\"etag\"");
        this.testDoesNotModifyHeaderOnRequests("If-Range");
    }

    @Test
    public void testDoesNotModifyIfUnmodifiedSinceOnRequests() throws Exception {
        this.request = new BasicClassicHttpRequest("DELETE", "/");
        this.request.setHeader("If-Unmodified-Since", (Object)DateUtils.formatDate((Date)new Date()));
        this.testDoesNotModifyHeaderOnRequests("If-Unmodified-Since");
    }

    @Test
    public void testDoesNotModifyLastModifiedOnResponses() throws Exception {
        this.originResponse.setHeader("Last-Modified", (Object)DateUtils.formatDate((Date)new Date()));
        this.testDoesNotModifyHeaderOnResponses("Last-Modified");
    }

    @Test
    public void testDoesNotModifyLocationOnResponses() throws Exception {
        this.originResponse.setCode(307);
        this.originResponse.setReasonPhrase("Temporary Redirect");
        this.originResponse.setHeader("Location", (Object)"http://foo.example.com/bar");
        this.testDoesNotModifyHeaderOnResponses("Location");
    }

    @Test
    public void testDoesNotModifyRangeOnRequests() throws Exception {
        this.request.setHeader("Range", (Object)"bytes=0-128");
        this.testDoesNotModifyHeaderOnRequests("Range");
    }

    @Test
    public void testDoesNotModifyRefererOnRequests() throws Exception {
        this.request.setHeader("Referer", (Object)"http://foo.example.com/bar");
        this.testDoesNotModifyHeaderOnRequests("Referer");
    }

    @Test
    public void testDoesNotModifyRetryAfterOnResponses() throws Exception {
        this.originResponse.setCode(503);
        this.originResponse.setReasonPhrase("Service Unavailable");
        this.originResponse.setHeader("Retry-After", (Object)"120");
        this.testDoesNotModifyHeaderOnResponses("Retry-After");
    }

    @Test
    public void testDoesNotModifyServerOnResponses() throws Exception {
        this.originResponse.setHeader("Server", (Object)"SomeServer/1.0");
        this.testDoesNotModifyHeaderOnResponses("Server");
    }

    @Test
    public void testDoesNotModifyUserAgentOnRequests() throws Exception {
        this.request.setHeader("User-Agent", (Object)"MyClient/1.0");
        this.testDoesNotModifyHeaderOnRequests("User-Agent");
    }

    @Test
    public void testDoesNotModifyVaryOnResponses() throws Exception {
        this.request.setHeader("Accept-Encoding", (Object)"identity");
        this.originResponse.setHeader("Vary", (Object)"Accept-Encoding");
        this.testDoesNotModifyHeaderOnResponses("Vary");
    }

    @Test
    public void testDoesNotModifyExtensionHeaderOnRequests() throws Exception {
        this.request.setHeader("X-Extension", (Object)"x-value");
        this.testDoesNotModifyHeaderOnRequests("X-Extension");
    }

    @Test
    public void testDoesNotModifyExtensionHeaderOnResponses() throws Exception {
        this.originResponse.setHeader("X-Extension", (Object)"x-value");
        this.testDoesNotModifyHeaderOnResponses("X-Extension");
    }

    @Test
    public void testUsesLastModifiedDateForCacheConditionalRequests() throws Exception {
        Date twentySecondsAgo = new Date(this.now.getTime() - 20000L);
        String lmDate = DateUtils.formatDate((Date)twentySecondsAgo);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo));
        resp1.setHeader("Last-Modified", (Object)lmDate);
        resp1.setHeader("Cache-Control", (Object)"max-age=5");
        this.backendExpectsAnyRequestAndReturn(resp1);
        Capture cap = new Capture();
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        ClassicHttpRequest captured = (ClassicHttpRequest)cap.getValue();
        Header ifModifiedSince = captured.getFirstHeader("If-Modified-Since");
        Assert.assertEquals((Object)lmDate, (Object)ifModifiedSince.getValue());
    }

    @Test
    public void testUsesBothLastModifiedAndETagForConditionalRequestsIfAvailable() throws Exception {
        Date twentySecondsAgo = new Date(this.now.getTime() - 20000L);
        String lmDate = DateUtils.formatDate((Date)twentySecondsAgo);
        String etag = "\"etag\"";
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo));
        resp1.setHeader("Last-Modified", (Object)lmDate);
        resp1.setHeader("Cache-Control", (Object)"max-age=5");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        this.backendExpectsAnyRequestAndReturn(resp1);
        Capture cap = new Capture();
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        ClassicHttpRequest captured = (ClassicHttpRequest)cap.getValue();
        Header ifModifiedSince = captured.getFirstHeader("If-Modified-Since");
        Assert.assertEquals((Object)lmDate, (Object)ifModifiedSince.getValue());
        Header ifNoneMatch = captured.getFirstHeader("If-None-Match");
        Assert.assertEquals((Object)"\"etag\"", (Object)ifNoneMatch.getValue());
    }

    @Test
    public void testRevalidatesCachedResponseWithExpirationInThePast() throws Exception {
        Date oneSecondAgo = new Date(this.now.getTime() - 1000L);
        Date oneSecondFromNow = new Date(this.now.getTime() + 1000L);
        Date twoSecondsFromNow = new Date(this.now.getTime() + 2000L);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        resp1.setHeader("Expires", (Object)DateUtils.formatDate((Date)oneSecondAgo));
        resp1.setHeader("Cache-Control", (Object)"public");
        this.backendExpectsAnyRequestAndReturn(resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        BasicClassicHttpRequest revalidate = new BasicClassicHttpRequest("GET", "/");
        revalidate.setHeader("If-None-Match", (Object)"\"etag\"");
        ClassicHttpResponse resp2 = HttpTestUtils.make304Response();
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)twoSecondsFromNow));
        resp2.setHeader("Expires", (Object)DateUtils.formatDate((Date)oneSecondFromNow));
        resp2.setHeader("ETag", (Object)"\"etag\"");
        EasyMock.expect((Object)this.mockExecChain.proceed(TestProtocolRecommendations.eqRequest((ClassicHttpRequest)revalidate), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result.getCode());
    }

    @Test
    public void testRetriesValidationThatResultsInAnOlderDated304Response() throws Exception {
        Date elevenSecondsAgo = new Date(this.now.getTime() - 11000L);
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"max-age=5");
        this.backendExpectsAnyRequestAndReturn(resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp2 = HttpTestUtils.make304Response();
        resp2.setHeader("ETag", (Object)"\"etag\"");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)elevenSecondsAgo));
        this.backendExpectsAnyRequestAndReturn(resp2);
        Capture cap = new Capture();
        ClassicHttpResponse resp3 = HttpTestUtils.make200Response();
        resp3.setHeader("ETag", (Object)"\"etag2\"");
        resp3.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        resp3.setHeader("Cache-Control", (Object)"max-age=5");
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp3);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        ClassicHttpRequest captured = (ClassicHttpRequest)cap.getValue();
        boolean hasMaxAge0 = false;
        boolean hasNoCache = false;
        Iterator it = MessageSupport.iterate((MessageHeaders)captured, (String)"Cache-Control");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if ("max-age".equals(elt.getName())) {
                try {
                    int maxage = Integer.parseInt(elt.getValue());
                    if (maxage != 0) continue;
                    hasMaxAge0 = true;
                }
                catch (NumberFormatException nfe) {}
                continue;
            }
            if (!"no-cache".equals(elt.getName())) continue;
            hasNoCache = true;
        }
        Assert.assertTrue((hasMaxAge0 || hasNoCache ? 1 : 0) != 0);
        Assert.assertNull((Object)captured.getFirstHeader("If-None-Match"));
        Assert.assertNull((Object)captured.getFirstHeader("If-Modified-Since"));
        Assert.assertNull((Object)captured.getFirstHeader("If-Range"));
        Assert.assertNull((Object)captured.getFirstHeader("If-Match"));
        Assert.assertNull((Object)captured.getFirstHeader("If-Unmodified-Since"));
    }

    @Test
    public void testSendsAllVariantEtagsInConditionalRequest() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        req1.setHeader("User-Agent", (Object)"agent1");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Vary", (Object)"User-Agent");
        resp1.setHeader("Etag", (Object)"\"etag1\"");
        this.backendExpectsAnyRequestAndReturn(resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("User-Agent", (Object)"agent2");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("Cache-Control", (Object)"max-age=3600");
        resp2.setHeader("Vary", (Object)"User-Agent");
        resp2.setHeader("Etag", (Object)"\"etag2\"");
        this.backendExpectsAnyRequestAndReturn(resp2);
        Capture cap = new Capture();
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        req3.setHeader("User-Agent", (Object)"agent3");
        ClassicHttpResponse resp3 = HttpTestUtils.make200Response();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp3);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
        ClassicHttpRequest captured = (ClassicHttpRequest)cap.getValue();
        boolean foundEtag1 = false;
        boolean foundEtag2 = false;
        for (Header h : captured.getHeaders("If-None-Match")) {
            for (String etag : h.getValue().split(",")) {
                if ("\"etag1\"".equals(etag.trim())) {
                    foundEtag1 = true;
                }
                if (!"\"etag2\"".equals(etag.trim())) continue;
                foundEtag2 = true;
            }
        }
        Assert.assertTrue((foundEtag1 && foundEtag2 ? 1 : 0) != 0);
    }

    @Test
    public void testResponseToExistingVariantsUpdatesEntry() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        req1.setHeader("User-Agent", (Object)"agent1");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo));
        resp1.setHeader("Vary", (Object)"User-Agent");
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("ETag", (Object)"\"etag1\"");
        this.backendExpectsAnyRequestAndReturn(resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("User-Agent", (Object)"agent2");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo));
        resp2.setHeader("Vary", (Object)"User-Agent");
        resp2.setHeader("Cache-Control", (Object)"max-age=3600");
        resp2.setHeader("ETag", (Object)"\"etag2\"");
        this.backendExpectsAnyRequestAndReturn(resp2);
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        req3.setHeader("User-Agent", (Object)"agent3");
        BasicClassicHttpResponse resp3 = new BasicClassicHttpResponse(304, "Not Modified");
        resp3.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        resp3.setHeader("ETag", (Object)"\"etag1\"");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp3);
        BasicClassicHttpRequest req4 = new BasicClassicHttpRequest("GET", "/");
        req4.setHeader("User-Agent", (Object)"agent1");
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        ClassicHttpResponse result1 = this.execute((ClassicHttpRequest)req3);
        ClassicHttpResponse result2 = this.execute((ClassicHttpRequest)req4);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result1.getCode());
        Assert.assertEquals((Object)"\"etag1\"", (Object)result1.getFirstHeader("ETag").getValue());
        Assert.assertEquals((Object)DateUtils.formatDate((Date)this.now), (Object)result1.getFirstHeader("Date").getValue());
        Assert.assertEquals((Object)DateUtils.formatDate((Date)this.now), (Object)result2.getFirstHeader("Date").getValue());
    }

    @Test
    public void testResponseToExistingVariantsIsCachedForFutureResponses() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        req1.setHeader("User-Agent", (Object)"agent1");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo));
        resp1.setHeader("Vary", (Object)"User-Agent");
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("ETag", (Object)"\"etag1\"");
        this.backendExpectsAnyRequestAndReturn(resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("User-Agent", (Object)"agent2");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(304, "Not Modified");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        resp2.setHeader("ETag", (Object)"\"etag1\"");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        req3.setHeader("User-Agent", (Object)"agent2");
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
    }

    @Test
    public void variantNegotiationsDoNotIncludeEtagsForPartialResponses() throws Exception {
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        req1.setHeader("User-Agent", (Object)"agent1");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Vary", (Object)"User-Agent");
        resp1.setHeader("ETag", (Object)"\"etag1\"");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        req2.setHeader("User-Agent", (Object)"agent2");
        req2.setHeader("Range", (Object)"bytes=0-49");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(206, "Partial Content");
        resp2.setEntity(HttpTestUtils.makeBody(50));
        resp2.setHeader("Content-Length", (Object)"50");
        resp2.setHeader("Content-Range", (Object)"bytes 0-49/100");
        resp2.setHeader("Vary", (Object)"User-Agent");
        resp2.setHeader("ETag", (Object)"\"etag2\"");
        resp2.setHeader("Cache-Control", (Object)"max-age=3600");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        ClassicHttpRequest req3 = HttpTestUtils.makeDefaultRequest();
        req3.setHeader("User-Agent", (Object)"agent3");
        ClassicHttpResponse resp3 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Vary", (Object)"User-Agent");
        resp1.setHeader("ETag", (Object)"\"etag3\"");
        Capture cap = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp3);
        this.replayMocks();
        this.execute(req1);
        this.execute(req2);
        this.execute(req3);
        this.verifyMocks();
        ClassicHttpRequest captured = (ClassicHttpRequest)cap.getValue();
        Iterator it = MessageSupport.iterate((MessageHeaders)captured, (String)"If-None-Match");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            Assert.assertFalse((boolean)"\"etag2\"".equals(elt.toString()));
        }
    }

    @Test
    public void cachedEntryShouldNotBeUsedIfMoreRecentMentionInContentLocation() throws Exception {
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("ETag", (Object)"\"old-etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo));
        this.backendExpectsAnyRequestAndReturn(resp1);
        HttpPost req2 = new HttpPost("http://foo.example.com/bar");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("ETag", (Object)"\"new-etag\"");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        resp2.setHeader("Content-Location", (Object)"http://foo.example.com/");
        this.backendExpectsAnyRequestAndReturn(resp2);
        HttpGet req3 = new HttpGet("http://foo.example.com");
        ClassicHttpResponse resp3 = HttpTestUtils.make200Response();
        this.backendExpectsAnyRequestAndReturn(resp3);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
    }

    @Test
    public void responseToGetWithQueryFrom1_0OriginAndNoExpiresIsNotCached() throws Exception {
        HttpGet req2 = new HttpGet("http://foo.example.com/bar?baz=quux");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(200, "OK");
        resp2.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        resp2.setEntity(HttpTestUtils.makeBody(200));
        resp2.setHeader("Content-Length", (Object)"200");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
    }

    @Test
    public void responseToGetWithQueryFrom1_0OriginVia1_1ProxyAndNoExpiresIsNotCached() throws Exception {
        HttpGet req2 = new HttpGet("http://foo.example.com/bar?baz=quux");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(200, "OK");
        resp2.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        resp2.setEntity(HttpTestUtils.makeBody(200));
        resp2.setHeader("Content-Length", (Object)"200");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        resp2.setHeader("Via", (Object)"1.0 someproxy");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
    }

    @Test
    public void shouldInvalidateNonvariantCacheEntryForUnknownMethod() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        this.backendExpectsAnyRequestAndReturn(resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("FROB", "/");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("Cache-Control", (Object)"max-age=3600");
        this.backendExpectsAnyRequestAndReturn(resp2);
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse resp3 = HttpTestUtils.make200Response();
        resp3.setHeader("ETag", (Object)"\"etag\"");
        this.backendExpectsAnyRequestAndReturn(resp3);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
        Assert.assertTrue((boolean)HttpTestUtils.semanticallyTransparent(resp3, result));
    }

    @Test
    public void shouldInvalidateAllVariantsForUnknownMethod() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        req1.setHeader("User-Agent", (Object)"agent1");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Vary", (Object)"User-Agent");
        this.backendExpectsAnyRequestAndReturn(resp1);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        req2.setHeader("User-Agent", (Object)"agent2");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("Cache-Control", (Object)"max-age=3600");
        resp2.setHeader("Vary", (Object)"User-Agent");
        this.backendExpectsAnyRequestAndReturn(resp2);
        BasicClassicHttpRequest req3 = new BasicClassicHttpRequest("FROB", "/");
        req3.setHeader("User-Agent", (Object)"agent3");
        ClassicHttpResponse resp3 = HttpTestUtils.make200Response();
        resp3.setHeader("Cache-Control", (Object)"max-age=3600");
        this.backendExpectsAnyRequestAndReturn(resp3);
        BasicClassicHttpRequest req4 = new BasicClassicHttpRequest("GET", "/");
        req4.setHeader("User-Agent", (Object)"agent1");
        ClassicHttpResponse resp4 = HttpTestUtils.make200Response();
        resp4.setHeader("ETag", (Object)"\"etag1\"");
        this.backendExpectsAnyRequestAndReturn(resp4);
        BasicClassicHttpRequest req5 = new BasicClassicHttpRequest("GET", "/");
        req5.setHeader("User-Agent", (Object)"agent2");
        ClassicHttpResponse resp5 = HttpTestUtils.make200Response();
        resp5.setHeader("ETag", (Object)"\"etag2\"");
        this.backendExpectsAnyRequestAndReturn(resp5);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.execute((ClassicHttpRequest)req3);
        ClassicHttpResponse result4 = this.execute((ClassicHttpRequest)req4);
        ClassicHttpResponse result5 = this.execute((ClassicHttpRequest)req5);
        this.verifyMocks();
        Assert.assertTrue((boolean)HttpTestUtils.semanticallyTransparent(resp4, result4));
        Assert.assertTrue((boolean)HttpTestUtils.semanticallyTransparent(resp5, result5));
    }

    @Test
    public void cacheShouldUpdateWithNewCacheableResponse() throws Exception {
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("ETag", (Object)"\"etag1\"");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        req2.setHeader("Cache-Control", (Object)"max-age=0");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        resp2.setHeader("Cache-Control", (Object)"max-age=3600");
        resp2.setHeader("ETag", (Object)"\"etag2\"");
        this.backendExpectsAnyRequestAndReturn(resp2);
        ClassicHttpRequest req3 = HttpTestUtils.makeDefaultRequest();
        this.replayMocks();
        this.execute(req1);
        this.execute(req2);
        ClassicHttpResponse result = this.execute(req3);
        this.verifyMocks();
        Assert.assertTrue((boolean)HttpTestUtils.semanticallyTransparent(resp2, result));
    }

    @Test
    public void expiresEqualToDateWithNoCacheControlIsNotCacheable() throws Exception {
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        resp1.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.now));
        resp1.removeHeaders("Cache-Control");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        req2.setHeader("Cache-Control", (Object)"max-stale=1000");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("ETag", (Object)"\"etag2\"");
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute(req1);
        ClassicHttpResponse result = this.execute(req2);
        this.verifyMocks();
        Assert.assertTrue((boolean)HttpTestUtils.semanticallyTransparent(resp2, result));
    }

    @Test
    public void expiresPriorToDateWithNoCacheControlIsNotCacheable() throws Exception {
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        resp1.setHeader("Expires", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo));
        resp1.removeHeaders("Cache-Control");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        req2.setHeader("Cache-Control", (Object)"max-stale=1000");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("ETag", (Object)"\"etag2\"");
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute(req1);
        ClassicHttpResponse result = this.execute(req2);
        this.verifyMocks();
        Assert.assertTrue((boolean)HttpTestUtils.semanticallyTransparent(resp2, result));
    }

    @Test
    public void otherFreshnessRequestDirectivesNotAllowedWithNoCache() throws Exception {
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        req1.setHeader("Cache-Control", (Object)"min-fresh=10, no-cache");
        req1.addHeader("Cache-Control", (Object)"max-stale=0, max-age=0");
        Capture cap = new Capture();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture((Capture)cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)HttpTestUtils.make200Response());
        this.replayMocks();
        this.execute(req1);
        this.verifyMocks();
        ClassicHttpRequest captured = (ClassicHttpRequest)cap.getValue();
        boolean foundNoCache = false;
        boolean foundDisallowedDirective = false;
        List<String> disallowed = Arrays.asList("min-fresh", "max-stale", "max-age");
        Iterator it = MessageSupport.iterate((MessageHeaders)captured, (String)"Cache-Control");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (disallowed.contains(elt.getName())) {
                foundDisallowedDirective = true;
            }
            if (!"no-cache".equals(elt.getName())) continue;
            foundNoCache = true;
        }
        Assert.assertTrue((boolean)foundNoCache);
        Assert.assertFalse((boolean)foundDisallowedDirective);
    }

    @Test
    public void cacheMissResultsIn504WithOnlyIfCached() throws Exception {
        ClassicHttpRequest req = HttpTestUtils.makeDefaultRequest();
        req.setHeader("Cache-Control", (Object)"only-if-cached");
        this.replayMocks();
        ClassicHttpResponse result = this.execute(req);
        this.verifyMocks();
        Assert.assertEquals((long)504L, (long)result.getCode());
    }

    @Test
    public void cacheHitOkWithOnlyIfCached() throws Exception {
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        req2.setHeader("Cache-Control", (Object)"only-if-cached");
        this.replayMocks();
        this.execute(req1);
        ClassicHttpResponse result = this.execute(req2);
        this.verifyMocks();
        Assert.assertTrue((boolean)HttpTestUtils.semanticallyTransparent(resp1, result));
    }

    @Test
    public void returns504ForStaleEntryWithOnlyIfCached() throws Exception {
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"max-age=5");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        req2.setHeader("Cache-Control", (Object)"only-if-cached");
        this.replayMocks();
        this.execute(req1);
        ClassicHttpResponse result = this.execute(req2);
        this.verifyMocks();
        Assert.assertEquals((long)504L, (long)result.getCode());
    }

    @Test
    public void returnsStaleCacheEntryWithOnlyIfCachedAndMaxStale() throws Exception {
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"max-age=5");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        req2.setHeader("Cache-Control", (Object)"max-stale=20, only-if-cached");
        this.replayMocks();
        this.execute(req1);
        ClassicHttpResponse result = this.execute(req2);
        this.verifyMocks();
        Assert.assertTrue((boolean)HttpTestUtils.semanticallyTransparent(resp1, result));
    }

    @Test
    public void issues304EvenWithWeakETag() throws Exception {
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"max-age=300");
        resp1.setHeader("ETag", (Object)"W/\"weak-sauce\"");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        req2.setHeader("If-None-Match", (Object)"W/\"weak-sauce\"");
        this.replayMocks();
        this.execute(req1);
        ClassicHttpResponse result = this.execute(req2);
        this.verifyMocks();
        Assert.assertEquals((long)304L, (long)result.getCode());
    }
}

