/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import java.util.Date;
import java.util.Random;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.cache.HttpCacheContext;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.impl.cache.BasicHttpCache;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CachingExec;
import org.apache.hc.client5.http.impl.cache.HttpCache;
import org.apache.hc.client5.http.impl.cache.RequestEquivalent;
import org.apache.hc.client5.http.impl.classic.ClassicRequestCopier;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.easymock.Capture;
import org.easymock.IArgumentMatcher;
import org.easymock.classextension.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestProtocolDeviations {
    private static final ProtocolVersion HTTP_1_1 = new ProtocolVersion("HTTP", 1, 1);
    private static final int MAX_BYTES = 1024;
    private static final int MAX_ENTRIES = 100;
    private final int entityLength = 128;
    private HttpHost host;
    private HttpRoute route;
    private HttpEntity body;
    private HttpEntity mockEntity;
    private ExecRuntime mockEndpoint;
    private ExecChain mockExecChain;
    private HttpCache mockCache;
    private ClassicHttpRequest request;
    private HttpCacheContext context;
    private ClassicHttpResponse originResponse;
    private ExecChainHandler impl;

    @Before
    public void setUp() {
        this.host = new HttpHost("foo.example.com", 80);
        this.route = new HttpRoute(this.host);
        this.body = this.makeBody(128);
        this.request = new BasicClassicHttpRequest("GET", "/foo");
        this.context = HttpCacheContext.create();
        this.originResponse = this.make200Response();
        CacheConfig config = CacheConfig.custom().setMaxCacheEntries(100).setMaxObjectSize(1024L).build();
        BasicHttpCache cache = new BasicHttpCache(config);
        this.mockEndpoint = (ExecRuntime)org.easymock.EasyMock.createNiceMock(ExecRuntime.class);
        this.mockExecChain = (ExecChain)org.easymock.EasyMock.createNiceMock(ExecChain.class);
        this.mockEntity = (HttpEntity)org.easymock.EasyMock.createNiceMock(HttpEntity.class);
        this.mockCache = (HttpCache)org.easymock.EasyMock.createNiceMock(HttpCache.class);
        this.impl = this.createCachingExecChain((HttpCache)cache, config);
    }

    private ClassicHttpResponse execute(ClassicHttpRequest request) throws IOException, HttpException {
        return this.impl.execute(ClassicRequestCopier.INSTANCE.copy(request), new ExecChain.Scope("test", this.route, request, this.mockEndpoint, (HttpClientContext)this.context), this.mockExecChain);
    }

    protected ExecChainHandler createCachingExecChain(HttpCache cache, CacheConfig config) {
        return new CachingExec(cache, config);
    }

    private ClassicHttpResponse make200Response() {
        BasicClassicHttpResponse out = new BasicClassicHttpResponse(200, "OK");
        out.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        out.setHeader("Server", (Object)"MockOrigin/1.0");
        out.setEntity(this.makeBody(128));
        return out;
    }

    private void replayMocks() {
        org.easymock.EasyMock.replay((Object[])new Object[]{this.mockExecChain});
        org.easymock.EasyMock.replay((Object[])new Object[]{this.mockCache});
        org.easymock.EasyMock.replay((Object[])new Object[]{this.mockEntity});
    }

    private void verifyMocks() {
        org.easymock.EasyMock.verify((Object[])new Object[]{this.mockExecChain});
        org.easymock.EasyMock.verify((Object[])new Object[]{this.mockCache});
        org.easymock.EasyMock.verify((Object[])new Object[]{this.mockEntity});
    }

    private HttpEntity makeBody(int nbytes) {
        byte[] bytes = new byte[nbytes];
        new Random().nextBytes(bytes);
        return new ByteArrayEntity(bytes);
    }

    public static HttpRequest eqRequest(HttpRequest in) {
        org.easymock.EasyMock.reportMatcher((IArgumentMatcher)new RequestEquivalent(in));
        return null;
    }

    @Ignore
    public void testHTTP1_1RequestsWithBodiesOfKnownLengthMustHaveContentLength() throws Exception {
        BasicClassicHttpRequest post = new BasicClassicHttpRequest("POST", "/");
        post.setEntity(this.mockEntity);
        this.replayMocks();
        ClassicHttpResponse response = this.execute((ClassicHttpRequest)post);
        this.verifyMocks();
        Assert.assertEquals((long)411L, (long)response.getCode());
    }

    @Ignore
    public void testHTTP1_1RequestsWithUnknownBodyLengthAreRejectedOrHaveContentLengthAdded() throws Exception {
        BasicClassicHttpRequest post = new BasicClassicHttpRequest("POST", "/");
        byte[] bytes = new byte[128];
        new Random().nextBytes(bytes);
        HttpEntity mockBody = (HttpEntity)EasyMock.createMockBuilder(ByteArrayEntity.class).withConstructor(new Object[]{bytes}).addMockedMethods(new String[]{"getContentLength"}).createNiceMock();
        org.easymock.EasyMock.expect((Object)mockBody.getContentLength()).andReturn((Object)-1L).anyTimes();
        post.setEntity(mockBody);
        Capture reqCap = new Capture();
        org.easymock.EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)org.easymock.EasyMock.capture((Capture)reqCap), (ExecChain.Scope)org.easymock.EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse).times(0, 1);
        this.replayMocks();
        org.easymock.EasyMock.replay((Object[])new Object[]{mockBody});
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)post);
        this.verifyMocks();
        org.easymock.EasyMock.verify((Object[])new Object[]{mockBody});
        if (reqCap.hasCaptured()) {
            HttpRequest forwarded = (HttpRequest)reqCap.getValue();
            Assert.assertNotNull((Object)forwarded.getFirstHeader("Content-Length"));
        } else {
            int status = result.getCode();
            Assert.assertTrue((411 == status || 400 == status ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPartialContentIsNotReturnedToAClientThatDidNotAskForIt() throws Exception {
        this.request.removeHeaders("Range");
        this.originResponse = new BasicClassicHttpResponse(206, "Partial Content");
        this.originResponse.setHeader("Content-Range", (Object)"bytes 0-499/1234");
        this.originResponse.setEntity(this.makeBody(500));
        org.easymock.EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)org.easymock.EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)org.easymock.EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        try {
            ClassicHttpResponse result = this.execute(this.request);
            Assert.assertTrue((206 != result.getCode() ? 1 : 0) != 0);
        }
        catch (ClientProtocolException clientProtocolException) {
            // empty catch block
        }
    }

    @Test
    public void testPassesOnOrigin401ResponseWithoutWWWAuthenticateHeader() throws Exception {
        this.originResponse = new BasicClassicHttpResponse(401, "Unauthorized");
        org.easymock.EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)org.easymock.EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)org.easymock.EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertSame((Object)this.originResponse, (Object)result);
    }

    @Test
    public void testPassesOnOrigin405WithoutAllowHeader() throws Exception {
        this.originResponse = new BasicClassicHttpResponse(405, "Method Not Allowed");
        org.easymock.EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)org.easymock.EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)org.easymock.EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertSame((Object)this.originResponse, (Object)result);
    }

    @Test
    public void testPassesOnOrigin407WithoutAProxyAuthenticateHeader() throws Exception {
        this.originResponse = new BasicClassicHttpResponse(407, "Proxy Authentication Required");
        org.easymock.EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)org.easymock.EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)org.easymock.EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)this.originResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
        Assert.assertSame((Object)this.originResponse, (Object)result);
    }
}

