/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.net.SocketTimeoutException;
import java.util.Date;
import org.apache.hc.client5.http.impl.cache.AbstractProtocolTest;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.junit.Assert;
import org.junit.Test;

public class TestProtocolAllowedBehavior
extends AbstractProtocolTest {
    @Test
    public void testNonSharedCacheReturnsStaleResponseWhenRevalidationFailsForProxyRevalidate() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        this.originResponse.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        this.originResponse.setHeader("Cache-Control", (Object)"max-age=5,proxy-revalidate");
        this.originResponse.setHeader("Etag", (Object)"\"etag\"");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        this.backendExpectsAnyRequest().andThrow((Throwable)new SocketTimeoutException());
        this.replayMocks();
        this.behaveAsNonSharedCache();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result.getCode());
    }

    @Test
    public void testNonSharedCacheMayCacheResponsesWithCacheControlPrivate() throws Exception {
        BasicClassicHttpRequest req1 = new BasicClassicHttpRequest("GET", "/");
        this.originResponse.setHeader("Cache-Control", (Object)"private,max-age=3600");
        this.backendExpectsAnyRequest().andReturn((Object)this.originResponse);
        BasicClassicHttpRequest req2 = new BasicClassicHttpRequest("GET", "/");
        this.replayMocks();
        this.behaveAsNonSharedCache();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result.getCode());
    }
}

