/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.File;
import java.util.Date;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.cache.CacheResponseStatus;
import org.apache.hc.client5.http.cache.HttpCacheContext;
import org.apache.hc.client5.http.cache.HttpCacheStorage;
import org.apache.hc.client5.http.cache.ResourceFactory;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.cache.BasicHttpCache;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CachingExec;
import org.apache.hc.client5.http.impl.cache.FileResourceFactory;
import org.apache.hc.client5.http.impl.cache.HttpCache;
import org.apache.hc.client5.http.impl.cache.HttpTestUtils;
import org.apache.hc.client5.http.impl.cache.ManagedHttpCacheStorage;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHttpCacheJiraNumber1147 {
    private File cacheDir;

    private void removeCache() {
        if (this.cacheDir != null) {
            File[] files;
            for (File cacheFile : files = this.cacheDir.listFiles()) {
                cacheFile.delete();
            }
            this.cacheDir.delete();
            this.cacheDir = null;
        }
    }

    @Before
    public void setUp() throws Exception {
        this.cacheDir = File.createTempFile("cachedir", "");
        if (this.cacheDir.exists()) {
            this.cacheDir.delete();
        }
        this.cacheDir.mkdir();
    }

    @After
    public void cleanUp() {
        this.removeCache();
    }

    @Test
    public void testIssue1147() throws Exception {
        CacheConfig cacheConfig = CacheConfig.custom().setSharedCache(true).setMaxObjectSize(262144L).build();
        FileResourceFactory resourceFactory = new FileResourceFactory(this.cacheDir);
        ManagedHttpCacheStorage httpCacheStorage = new ManagedHttpCacheStorage(cacheConfig);
        ExecChain mockExecChain = (ExecChain)Mockito.mock(ExecChain.class);
        ExecRuntime mockEndpoint = (ExecRuntime)Mockito.mock(ExecRuntime.class);
        HttpHost target = new HttpHost("somehost", 80);
        HttpRoute route = new HttpRoute(target);
        HttpGet get = new HttpGet("http://somehost/");
        HttpCacheContext context = HttpCacheContext.create();
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity(HttpTestUtils.makeBody(128));
        response.setHeader("Content-Length", (Object)"128");
        response.setHeader("ETag", (Object)"\"etag\"");
        response.setHeader("Cache-Control", (Object)"public, max-age=3600");
        response.setHeader("Last-Modified", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        Mockito.when((Object)mockExecChain.proceed((ClassicHttpRequest)ArgumentMatchers.isA(ClassicHttpRequest.class), (ExecChain.Scope)ArgumentMatchers.isA(ExecChain.Scope.class))).thenReturn((Object)response);
        BasicHttpCache cache = new BasicHttpCache((ResourceFactory)resourceFactory, (HttpCacheStorage)httpCacheStorage);
        ExecChainHandler t = this.createCachingExecChain(cache, cacheConfig);
        ExecChain.Scope scope = new ExecChain.Scope("teset", route, (ClassicHttpRequest)get, mockEndpoint, (HttpClientContext)context);
        ClassicHttpResponse response1 = t.execute((ClassicHttpRequest)get, scope, mockExecChain);
        Assert.assertEquals((long)200L, (long)response1.getCode());
        EntityUtils.consume((HttpEntity)response1.getEntity());
        ((ExecChain)Mockito.verify((Object)mockExecChain)).proceed((ClassicHttpRequest)ArgumentMatchers.isA(ClassicHttpRequest.class), (ExecChain.Scope)ArgumentMatchers.isA(ExecChain.Scope.class));
        this.removeCache();
        Mockito.reset((Object[])new ExecChain[]{mockExecChain});
        Mockito.when((Object)mockExecChain.proceed((ClassicHttpRequest)ArgumentMatchers.isA(ClassicHttpRequest.class), (ExecChain.Scope)ArgumentMatchers.isA(ExecChain.Scope.class))).thenReturn((Object)response);
        ClassicHttpResponse response2 = t.execute((ClassicHttpRequest)get, scope, mockExecChain);
        Assert.assertEquals((long)200L, (long)response2.getCode());
        EntityUtils.consume((HttpEntity)response2.getEntity());
        ((ExecChain)Mockito.verify((Object)mockExecChain, (VerificationMode)Mockito.times((int)1))).proceed((ClassicHttpRequest)ArgumentMatchers.isA(ClassicHttpRequest.class), (ExecChain.Scope)ArgumentMatchers.isA(ExecChain.Scope.class));
        Assert.assertEquals((Object)CacheResponseStatus.FAILURE, (Object)context.getCacheResponseStatus());
    }

    protected ExecChainHandler createCachingExecChain(BasicHttpCache cache, CacheConfig config) {
        return new CachingExec((HttpCache)cache, config);
    }
}

