/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.impl.cache.AsynchronousValidationRequest;
import org.apache.hc.client5.http.impl.cache.AsynchronousValidator;
import org.apache.hc.client5.http.impl.cache.CachingExec;
import org.apache.hc.client5.http.impl.cache.ExponentialBackOffSchedulingStrategy;
import org.apache.hc.client5.http.impl.cache.SchedulingStrategy;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestExponentialBackingOffSchedulingStrategy {
    private ScheduledExecutorService mockExecutor;
    private ExecRuntime mockEndpoint;
    private ExponentialBackOffSchedulingStrategy impl;

    @Before
    public void setUp() {
        this.mockExecutor = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        this.impl = new ExponentialBackOffSchedulingStrategy(this.mockExecutor, 10L, ExponentialBackOffSchedulingStrategy.DEFAULT_INITIAL_EXPIRY_IN_MILLIS, ExponentialBackOffSchedulingStrategy.DEFAULT_MAX_EXPIRY_IN_MILLIS);
    }

    @Test
    public void testScheduleWithoutPreviousError() {
        AsynchronousValidationRequest request = this.createAsynchronousValidationRequest(TestExponentialBackingOffSchedulingStrategy.withErrorCount(0));
        this.expectRequestScheduledWithoutDelay(request);
        this.impl.schedule(request);
        ((ScheduledExecutorService)Mockito.verify((Object)this.mockExecutor)).schedule((Runnable)request, 0L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testScheduleWithOneFailedAttempt() {
        AsynchronousValidationRequest request = this.createAsynchronousValidationRequest(TestExponentialBackingOffSchedulingStrategy.withErrorCount(1));
        this.expectRequestScheduledWithDelay(request, TimeUnit.SECONDS.toMillis(6L));
        this.impl.schedule(request);
        ((ScheduledExecutorService)Mockito.verify((Object)this.mockExecutor)).schedule((Runnable)request, 6000L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testScheduleWithTwoFailedAttempts() {
        AsynchronousValidationRequest request = this.createAsynchronousValidationRequest(TestExponentialBackingOffSchedulingStrategy.withErrorCount(2));
        this.expectRequestScheduledWithDelay(request, TimeUnit.SECONDS.toMillis(60L));
        this.impl.schedule(request);
        ((ScheduledExecutorService)Mockito.verify((Object)this.mockExecutor)).schedule((Runnable)request, 60000L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testScheduleWithThreeFailedAttempts() {
        AsynchronousValidationRequest request = this.createAsynchronousValidationRequest(TestExponentialBackingOffSchedulingStrategy.withErrorCount(3));
        this.expectRequestScheduledWithDelay(request, TimeUnit.SECONDS.toMillis(600L));
        this.impl.schedule(request);
        ((ScheduledExecutorService)Mockito.verify((Object)this.mockExecutor)).schedule((Runnable)request, 600000L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testScheduleWithFourFailedAttempts() {
        AsynchronousValidationRequest request = this.createAsynchronousValidationRequest(TestExponentialBackingOffSchedulingStrategy.withErrorCount(4));
        this.expectRequestScheduledWithDelay(request, TimeUnit.SECONDS.toMillis(6000L));
        this.impl.schedule(request);
        ((ScheduledExecutorService)Mockito.verify((Object)this.mockExecutor)).schedule((Runnable)request, 6000000L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testScheduleWithFiveFailedAttempts() {
        AsynchronousValidationRequest request = this.createAsynchronousValidationRequest(TestExponentialBackingOffSchedulingStrategy.withErrorCount(5));
        this.expectRequestScheduledWithDelay(request, TimeUnit.SECONDS.toMillis(60000L));
        this.impl.schedule(request);
        ((ScheduledExecutorService)Mockito.verify((Object)this.mockExecutor)).schedule((Runnable)request, 60000000L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testScheduleWithSixFailedAttempts() {
        AsynchronousValidationRequest request = this.createAsynchronousValidationRequest(TestExponentialBackingOffSchedulingStrategy.withErrorCount(6));
        this.expectRequestScheduledWithDelay(request, TimeUnit.SECONDS.toMillis(86400L));
        this.impl.schedule(request);
        ((ScheduledExecutorService)Mockito.verify((Object)this.mockExecutor)).schedule((Runnable)request, 86400000L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testScheduleWithMaxNumberOfFailedAttempts() {
        AsynchronousValidationRequest request = this.createAsynchronousValidationRequest(TestExponentialBackingOffSchedulingStrategy.withErrorCount(Integer.MAX_VALUE));
        this.expectRequestScheduledWithDelay(request, TimeUnit.SECONDS.toMillis(86400L));
        this.impl.schedule(request);
        ((ScheduledExecutorService)Mockito.verify((Object)this.mockExecutor)).schedule((Runnable)request, 86400000L, TimeUnit.MILLISECONDS);
    }

    private void expectRequestScheduledWithoutDelay(AsynchronousValidationRequest request) {
        this.expectRequestScheduledWithDelay(request, 0L);
    }

    private void expectRequestScheduledWithDelay(AsynchronousValidationRequest request, long delayInMillis) {
        Mockito.when(this.mockExecutor.schedule((Runnable)request, delayInMillis, TimeUnit.MILLISECONDS)).thenReturn(null);
    }

    private AsynchronousValidationRequest createAsynchronousValidationRequest(int errorCount) {
        CachingExec cachingHttpClient = new CachingExec();
        AsynchronousValidator mockValidator = new AsynchronousValidator((SchedulingStrategy)this.impl);
        HttpHost host = new HttpHost("foo.example.com", 80);
        HttpRoute route = new HttpRoute(host);
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("GET", "/");
        HttpClientContext context = new HttpClientContext();
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, (ExecRuntime)Mockito.mock(ExecRuntime.class), context);
        return new AsynchronousValidationRequest(mockValidator, cachingHttpClient, host, (ClassicHttpRequest)request, scope, (ExecChain)Mockito.mock(ExecChain.class), null, "identifier", errorCount);
    }

    private static int withErrorCount(int errorCount) {
        return errorCount;
    }
}

