/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import org.apache.hc.client5.http.impl.cache.DefaultFailureCache;
import org.apache.hc.client5.http.impl.cache.FailureCache;
import org.junit.Assert;
import org.junit.Test;

public class TestDefaultFailureCache {
    private static final String IDENTIFIER = "some-identifier";
    private FailureCache failureCache = new DefaultFailureCache();

    @Test
    public void testResetErrorCount() {
        this.failureCache.increaseErrorCount(IDENTIFIER);
        this.failureCache.resetErrorCount(IDENTIFIER);
        int errorCount = this.failureCache.getErrorCount(IDENTIFIER);
        Assert.assertEquals((long)0L, (long)errorCount);
    }

    @Test
    public void testIncrementErrorCount() {
        this.failureCache.increaseErrorCount(IDENTIFIER);
        this.failureCache.increaseErrorCount(IDENTIFIER);
        this.failureCache.increaseErrorCount(IDENTIFIER);
        int errorCount = this.failureCache.getErrorCount(IDENTIFIER);
        Assert.assertEquals((long)3L, (long)errorCount);
    }

    @Test
    public void testMaxSize() {
        this.failureCache = new DefaultFailureCache(3);
        this.failureCache.increaseErrorCount("a");
        this.failureCache.increaseErrorCount("b");
        this.failureCache.increaseErrorCount("c");
        this.failureCache.increaseErrorCount("d");
        int errorCount = this.failureCache.getErrorCount("a");
        Assert.assertEquals((long)0L, (long)errorCount);
    }
}

