/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheStorage;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.impl.cache.CacheKeyGenerator;
import org.apache.hc.client5.http.impl.cache.DefaultCacheInvalidator;
import org.apache.hc.client5.http.impl.cache.HttpTestUtils;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.message.BasicHeader;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDefaultCacheInvalidator {
    private DefaultCacheInvalidator impl;
    private HttpCacheStorage mockStorage;
    private HttpHost host;
    private CacheKeyGenerator cacheKeyGenerator;
    private HttpCacheEntry mockEntry;
    private ClassicHttpRequest request;
    private ClassicHttpResponse response;
    private Date now;
    private Date tenSecondsAgo;

    @Before
    public void setUp() {
        this.now = new Date();
        this.tenSecondsAgo = new Date(this.now.getTime() - 10000L);
        this.host = new HttpHost("foo.example.com");
        this.mockStorage = (HttpCacheStorage)Mockito.mock(HttpCacheStorage.class);
        this.cacheKeyGenerator = new CacheKeyGenerator();
        this.mockEntry = (HttpCacheEntry)Mockito.mock(HttpCacheEntry.class);
        this.request = HttpTestUtils.makeDefaultRequest();
        this.response = HttpTestUtils.make200Response();
        this.impl = new DefaultCacheInvalidator(this.cacheKeyGenerator, this.mockStorage);
    }

    @Test
    public void testInvalidatesRequestsThatArentGETorHEAD() throws Exception {
        this.request = new BasicClassicHttpRequest("POST", "/path");
        String theUri = "http://foo.example.com:80/path";
        HashMap<String, String> variantMap = new HashMap<String, String>();
        this.cacheEntryHasVariantMap(variantMap);
        this.cacheReturnsEntryForUri("http://foo.example.com:80/path");
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request);
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).getVariantMap();
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/path");
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).removeEntry("http://foo.example.com:80/path");
    }

    @Test
    public void testInvalidatesUrisInContentLocationHeadersOnPUTs() throws Exception {
        BasicClassicHttpRequest putRequest = new BasicClassicHttpRequest("PUT", "/");
        putRequest.setEntity(HttpTestUtils.makeBody(128));
        putRequest.setHeader("Content-Length", (Object)"128");
        String contentLocation = "http://foo.example.com/content";
        putRequest.setHeader("Content-Location", (Object)"http://foo.example.com/content");
        String theUri = "http://foo.example.com:80/";
        this.cacheEntryHasVariantMap(new HashMap<String, String>());
        this.cacheReturnsEntryForUri("http://foo.example.com:80/");
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)putRequest);
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).getVariantMap();
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/");
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).removeEntry("http://foo.example.com:80/");
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).removeEntry("http://foo.example.com:80/content");
    }

    @Test
    public void testInvalidatesUrisInLocationHeadersOnPUTs() throws Exception {
        BasicClassicHttpRequest putRequest = new BasicClassicHttpRequest("PUT", "/");
        putRequest.setEntity(HttpTestUtils.makeBody(128));
        putRequest.setHeader("Content-Length", (Object)"128");
        String contentLocation = "http://foo.example.com/content";
        putRequest.setHeader("Location", (Object)"http://foo.example.com/content");
        String theUri = "http://foo.example.com:80/";
        this.cacheEntryHasVariantMap(new HashMap<String, String>());
        this.cacheReturnsEntryForUri("http://foo.example.com:80/");
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)putRequest);
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).getVariantMap();
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/");
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).removeEntry("http://foo.example.com:80/");
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).removeEntry(this.cacheKeyGenerator.generateKey(new URI("http://foo.example.com/content")));
    }

    @Test
    public void testInvalidatesRelativeUrisInContentLocationHeadersOnPUTs() throws Exception {
        BasicClassicHttpRequest putRequest = new BasicClassicHttpRequest("PUT", "/");
        putRequest.setEntity(HttpTestUtils.makeBody(128));
        putRequest.setHeader("Content-Length", (Object)"128");
        String relativePath = "/content";
        putRequest.setHeader("Content-Location", (Object)"/content");
        String theUri = "http://foo.example.com:80/";
        this.cacheEntryHasVariantMap(new HashMap<String, String>());
        this.cacheReturnsEntryForUri("http://foo.example.com:80/");
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)putRequest);
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).getVariantMap();
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/");
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).removeEntry("http://foo.example.com:80/");
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).removeEntry("http://foo.example.com:80/content");
    }

    @Test
    public void testDoesNotInvalidateUrisInContentLocationHeadersOnPUTsToDifferentHosts() throws Exception {
        BasicClassicHttpRequest putRequest = new BasicClassicHttpRequest("PUT", "/");
        putRequest.setEntity(HttpTestUtils.makeBody(128));
        putRequest.setHeader("Content-Length", (Object)"128");
        String contentLocation = "http://bar.example.com/content";
        putRequest.setHeader("Content-Location", (Object)"http://bar.example.com/content");
        String theUri = "http://foo.example.com:80/";
        this.cacheEntryHasVariantMap(new HashMap<String, String>());
        this.cacheReturnsEntryForUri("http://foo.example.com:80/");
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)putRequest);
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).getVariantMap();
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/");
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).removeEntry("http://foo.example.com:80/");
    }

    @Test
    public void testDoesNotInvalidateGETRequest() throws Exception {
        this.request = new BasicClassicHttpRequest("GET", "/");
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorage});
    }

    @Test
    public void testDoesNotInvalidateHEADRequest() throws Exception {
        this.request = new BasicClassicHttpRequest("HEAD", "/");
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorage});
    }

    @Test
    public void testInvalidatesHEADCacheEntryIfSubsequentGETRequestsAreMadeToTheSameURI() throws Exception {
        this.impl = new DefaultCacheInvalidator(this.cacheKeyGenerator, this.mockStorage);
        String theURI = "http://foo.example.com:80/";
        this.request = new BasicClassicHttpRequest("GET", "http://foo.example.com:80/");
        this.cacheEntryisForMethod("HEAD");
        this.cacheEntryHasVariantMap(new HashMap<String, String>());
        this.cacheReturnsEntryForUri("http://foo.example.com:80/");
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request);
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).getRequestMethod();
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).getVariantMap();
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/");
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).removeEntry("http://foo.example.com:80/");
    }

    @Test
    public void testInvalidatesVariantHEADCacheEntriesIfSubsequentGETRequestsAreMadeToTheSameURI() throws Exception {
        this.impl = new DefaultCacheInvalidator(this.cacheKeyGenerator, this.mockStorage);
        String theURI = "http://foo.example.com:80/";
        this.request = new BasicClassicHttpRequest("GET", "http://foo.example.com:80/");
        String theVariantKey = "{Accept-Encoding=gzip%2Cdeflate&User-Agent=Apache-HttpClient}";
        String theVariantURI = "{Accept-Encoding=gzip%2Cdeflate&User-Agent=Apache-HttpClient}http://foo.example.com:80/";
        Map<String, String> variants = HttpTestUtils.makeDefaultVariantMap("{Accept-Encoding=gzip%2Cdeflate&User-Agent=Apache-HttpClient}", "{Accept-Encoding=gzip%2Cdeflate&User-Agent=Apache-HttpClient}http://foo.example.com:80/");
        this.cacheEntryisForMethod("HEAD");
        this.cacheEntryHasVariantMap(variants);
        this.cacheReturnsEntryForUri("http://foo.example.com:80/");
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request);
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).getRequestMethod();
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).getVariantMap();
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/");
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).removeEntry("http://foo.example.com:80/");
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).removeEntry("{Accept-Encoding=gzip%2Cdeflate&User-Agent=Apache-HttpClient}http://foo.example.com:80/");
    }

    @Test
    public void testDoesNotInvalidateHEADCacheEntry() throws Exception {
        String theURI = "http://foo.example.com:80/";
        this.request = new BasicClassicHttpRequest("HEAD", "http://foo.example.com:80/");
        this.cacheReturnsEntryForUri("http://foo.example.com:80/");
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorage});
    }

    @Test
    public void testDoesNotInvalidateHEADCacheEntryIfSubsequentHEADRequestsAreMadeToTheSameURI() throws Exception {
        this.impl = new DefaultCacheInvalidator(this.cacheKeyGenerator, this.mockStorage);
        String theURI = "http://foo.example.com:80/";
        this.request = new BasicClassicHttpRequest("HEAD", "http://foo.example.com:80/");
        this.cacheReturnsEntryForUri("http://foo.example.com:80/");
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorage});
    }

    @Test
    public void testDoesNotInvalidateGETCacheEntryIfSubsequentGETRequestsAreMadeToTheSameURI() throws Exception {
        this.impl = new DefaultCacheInvalidator(this.cacheKeyGenerator, this.mockStorage);
        String theURI = "http://foo.example.com:80/";
        this.request = new BasicClassicHttpRequest("GET", "http://foo.example.com:80/");
        this.cacheEntryisForMethod("GET");
        this.cacheReturnsEntryForUri("http://foo.example.com:80/");
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request);
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).getRequestMethod();
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorage});
    }

    @Test
    public void testDoesNotInvalidateRequestsWithClientCacheControlHeaders() throws Exception {
        this.request = new BasicClassicHttpRequest("GET", "/");
        this.request.setHeader("Cache-Control", (Object)"no-cache");
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorage});
    }

    @Test
    public void testDoesNotInvalidateRequestsWithClientPragmaHeaders() throws Exception {
        this.request = new BasicClassicHttpRequest("GET", "/");
        this.request.setHeader("Pragma", (Object)"no-cache");
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorage});
    }

    @Test
    public void testVariantURIsAreFlushedAlso() throws Exception {
        this.request = new BasicClassicHttpRequest("POST", "/");
        String theUri = "http://foo.example.com:80/";
        String variantUri = "theVariantURI";
        Map<String, String> mapOfURIs = HttpTestUtils.makeDefaultVariantMap("theVariantURI", "theVariantURI");
        this.cacheReturnsEntryForUri("http://foo.example.com:80/");
        this.cacheEntryHasVariantMap(mapOfURIs);
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/");
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).getVariantMap();
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).removeEntry("theVariantURI");
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).removeEntry("http://foo.example.com:80/");
    }

    @Test
    public void testCacheFlushException() throws Exception {
        this.request = new BasicClassicHttpRequest("POST", "/");
        String theURI = "http://foo.example.com:80/";
        this.cacheReturnsExceptionForUri("http://foo.example.com:80/");
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorage});
    }

    @Test
    public void doesNotFlushForResponsesWithoutContentLocation() throws Exception {
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request, (HttpResponse)this.response);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorage});
    }

    @Test
    public void flushesEntryIfFresherAndSpecifiedByContentLocation() throws Exception {
        this.response.setHeader("ETag", (Object)"\"new-etag\"");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        String theURI = "http://foo.example.com:80/bar";
        this.response.setHeader("Content-Location", (Object)"http://foo.example.com:80/bar");
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("ETag", (Object)"\"old-etag\"")});
        Mockito.when((Object)this.mockStorage.getEntry("http://foo.example.com:80/bar")).thenReturn((Object)entry);
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request, (HttpResponse)this.response);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/bar");
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).removeEntry("http://foo.example.com:80/bar");
    }

    @Test
    public void flushesEntryIfFresherAndSpecifiedByLocation() throws Exception {
        this.response.setCode(201);
        this.response.setHeader("ETag", (Object)"\"new-etag\"");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        String theURI = "http://foo.example.com:80/bar";
        this.response.setHeader("Location", (Object)"http://foo.example.com:80/bar");
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("ETag", (Object)"\"old-etag\"")});
        Mockito.when((Object)this.mockStorage.getEntry("http://foo.example.com:80/bar")).thenReturn((Object)entry);
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request, (HttpResponse)this.response);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/bar");
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).removeEntry("http://foo.example.com:80/bar");
    }

    @Test
    public void doesNotFlushEntryForUnsuccessfulResponse() throws Exception {
        this.response = new BasicClassicHttpResponse(400, "Bad Request");
        this.response.setHeader("ETag", (Object)"\"new-etag\"");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        String theURI = "http://foo.example.com:80/bar";
        this.response.setHeader("Content-Location", (Object)"http://foo.example.com:80/bar");
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request, (HttpResponse)this.response);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorage});
    }

    @Test
    public void flushesEntryIfFresherAndSpecifiedByNonCanonicalContentLocation() throws Exception {
        this.response.setHeader("ETag", (Object)"\"new-etag\"");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        String cacheKey = "http://foo.example.com:80/bar";
        this.response.setHeader("Content-Location", (Object)"http://foo.example.com/bar");
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("ETag", (Object)"\"old-etag\"")});
        Mockito.when((Object)this.mockStorage.getEntry("http://foo.example.com:80/bar")).thenReturn((Object)entry);
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request, (HttpResponse)this.response);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/bar");
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).removeEntry("http://foo.example.com:80/bar");
    }

    @Test
    public void flushesEntryIfFresherAndSpecifiedByRelativeContentLocation() throws Exception {
        this.response.setHeader("ETag", (Object)"\"new-etag\"");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        String cacheKey = "http://foo.example.com:80/bar";
        this.response.setHeader("Content-Location", (Object)"/bar");
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("ETag", (Object)"\"old-etag\"")});
        Mockito.when((Object)this.mockStorage.getEntry("http://foo.example.com:80/bar")).thenReturn((Object)entry);
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request, (HttpResponse)this.response);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/bar");
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).removeEntry("http://foo.example.com:80/bar");
    }

    @Test
    public void doesNotFlushEntryIfContentLocationFromDifferentHost() throws Exception {
        this.response.setHeader("ETag", (Object)"\"new-etag\"");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        String cacheKey = "http://baz.example.com:80/bar";
        this.response.setHeader("Content-Location", (Object)"http://baz.example.com:80/bar");
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("ETag", (Object)"\"old-etag\"")});
        Mockito.when((Object)this.mockStorage.getEntry("http://baz.example.com:80/bar")).thenReturn((Object)entry);
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request, (HttpResponse)this.response);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://baz.example.com:80/bar");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorage});
    }

    @Test
    public void doesNotFlushEntrySpecifiedByContentLocationIfEtagsMatch() throws Exception {
        this.response.setHeader("ETag", (Object)"\"same-etag\"");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        String theURI = "http://foo.example.com:80/bar";
        this.response.setHeader("Content-Location", (Object)"http://foo.example.com:80/bar");
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("ETag", (Object)"\"same-etag\"")});
        Mockito.when((Object)this.mockStorage.getEntry("http://foo.example.com:80/bar")).thenReturn((Object)entry);
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request, (HttpResponse)this.response);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/bar");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorage});
    }

    @Test
    public void doesNotFlushEntrySpecifiedByContentLocationIfOlder() throws Exception {
        this.response.setHeader("ETag", (Object)"\"new-etag\"");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo));
        String theURI = "http://foo.example.com:80/bar";
        this.response.setHeader("Content-Location", (Object)"http://foo.example.com:80/bar");
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.now)), new BasicHeader("ETag", (Object)"\"old-etag\"")});
        Mockito.when((Object)this.mockStorage.getEntry("http://foo.example.com:80/bar")).thenReturn((Object)entry);
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request, (HttpResponse)this.response);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/bar");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorage});
    }

    @Test
    public void doesNotFlushEntryIfNotInCache() throws Exception {
        this.response.setHeader("ETag", (Object)"\"new-etag\"");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        String theURI = "http://foo.example.com:80/bar";
        this.response.setHeader("Content-Location", (Object)"http://foo.example.com:80/bar");
        Mockito.when((Object)this.mockStorage.getEntry("http://foo.example.com:80/bar")).thenReturn(null);
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request, (HttpResponse)this.response);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/bar");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorage});
    }

    @Test
    public void doesNotFlushEntrySpecifiedByContentLocationIfResponseHasNoEtag() throws Exception {
        this.response.removeHeaders("ETag");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        String theURI = "http://foo.example.com:80/bar";
        this.response.setHeader("Content-Location", (Object)"http://foo.example.com:80/bar");
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("ETag", (Object)"\"old-etag\"")});
        Mockito.when((Object)this.mockStorage.getEntry("http://foo.example.com:80/bar")).thenReturn((Object)entry);
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request, (HttpResponse)this.response);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/bar");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorage});
    }

    @Test
    public void doesNotFlushEntrySpecifiedByContentLocationIfEntryHasNoEtag() throws Exception {
        this.response.setHeader("ETag", (Object)"\"some-etag\"");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        String theURI = "http://foo.example.com:80/bar";
        this.response.setHeader("Content-Location", (Object)"http://foo.example.com:80/bar");
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo))});
        Mockito.when((Object)this.mockStorage.getEntry("http://foo.example.com:80/bar")).thenReturn((Object)entry);
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request, (HttpResponse)this.response);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/bar");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorage});
    }

    @Test
    public void flushesEntrySpecifiedByContentLocationIfResponseHasNoDate() throws Exception {
        this.response.setHeader("ETag", (Object)"\"new-etag\"");
        this.response.removeHeaders("Date");
        String theURI = "http://foo.example.com:80/bar";
        this.response.setHeader("Content-Location", (Object)"http://foo.example.com:80/bar");
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(new Header[]{new BasicHeader("ETag", (Object)"\"old-etag\""), new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo))});
        Mockito.when((Object)this.mockStorage.getEntry("http://foo.example.com:80/bar")).thenReturn((Object)entry);
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request, (HttpResponse)this.response);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/bar");
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).removeEntry("http://foo.example.com:80/bar");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorage});
    }

    @Test
    public void flushesEntrySpecifiedByContentLocationIfEntryHasNoDate() throws Exception {
        this.response.setHeader("ETag", (Object)"\"new-etag\"");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        String theURI = "http://foo.example.com:80/bar";
        this.response.setHeader("Content-Location", (Object)"http://foo.example.com:80/bar");
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(new Header[]{new BasicHeader("ETag", (Object)"\"old-etag\"")});
        Mockito.when((Object)this.mockStorage.getEntry("http://foo.example.com:80/bar")).thenReturn((Object)entry);
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request, (HttpResponse)this.response);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/bar");
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).removeEntry("http://foo.example.com:80/bar");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorage});
    }

    @Test
    public void flushesEntrySpecifiedByContentLocationIfResponseHasMalformedDate() throws Exception {
        this.response.setHeader("ETag", (Object)"\"new-etag\"");
        this.response.setHeader("Date", (Object)"blarg");
        String theURI = "http://foo.example.com:80/bar";
        this.response.setHeader("Content-Location", (Object)"http://foo.example.com:80/bar");
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(new Header[]{new BasicHeader("ETag", (Object)"\"old-etag\""), new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo))});
        Mockito.when((Object)this.mockStorage.getEntry("http://foo.example.com:80/bar")).thenReturn((Object)entry);
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request, (HttpResponse)this.response);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/bar");
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).removeEntry("http://foo.example.com:80/bar");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorage});
    }

    @Test
    public void flushesEntrySpecifiedByContentLocationIfEntryHasMalformedDate() throws Exception {
        this.response.setHeader("ETag", (Object)"\"new-etag\"");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.now));
        String theURI = "http://foo.example.com:80/bar";
        this.response.setHeader("Content-Location", (Object)"http://foo.example.com:80/bar");
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(new Header[]{new BasicHeader("ETag", (Object)"\"old-etag\""), new BasicHeader("Date", (Object)"foo")});
        Mockito.when((Object)this.mockStorage.getEntry("http://foo.example.com:80/bar")).thenReturn((Object)entry);
        this.impl.flushInvalidatedCacheEntries(this.host, (HttpRequest)this.request, (HttpResponse)this.response);
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).getEntry("http://foo.example.com:80/bar");
        ((HttpCacheStorage)Mockito.verify((Object)this.mockStorage)).removeEntry("http://foo.example.com:80/bar");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorage});
    }

    private void cacheEntryHasVariantMap(Map<String, String> variantMap) {
        Mockito.when((Object)this.mockEntry.getVariantMap()).thenReturn(variantMap);
    }

    private void cacheReturnsEntryForUri(String theUri) throws IOException {
        Mockito.when((Object)this.mockStorage.getEntry(theUri)).thenReturn((Object)this.mockEntry);
    }

    private void cacheReturnsExceptionForUri(String theUri) throws IOException {
        Mockito.when((Object)this.mockStorage.getEntry(theUri)).thenThrow(new Throwable[]{new ResourceIOException("TOTAL FAIL")});
    }

    private void cacheEntryisForMethod(String httpMethod) {
        Mockito.when((Object)this.mockEntry.getRequestMethod()).thenReturn((Object)httpMethod);
    }
}

