/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.impl.MessageCopier;
import org.apache.hc.client5.http.impl.RequestCopier;
import org.apache.hc.client5.http.impl.cache.ConditionalRequestBuilder;
import org.apache.hc.client5.http.impl.cache.HttpTestUtils;
import org.apache.hc.client5.http.impl.cache.Variant;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.MessageSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConditionalRequestBuilder {
    private ConditionalRequestBuilder<HttpRequest> impl;
    private HttpRequest request;

    @Before
    public void setUp() throws Exception {
        this.impl = new ConditionalRequestBuilder((MessageCopier)RequestCopier.INSTANCE);
        this.request = new BasicHttpRequest("GET", "/");
    }

    @Test
    public void testBuildConditionalRequestWithLastModified() throws ProtocolException {
        String theMethod = "GET";
        String theUri = "/theuri";
        String lastModified = "this is my last modified date";
        BasicHttpRequest basicRequest = new BasicHttpRequest("GET", "/theuri");
        basicRequest.addHeader("Accept-Encoding", (Object)"gzip");
        HttpRequest requestWrapper = RequestCopier.INSTANCE.copy((HttpRequest)basicRequest);
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)new Date())), new BasicHeader("Last-Modified", (Object)"this is my last modified date")};
        HttpCacheEntry cacheEntry = HttpTestUtils.makeCacheEntry(headers);
        HttpRequest newRequest = this.impl.buildConditionalRequest(requestWrapper, cacheEntry);
        Assert.assertNotSame((Object)basicRequest, (Object)newRequest);
        Assert.assertEquals((Object)"GET", (Object)newRequest.getMethod());
        Assert.assertEquals((Object)"/theuri", (Object)newRequest.getRequestUri());
        Assert.assertEquals((long)2L, (long)newRequest.getAllHeaders().length);
        Assert.assertEquals((Object)"Accept-Encoding", (Object)newRequest.getAllHeaders()[0].getName());
        Assert.assertEquals((Object)"gzip", (Object)newRequest.getAllHeaders()[0].getValue());
        Assert.assertEquals((Object)"If-Modified-Since", (Object)newRequest.getAllHeaders()[1].getName());
        Assert.assertEquals((Object)"this is my last modified date", (Object)newRequest.getAllHeaders()[1].getValue());
    }

    @Test
    public void testConditionalRequestForEntryWithLastModifiedAndEtagIncludesBothAsValidators() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        Date twentySecondsAgo = new Date(now.getTime() - 20000L);
        String lmDate = DateUtils.formatDate((Date)twentySecondsAgo);
        String etag = "\"etag\"";
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo)), new BasicHeader("Last-Modified", (Object)lmDate), new BasicHeader("ETag", (Object)"\"etag\"")};
        BasicHttpRequest basicRequest = new BasicHttpRequest("GET", "/");
        HttpRequest requestWrapper = RequestCopier.INSTANCE.copy((HttpRequest)basicRequest);
        HttpCacheEntry cacheEntry = HttpTestUtils.makeCacheEntry(headers);
        HttpRequest result = this.impl.buildConditionalRequest(requestWrapper, cacheEntry);
        Assert.assertEquals((Object)lmDate, (Object)result.getFirstHeader("If-Modified-Since").getValue());
        Assert.assertEquals((Object)"\"etag\"", (Object)result.getFirstHeader("If-None-Match").getValue());
    }

    @Test
    public void testBuildConditionalRequestWithETag() throws ProtocolException {
        String theMethod = "GET";
        String theUri = "/theuri";
        String theETag = "this is my eTag";
        BasicHttpRequest basicRequest = new BasicHttpRequest("GET", "/theuri");
        basicRequest.addHeader("Accept-Encoding", (Object)"gzip");
        HttpRequest requestWrapper = RequestCopier.INSTANCE.copy((HttpRequest)basicRequest);
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)new Date())), new BasicHeader("Last-Modified", (Object)DateUtils.formatDate((Date)new Date())), new BasicHeader("ETag", (Object)"this is my eTag")};
        HttpCacheEntry cacheEntry = HttpTestUtils.makeCacheEntry(headers);
        HttpRequest newRequest = this.impl.buildConditionalRequest(requestWrapper, cacheEntry);
        Assert.assertNotSame((Object)basicRequest, (Object)newRequest);
        Assert.assertEquals((Object)"GET", (Object)newRequest.getMethod());
        Assert.assertEquals((Object)"/theuri", (Object)newRequest.getRequestUri());
        Assert.assertEquals((long)3L, (long)newRequest.getAllHeaders().length);
        Assert.assertEquals((Object)"Accept-Encoding", (Object)newRequest.getAllHeaders()[0].getName());
        Assert.assertEquals((Object)"gzip", (Object)newRequest.getAllHeaders()[0].getValue());
        Assert.assertEquals((Object)"If-None-Match", (Object)newRequest.getAllHeaders()[1].getName());
        Assert.assertEquals((Object)"this is my eTag", (Object)newRequest.getAllHeaders()[1].getValue());
    }

    @Test
    public void testCacheEntryWithMustRevalidateDoesEndToEndRevalidation() throws Exception {
        BasicHttpRequest basicRequest = new BasicHttpRequest("GET", "/");
        HttpRequest requestWrapper = RequestCopier.INSTANCE.copy((HttpRequest)basicRequest);
        Date now = new Date();
        Date elevenSecondsAgo = new Date(now.getTime() - 11000L);
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        Date nineSecondsAgo = new Date(now.getTime() - 9000L);
        Header[] cacheEntryHeaders = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo)), new BasicHeader("ETag", (Object)"\"etag\""), new BasicHeader("Cache-Control", (Object)"max-age=5, must-revalidate")};
        HttpCacheEntry cacheEntry = HttpTestUtils.makeCacheEntry(elevenSecondsAgo, nineSecondsAgo, cacheEntryHeaders);
        HttpRequest result = this.impl.buildConditionalRequest(requestWrapper, cacheEntry);
        boolean foundMaxAge0 = false;
        Iterator it = MessageSupport.iterate((MessageHeaders)result, (String)"Cache-Control");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (!"max-age".equalsIgnoreCase(elt.getName()) || !"0".equals(elt.getValue())) continue;
            foundMaxAge0 = true;
        }
        Assert.assertTrue((boolean)foundMaxAge0);
    }

    @Test
    public void testCacheEntryWithProxyRevalidateDoesEndToEndRevalidation() throws Exception {
        BasicHttpRequest basicRequest = new BasicHttpRequest("GET", "/");
        HttpRequest requestWrapper = RequestCopier.INSTANCE.copy((HttpRequest)basicRequest);
        Date now = new Date();
        Date elevenSecondsAgo = new Date(now.getTime() - 11000L);
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        Date nineSecondsAgo = new Date(now.getTime() - 9000L);
        Header[] cacheEntryHeaders = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo)), new BasicHeader("ETag", (Object)"\"etag\""), new BasicHeader("Cache-Control", (Object)"max-age=5, proxy-revalidate")};
        HttpCacheEntry cacheEntry = HttpTestUtils.makeCacheEntry(elevenSecondsAgo, nineSecondsAgo, cacheEntryHeaders);
        HttpRequest result = this.impl.buildConditionalRequest(requestWrapper, cacheEntry);
        boolean foundMaxAge0 = false;
        Iterator it = MessageSupport.iterate((MessageHeaders)result, (String)"Cache-Control");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (!"max-age".equalsIgnoreCase(elt.getName()) || !"0".equals(elt.getValue())) continue;
            foundMaxAge0 = true;
        }
        Assert.assertTrue((boolean)foundMaxAge0);
    }

    @Test
    public void testBuildUnconditionalRequestUsesGETMethod() throws Exception {
        HttpRequest result = this.impl.buildUnconditionalRequest(this.request);
        Assert.assertEquals((Object)"GET", (Object)result.getMethod());
    }

    @Test
    public void testBuildUnconditionalRequestUsesRequestUri() throws Exception {
        String uri = "/theURI";
        this.request = new BasicHttpRequest("GET", "/theURI");
        HttpRequest result = this.impl.buildUnconditionalRequest(this.request);
        Assert.assertEquals((Object)"/theURI", (Object)result.getRequestUri());
    }

    @Test
    public void testBuildUnconditionalRequestAddsCacheControlNoCache() throws Exception {
        HttpRequest result = this.impl.buildUnconditionalRequest(this.request);
        boolean ccNoCacheFound = false;
        Iterator it = MessageSupport.iterate((MessageHeaders)result, (String)"Cache-Control");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (!"no-cache".equals(elt.getName())) continue;
            ccNoCacheFound = true;
        }
        Assert.assertTrue((boolean)ccNoCacheFound);
    }

    @Test
    public void testBuildUnconditionalRequestAddsPragmaNoCache() throws Exception {
        HttpRequest result = this.impl.buildUnconditionalRequest(this.request);
        boolean ccNoCacheFound = false;
        Iterator it = MessageSupport.iterate((MessageHeaders)result, (String)"Pragma");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            if (!"no-cache".equals(elt.getName())) continue;
            ccNoCacheFound = true;
        }
        Assert.assertTrue((boolean)ccNoCacheFound);
    }

    @Test
    public void testBuildUnconditionalRequestDoesNotUseIfRange() throws Exception {
        this.request.addHeader("If-Range", (Object)"\"etag\"");
        HttpRequest result = this.impl.buildUnconditionalRequest(this.request);
        Assert.assertNull((Object)result.getFirstHeader("If-Range"));
    }

    @Test
    public void testBuildUnconditionalRequestDoesNotUseIfMatch() throws Exception {
        this.request.addHeader("If-Match", (Object)"\"etag\"");
        HttpRequest result = this.impl.buildUnconditionalRequest(this.request);
        Assert.assertNull((Object)result.getFirstHeader("If-Match"));
    }

    @Test
    public void testBuildUnconditionalRequestDoesNotUseIfNoneMatch() throws Exception {
        this.request.addHeader("If-None-Match", (Object)"\"etag\"");
        HttpRequest result = this.impl.buildUnconditionalRequest(this.request);
        Assert.assertNull((Object)result.getFirstHeader("If-None-Match"));
    }

    @Test
    public void testBuildUnconditionalRequestDoesNotUseIfUnmodifiedSince() throws Exception {
        this.request.addHeader("If-Unmodified-Since", (Object)DateUtils.formatDate((Date)new Date()));
        HttpRequest result = this.impl.buildUnconditionalRequest(this.request);
        Assert.assertNull((Object)result.getFirstHeader("If-Unmodified-Since"));
    }

    @Test
    public void testBuildUnconditionalRequestDoesNotUseIfModifiedSince() throws Exception {
        this.request.addHeader("If-Modified-Since", (Object)DateUtils.formatDate((Date)new Date()));
        HttpRequest result = this.impl.buildUnconditionalRequest(this.request);
        Assert.assertNull((Object)result.getFirstHeader("If-Modified-Since"));
    }

    @Test
    public void testBuildUnconditionalRequestCarriesOtherRequestHeaders() throws Exception {
        this.request.addHeader("User-Agent", (Object)"MyBrowser/1.0");
        HttpRequest result = this.impl.buildUnconditionalRequest(this.request);
        Assert.assertEquals((Object)"MyBrowser/1.0", (Object)result.getFirstHeader("User-Agent").getValue());
    }

    @Test
    public void testBuildConditionalRequestFromVariants() throws Exception {
        String etag1 = "\"123\"";
        String etag2 = "\"456\"";
        String etag3 = "\"789\"";
        HashMap<String, Variant> variantEntries = new HashMap<String, Variant>();
        variantEntries.put("\"123\"", new Variant("A", "B", HttpTestUtils.makeCacheEntry(new Header[]{new BasicHeader("ETag", (Object)"\"123\"")})));
        variantEntries.put("\"456\"", new Variant("C", "D", HttpTestUtils.makeCacheEntry(new Header[]{new BasicHeader("ETag", (Object)"\"456\"")})));
        variantEntries.put("\"789\"", new Variant("E", "F", HttpTestUtils.makeCacheEntry(new Header[]{new BasicHeader("ETag", (Object)"\"789\"")})));
        HttpRequest conditional = this.impl.buildConditionalRequestFromVariants(this.request, variantEntries);
        String ifNoneMatch = conditional.getFirstHeader("If-None-Match").getValue();
        Assert.assertTrue((boolean)ifNoneMatch.contains("\"123\""));
        Assert.assertTrue((boolean)ifNoneMatch.contains("\"456\""));
        Assert.assertTrue((boolean)ifNoneMatch.contains("\"789\""));
        ifNoneMatch = ifNoneMatch.replace("\"123\"", "");
        ifNoneMatch = ifNoneMatch.replace("\"456\"", "");
        ifNoneMatch = ifNoneMatch.replace("\"789\"", "");
        ifNoneMatch = ifNoneMatch.replace(",", "");
        ifNoneMatch = ifNoneMatch.replace(" ", "");
        Assert.assertEquals((Object)ifNoneMatch, (Object)"");
    }
}

