/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.ByteArrayInputStream;
import org.apache.hc.client5.http.impl.cache.CombinedEntity;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCombinedEntity {
    @Test
    public void testCombinedEntityBasics() throws Exception {
        HttpEntity httpEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)httpEntity.getContent()).thenReturn((Object)new ByteArrayInputStream(new byte[]{6, 7, 8, 9, 10}));
        ByteArrayBuffer buf = new ByteArrayBuffer(1024);
        byte[] tmp = new byte[]{1, 2, 3, 4, 5};
        buf.append(tmp, 0, tmp.length);
        CombinedEntity entity = new CombinedEntity(httpEntity, buf);
        Assert.assertEquals((long)-1L, (long)entity.getContentLength());
        Assert.assertFalse((boolean)entity.isRepeatable());
        Assert.assertTrue((boolean)entity.isStreaming());
        Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, (byte[])EntityUtils.toByteArray((HttpEntity)entity));
        ((HttpEntity)Mockito.verify((Object)httpEntity)).getContent();
        entity.close();
        ((HttpEntity)Mockito.verify((Object)httpEntity)).close();
    }
}

