/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Date;
import junit.framework.AssertionFailedError;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.cache.CacheResponseStatus;
import org.apache.hc.client5.http.cache.HttpCacheContext;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheStorage;
import org.apache.hc.client5.http.cache.ResourceFactory;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.impl.cache.BasicHttpCache;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CacheValidityPolicy;
import org.apache.hc.client5.http.impl.cache.CacheableRequestPolicy;
import org.apache.hc.client5.http.impl.cache.CachedHttpResponseGenerator;
import org.apache.hc.client5.http.impl.cache.CachedResponseSuitabilityChecker;
import org.apache.hc.client5.http.impl.cache.CachingExec;
import org.apache.hc.client5.http.impl.cache.ConditionalRequestBuilder;
import org.apache.hc.client5.http.impl.cache.DummyBackend;
import org.apache.hc.client5.http.impl.cache.HeapResourceFactory;
import org.apache.hc.client5.http.impl.cache.HttpCache;
import org.apache.hc.client5.http.impl.cache.HttpTestUtils;
import org.apache.hc.client5.http.impl.cache.RequestEquivalent;
import org.apache.hc.client5.http.impl.cache.RequestProtocolCompliance;
import org.apache.hc.client5.http.impl.cache.RequestProtocolError;
import org.apache.hc.client5.http.impl.cache.ResponseCachingPolicy;
import org.apache.hc.client5.http.impl.cache.ResponseEquivalent;
import org.apache.hc.client5.http.impl.cache.ResponseProtocolCompliance;
import org.apache.hc.client5.http.impl.classic.ClassicRequestCopier;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.easymock.IExpectationSetters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class TestCachingExecChain {
    private CachingExec impl;
    protected CacheValidityPolicy mockValidityPolicy;
    protected CacheableRequestPolicy mockRequestPolicy;
    protected ExecChain mockExecChain;
    protected ExecRuntime mockEndpoint;
    protected HttpCache mockCache;
    private HttpCacheStorage mockStorage;
    protected CachedResponseSuitabilityChecker mockSuitabilityChecker;
    protected ResponseCachingPolicy mockResponsePolicy;
    protected HttpCacheEntry mockCacheEntry;
    protected CachedHttpResponseGenerator mockResponseGenerator;
    private HttpClientResponseHandler<Object> mockHandler;
    private ClassicHttpRequest mockUriRequest;
    protected ConditionalRequestBuilder<ClassicHttpRequest> mockConditionalRequestBuilder;
    private HttpRequest mockConditionalRequest;
    protected ResponseProtocolCompliance mockResponseProtocolCompliance;
    protected RequestProtocolCompliance mockRequestProtocolCompliance;
    protected CacheConfig config;
    protected HttpRoute route;
    protected HttpHost host;
    protected ClassicHttpRequest request;
    protected HttpCacheContext context;
    protected HttpCacheEntry entry;

    @Before
    public void setUp() {
        this.mockRequestPolicy = (CacheableRequestPolicy)org.easymock.classextension.EasyMock.createNiceMock(CacheableRequestPolicy.class);
        this.mockValidityPolicy = (CacheValidityPolicy)org.easymock.classextension.EasyMock.createNiceMock(CacheValidityPolicy.class);
        this.mockEndpoint = (ExecRuntime)org.easymock.classextension.EasyMock.createNiceMock(ExecRuntime.class);
        this.mockExecChain = (ExecChain)org.easymock.classextension.EasyMock.createNiceMock(ExecChain.class);
        this.mockCache = (HttpCache)org.easymock.classextension.EasyMock.createNiceMock(HttpCache.class);
        this.mockSuitabilityChecker = (CachedResponseSuitabilityChecker)org.easymock.classextension.EasyMock.createNiceMock(CachedResponseSuitabilityChecker.class);
        this.mockResponsePolicy = (ResponseCachingPolicy)org.easymock.classextension.EasyMock.createNiceMock(ResponseCachingPolicy.class);
        this.mockHandler = (HttpClientResponseHandler)org.easymock.classextension.EasyMock.createNiceMock(HttpClientResponseHandler.class);
        this.mockUriRequest = (ClassicHttpRequest)org.easymock.classextension.EasyMock.createNiceMock(ClassicHttpRequest.class);
        this.mockCacheEntry = (HttpCacheEntry)org.easymock.classextension.EasyMock.createNiceMock(HttpCacheEntry.class);
        this.mockResponseGenerator = (CachedHttpResponseGenerator)org.easymock.classextension.EasyMock.createNiceMock(CachedHttpResponseGenerator.class);
        this.mockConditionalRequestBuilder = (ConditionalRequestBuilder)org.easymock.classextension.EasyMock.createNiceMock(ConditionalRequestBuilder.class);
        this.mockConditionalRequest = (HttpRequest)org.easymock.classextension.EasyMock.createNiceMock(HttpRequest.class);
        this.mockResponseProtocolCompliance = (ResponseProtocolCompliance)org.easymock.classextension.EasyMock.createNiceMock(ResponseProtocolCompliance.class);
        this.mockRequestProtocolCompliance = (RequestProtocolCompliance)org.easymock.classextension.EasyMock.createNiceMock(RequestProtocolCompliance.class);
        this.mockStorage = (HttpCacheStorage)org.easymock.classextension.EasyMock.createNiceMock(HttpCacheStorage.class);
        this.config = CacheConfig.DEFAULT;
        this.host = new HttpHost("foo.example.com", 80);
        this.route = new HttpRoute(this.host);
        this.request = new BasicClassicHttpRequest("GET", "/stuff");
        this.context = HttpCacheContext.create();
        this.entry = HttpTestUtils.makeCacheEntry();
        this.impl = this.createCachingExecChain(this.mockCache, this.mockValidityPolicy, this.mockResponsePolicy, this.mockResponseGenerator, this.mockRequestPolicy, this.mockSuitabilityChecker, this.mockConditionalRequestBuilder, this.mockResponseProtocolCompliance, this.mockRequestProtocolCompliance, this.config);
    }

    public abstract CachingExec createCachingExecChain(HttpCache var1, CacheValidityPolicy var2, ResponseCachingPolicy var3, CachedHttpResponseGenerator var4, CacheableRequestPolicy var5, CachedResponseSuitabilityChecker var6, ConditionalRequestBuilder<ClassicHttpRequest> var7, ResponseProtocolCompliance var8, RequestProtocolCompliance var9, CacheConfig var10);

    public abstract CachingExec createCachingExecChain(HttpCache var1, CacheConfig var2);

    protected ClassicHttpResponse execute(ClassicHttpRequest request) throws IOException, HttpException {
        return this.impl.execute(ClassicRequestCopier.INSTANCE.copy(request), new ExecChain.Scope("test", this.route, request, this.mockEndpoint, (HttpClientContext)this.context), this.mockExecChain);
    }

    public static ClassicHttpRequest eqRequest(ClassicHttpRequest in) {
        EasyMock.reportMatcher((IArgumentMatcher)new RequestEquivalent((HttpRequest)in));
        return null;
    }

    public static <R extends HttpResponse> R eqResponse(R in) {
        EasyMock.reportMatcher((IArgumentMatcher)new ResponseEquivalent(in));
        return null;
    }

    protected void replayMocks() {
        org.easymock.classextension.EasyMock.replay((Object[])new Object[]{this.mockRequestPolicy});
        org.easymock.classextension.EasyMock.replay((Object[])new Object[]{this.mockValidityPolicy});
        org.easymock.classextension.EasyMock.replay((Object[])new Object[]{this.mockSuitabilityChecker});
        org.easymock.classextension.EasyMock.replay((Object[])new Object[]{this.mockResponsePolicy});
        org.easymock.classextension.EasyMock.replay((Object[])new Object[]{this.mockCacheEntry});
        org.easymock.classextension.EasyMock.replay((Object[])new Object[]{this.mockResponseGenerator});
        org.easymock.classextension.EasyMock.replay((Object[])new Object[]{this.mockExecChain});
        org.easymock.classextension.EasyMock.replay((Object[])new Object[]{this.mockCache});
        org.easymock.classextension.EasyMock.replay((Object[])new Object[]{this.mockHandler});
        org.easymock.classextension.EasyMock.replay((Object[])new Object[]{this.mockUriRequest});
        org.easymock.classextension.EasyMock.replay((Object[])new Object[]{this.mockConditionalRequestBuilder});
        org.easymock.classextension.EasyMock.replay((Object[])new Object[]{this.mockConditionalRequest});
        org.easymock.classextension.EasyMock.replay((Object[])new Object[]{this.mockResponseProtocolCompliance});
        org.easymock.classextension.EasyMock.replay((Object[])new Object[]{this.mockRequestProtocolCompliance});
        org.easymock.classextension.EasyMock.replay((Object[])new Object[]{this.mockStorage});
    }

    protected void verifyMocks() {
        org.easymock.classextension.EasyMock.verify((Object[])new Object[]{this.mockRequestPolicy});
        org.easymock.classextension.EasyMock.verify((Object[])new Object[]{this.mockValidityPolicy});
        org.easymock.classextension.EasyMock.verify((Object[])new Object[]{this.mockSuitabilityChecker});
        org.easymock.classextension.EasyMock.verify((Object[])new Object[]{this.mockResponsePolicy});
        org.easymock.classextension.EasyMock.verify((Object[])new Object[]{this.mockCacheEntry});
        org.easymock.classextension.EasyMock.verify((Object[])new Object[]{this.mockResponseGenerator});
        org.easymock.classextension.EasyMock.verify((Object[])new Object[]{this.mockExecChain});
        org.easymock.classextension.EasyMock.verify((Object[])new Object[]{this.mockCache});
        org.easymock.classextension.EasyMock.verify((Object[])new Object[]{this.mockHandler});
        org.easymock.classextension.EasyMock.verify((Object[])new Object[]{this.mockUriRequest});
        org.easymock.classextension.EasyMock.verify((Object[])new Object[]{this.mockConditionalRequestBuilder});
        org.easymock.classextension.EasyMock.verify((Object[])new Object[]{this.mockConditionalRequest});
        org.easymock.classextension.EasyMock.verify((Object[])new Object[]{this.mockResponseProtocolCompliance});
        org.easymock.classextension.EasyMock.verify((Object[])new Object[]{this.mockRequestProtocolCompliance});
        org.easymock.classextension.EasyMock.verify((Object[])new Object[]{this.mockStorage});
    }

    @Test
    public void testCacheableResponsesGoIntoCache() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        this.replayMocks();
        this.execute(req1);
        this.execute(req2);
        this.verifyMocks();
    }

    @Test
    public void testOlderCacheableResponsesDoNotGoIntoCache() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        Date now = new Date();
        Date fiveSecondsAgo = new Date(now.getTime() - 5000L);
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Etag", (Object)"\"new-etag\"");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        req2.setHeader("Cache-Control", (Object)"no-cache");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("ETag", (Object)"\"old-etag\"");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)fiveSecondsAgo));
        resp2.setHeader("Cache-Control", (Object)"max-age=3600");
        this.backendExpectsAnyRequestAndReturn(resp2);
        ClassicHttpRequest req3 = HttpTestUtils.makeDefaultRequest();
        this.replayMocks();
        this.execute(req1);
        this.execute(req2);
        ClassicHttpResponse result = this.execute(req3);
        this.verifyMocks();
        Assert.assertEquals((Object)"\"new-etag\"", (Object)result.getFirstHeader("ETag").getValue());
    }

    @Test
    public void testNewerCacheableResponsesReplaceExistingCacheEntry() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        Date now = new Date();
        Date fiveSecondsAgo = new Date(now.getTime() - 5000L);
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)fiveSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"max-age=3600");
        resp1.setHeader("Etag", (Object)"\"old-etag\"");
        this.backendExpectsAnyRequestAndReturn(resp1);
        ClassicHttpRequest req2 = HttpTestUtils.makeDefaultRequest();
        req2.setHeader("Cache-Control", (Object)"max-age=0");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("ETag", (Object)"\"new-etag\"");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp2.setHeader("Cache-Control", (Object)"max-age=3600");
        this.backendExpectsAnyRequestAndReturn(resp2);
        ClassicHttpRequest req3 = HttpTestUtils.makeDefaultRequest();
        this.replayMocks();
        this.execute(req1);
        this.execute(req2);
        ClassicHttpResponse result = this.execute(req3);
        this.verifyMocks();
        Assert.assertEquals((Object)"\"new-etag\"", (Object)result.getFirstHeader("ETag").getValue());
    }

    protected void requestIsFatallyNonCompliant(RequestProtocolError error) {
        ArrayList<RequestProtocolError> errors = new ArrayList<RequestProtocolError>();
        if (error != null) {
            errors.add(error);
        }
        EasyMock.expect((Object)this.mockRequestProtocolCompliance.requestIsFatallyNonCompliant((HttpRequest)TestCachingExecChain.eqRequest(this.request))).andReturn(errors);
    }

    @Test
    public void testSuitableCacheEntryDoesNotCauseBackendRequest() throws Exception {
        this.requestPolicyAllowsCaching(true);
        this.getCacheEntryReturns(this.mockCacheEntry);
        this.cacheEntrySuitable(true);
        this.responseIsGeneratedFromCache(SimpleHttpResponse.create((int)200));
        this.requestIsFatallyNonCompliant(null);
        this.entryHasStaleness(0L);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(this.request);
        this.verifyMocks();
    }

    @Test
    public void testNonCacheableResponseIsNotCachedAndIsReturnedAsIs() throws Exception {
        CacheConfig configDefault = CacheConfig.DEFAULT;
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache((ResourceFactory)new HeapResourceFactory(), this.mockStorage), configDefault);
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Cache-Control", (Object)"no-cache");
        EasyMock.expect((Object)this.mockStorage.getEntry((String)EasyMock.isA(String.class))).andReturn(null).anyTimes();
        this.mockStorage.removeEntry((String)EasyMock.isA(String.class));
        EasyMock.expectLastCall().anyTimes();
        this.backendExpectsAnyRequestAndReturn(resp1);
        this.replayMocks();
        ClassicHttpResponse result = this.execute(req1);
        this.verifyMocks();
        Assert.assertTrue((boolean)HttpTestUtils.semanticallyTransparent(resp1, result));
    }

    @Test
    public void testResponseIsGeneratedWhenCacheEntryIsUsable() throws Exception {
        this.requestIsFatallyNonCompliant(null);
        this.requestPolicyAllowsCaching(true);
        this.cacheEntrySuitable(true);
        this.getCacheEntryReturns(this.mockCacheEntry);
        this.responseIsGeneratedFromCache(SimpleHttpResponse.create((int)200));
        this.entryHasStaleness(0L);
        this.replayMocks();
        this.execute(this.request);
        this.verifyMocks();
    }

    @Test
    public void testSetsModuleGeneratedResponseContextForCacheOptionsResponse() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        BasicClassicHttpRequest req = new BasicClassicHttpRequest("OPTIONS", "*");
        req.setHeader("Max-Forwards", (Object)"0");
        this.execute((ClassicHttpRequest)req);
        Assert.assertEquals((Object)CacheResponseStatus.CACHE_MODULE_RESPONSE, (Object)this.context.getCacheResponseStatus());
    }

    @Test
    public void testSetsModuleGeneratedResponseContextForFatallyNoncompliantRequest() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req = new HttpGet("http://foo.example.com/");
        req.setHeader("Range", (Object)"bytes=0-50");
        req.setHeader("If-Range", (Object)"W/\"weak-etag\"");
        this.execute((ClassicHttpRequest)req);
        Assert.assertEquals((Object)CacheResponseStatus.CACHE_MODULE_RESPONSE, (Object)this.context.getCacheResponseStatus());
    }

    @Test
    public void testRecordsClientProtocolInViaHeaderIfRequestNotServableFromCache() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        BasicClassicHttpRequest originalRequest = new BasicClassicHttpRequest("GET", "/");
        originalRequest.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        BasicClassicHttpRequest req = originalRequest;
        req.setHeader("Cache-Control", (Object)"no-cache");
        BasicClassicHttpResponse resp = new BasicClassicHttpResponse(204, "No Content");
        Capture cap = new Capture();
        this.backendCaptureRequestAndReturn((Capture<ClassicHttpRequest>)cap, (ClassicHttpResponse)resp);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req);
        this.verifyMocks();
        HttpRequest captured = (HttpRequest)cap.getValue();
        String via = captured.getFirstHeader("Via").getValue();
        String proto = via.split("\\s+")[0];
        Assert.assertTrue(("http/1.0".equalsIgnoreCase(proto) || "1.0".equalsIgnoreCase(proto) ? 1 : 0) != 0);
    }

    @Test
    public void testSetsCacheMissContextIfRequestNotServableFromCache() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req = new HttpGet("http://foo.example.com/");
        req.setHeader("Cache-Control", (Object)"no-cache");
        BasicClassicHttpResponse resp = new BasicClassicHttpResponse(204, "No Content");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req);
        this.verifyMocks();
        Assert.assertEquals((Object)CacheResponseStatus.CACHE_MISS, (Object)this.context.getCacheResponseStatus());
    }

    @Test
    public void testSetsViaHeaderOnResponseIfRequestNotServableFromCache() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req = new HttpGet("http://foo.example.com/");
        req.setHeader("Cache-Control", (Object)"no-cache");
        BasicClassicHttpResponse resp = new BasicClassicHttpResponse(204, "No Content");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp);
        this.replayMocks();
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req);
        this.verifyMocks();
        Assert.assertNotNull((Object)result.getFirstHeader("Via"));
    }

    @Test
    public void testSetsViaHeaderOnResponseForCacheMiss() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=3600");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.replayMocks();
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req1);
        this.verifyMocks();
        Assert.assertNotNull((Object)result.getFirstHeader("Via"));
    }

    @Test
    public void testSetsCacheHitContextIfRequestServedFromCache() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=3600");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((Object)CacheResponseStatus.CACHE_HIT, (Object)this.context.getCacheResponseStatus());
    }

    @Test
    public void testSetsViaHeaderOnResponseIfRequestServedFromCache() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=3600");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertNotNull((Object)result.getFirstHeader("Via"));
    }

    @Test
    public void testReturns304ForIfModifiedSinceHeaderIfRequestServedFromCache() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        req2.addHeader("If-Modified-Since", (Object)DateUtils.formatDate((Date)now));
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=3600");
        resp1.setHeader("Last-Modified", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)304L, (long)result.getCode());
    }

    @Test
    public void testReturns304ForIfModifiedSinceHeaderIf304ResponseInCache() throws Exception {
        Date now = new Date();
        Date oneHourAgo = new Date(now.getTime() - 3600000L);
        Date inTenMinutes = new Date(now.getTime() + 600000L);
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        req1.addHeader("If-Modified-Since", (Object)DateUtils.formatDate((Date)oneHourAgo));
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        req2.addHeader("If-Modified-Since", (Object)DateUtils.formatDate((Date)oneHourAgo));
        ClassicHttpResponse resp1 = HttpTestUtils.make304Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp1.setHeader("Cache-control", (Object)"max-age=600");
        resp1.setHeader("Expires", (Object)DateUtils.formatDate((Date)inTenMinutes));
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andReturn((Object)resp1).once();
        EasyMock.expect((Object)this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class))).andThrow((Throwable)new AssertionFailedError("Should have reused cached 304 response")).anyTimes();
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)304L, (long)result.getCode());
        Assert.assertFalse((boolean)result.containsHeader("Last-Modified"));
    }

    @Test
    public void testReturns200ForIfModifiedSinceDateIsLess() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=3600");
        resp1.setHeader("Last-Modified", (Object)DateUtils.formatDate((Date)new Date()));
        req2.addHeader("If-Modified-Since", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result.getCode());
    }

    @Test
    public void testReturns200ForIfModifiedSinceDateIsInvalid() throws Exception {
        Date now = new Date();
        Date tenSecondsAfter = new Date(now.getTime() + 10000L);
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=3600");
        resp1.setHeader("Last-Modified", (Object)DateUtils.formatDate((Date)new Date()));
        req2.addHeader("If-Modified-Since", (Object)DateUtils.formatDate((Date)tenSecondsAfter));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1).times(2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result.getCode());
    }

    @Test
    public void testReturns304ForIfNoneMatchHeaderIfRequestServedFromCache() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        req2.addHeader("If-None-Match", (Object)"*");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=3600");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)304L, (long)result.getCode());
    }

    @Test
    public void testReturns200ForIfNoneMatchHeaderFails() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=3600");
        req2.addHeader("If-None-Match", (Object)"\"abc\"");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result.getCode());
    }

    @Test
    public void testReturns304ForIfNoneMatchHeaderAndIfModifiedSinceIfRequestServedFromCache() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=3600");
        resp1.setHeader("Last-Modified", (Object)DateUtils.formatDate((Date)new Date()));
        req2.addHeader("If-None-Match", (Object)"*");
        req2.addHeader("If-Modified-Since", (Object)DateUtils.formatDate((Date)now));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)304L, (long)result.getCode());
    }

    @Test
    public void testReturns200ForIfNoneMatchHeaderFailsIfModifiedSinceIgnored() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        req2.addHeader("If-None-Match", (Object)"\"abc\"");
        req2.addHeader("If-Modified-Since", (Object)DateUtils.formatDate((Date)now));
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=3600");
        resp1.setHeader("Last-Modified", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result.getCode());
    }

    @Test
    public void testReturns200ForOptionsFollowedByGetIfAuthorizationHeaderAndSharedCache() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.custom().setSharedCache(true).build());
        Date now = new Date();
        HttpOptions req1 = new HttpOptions("http://foo.example.com/");
        req1.setHeader("Authorization", (Object)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        req2.setHeader("Authorization", (Object)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(204, "No Content");
        resp1.setHeader("Content-Length", (Object)"0");
        resp1.setHeader("ETag", (Object)"\"options-etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=3600");
        resp1.setHeader("Last-Modified", (Object)DateUtils.formatDate((Date)now));
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("ETag", (Object)"\"get-etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=3600");
        resp1.setHeader("Last-Modified", (Object)DateUtils.formatDate((Date)now));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result.getCode());
    }

    @Test
    public void testSetsValidatedContextIfRequestWasSuccessfullyValidated() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=5");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(200, "OK");
        resp2.setEntity(HttpTestUtils.makeBody(128));
        resp2.setHeader("Content-Length", (Object)"128");
        resp2.setHeader("ETag", (Object)"\"etag\"");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp2.setHeader("Cache-Control", (Object)"public, max-age=5");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((Object)CacheResponseStatus.VALIDATED, (Object)this.context.getCacheResponseStatus());
    }

    @Test
    public void testSetsViaHeaderIfRequestWasSuccessfullyValidated() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=5");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(200, "OK");
        resp2.setEntity(HttpTestUtils.makeBody(128));
        resp2.setHeader("Content-Length", (Object)"128");
        resp2.setHeader("ETag", (Object)"\"etag\"");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp2.setHeader("Cache-Control", (Object)"public, max-age=5");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertNotNull((Object)result.getFirstHeader("Via"));
    }

    @Test
    public void testSetsModuleResponseContextIfValidationRequiredButFailed() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=5, must-revalidate");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.backendExpectsAnyRequestAndThrows(new IOException());
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((Object)CacheResponseStatus.CACHE_MODULE_RESPONSE, (Object)this.context.getCacheResponseStatus());
    }

    @Test
    public void testSetsModuleResponseContextIfValidationFailsButNotRequired() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=5");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.backendExpectsAnyRequestAndThrows(new IOException());
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((Object)CacheResponseStatus.CACHE_HIT, (Object)this.context.getCacheResponseStatus());
    }

    @Test
    public void testSetViaHeaderIfValidationFailsButNotRequired() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=5");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.backendExpectsAnyRequestAndThrows(new IOException());
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertNotNull((Object)result.getFirstHeader("Via"));
    }

    @Test
    public void testReturns304ForIfNoneMatchPassesIfRequestServedFromOrigin() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=5");
        req2.addHeader("If-None-Match", (Object)"\"etag\"");
        ClassicHttpResponse resp2 = HttpTestUtils.make304Response();
        resp2.setHeader("ETag", (Object)"\"etag\"");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp2.setHeader("Cache-Control", (Object)"public, max-age=5");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)304L, (long)result.getCode());
    }

    @Test
    public void testReturns200ForIfNoneMatchFailsIfRequestServedFromOrigin() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=5");
        req2.addHeader("If-None-Match", (Object)"\"etag\"");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(200, "OK");
        resp2.setEntity(HttpTestUtils.makeBody(128));
        resp2.setHeader("Content-Length", (Object)"128");
        resp2.setHeader("ETag", (Object)"\"newetag\"");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp2.setHeader("Cache-Control", (Object)"public, max-age=5");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result.getCode());
    }

    @Test
    public void testReturns304ForIfModifiedSincePassesIfRequestServedFromOrigin() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("Last-Modified", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=5");
        req2.addHeader("If-Modified-Since", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        ClassicHttpResponse resp2 = HttpTestUtils.make304Response();
        resp2.setHeader("ETag", (Object)"\"etag\"");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("Last-Modified", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp2.setHeader("Cache-Control", (Object)"public, max-age=5");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)304L, (long)result.getCode());
    }

    @Test
    public void testReturns200ForIfModifiedSinceFailsIfRequestServedFromOrigin() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("Last-Modified", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=5");
        req2.addHeader("If-Modified-Since", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(200, "OK");
        resp2.setEntity(HttpTestUtils.makeBody(128));
        resp2.setHeader("Content-Length", (Object)"128");
        resp2.setHeader("ETag", (Object)"\"newetag\"");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp1.setHeader("Last-Modified", (Object)DateUtils.formatDate((Date)now));
        resp2.setHeader("Cache-Control", (Object)"public, max-age=5");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        this.replayMocks();
        this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result.getCode());
    }

    @Test
    public void testVariantMissServerIfReturns304CacheReturns200() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        Date now = new Date();
        HttpGet req1 = new HttpGet("http://foo.example.com");
        req1.addHeader("Accept-Encoding", (Object)"gzip");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("Etag", (Object)"\"gzip_etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp1.setHeader("Vary", (Object)"Accept-Encoding");
        resp1.setHeader("Cache-Control", (Object)"public, max-age=3600");
        HttpGet req2 = new HttpGet("http://foo.example.com");
        req2.addHeader("Accept-Encoding", (Object)"deflate");
        HttpGet req2Server = new HttpGet("http://foo.example.com");
        req2Server.addHeader("Accept-Encoding", (Object)"deflate");
        req2Server.addHeader("If-None-Match", (Object)"\"gzip_etag\"");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(200, "OK");
        resp2.setEntity(HttpTestUtils.makeBody(128));
        resp2.setHeader("Content-Length", (Object)"128");
        resp2.setHeader("Etag", (Object)"\"deflate_etag\"");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp2.setHeader("Vary", (Object)"Accept-Encoding");
        resp2.setHeader("Cache-Control", (Object)"public, max-age=3600");
        HttpGet req3 = new HttpGet("http://foo.example.com");
        req3.addHeader("Accept-Encoding", (Object)"gzip,deflate");
        HttpGet req3Server = new HttpGet("http://foo.example.com");
        req3Server.addHeader("Accept-Encoding", (Object)"gzip,deflate");
        req3Server.addHeader("If-None-Match", (Object)"\"gzip_etag\",\"deflate_etag\"");
        BasicClassicHttpResponse resp3 = new BasicClassicHttpResponse(200, "OK");
        resp3.setEntity(HttpTestUtils.makeBody(128));
        resp3.setHeader("Content-Length", (Object)"128");
        resp3.setHeader("Etag", (Object)"\"gzip_etag\"");
        resp3.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp3.setHeader("Vary", (Object)"Accept-Encoding");
        resp3.setHeader("Cache-Control", (Object)"public, max-age=3600");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp3);
        this.replayMocks();
        ClassicHttpResponse result1 = this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result2 = this.execute((ClassicHttpRequest)req2);
        ClassicHttpResponse result3 = this.execute((ClassicHttpRequest)req3);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result1.getCode());
        Assert.assertEquals((long)200L, (long)result2.getCode());
        Assert.assertEquals((long)200L, (long)result3.getCode());
    }

    @Test
    public void testVariantsMissServerReturns304CacheReturns304() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        Date now = new Date();
        HttpGet req1 = new HttpGet("http://foo.example.com");
        req1.addHeader("Accept-Encoding", (Object)"gzip");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity(HttpTestUtils.makeBody(128));
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("Etag", (Object)"\"gzip_etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp1.setHeader("Vary", (Object)"Accept-Encoding");
        resp1.setHeader("Cache-Control", (Object)"public, max-age=3600");
        HttpGet req2 = new HttpGet("http://foo.example.com");
        req2.addHeader("Accept-Encoding", (Object)"deflate");
        HttpGet req2Server = new HttpGet("http://foo.example.com");
        req2Server.addHeader("Accept-Encoding", (Object)"deflate");
        req2Server.addHeader("If-None-Match", (Object)"\"gzip_etag\"");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(200, "OK");
        resp2.setEntity(HttpTestUtils.makeBody(128));
        resp2.setHeader("Content-Length", (Object)"128");
        resp2.setHeader("Etag", (Object)"\"deflate_etag\"");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp2.setHeader("Vary", (Object)"Accept-Encoding");
        resp2.setHeader("Cache-Control", (Object)"public, max-age=3600");
        HttpGet req4 = new HttpGet("http://foo.example.com");
        req4.addHeader("Accept-Encoding", (Object)"gzip,identity");
        req4.addHeader("If-None-Match", (Object)"\"gzip_etag\"");
        HttpGet req4Server = new HttpGet("http://foo.example.com");
        req4Server.addHeader("Accept-Encoding", (Object)"gzip,identity");
        req4Server.addHeader("If-None-Match", (Object)"\"gzip_etag\"");
        ClassicHttpResponse resp4 = HttpTestUtils.make304Response();
        resp4.setHeader("Etag", (Object)"\"gzip_etag\"");
        resp4.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp4.setHeader("Vary", (Object)"Accept-Encoding");
        resp4.setHeader("Cache-Control", (Object)"public, max-age=3600");
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2);
        this.backendExpectsAnyRequestAndReturn(resp4);
        this.replayMocks();
        ClassicHttpResponse result1 = this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result2 = this.execute((ClassicHttpRequest)req2);
        ClassicHttpResponse result4 = this.execute((ClassicHttpRequest)req4);
        this.verifyMocks();
        Assert.assertEquals((long)200L, (long)result1.getCode());
        Assert.assertEquals((long)200L, (long)result2.getCode());
        Assert.assertEquals((long)304L, (long)result4.getCode());
    }

    @Test
    public void testSocketTimeoutExceptionIsNotSilentlyCatched() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        Date now = new Date();
        HttpGet req1 = new HttpGet("http://foo.example.com");
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setEntity((HttpEntity)new InputStreamEntity(new InputStream(){
            private boolean closed = false;

            @Override
            public void close() throws IOException {
                this.closed = true;
            }

            @Override
            public int read() throws IOException {
                if (this.closed) {
                    throw new SocketException("Socket closed");
                }
                throw new SocketTimeoutException("Read timed out");
            }
        }, 128L));
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp1);
        this.replayMocks();
        try {
            ClassicHttpResponse result1 = this.execute((ClassicHttpRequest)req1);
            EntityUtils.toString((HttpEntity)result1.getEntity());
            Assert.fail((String)"We should have had a SocketTimeoutException");
        }
        catch (SocketTimeoutException e) {
            // empty catch block
        }
        this.verifyMocks();
    }

    @Test
    public void testIsSharedCache() {
        Assert.assertTrue((boolean)this.config.isSharedCache());
    }

    @Test
    public void testTooLargeResponsesAreNotCached() throws Exception {
        this.mockCache = (HttpCache)EasyMock.createStrictMock(HttpCache.class);
        this.impl = this.createCachingExecChain(this.mockCache, this.mockValidityPolicy, this.mockResponsePolicy, this.mockResponseGenerator, this.mockRequestPolicy, this.mockSuitabilityChecker, this.mockConditionalRequestBuilder, this.mockResponseProtocolCompliance, this.mockRequestProtocolCompliance, this.config);
        HttpHost host = new HttpHost("foo.example.com");
        HttpGet request = new HttpGet("http://foo.example.com/bar");
        Date now = new Date();
        Date requestSent = new Date(now.getTime() - 3000L);
        Date responseGenerated = new Date(now.getTime() - 2000L);
        Date responseReceived = new Date(now.getTime() - 1000L);
        BasicClassicHttpResponse originResponse = new BasicClassicHttpResponse(200, "OK");
        originResponse.setEntity(HttpTestUtils.makeBody(8193));
        originResponse.setHeader("Cache-Control", (Object)"public, max-age=3600");
        originResponse.setHeader("Date", (Object)DateUtils.formatDate((Date)responseGenerated));
        originResponse.setHeader("ETag", (Object)"\"etag\"");
        this.replayMocks();
        this.impl.cacheAndReturnResponse(host, (HttpRequest)request, (ClassicHttpResponse)originResponse, requestSent, responseReceived);
        this.verifyMocks();
    }

    @Test
    public void testSmallEnoughResponsesAreCached() throws Exception {
        HttpHost host = new HttpHost("foo.example.com");
        HttpGet request = new HttpGet("http://foo.example.com/bar");
        Date now = new Date();
        Date requestSent = new Date(now.getTime() - 3000L);
        Date responseGenerated = new Date(now.getTime() - 2000L);
        Date responseReceived = new Date(now.getTime() - 1000L);
        BasicClassicHttpResponse originResponse = new BasicClassicHttpResponse(200, "OK");
        originResponse.setEntity(HttpTestUtils.makeBody(8191));
        originResponse.setHeader("Cache-Control", (Object)"public, max-age=3600");
        originResponse.setHeader("Date", (Object)DateUtils.formatDate((Date)responseGenerated));
        originResponse.setHeader("ETag", (Object)"\"etag\"");
        HttpCacheEntry httpCacheEntry = HttpTestUtils.makeCacheEntry();
        SimpleHttpResponse response = SimpleHttpResponse.create((int)200);
        EasyMock.expect((Object)this.mockCache.createCacheEntry((HttpHost)EasyMock.eq((Object)host), (HttpRequest)EasyMock.same((Object)request), (HttpResponse)EasyMock.same((Object)originResponse), (ByteArrayBuffer)EasyMock.isA(ByteArrayBuffer.class), (Date)EasyMock.eq((Object)requestSent), (Date)EasyMock.eq((Object)responseReceived))).andReturn((Object)httpCacheEntry).once();
        EasyMock.expect((Object)this.mockResponseGenerator.generateResponse((HttpRequest)EasyMock.same((Object)request), (HttpCacheEntry)EasyMock.same((Object)httpCacheEntry))).andReturn((Object)response).once();
        this.replayMocks();
        this.impl.cacheAndReturnResponse(host, (HttpRequest)request, (ClassicHttpResponse)originResponse, requestSent, responseReceived);
        this.verifyMocks();
    }

    @Test
    public void testIfOnlyIfCachedAndNoCacheEntryBackendNotCalled() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        this.request.addHeader("Cache-Control", (Object)"only-if-cached");
        ClassicHttpResponse resp = this.execute(this.request);
        Assert.assertEquals((long)504L, (long)resp.getCode());
    }

    @Test
    public void testIfOnlyIfCachedAndEntryNotSuitableBackendNotCalled() throws Exception {
        this.request.setHeader("Cache-Control", (Object)"only-if-cached");
        this.entry = HttpTestUtils.makeCacheEntry(new Header[]{new BasicHeader("Cache-Control", (Object)"must-revalidate")});
        this.requestIsFatallyNonCompliant(null);
        this.requestPolicyAllowsCaching(true);
        this.getCacheEntryReturns(this.entry);
        this.cacheEntrySuitable(false);
        this.replayMocks();
        ClassicHttpResponse resp = this.execute(this.request);
        this.verifyMocks();
        Assert.assertEquals((long)504L, (long)resp.getCode());
    }

    @Test
    public void testIfOnlyIfCachedAndEntryExistsAndIsSuitableReturnsEntry() throws Exception {
        this.request.setHeader("Cache-Control", (Object)"only-if-cached");
        this.requestIsFatallyNonCompliant(null);
        this.requestPolicyAllowsCaching(true);
        this.getCacheEntryReturns(this.entry);
        this.cacheEntrySuitable(true);
        this.responseIsGeneratedFromCache(SimpleHttpResponse.create((int)200));
        this.entryHasStaleness(0L);
        this.replayMocks();
        ClassicHttpResponse resp = this.execute(this.request);
        this.verifyMocks();
    }

    @Test
    public void testDoesNotSetConnectionInContextOnCacheHit() throws Exception {
        DummyBackend backend = new DummyBackend();
        ClassicHttpResponse response = HttpTestUtils.make200Response();
        response.setHeader("Cache-Control", (Object)"max-age=3600");
        backend.setResponse(response);
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpClientContext ctx = HttpClientContext.create();
        this.impl.execute(this.request, new ExecChain.Scope("test", this.route, this.request, this.mockEndpoint, (HttpClientContext)this.context), (ExecChain)backend);
        this.impl.execute(this.request, new ExecChain.Scope("test", this.route, this.request, this.mockEndpoint, ctx), (ExecChain)backend);
    }

    @Test
    public void testSetsTargetHostInContextOnCacheHit() throws Exception {
        DummyBackend backend = new DummyBackend();
        ClassicHttpResponse response = HttpTestUtils.make200Response();
        response.setHeader("Cache-Control", (Object)"max-age=3600");
        backend.setResponse(response);
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpClientContext ctx = HttpClientContext.create();
        this.impl.execute(this.request, new ExecChain.Scope("test", this.route, this.request, this.mockEndpoint, (HttpClientContext)this.context), (ExecChain)backend);
        this.impl.execute(this.request, new ExecChain.Scope("test", this.route, this.request, this.mockEndpoint, ctx), (ExecChain)backend);
    }

    @Test
    public void testSetsRouteInContextOnCacheHit() throws Exception {
        DummyBackend backend = new DummyBackend();
        ClassicHttpResponse response = HttpTestUtils.make200Response();
        response.setHeader("Cache-Control", (Object)"max-age=3600");
        backend.setResponse(response);
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpClientContext ctx = HttpClientContext.create();
        this.impl.execute(this.request, new ExecChain.Scope("test", this.route, this.request, this.mockEndpoint, (HttpClientContext)this.context), (ExecChain)backend);
        this.impl.execute(this.request, new ExecChain.Scope("test", this.route, this.request, this.mockEndpoint, ctx), (ExecChain)backend);
        Assert.assertEquals((Object)this.route, (Object)ctx.getHttpRoute());
    }

    @Test
    public void testSetsRequestInContextOnCacheHit() throws Exception {
        DummyBackend backend = new DummyBackend();
        ClassicHttpResponse response = HttpTestUtils.make200Response();
        response.setHeader("Cache-Control", (Object)"max-age=3600");
        backend.setResponse(response);
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpClientContext ctx = HttpClientContext.create();
        this.impl.execute(this.request, new ExecChain.Scope("test", this.route, this.request, this.mockEndpoint, (HttpClientContext)this.context), (ExecChain)backend);
        this.impl.execute(this.request, new ExecChain.Scope("test", this.route, this.request, this.mockEndpoint, ctx), (ExecChain)backend);
        if (!HttpTestUtils.equivalent((HttpRequest)this.request, ctx.getRequest())) {
            Assert.assertSame((Object)this.request, (Object)ctx.getRequest());
        }
    }

    @Test
    public void testSetsResponseInContextOnCacheHit() throws Exception {
        DummyBackend backend = new DummyBackend();
        ClassicHttpResponse response = HttpTestUtils.make200Response();
        response.setHeader("Cache-Control", (Object)"max-age=3600");
        backend.setResponse(response);
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpClientContext ctx = HttpClientContext.create();
        this.impl.execute(this.request, new ExecChain.Scope("test", this.route, this.request, this.mockEndpoint, (HttpClientContext)this.context), (ExecChain)backend);
        ClassicHttpResponse result = this.impl.execute(this.request, new ExecChain.Scope("test", this.route, this.request, this.mockEndpoint, ctx), null);
        if (!HttpTestUtils.equivalent((HttpResponse)result, ctx.getResponse())) {
            Assert.assertSame((Object)result, (Object)ctx.getResponse());
        }
    }

    @Test
    public void testSetsRequestSentInContextOnCacheHit() throws Exception {
        DummyBackend backend = new DummyBackend();
        ClassicHttpResponse response = HttpTestUtils.make200Response();
        response.setHeader("Cache-Control", (Object)"max-age=3600");
        backend.setResponse(response);
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpClientContext ctx = HttpClientContext.create();
        this.impl.execute(this.request, new ExecChain.Scope("test", this.route, this.request, this.mockEndpoint, (HttpClientContext)this.context), (ExecChain)backend);
        this.impl.execute(this.request, new ExecChain.Scope("test", this.route, this.request, this.mockEndpoint, ctx), (ExecChain)backend);
    }

    @Test
    public void testCanCacheAResponseWithoutABody() throws Exception {
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(204, "No Content");
        response.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        response.setHeader("Cache-Control", (Object)"max-age=300");
        DummyBackend backend = new DummyBackend();
        backend.setResponse((ClassicHttpResponse)response);
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        this.impl.execute(this.request, new ExecChain.Scope("test", this.route, this.request, this.mockEndpoint, (HttpClientContext)this.context), (ExecChain)backend);
        this.impl.execute(this.request, new ExecChain.Scope("test", this.route, this.request, this.mockEndpoint, (HttpClientContext)this.context), (ExecChain)backend);
        Assert.assertEquals((long)1L, (long)backend.getExecutions());
    }

    @Test
    public void testNoEntityForIfNoneMatchRequestNotYetInCache() throws Exception {
        Date now = new Date();
        Date tenSecondsAgo = new Date(now.getTime() - 10000L);
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        req1.addHeader("If-None-Match", (Object)"\"etag\"");
        ClassicHttpResponse resp1 = HttpTestUtils.make304Response();
        resp1.setHeader("Content-Length", (Object)"128");
        resp1.setHeader("ETag", (Object)"\"etag\"");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)tenSecondsAgo));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=5");
        this.backendExpectsAnyRequestAndReturn(resp1);
        this.replayMocks();
        ClassicHttpResponse result = this.execute((ClassicHttpRequest)req1);
        this.verifyMocks();
        Assert.assertEquals((long)304L, (long)result.getCode());
        Assert.assertNull((String)"The 304 response messages MUST NOT contain a message-body", (Object)result.getEntity());
    }

    @Test
    public void testNotModifiedResponseUpdatesCacheEntryWhenNoEntity() throws Exception {
        Date now = new Date();
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        req1.addHeader("If-None-Match", (Object)"etag");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        req2.addHeader("If-None-Match", (Object)"etag");
        ClassicHttpResponse resp1 = HttpTestUtils.make304Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp1.setHeader("Cache-Control", (Object)"max-age=0");
        resp1.setHeader("Etag", (Object)"etag");
        ClassicHttpResponse resp2 = HttpTestUtils.make304Response();
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp2.setHeader("Cache-Control", (Object)"max-age=0");
        resp1.setHeader("Etag", (Object)"etag");
        this.backendExpectsAnyRequestAndReturn(resp1);
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        ClassicHttpResponse result1 = this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result2 = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)304L, (long)result1.getCode());
        Assert.assertEquals((Object)"etag", (Object)result1.getFirstHeader("Etag").getValue());
        Assert.assertEquals((long)304L, (long)result2.getCode());
        Assert.assertEquals((Object)"etag", (Object)result2.getFirstHeader("Etag").getValue());
    }

    @Test
    public void testNotModifiedResponseWithVaryUpdatesCacheEntryWhenNoEntity() throws Exception {
        Date now = new Date();
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        req1.addHeader("If-None-Match", (Object)"etag");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        req2.addHeader("If-None-Match", (Object)"etag");
        ClassicHttpResponse resp1 = HttpTestUtils.make304Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp1.setHeader("Cache-Control", (Object)"max-age=0");
        resp1.setHeader("Etag", (Object)"etag");
        resp1.setHeader("Vary", (Object)"Accept-Encoding");
        ClassicHttpResponse resp2 = HttpTestUtils.make304Response();
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp2.setHeader("Cache-Control", (Object)"max-age=0");
        resp1.setHeader("Etag", (Object)"etag");
        resp1.setHeader("Vary", (Object)"Accept-Encoding");
        this.backendExpectsAnyRequestAndReturn(resp1);
        this.backendExpectsAnyRequestAndReturn(resp2);
        this.replayMocks();
        ClassicHttpResponse result1 = this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result2 = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)304L, (long)result1.getCode());
        Assert.assertEquals((Object)"etag", (Object)result1.getFirstHeader("Etag").getValue());
        Assert.assertEquals((long)304L, (long)result2.getCode());
        Assert.assertEquals((Object)"etag", (Object)result2.getFirstHeader("Etag").getValue());
    }

    @Test
    public void testDoesNotSend304ForNonConditionalRequest() throws Exception {
        Date now = new Date();
        Date inOneMinute = new Date(System.currentTimeMillis() + 60000L);
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        HttpGet req1 = new HttpGet("http://foo.example.com/");
        req1.addHeader("If-None-Match", (Object)"etag");
        HttpGet req2 = new HttpGet("http://foo.example.com/");
        ClassicHttpResponse resp1 = HttpTestUtils.make304Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp1.setHeader("Cache-Control", (Object)"public, max-age=60");
        resp1.setHeader("Expires", (Object)DateUtils.formatDate((Date)inOneMinute));
        resp1.setHeader("Etag", (Object)"etag");
        resp1.setHeader("Vary", (Object)"Accept-Encoding");
        BasicClassicHttpResponse resp2 = new BasicClassicHttpResponse(200, "Ok");
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)now));
        resp2.setHeader("Cache-Control", (Object)"public, max-age=60");
        resp2.setHeader("Expires", (Object)DateUtils.formatDate((Date)inOneMinute));
        resp2.setHeader("Etag", (Object)"etag");
        resp2.setHeader("Vary", (Object)"Accept-Encoding");
        resp2.setEntity(HttpTestUtils.makeBody(128));
        this.backendExpectsAnyRequestAndReturn(resp1);
        this.backendExpectsAnyRequestAndReturn((ClassicHttpResponse)resp2).anyTimes();
        this.replayMocks();
        ClassicHttpResponse result1 = this.execute((ClassicHttpRequest)req1);
        ClassicHttpResponse result2 = this.execute((ClassicHttpRequest)req2);
        this.verifyMocks();
        Assert.assertEquals((long)304L, (long)result1.getCode());
        Assert.assertNull((Object)result1.getEntity());
        Assert.assertEquals((long)200L, (long)result2.getCode());
        Assert.assertNotNull((Object)result2.getEntity());
    }

    @Test
    public void testUsesVirtualHostForCacheKey() throws Exception {
        DummyBackend backend = new DummyBackend();
        ClassicHttpResponse response = HttpTestUtils.make200Response();
        response.setHeader("Cache-Control", (Object)"max-age=3600");
        backend.setResponse(response);
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        this.impl.execute(this.request, new ExecChain.Scope("test", this.route, this.request, this.mockEndpoint, (HttpClientContext)this.context), (ExecChain)backend);
        Assert.assertEquals((long)1L, (long)backend.getExecutions());
        this.request.setAuthority(new URIAuthority("bar.example.com"));
        this.impl.execute(this.request, new ExecChain.Scope("test", this.route, this.request, this.mockEndpoint, (HttpClientContext)this.context), (ExecChain)backend);
        Assert.assertEquals((long)2L, (long)backend.getExecutions());
        this.impl.execute(this.request, new ExecChain.Scope("test", this.route, this.request, this.mockEndpoint, (HttpClientContext)this.context), (ExecChain)backend);
        Assert.assertEquals((long)2L, (long)backend.getExecutions());
    }

    protected IExpectationSetters<ClassicHttpResponse> backendExpectsRequestAndReturn(ClassicHttpRequest request, ClassicHttpResponse response) throws Exception {
        ClassicHttpResponse resp = this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.eq((Object)request), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class));
        return EasyMock.expect((Object)resp).andReturn((Object)response);
    }

    private IExpectationSetters<ClassicHttpResponse> backendExpectsAnyRequestAndReturn(ClassicHttpResponse response) throws Exception {
        ClassicHttpResponse resp = this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class));
        return EasyMock.expect((Object)resp).andReturn((Object)response);
    }

    protected IExpectationSetters<ClassicHttpResponse> backendExpectsAnyRequestAndThrows(Throwable throwable) throws Exception {
        ClassicHttpResponse resp = this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class));
        return EasyMock.expect((Object)resp).andThrow(throwable);
    }

    protected IExpectationSetters<ClassicHttpResponse> backendCaptureRequestAndReturn(Capture<ClassicHttpRequest> cap, ClassicHttpResponse response) throws Exception {
        ClassicHttpResponse resp = this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.capture(cap), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class));
        return EasyMock.expect((Object)resp).andReturn((Object)response);
    }

    protected void getCacheEntryReturns(HttpCacheEntry result) throws IOException {
        EasyMock.expect((Object)this.mockCache.getCacheEntry((HttpHost)EasyMock.eq((Object)this.host), (HttpRequest)TestCachingExecChain.eqRequest(this.request))).andReturn((Object)result);
    }

    private void cacheInvalidatorWasCalled() throws IOException {
        this.mockCache.flushInvalidatedCacheEntriesFor((HttpHost)EasyMock.anyObject(), (HttpRequest)EasyMock.anyObject());
    }

    protected void cacheEntryValidatable(boolean b) {
        EasyMock.expect((Object)this.mockValidityPolicy.isRevalidatable((HttpCacheEntry)EasyMock.anyObject())).andReturn((Object)b).anyTimes();
    }

    protected void cacheEntryMustRevalidate(boolean b) {
        EasyMock.expect((Object)this.mockValidityPolicy.mustRevalidate(this.mockCacheEntry)).andReturn((Object)b);
    }

    protected void cacheEntryProxyRevalidate(boolean b) {
        EasyMock.expect((Object)this.mockValidityPolicy.proxyRevalidate(this.mockCacheEntry)).andReturn((Object)b);
    }

    protected void mayReturnStaleWhileRevalidating(boolean b) {
        EasyMock.expect((Object)this.mockValidityPolicy.mayReturnStaleWhileRevalidating((HttpCacheEntry)EasyMock.anyObject(), (Date)EasyMock.anyObject())).andReturn((Object)b);
    }

    protected void conditionalRequestBuilderReturns(ClassicHttpRequest validate) throws Exception {
        EasyMock.expect((Object)this.mockConditionalRequestBuilder.buildConditionalRequest((HttpRequest)this.request, this.entry)).andReturn((Object)validate);
    }

    protected void requestPolicyAllowsCaching(boolean allow) {
        EasyMock.expect((Object)this.mockRequestPolicy.isServableFromCache((HttpRequest)EasyMock.anyObject())).andReturn((Object)allow);
    }

    protected void cacheEntrySuitable(boolean suitable) {
        EasyMock.expect((Object)this.mockSuitabilityChecker.canCachedResponseBeUsed((HttpHost)EasyMock.anyObject(), (HttpRequest)EasyMock.anyObject(), (HttpCacheEntry)EasyMock.anyObject(), (Date)EasyMock.anyObject())).andReturn((Object)suitable);
    }

    private void entryHasStaleness(long staleness) {
        EasyMock.expect((Object)this.mockValidityPolicy.getStalenessSecs((HttpCacheEntry)EasyMock.anyObject(), (Date)EasyMock.anyObject())).andReturn((Object)staleness);
    }

    protected void responseIsGeneratedFromCache(SimpleHttpResponse cachedResponse) throws IOException {
        EasyMock.expect((Object)this.mockResponseGenerator.generateResponse((HttpRequest)((ClassicHttpRequest)EasyMock.anyObject()), (HttpCacheEntry)EasyMock.anyObject())).andReturn((Object)cachedResponse);
    }

    protected void doesNotFlushCache() throws IOException {
        this.mockCache.flushInvalidatedCacheEntriesFor((HttpHost)EasyMock.isA(HttpHost.class), (HttpRequest)EasyMock.isA(HttpRequest.class));
        EasyMock.expectLastCall().andThrow((Throwable)((Object)new AssertionError((Object)"flushInvalidatedCacheEntriesFor should not have been called"))).anyTimes();
    }
}

