/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.cache.BasicHttpCache;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CacheValidityPolicy;
import org.apache.hc.client5.http.impl.cache.CacheableRequestPolicy;
import org.apache.hc.client5.http.impl.cache.CachedHttpResponseGenerator;
import org.apache.hc.client5.http.impl.cache.CachedResponseSuitabilityChecker;
import org.apache.hc.client5.http.impl.cache.CachingExec;
import org.apache.hc.client5.http.impl.cache.ConditionalRequestBuilder;
import org.apache.hc.client5.http.impl.cache.HttpCache;
import org.apache.hc.client5.http.impl.cache.HttpTestUtils;
import org.apache.hc.client5.http.impl.cache.RequestProtocolCompliance;
import org.apache.hc.client5.http.impl.cache.ResponseCachingPolicy;
import org.apache.hc.client5.http.impl.cache.ResponseProtocolCompliance;
import org.apache.hc.client5.http.impl.cache.TestCachingExecChain;
import org.apache.hc.client5.http.impl.cache.Variant;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestCachingExec
extends TestCachingExecChain {
    private static final String GET_CURRENT_DATE = "getCurrentDate";
    private static final String HANDLE_BACKEND_RESPONSE = "handleBackendResponse";
    private static final String CALL_BACKEND = "callBackend";
    private static final String REVALIDATE_CACHE_ENTRY = "revalidateCacheEntry";
    private CachingExec impl;
    private boolean mockedImpl;
    private ExecChain.Scope scope;
    private ClassicHttpResponse mockBackendResponse;
    private Date requestDate;
    private Date responseDate;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.scope = new ExecChain.Scope("test", this.route, this.request, this.mockEndpoint, (HttpClientContext)this.context);
        this.mockBackendResponse = (ClassicHttpResponse)org.easymock.classextension.EasyMock.createNiceMock(ClassicHttpResponse.class);
        this.requestDate = new Date(System.currentTimeMillis() - 1000L);
        this.responseDate = new Date();
    }

    @Override
    public CachingExec createCachingExecChain(HttpCache mockCache, CacheValidityPolicy mockValidityPolicy, ResponseCachingPolicy mockResponsePolicy, CachedHttpResponseGenerator mockResponseGenerator, CacheableRequestPolicy mockRequestPolicy, CachedResponseSuitabilityChecker mockSuitabilityChecker, ConditionalRequestBuilder<ClassicHttpRequest> mockConditionalRequestBuilder, ResponseProtocolCompliance mockResponseProtocolCompliance, RequestProtocolCompliance mockRequestProtocolCompliance, CacheConfig config) {
        this.impl = new CachingExec(mockCache, mockValidityPolicy, mockResponsePolicy, mockResponseGenerator, mockRequestPolicy, mockSuitabilityChecker, mockConditionalRequestBuilder, mockResponseProtocolCompliance, mockRequestProtocolCompliance, config);
        return this.impl;
    }

    @Override
    public CachingExec createCachingExecChain(HttpCache cache, CacheConfig config) {
        this.impl = new CachingExec(cache, config);
        return this.impl;
    }

    @Override
    protected void replayMocks() {
        super.replayMocks();
        org.easymock.classextension.EasyMock.replay((Object[])new Object[]{this.mockBackendResponse});
        if (this.mockedImpl) {
            org.easymock.classextension.EasyMock.replay((Object[])new Object[]{this.impl});
        }
    }

    @Override
    protected void verifyMocks() {
        super.verifyMocks();
        org.easymock.classextension.EasyMock.verify((Object[])new Object[]{this.mockBackendResponse});
        if (this.mockedImpl) {
            org.easymock.classextension.EasyMock.verify((Object[])new Object[]{this.impl});
        }
    }

    @Test
    public void testRequestThatCannotBeServedFromCacheCausesBackendRequest() throws Exception {
        this.cacheInvalidatorWasCalled();
        this.requestPolicyAllowsCaching(false);
        this.mockImplMethods(CALL_BACKEND);
        this.implExpectsAnyRequestAndReturn(this.mockBackendResponse);
        this.requestIsFatallyNonCompliant(null);
        this.replayMocks();
        ClassicHttpResponse result = this.impl.execute(this.request, this.scope, this.mockExecChain);
        this.verifyMocks();
        Assert.assertSame((Object)this.mockBackendResponse, (Object)result);
    }

    @Test
    public void testCacheMissCausesBackendRequest() throws Exception {
        this.mockImplMethods(CALL_BACKEND);
        this.requestPolicyAllowsCaching(true);
        this.getCacheEntryReturns(null);
        this.getVariantCacheEntriesReturns(new HashMap<String, Variant>());
        this.requestIsFatallyNonCompliant(null);
        this.implExpectsAnyRequestAndReturn(this.mockBackendResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.impl.execute(this.request, this.scope, this.mockExecChain);
        this.verifyMocks();
        Assert.assertSame((Object)this.mockBackendResponse, (Object)result);
        Assert.assertEquals((long)1L, (long)this.impl.getCacheMisses());
        Assert.assertEquals((long)0L, (long)this.impl.getCacheHits());
        Assert.assertEquals((long)0L, (long)this.impl.getCacheUpdates());
    }

    @Test
    public void testUnsuitableUnvalidatableCacheEntryCausesBackendRequest() throws Exception {
        this.mockImplMethods(CALL_BACKEND);
        this.requestPolicyAllowsCaching(true);
        this.requestIsFatallyNonCompliant(null);
        this.getCacheEntryReturns(this.mockCacheEntry);
        this.cacheEntrySuitable(false);
        this.cacheEntryValidatable(false);
        EasyMock.expect((Object)this.mockConditionalRequestBuilder.buildConditionalRequest((HttpRequest)this.request, this.mockCacheEntry)).andReturn((Object)this.request);
        this.backendExpectsRequestAndReturn(this.request, this.mockBackendResponse);
        EasyMock.expect((Object)this.mockBackendResponse.getVersion()).andReturn((Object)HttpVersion.HTTP_1_1).anyTimes();
        EasyMock.expect((Object)this.mockBackendResponse.getCode()).andReturn((Object)200);
        this.replayMocks();
        ClassicHttpResponse result = this.impl.execute(this.request, this.scope, this.mockExecChain);
        this.verifyMocks();
        Assert.assertSame((Object)this.mockBackendResponse, (Object)result);
        Assert.assertEquals((long)0L, (long)this.impl.getCacheMisses());
        Assert.assertEquals((long)1L, (long)this.impl.getCacheHits());
        Assert.assertEquals((long)1L, (long)this.impl.getCacheUpdates());
    }

    @Test
    @Ignore
    public void testUnsuitableValidatableCacheEntryCausesRevalidation() throws Exception {
        this.mockImplMethods(REVALIDATE_CACHE_ENTRY);
        this.requestPolicyAllowsCaching(true);
        this.requestIsFatallyNonCompliant(null);
        this.getCacheEntryReturns(this.mockCacheEntry);
        this.cacheEntrySuitable(false);
        this.cacheEntryValidatable(true);
        this.cacheEntryMustRevalidate(false);
        this.cacheEntryProxyRevalidate(false);
        this.mayReturnStaleWhileRevalidating(false);
        EasyMock.expect((Object)this.impl.revalidateCacheEntry((HttpHost)EasyMock.isA(HttpHost.class), (ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class), (ExecChain)EasyMock.isA(ExecChain.class), (HttpCacheEntry)EasyMock.isA(HttpCacheEntry.class))).andReturn((Object)this.mockBackendResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.impl.execute(this.request, this.scope, this.mockExecChain);
        this.verifyMocks();
        Assert.assertSame((Object)this.mockBackendResponse, (Object)result);
        Assert.assertEquals((long)0L, (long)this.impl.getCacheMisses());
        Assert.assertEquals((long)1L, (long)this.impl.getCacheHits());
        Assert.assertEquals((long)0L, (long)this.impl.getCacheUpdates());
    }

    @Test
    public void testRevalidationCallsHandleBackEndResponseWhenNot200Or304() throws Exception {
        this.mockImplMethods(GET_CURRENT_DATE, HANDLE_BACKEND_RESPONSE);
        BasicClassicHttpRequest validate = new BasicClassicHttpRequest("GET", "/");
        BasicClassicHttpResponse originResponse = new BasicClassicHttpResponse(404, "Not Found");
        ClassicHttpResponse finalResponse = HttpTestUtils.make200Response();
        this.conditionalRequestBuilderReturns((ClassicHttpRequest)validate);
        this.getCurrentDateReturns(this.requestDate);
        this.backendExpectsRequestAndReturn((ClassicHttpRequest)validate, (ClassicHttpResponse)originResponse);
        this.getCurrentDateReturns(this.responseDate);
        EasyMock.expect((Object)this.impl.handleBackendResponse((HttpHost)EasyMock.same((Object)this.host), (ClassicHttpRequest)EasyMock.same((Object)validate), (ExecChain.Scope)EasyMock.same((Object)this.scope), (Date)EasyMock.eq((Object)this.requestDate), (Date)EasyMock.eq((Object)this.responseDate), (ClassicHttpResponse)EasyMock.same((Object)originResponse))).andReturn((Object)finalResponse);
        this.replayMocks();
        ClassicHttpResponse result = this.impl.revalidateCacheEntry(this.host, this.request, this.scope, this.mockExecChain, this.entry);
        this.verifyMocks();
        Assert.assertSame((Object)finalResponse, (Object)result);
    }

    @Test
    public void testRevalidationUpdatesCacheEntryAndPutsItToCacheWhen304ReturningCachedResponse() throws Exception {
        this.mockImplMethods(GET_CURRENT_DATE);
        BasicClassicHttpRequest validate = new BasicClassicHttpRequest("GET", "/");
        ClassicHttpResponse originResponse = HttpTestUtils.make304Response();
        HttpCacheEntry updatedEntry = HttpTestUtils.makeCacheEntry();
        this.conditionalRequestBuilderReturns((ClassicHttpRequest)validate);
        this.getCurrentDateReturns(this.requestDate);
        this.backendExpectsRequestAndReturn((ClassicHttpRequest)validate, originResponse);
        this.getCurrentDateReturns(this.responseDate);
        EasyMock.expect((Object)this.mockCache.updateCacheEntry((HttpHost)EasyMock.eq((Object)this.host), (HttpRequest)EasyMock.same((Object)this.request), (HttpCacheEntry)EasyMock.same((Object)this.entry), (HttpResponse)EasyMock.same((Object)originResponse), (Date)EasyMock.eq((Object)this.requestDate), (Date)EasyMock.eq((Object)this.responseDate))).andReturn((Object)updatedEntry);
        EasyMock.expect((Object)this.mockSuitabilityChecker.isConditional((HttpRequest)this.request)).andReturn((Object)false);
        this.responseIsGeneratedFromCache(SimpleHttpResponse.create((int)200));
        this.replayMocks();
        this.impl.revalidateCacheEntry(this.host, this.request, this.scope, this.mockExecChain, this.entry);
        this.verifyMocks();
    }

    @Test
    public void testRevalidationRewritesAbsoluteUri() throws Exception {
        this.mockImplMethods(GET_CURRENT_DATE);
        EasyMock.resetToStrict((Object[])new Object[]{this.mockExecChain});
        HttpGet validate = new HttpGet("http://foo.example.com/resource");
        BasicClassicHttpRequest relativeValidate = new BasicClassicHttpRequest("GET", "/resource");
        BasicClassicHttpResponse originResponse = new BasicClassicHttpResponse(200, "Okay");
        this.conditionalRequestBuilderReturns((ClassicHttpRequest)validate);
        this.getCurrentDateReturns(this.requestDate);
        ClassicHttpResponse resp = this.mockExecChain.proceed(TestCachingExec.eqRequest((ClassicHttpRequest)relativeValidate), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class));
        EasyMock.expect((Object)resp).andReturn((Object)originResponse);
        this.getCurrentDateReturns(this.responseDate);
        this.replayMocks();
        this.impl.revalidateCacheEntry(this.host, this.request, this.scope, this.mockExecChain, this.entry);
        this.verifyMocks();
    }

    @Test
    public void testEndlessResponsesArePassedThrough() throws Exception {
        this.impl = this.createCachingExecChain((HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
        BasicClassicHttpResponse resp1 = new BasicClassicHttpResponse(200, "OK");
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        resp1.setHeader("Server", (Object)"MockOrigin/1.0");
        resp1.setHeader("Transfer-Encoding", (Object)"chunked");
        final AtomicInteger size = new AtomicInteger();
        final AtomicInteger maxlength = new AtomicInteger(Integer.MAX_VALUE);
        resp1.setEntity((HttpEntity)new InputStreamEntity(new InputStream(){
            private Throwable closed;

            @Override
            public void close() throws IOException {
                this.closed = new Throwable();
                super.close();
            }

            @Override
            public int read() throws IOException {
                Thread.yield();
                if (this.closed != null) {
                    throw new IOException("Response has been closed");
                }
                if (size.incrementAndGet() > maxlength.get()) {
                    return -1;
                }
                return 121;
            }
        }, -1L));
        ClassicHttpResponse resp = this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class));
        EasyMock.expect((Object)resp).andReturn((Object)resp1);
        ClassicHttpRequest req1 = HttpTestUtils.makeDefaultRequest();
        this.replayMocks();
        ClassicHttpResponse resp2 = this.impl.execute(req1, this.scope, this.mockExecChain);
        maxlength.set(size.get() * 2);
        this.verifyMocks();
        Assert.assertTrue((boolean)HttpTestUtils.semanticallyTransparent((ClassicHttpResponse)resp1, resp2));
    }

    @Test
    public void testCallBackendMakesBackEndRequestAndHandlesResponse() throws Exception {
        this.mockImplMethods(GET_CURRENT_DATE, HANDLE_BACKEND_RESPONSE);
        BasicClassicHttpResponse resp = new BasicClassicHttpResponse(200, "OK");
        this.getCurrentDateReturns(this.requestDate);
        this.backendExpectsRequestAndReturn(this.request, (ClassicHttpResponse)resp);
        this.getCurrentDateReturns(this.responseDate);
        this.handleBackendResponseReturnsResponse(this.request, (ClassicHttpResponse)resp);
        this.replayMocks();
        this.impl.callBackend(this.host, this.request, this.scope, this.mockExecChain);
        this.verifyMocks();
    }

    @Test
    public void testDoesNotFlushCachesOnCacheHit() throws Exception {
        this.requestPolicyAllowsCaching(true);
        this.requestIsFatallyNonCompliant(null);
        this.getCacheEntryReturns(this.mockCacheEntry);
        this.doesNotFlushCache();
        this.cacheEntrySuitable(true);
        this.cacheEntryValidatable(true);
        this.responseIsGeneratedFromCache(SimpleHttpResponse.create((int)200));
        this.replayMocks();
        this.impl.execute(this.request, this.scope, this.mockExecChain);
        this.verifyMocks();
    }

    private IExpectationSetters<ClassicHttpResponse> implExpectsAnyRequestAndReturn(ClassicHttpResponse response) throws Exception {
        ClassicHttpResponse resp = this.impl.callBackend((HttpHost)EasyMock.same((Object)this.host), (ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class), (ExecChain)EasyMock.isA(ExecChain.class));
        return EasyMock.expect((Object)resp).andReturn((Object)response);
    }

    private void getVariantCacheEntriesReturns(Map<String, Variant> result) throws IOException {
        EasyMock.expect((Object)this.mockCache.getVariantCacheEntriesWithEtags(this.host, (HttpRequest)this.request)).andReturn(result);
    }

    private void cacheInvalidatorWasCalled() throws IOException {
        this.mockCache.flushInvalidatedCacheEntriesFor((HttpHost)EasyMock.anyObject(), (HttpRequest)EasyMock.anyObject());
    }

    private void getCurrentDateReturns(Date date) {
        EasyMock.expect((Object)this.impl.getCurrentDate()).andReturn((Object)date);
    }

    private void handleBackendResponseReturnsResponse(ClassicHttpRequest request, ClassicHttpResponse response) throws IOException {
        EasyMock.expect((Object)this.impl.handleBackendResponse((HttpHost)EasyMock.same((Object)this.host), (ClassicHttpRequest)EasyMock.same((Object)request), (ExecChain.Scope)EasyMock.same((Object)this.scope), (Date)EasyMock.isA(Date.class), (Date)EasyMock.isA(Date.class), (ClassicHttpResponse)EasyMock.isA(ClassicHttpResponse.class))).andReturn((Object)response);
    }

    private void mockImplMethods(String ... methods) {
        this.mockedImpl = true;
        this.impl = (CachingExec)org.easymock.classextension.EasyMock.createMockBuilder(CachingExec.class).withConstructor(new Object[]{this.mockCache, this.mockValidityPolicy, this.mockResponsePolicy, this.mockResponseGenerator, this.mockRequestPolicy, this.mockSuitabilityChecker, this.mockConditionalRequestBuilder, this.mockResponseProtocolCompliance, this.mockRequestProtocolCompliance, this.config}).addMockedMethods(methods).createNiceMock();
    }
}

