/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.Date;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CachedResponseSuitabilityChecker;
import org.apache.hc.client5.http.impl.cache.HttpTestUtils;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCachedResponseSuitabilityChecker {
    private Date now;
    private Date elevenSecondsAgo;
    private Date tenSecondsAgo;
    private Date nineSecondsAgo;
    private HttpHost host;
    private HttpRequest request;
    private HttpCacheEntry entry;
    private CachedResponseSuitabilityChecker impl;

    @Before
    public void setUp() {
        this.now = new Date();
        this.elevenSecondsAgo = new Date(this.now.getTime() - 11000L);
        this.tenSecondsAgo = new Date(this.now.getTime() - 10000L);
        this.nineSecondsAgo = new Date(this.now.getTime() - 9000L);
        this.host = new HttpHost("foo.example.com");
        this.request = new BasicHttpRequest("GET", "/foo");
        this.entry = HttpTestUtils.makeCacheEntry();
        this.impl = new CachedResponseSuitabilityChecker(CacheConfig.DEFAULT);
    }

    private HttpCacheEntry getEntry(Header[] headers) {
        return HttpTestUtils.makeCacheEntry(this.elevenSecondsAgo, this.nineSecondsAgo, headers);
    }

    @Test
    public void testNotSuitableIfContentLengthHeaderIsWrong() {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=3600"), new BasicHeader("Content-Length", (Object)"1")};
        this.entry = this.getEntry(headers);
        Assert.assertFalse((boolean)this.impl.canCachedResponseBeUsed(this.host, this.request, this.entry, this.now));
    }

    @Test
    public void testSuitableIfCacheEntryIsFresh() {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=3600"), new BasicHeader("Content-Length", (Object)"128")};
        this.entry = this.getEntry(headers);
        Assert.assertTrue((boolean)this.impl.canCachedResponseBeUsed(this.host, this.request, this.entry, this.now));
    }

    @Test
    public void testNotSuitableIfCacheEntryIsNotFresh() {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=5"), new BasicHeader("Content-Length", (Object)"128")};
        this.entry = this.getEntry(headers);
        Assert.assertFalse((boolean)this.impl.canCachedResponseBeUsed(this.host, this.request, this.entry, this.now));
    }

    @Test
    public void testNotSuitableIfRequestHasNoCache() {
        this.request.addHeader("Cache-Control", (Object)"no-cache");
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=3600"), new BasicHeader("Content-Length", (Object)"128")};
        this.entry = this.getEntry(headers);
        Assert.assertFalse((boolean)this.impl.canCachedResponseBeUsed(this.host, this.request, this.entry, this.now));
    }

    @Test
    public void testNotSuitableIfAgeExceedsRequestMaxAge() {
        this.request.addHeader("Cache-Control", (Object)"max-age=10");
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=3600"), new BasicHeader("Content-Length", (Object)"128")};
        this.entry = this.getEntry(headers);
        Assert.assertFalse((boolean)this.impl.canCachedResponseBeUsed(this.host, this.request, this.entry, this.now));
    }

    @Test
    public void testSuitableIfFreshAndAgeIsUnderRequestMaxAge() {
        this.request.addHeader("Cache-Control", (Object)"max-age=15");
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=3600"), new BasicHeader("Content-Length", (Object)"128")};
        this.entry = this.getEntry(headers);
        Assert.assertTrue((boolean)this.impl.canCachedResponseBeUsed(this.host, this.request, this.entry, this.now));
    }

    @Test
    public void testSuitableIfFreshAndFreshnessLifetimeGreaterThanRequestMinFresh() {
        this.request.addHeader("Cache-Control", (Object)"min-fresh=10");
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=3600"), new BasicHeader("Content-Length", (Object)"128")};
        this.entry = this.getEntry(headers);
        Assert.assertTrue((boolean)this.impl.canCachedResponseBeUsed(this.host, this.request, this.entry, this.now));
    }

    @Test
    public void testNotSuitableIfFreshnessLifetimeLessThanRequestMinFresh() {
        this.request.addHeader("Cache-Control", (Object)"min-fresh=10");
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=15"), new BasicHeader("Content-Length", (Object)"128")};
        this.entry = this.getEntry(headers);
        Assert.assertFalse((boolean)this.impl.canCachedResponseBeUsed(this.host, this.request, this.entry, this.now));
    }

    @Test
    public void testSuitableEvenIfStaleButPermittedByRequestMaxStale() {
        this.request.addHeader("Cache-Control", (Object)"max-stale=10");
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=5"), new BasicHeader("Content-Length", (Object)"128")};
        this.entry = this.getEntry(headers);
        Assert.assertTrue((boolean)this.impl.canCachedResponseBeUsed(this.host, this.request, this.entry, this.now));
    }

    @Test
    public void testNotSuitableIfStaleButTooStaleForRequestMaxStale() {
        this.request.addHeader("Cache-Control", (Object)"max-stale=2");
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=5"), new BasicHeader("Content-Length", (Object)"128")};
        this.entry = this.getEntry(headers);
        Assert.assertFalse((boolean)this.impl.canCachedResponseBeUsed(this.host, this.request, this.entry, this.now));
    }

    @Test
    public void testMalformedCacheControlMaxAgeRequestHeaderCausesUnsuitableEntry() {
        this.request.addHeader((Header)new BasicHeader("Cache-Control", (Object)"max-age=foo"));
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=3600"), new BasicHeader("Content-Length", (Object)"128")};
        this.entry = this.getEntry(headers);
        Assert.assertFalse((boolean)this.impl.canCachedResponseBeUsed(this.host, this.request, this.entry, this.now));
    }

    @Test
    public void testMalformedCacheControlMinFreshRequestHeaderCausesUnsuitableEntry() {
        this.request.addHeader((Header)new BasicHeader("Cache-Control", (Object)"min-fresh=foo"));
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=3600"), new BasicHeader("Content-Length", (Object)"128")};
        this.entry = this.getEntry(headers);
        Assert.assertFalse((boolean)this.impl.canCachedResponseBeUsed(this.host, this.request, this.entry, this.now));
    }

    @Test
    public void testSuitableIfCacheEntryIsHeuristicallyFreshEnough() {
        Date oneSecondAgo = new Date(this.now.getTime() - 1000L);
        Date twentyOneSecondsAgo = new Date(this.now.getTime() - 21000L);
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)oneSecondAgo)), new BasicHeader("Last-Modified", (Object)DateUtils.formatDate((Date)twentyOneSecondsAgo)), new BasicHeader("Content-Length", (Object)"128")};
        this.entry = HttpTestUtils.makeCacheEntry(oneSecondAgo, oneSecondAgo, headers);
        CacheConfig config = CacheConfig.custom().setHeuristicCachingEnabled(true).setHeuristicCoefficient(0.1f).build();
        this.impl = new CachedResponseSuitabilityChecker(config);
        Assert.assertTrue((boolean)this.impl.canCachedResponseBeUsed(this.host, this.request, this.entry, this.now));
    }

    @Test
    public void testSuitableIfCacheEntryIsHeuristicallyFreshEnoughByDefault() {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Content-Length", (Object)"128")};
        this.entry = this.getEntry(headers);
        CacheConfig config = CacheConfig.custom().setHeuristicCachingEnabled(true).setHeuristicDefaultLifetime(20L).build();
        this.impl = new CachedResponseSuitabilityChecker(config);
        Assert.assertTrue((boolean)this.impl.canCachedResponseBeUsed(this.host, this.request, this.entry, this.now));
    }

    @Test
    public void testSuitableIfRequestMethodisHEAD() {
        BasicHttpRequest headRequest = new BasicHttpRequest("HEAD", "/foo");
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=3600"), new BasicHeader("Content-Length", (Object)"128")};
        this.entry = this.getEntry(headers);
        Assert.assertTrue((boolean)this.impl.canCachedResponseBeUsed(this.host, (HttpRequest)headRequest, this.entry, this.now));
    }

    @Test
    public void testNotSuitableIfRequestMethodIsGETAndEntryResourceIsNull() {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=3600"), new BasicHeader("Content-Length", (Object)"128")};
        this.entry = HttpTestUtils.makeHeadCacheEntry(headers);
        Assert.assertFalse((boolean)this.impl.canCachedResponseBeUsed(this.host, this.request, this.entry, this.now));
    }

    @Test
    public void testNotSuitableForGETIfEntryDoesNotSpecifyARequestMethodOrEntity() {
        this.impl = new CachedResponseSuitabilityChecker(CacheConfig.custom().build());
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=3600"), new BasicHeader("Content-Length", (Object)"128")};
        this.entry = HttpTestUtils.makeCacheEntryWithNoRequestMethodOrEntity(headers);
        Assert.assertFalse((boolean)this.impl.canCachedResponseBeUsed(this.host, this.request, this.entry, this.now));
    }

    @Test
    public void testSuitableForGETIfEntryDoesNotSpecifyARequestMethodButContainsEntity() {
        this.impl = new CachedResponseSuitabilityChecker(CacheConfig.custom().build());
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=3600"), new BasicHeader("Content-Length", (Object)"128")};
        this.entry = HttpTestUtils.makeCacheEntryWithNoRequestMethod(headers);
        Assert.assertTrue((boolean)this.impl.canCachedResponseBeUsed(this.host, this.request, this.entry, this.now));
    }

    @Test
    public void testSuitableForGETIfHeadResponseCachingEnabledAndEntryDoesNotSpecifyARequestMethodButContains204Response() {
        this.impl = new CachedResponseSuitabilityChecker(CacheConfig.custom().build());
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=3600")};
        this.entry = HttpTestUtils.make204CacheEntryWithNoRequestMethod(headers);
        Assert.assertTrue((boolean)this.impl.canCachedResponseBeUsed(this.host, this.request, this.entry, this.now));
    }

    @Test
    public void testSuitableForHEADIfHeadResponseCachingEnabledAndEntryDoesNotSpecifyARequestMethod() {
        BasicHttpRequest headRequest = new BasicHttpRequest("HEAD", "/foo");
        this.impl = new CachedResponseSuitabilityChecker(CacheConfig.custom().build());
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=3600"), new BasicHeader("Content-Length", (Object)"128")};
        this.entry = HttpTestUtils.makeHeadCacheEntryWithNoRequestMethod(headers);
        Assert.assertTrue((boolean)this.impl.canCachedResponseBeUsed(this.host, (HttpRequest)headRequest, this.entry, this.now));
    }
}

