/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.Date;
import java.util.HashMap;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.impl.cache.CacheValidityPolicy;
import org.apache.hc.client5.http.impl.cache.CachedHttpResponseGenerator;
import org.apache.hc.client5.http.impl.cache.HttpTestUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.BasicHeader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestCachedHttpResponseGenerator {
    private HttpCacheEntry entry;
    private ClassicHttpRequest request;
    private CacheValidityPolicy mockValidityPolicy;
    private CachedHttpResponseGenerator impl;

    @Before
    public void setUp() {
        this.entry = HttpTestUtils.makeCacheEntry(new HashMap<String, String>());
        this.request = HttpTestUtils.makeDefaultRequest();
        this.mockValidityPolicy = (CacheValidityPolicy)Mockito.mock(CacheValidityPolicy.class);
        this.impl = new CachedHttpResponseGenerator(this.mockValidityPolicy);
    }

    @Test
    public void testResponseHasContentLength() throws Exception {
        byte[] buf = new byte[]{1, 2, 3, 4, 5};
        HttpCacheEntry entry1 = HttpTestUtils.makeCacheEntry(buf);
        SimpleHttpResponse response = this.impl.generateResponse((HttpRequest)this.request, entry1);
        Header length = response.getFirstHeader("Content-Length");
        Assert.assertNotNull((String)"Content-Length Header is missing", (Object)length);
        Assert.assertEquals((String)"Content-Length does not match buffer length", (long)buf.length, (long)Integer.parseInt(length.getValue()));
    }

    @Test
    public void testContentLengthIsNotAddedWhenTransferEncodingIsPresent() throws Exception {
        Header[] hdrs = new Header[]{new BasicHeader("Transfer-Encoding", (Object)"chunked")};
        byte[] buf = new byte[]{1, 2, 3, 4, 5};
        HttpCacheEntry entry1 = HttpTestUtils.makeCacheEntry(hdrs, buf);
        SimpleHttpResponse response = this.impl.generateResponse((HttpRequest)this.request, entry1);
        Header length = response.getFirstHeader("Content-Length");
        Assert.assertNull((Object)length);
    }

    @Test
    public void testResponseMatchesCacheEntry() throws Exception {
        SimpleHttpResponse response = this.impl.generateResponse((HttpRequest)this.request, this.entry);
        Assert.assertTrue((boolean)response.containsHeader("Content-Length"));
        Assert.assertSame((Object)"HTTP", (Object)response.getVersion().getProtocol());
        Assert.assertEquals((long)1L, (long)response.getVersion().getMajor());
        Assert.assertEquals((long)1L, (long)response.getVersion().getMinor());
    }

    @Test
    public void testResponseStatusCodeMatchesCacheEntry() throws Exception {
        SimpleHttpResponse response = this.impl.generateResponse((HttpRequest)this.request, this.entry);
        Assert.assertEquals((long)this.entry.getStatus(), (long)response.getCode());
    }

    @Test
    public void testAgeHeaderIsPopulatedWithCurrentAgeOfCacheEntryIfNonZero() throws Exception {
        this.currentAge(10L);
        SimpleHttpResponse response = this.impl.generateResponse((HttpRequest)this.request, this.entry);
        ((CacheValidityPolicy)Mockito.verify((Object)this.mockValidityPolicy)).getCurrentAgeSecs((HttpCacheEntry)ArgumentMatchers.same((Object)this.entry), (Date)ArgumentMatchers.isA(Date.class));
        Header ageHdr = response.getFirstHeader("Age");
        Assert.assertNotNull((Object)ageHdr);
        Assert.assertEquals((long)10L, (long)Long.parseLong(ageHdr.getValue()));
    }

    @Test
    public void testAgeHeaderIsNotPopulatedIfCurrentAgeOfCacheEntryIsZero() throws Exception {
        this.currentAge(0L);
        SimpleHttpResponse response = this.impl.generateResponse((HttpRequest)this.request, this.entry);
        ((CacheValidityPolicy)Mockito.verify((Object)this.mockValidityPolicy)).getCurrentAgeSecs((HttpCacheEntry)ArgumentMatchers.same((Object)this.entry), (Date)ArgumentMatchers.isA(Date.class));
        Header ageHdr = response.getFirstHeader("Age");
        Assert.assertNull((Object)ageHdr);
    }

    @Test
    public void testAgeHeaderIsPopulatedWithMaxAgeIfCurrentAgeTooBig() throws Exception {
        this.currentAge(0x80000001L);
        SimpleHttpResponse response = this.impl.generateResponse((HttpRequest)this.request, this.entry);
        ((CacheValidityPolicy)Mockito.verify((Object)this.mockValidityPolicy)).getCurrentAgeSecs((HttpCacheEntry)ArgumentMatchers.same((Object)this.entry), (Date)ArgumentMatchers.isA(Date.class));
        Header ageHdr = response.getFirstHeader("Age");
        Assert.assertNotNull((Object)ageHdr);
        Assert.assertEquals((long)0x80000000L, (long)Long.parseLong(ageHdr.getValue()));
    }

    private void currentAge(long sec) {
        Mockito.when((Object)this.mockValidityPolicy.getCurrentAgeSecs((HttpCacheEntry)ArgumentMatchers.same((Object)this.entry), (Date)ArgumentMatchers.isA(Date.class))).thenReturn((Object)sec);
    }

    @Test
    public void testResponseContainsEntityToServeGETRequestIfEntryContainsResource() throws Exception {
        SimpleHttpResponse response = this.impl.generateResponse((HttpRequest)this.request, this.entry);
        Assert.assertNotNull((Object)response.getBody());
    }

    @Test
    public void testResponseDoesNotContainEntityToServeHEADRequestIfEntryContainsResource() throws Exception {
        ClassicHttpRequest headRequest = HttpTestUtils.makeDefaultHEADRequest();
        SimpleHttpResponse response = this.impl.generateResponse((HttpRequest)headRequest, this.entry);
        Assert.assertNull((Object)response.getBody());
    }
}

