/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import org.apache.hc.client5.http.impl.cache.CacheableRequestPolicy;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCacheableRequestPolicy {
    private CacheableRequestPolicy policy;

    @Before
    public void setUp() throws Exception {
        this.policy = new CacheableRequestPolicy();
    }

    @Test
    public void testIsGetServableFromCache() {
        BasicHttpRequest request = new BasicHttpRequest("GET", "someUri");
        Assert.assertTrue((boolean)this.policy.isServableFromCache((HttpRequest)request));
    }

    @Test
    public void testIsGetWithCacheControlServableFromCache() {
        BasicHttpRequest request = new BasicHttpRequest("GET", "someUri");
        request.addHeader("Cache-Control", (Object)"no-cache");
        Assert.assertFalse((boolean)this.policy.isServableFromCache((HttpRequest)request));
        request = new BasicHttpRequest("GET", "someUri");
        request.addHeader("Cache-Control", (Object)"no-store");
        request.addHeader("Cache-Control", (Object)"max-age=20");
        Assert.assertFalse((boolean)this.policy.isServableFromCache((HttpRequest)request));
        request = new BasicHttpRequest("GET", "someUri");
        request.addHeader("Cache-Control", (Object)"public");
        request.addHeader("Cache-Control", (Object)"no-store, max-age=20");
        Assert.assertFalse((boolean)this.policy.isServableFromCache((HttpRequest)request));
    }

    @Test
    public void testIsGetWithPragmaServableFromCache() {
        BasicHttpRequest request = new BasicHttpRequest("GET", "someUri");
        request.addHeader("Pragma", (Object)"no-cache");
        Assert.assertFalse((boolean)this.policy.isServableFromCache((HttpRequest)request));
        request = new BasicHttpRequest("GET", "someUri");
        request.addHeader("Pragma", (Object)"value1");
        request.addHeader("Pragma", (Object)"value2");
        Assert.assertFalse((boolean)this.policy.isServableFromCache((HttpRequest)request));
    }

    @Test
    public void testIsHeadServableFromCache() {
        BasicHttpRequest request = new BasicHttpRequest("HEAD", "someUri");
        Assert.assertTrue((boolean)this.policy.isServableFromCache((HttpRequest)request));
        request = new BasicHttpRequest("HEAD", "someUri");
        request.addHeader("Cache-Control", (Object)"public");
        request.addHeader("Cache-Control", (Object)"max-age=20");
        Assert.assertTrue((boolean)this.policy.isServableFromCache((HttpRequest)request));
    }

    @Test
    public void testIsHeadWithCacheControlServableFromCache() {
        BasicHttpRequest request = new BasicHttpRequest("HEAD", "someUri");
        request.addHeader("Cache-Control", (Object)"no-cache");
        Assert.assertFalse((boolean)this.policy.isServableFromCache((HttpRequest)request));
        request = new BasicHttpRequest("HEAD", "someUri");
        request.addHeader("Cache-Control", (Object)"no-store");
        request.addHeader("Cache-Control", (Object)"max-age=20");
        Assert.assertFalse((boolean)this.policy.isServableFromCache((HttpRequest)request));
        request = new BasicHttpRequest("HEAD", "someUri");
        request.addHeader("Cache-Control", (Object)"public");
        request.addHeader("Cache-Control", (Object)"no-store, max-age=20");
        Assert.assertFalse((boolean)this.policy.isServableFromCache((HttpRequest)request));
    }

    @Test
    public void testIsHeadWithPragmaServableFromCache() {
        BasicHttpRequest request = new BasicHttpRequest("HEAD", "someUri");
        request.addHeader("Pragma", (Object)"no-cache");
        Assert.assertFalse((boolean)this.policy.isServableFromCache((HttpRequest)request));
        request = new BasicHttpRequest("HEAD", "someUri");
        request.addHeader("Pragma", (Object)"value1");
        request.addHeader("Pragma", (Object)"value2");
        Assert.assertFalse((boolean)this.policy.isServableFromCache((HttpRequest)request));
    }

    @Test
    public void testIsArbitraryMethodServableFromCache() {
        BasicHttpRequest request = new BasicHttpRequest("TRACE", "someUri");
        Assert.assertFalse((boolean)this.policy.isServableFromCache((HttpRequest)request));
        request = new BasicHttpRequest("get", "someUri");
        Assert.assertFalse((boolean)this.policy.isServableFromCache((HttpRequest)request));
    }
}

