/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.Date;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.impl.cache.CacheValidityPolicy;
import org.apache.hc.client5.http.impl.cache.HttpTestUtils;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCacheValidityPolicy {
    private CacheValidityPolicy impl;
    private Date now;
    private Date oneSecondAgo;
    private Date sixSecondsAgo;
    private Date tenSecondsAgo;
    private Date elevenSecondsAgo;

    @Before
    public void setUp() {
        this.impl = new CacheValidityPolicy();
        this.now = new Date();
        this.oneSecondAgo = new Date(this.now.getTime() - 1000L);
        this.sixSecondsAgo = new Date(this.now.getTime() - 6000L);
        this.tenSecondsAgo = new Date(this.now.getTime() - 10000L);
        this.elevenSecondsAgo = new Date(this.now.getTime() - 11000L);
    }

    @Test
    public void testApparentAgeIsMaxIntIfDateHeaderNotPresent() {
        Header[] headers = new Header[]{new BasicHeader("Server", (Object)"MockServer/1.0")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertEquals((long)0x80000000L, (long)this.impl.getApparentAgeSecs(entry));
    }

    @Test
    public void testApparentAgeIsResponseReceivedTimeLessDateHeader() {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo))};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(this.now, this.sixSecondsAgo, headers);
        Assert.assertEquals((long)4L, (long)this.impl.getApparentAgeSecs(entry));
    }

    @Test
    public void testNegativeApparentAgeIsBroughtUpToZero() {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.sixSecondsAgo))};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(this.now, this.tenSecondsAgo, headers);
        Assert.assertEquals((long)0L, (long)this.impl.getApparentAgeSecs(entry));
    }

    @Test
    public void testCorrectedReceivedAgeIsAgeHeaderIfLarger() {
        Header[] headers = new Header[]{new BasicHeader("Age", (Object)"10")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        this.impl = new CacheValidityPolicy(){

            protected long getApparentAgeSecs(HttpCacheEntry ent) {
                return 6L;
            }
        };
        Assert.assertEquals((long)10L, (long)this.impl.getCorrectedReceivedAgeSecs(entry));
    }

    @Test
    public void testCorrectedReceivedAgeIsApparentAgeIfLarger() {
        Header[] headers = new Header[]{new BasicHeader("Age", (Object)"6")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        this.impl = new CacheValidityPolicy(){

            protected long getApparentAgeSecs(HttpCacheEntry ent) {
                return 10L;
            }
        };
        Assert.assertEquals((long)10L, (long)this.impl.getCorrectedReceivedAgeSecs(entry));
    }

    @Test
    public void testResponseDelayIsDifferenceBetweenResponseAndRequestTimes() {
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(this.tenSecondsAgo, this.sixSecondsAgo);
        Assert.assertEquals((long)4L, (long)this.impl.getResponseDelaySecs(entry));
    }

    @Test
    public void testCorrectedInitialAgeIsCorrectedReceivedAgePlusResponseDelay() {
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry();
        this.impl = new CacheValidityPolicy(){

            protected long getCorrectedReceivedAgeSecs(HttpCacheEntry ent) {
                return 7L;
            }

            protected long getResponseDelaySecs(HttpCacheEntry ent) {
                return 13L;
            }
        };
        Assert.assertEquals((long)20L, (long)this.impl.getCorrectedInitialAgeSecs(entry));
    }

    @Test
    public void testResidentTimeSecondsIsTimeSinceResponseTime() {
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(this.now, this.sixSecondsAgo);
        Assert.assertEquals((long)6L, (long)this.impl.getResidentTimeSecs(entry, this.now));
    }

    @Test
    public void testCurrentAgeIsCorrectedInitialAgePlusResidentTime() {
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry();
        this.impl = new CacheValidityPolicy(){

            protected long getCorrectedInitialAgeSecs(HttpCacheEntry ent) {
                return 11L;
            }

            protected long getResidentTimeSecs(HttpCacheEntry ent, Date d) {
                return 17L;
            }
        };
        Assert.assertEquals((long)28L, (long)this.impl.getCurrentAgeSecs(entry, new Date()));
    }

    @Test
    public void testFreshnessLifetimeIsSMaxAgeIfPresent() {
        Header[] headers = new Header[]{new BasicHeader("Cache-Control", (Object)"s-maxage=10")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertEquals((long)10L, (long)this.impl.getFreshnessLifetimeSecs(entry));
    }

    @Test
    public void testFreshnessLifetimeIsMaxAgeIfPresent() {
        Header[] headers = new Header[]{new BasicHeader("Cache-Control", (Object)"max-age=10")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertEquals((long)10L, (long)this.impl.getFreshnessLifetimeSecs(entry));
    }

    @Test
    public void testFreshnessLifetimeIsMostRestrictiveOfMaxAgeAndSMaxAge() {
        Header[] headers = new Header[]{new BasicHeader("Cache-Control", (Object)"max-age=10"), new BasicHeader("Cache-Control", (Object)"s-maxage=20")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertEquals((long)10L, (long)this.impl.getFreshnessLifetimeSecs(entry));
        headers = new Header[]{new BasicHeader("Cache-Control", (Object)"max-age=20"), new BasicHeader("Cache-Control", (Object)"s-maxage=10")};
        entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertEquals((long)10L, (long)this.impl.getFreshnessLifetimeSecs(entry));
    }

    @Test
    public void testFreshnessLifetimeIsMaxAgeEvenIfExpiresIsPresent() {
        Header[] headers = new Header[]{new BasicHeader("Cache-Control", (Object)"max-age=10"), new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Expires", (Object)DateUtils.formatDate((Date)this.sixSecondsAgo))};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertEquals((long)10L, (long)this.impl.getFreshnessLifetimeSecs(entry));
    }

    @Test
    public void testFreshnessLifetimeIsSMaxAgeEvenIfExpiresIsPresent() {
        Header[] headers = new Header[]{new BasicHeader("Cache-Control", (Object)"s-maxage=10"), new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Expires", (Object)DateUtils.formatDate((Date)this.sixSecondsAgo))};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertEquals((long)10L, (long)this.impl.getFreshnessLifetimeSecs(entry));
    }

    @Test
    public void testFreshnessLifetimeIsFromExpiresHeaderIfNoMaxAge() {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Expires", (Object)DateUtils.formatDate((Date)this.sixSecondsAgo))};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertEquals((long)4L, (long)this.impl.getFreshnessLifetimeSecs(entry));
    }

    @Test
    public void testHeuristicFreshnessLifetime() {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.oneSecondAgo)), new BasicHeader("Last-Modified", (Object)DateUtils.formatDate((Date)this.elevenSecondsAgo))};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertEquals((long)1L, (long)this.impl.getHeuristicFreshnessLifetimeSecs(entry, 0.1f, 0L));
    }

    @Test
    public void testHeuristicFreshnessLifetimeDefaultsProperly() {
        long defaultFreshness = 10L;
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry();
        Assert.assertEquals((long)10L, (long)this.impl.getHeuristicFreshnessLifetimeSecs(entry, 0.1f, 10L));
    }

    @Test
    public void testHeuristicFreshnessLifetimeIsNonNegative() {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.elevenSecondsAgo)), new BasicHeader("Last-Modified", (Object)DateUtils.formatDate((Date)this.oneSecondAgo))};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertTrue((this.impl.getHeuristicFreshnessLifetimeSecs(entry, 0.1f, 10L) >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void testResponseIsFreshIfFreshnessLifetimeExceedsCurrentAge() {
        final HttpCacheEntry entry = HttpTestUtils.makeCacheEntry();
        this.impl = new CacheValidityPolicy(){

            public long getCurrentAgeSecs(HttpCacheEntry e, Date d) {
                Assert.assertSame((Object)entry, (Object)e);
                Assert.assertEquals((Object)TestCacheValidityPolicy.this.now, (Object)d);
                return 6L;
            }

            public long getFreshnessLifetimeSecs(HttpCacheEntry e) {
                Assert.assertSame((Object)entry, (Object)e);
                return 10L;
            }
        };
        Assert.assertTrue((boolean)this.impl.isResponseFresh(entry, this.now));
    }

    @Test
    public void testResponseIsNotFreshIfFreshnessLifetimeEqualsCurrentAge() {
        final HttpCacheEntry entry = HttpTestUtils.makeCacheEntry();
        this.impl = new CacheValidityPolicy(){

            public long getCurrentAgeSecs(HttpCacheEntry e, Date d) {
                Assert.assertEquals((Object)TestCacheValidityPolicy.this.now, (Object)d);
                Assert.assertSame((Object)entry, (Object)e);
                return 6L;
            }

            public long getFreshnessLifetimeSecs(HttpCacheEntry e) {
                Assert.assertSame((Object)entry, (Object)e);
                return 6L;
            }
        };
        Assert.assertFalse((boolean)this.impl.isResponseFresh(entry, this.now));
    }

    @Test
    public void testResponseIsNotFreshIfCurrentAgeExceedsFreshnessLifetime() {
        final HttpCacheEntry entry = HttpTestUtils.makeCacheEntry();
        this.impl = new CacheValidityPolicy(){

            public long getCurrentAgeSecs(HttpCacheEntry e, Date d) {
                Assert.assertEquals((Object)TestCacheValidityPolicy.this.now, (Object)d);
                Assert.assertSame((Object)entry, (Object)e);
                return 10L;
            }

            public long getFreshnessLifetimeSecs(HttpCacheEntry e) {
                Assert.assertSame((Object)entry, (Object)e);
                return 6L;
            }
        };
        Assert.assertFalse((boolean)this.impl.isResponseFresh(entry, this.now));
    }

    @Test
    public void testCacheEntryIsRevalidatableIfHeadersIncludeETag() {
        Header[] headers = new Header[]{new BasicHeader("Expires", (Object)DateUtils.formatDate((Date)new Date())), new BasicHeader("ETag", (Object)"somevalue")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertTrue((boolean)this.impl.isRevalidatable(entry));
    }

    @Test
    public void testCacheEntryIsRevalidatableIfHeadersIncludeLastModifiedDate() {
        Header[] headers = new Header[]{new BasicHeader("Expires", (Object)DateUtils.formatDate((Date)new Date())), new BasicHeader("Last-Modified", (Object)DateUtils.formatDate((Date)new Date()))};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertTrue((boolean)this.impl.isRevalidatable(entry));
    }

    @Test
    public void testCacheEntryIsNotRevalidatableIfNoAppropriateHeaders() {
        Header[] headers = new Header[]{new BasicHeader("Expires", (Object)DateUtils.formatDate((Date)new Date())), new BasicHeader("Cache-Control", (Object)"public")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertFalse((boolean)this.impl.isRevalidatable(entry));
    }

    @Test
    public void testMissingContentLengthDoesntInvalidateEntry() {
        int contentLength = 128;
        Header[] headers = new Header[]{};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers, HttpTestUtils.getRandomBytes(128));
        Assert.assertTrue((boolean)this.impl.contentLengthHeaderMatchesActualLength(entry));
    }

    @Test
    public void testCorrectContentLengthDoesntInvalidateEntry() {
        int contentLength = 128;
        Header[] headers = new Header[]{new BasicHeader("Content-Length", (Object)Integer.toString(128))};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers, HttpTestUtils.getRandomBytes(128));
        Assert.assertTrue((boolean)this.impl.contentLengthHeaderMatchesActualLength(entry));
    }

    @Test
    public void testWrongContentLengthInvalidatesEntry() {
        int contentLength = 128;
        Header[] headers = new Header[]{new BasicHeader("Content-Length", (Object)Integer.toString(129))};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers, HttpTestUtils.getRandomBytes(128));
        Assert.assertFalse((boolean)this.impl.contentLengthHeaderMatchesActualLength(entry));
    }

    @Test
    public void testNullResourceInvalidatesEntry() {
        int contentLength = 128;
        Header[] headers = new Header[]{new BasicHeader("Content-Length", (Object)Integer.toString(128))};
        HttpCacheEntry entry = HttpTestUtils.makeHeadCacheEntry(headers);
        Assert.assertFalse((boolean)this.impl.contentLengthHeaderMatchesActualLength(entry));
    }

    @Test
    public void testNegativeAgeHeaderValueReturnsMaxAge() {
        Header[] headers = new Header[]{new BasicHeader("Age", (Object)"-100")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertEquals((long)0x80000000L, (long)this.impl.getAgeValue(entry));
    }

    @Test
    public void testMalformedAgeHeaderValueReturnsMaxAge() {
        Header[] headers = new Header[]{new BasicHeader("Age", (Object)"asdf")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertEquals((long)0x80000000L, (long)this.impl.getAgeValue(entry));
    }

    @Test
    public void testMalformedCacheControlMaxAgeHeaderReturnsZero() {
        Header[] headers = new Header[]{new BasicHeader("Cache-Control", (Object)"max-age=asdf")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertEquals((long)0L, (long)this.impl.getMaxAge(entry));
    }

    @Test
    public void testMalformedExpirationDateReturnsNull() {
        Header[] headers = new Header[]{new BasicHeader("Expires", (Object)"asdf")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertNull((Object)this.impl.getExpirationDate(entry));
    }

    @Test
    public void testMustRevalidateIsFalseIfDirectiveNotPresent() {
        Header[] headers = new Header[]{new BasicHeader("Cache-Control", (Object)"public")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertFalse((boolean)this.impl.mustRevalidate(entry));
    }

    @Test
    public void testMustRevalidateIsTrueWhenDirectiveIsPresent() {
        Header[] headers = new Header[]{new BasicHeader("Cache-Control", (Object)"public, must-revalidate")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertTrue((boolean)this.impl.mustRevalidate(entry));
    }

    @Test
    public void testProxyRevalidateIsFalseIfDirectiveNotPresent() {
        Header[] headers = new Header[]{new BasicHeader("Cache-Control", (Object)"public")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertFalse((boolean)this.impl.proxyRevalidate(entry));
    }

    @Test
    public void testProxyRevalidateIsTrueWhenDirectiveIsPresent() {
        Header[] headers = new Header[]{new BasicHeader("Cache-Control", (Object)"public, proxy-revalidate")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertTrue((boolean)this.impl.proxyRevalidate(entry));
    }

    @Test
    public void testMayReturnStaleIfErrorInResponseIsTrueWithinStaleness() {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=5, stale-if-error=15")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(this.now, this.now, headers);
        BasicHttpRequest req = new BasicHttpRequest("GET", "/");
        Assert.assertTrue((boolean)this.impl.mayReturnStaleIfError((HttpRequest)req, entry, this.now));
    }

    @Test
    public void testMayReturnStaleIfErrorInRequestIsTrueWithinStaleness() {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=5")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(this.now, this.now, headers);
        BasicHttpRequest req = new BasicHttpRequest("GET", "/");
        req.setHeader("Cache-Control", (Object)"stale-if-error=15");
        Assert.assertTrue((boolean)this.impl.mayReturnStaleIfError((HttpRequest)req, entry, this.now));
    }

    @Test
    public void testMayNotReturnStaleIfErrorInResponseAndAfterResponseWindow() {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=5, stale-if-error=1")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(this.now, this.now, headers);
        BasicHttpRequest req = new BasicHttpRequest("GET", "/");
        Assert.assertFalse((boolean)this.impl.mayReturnStaleIfError((HttpRequest)req, entry, this.now));
    }

    @Test
    public void testMayNotReturnStaleIfErrorInResponseAndAfterRequestWindow() {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=5")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(this.now, this.now, headers);
        BasicHttpRequest req = new BasicHttpRequest("GET", "/");
        req.setHeader("Cache-Control", (Object)"stale-if-error=1");
        Assert.assertFalse((boolean)this.impl.mayReturnStaleIfError((HttpRequest)req, entry, this.now));
    }

    @Test
    public void testMayReturnStaleWhileRevalidatingIsFalseWhenDirectiveIsAbsent() {
        Header[] headers = new Header[]{new BasicHeader("Cache-control", (Object)"public")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(headers);
        Assert.assertFalse((boolean)this.impl.mayReturnStaleWhileRevalidating(entry, this.now));
    }

    @Test
    public void testMayReturnStaleWhileRevalidatingIsTrueWhenWithinStaleness() {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=5, stale-while-revalidate=15")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(this.now, this.now, headers);
        Assert.assertTrue((boolean)this.impl.mayReturnStaleWhileRevalidating(entry, this.now));
    }

    @Test
    public void testMayReturnStaleWhileRevalidatingIsFalseWhenPastStaleness() {
        Date twentyFiveSecondsAgo = new Date(this.now.getTime() - 25000L);
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)twentyFiveSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=5, stale-while-revalidate=15")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(this.now, this.now, headers);
        Assert.assertFalse((boolean)this.impl.mayReturnStaleWhileRevalidating(entry, this.now));
    }

    @Test
    public void testMayReturnStaleWhileRevalidatingIsFalseWhenDirectiveEmpty() {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo)), new BasicHeader("Cache-Control", (Object)"max-age=5, stale-while-revalidate=")};
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(this.now, this.now, headers);
        Assert.assertFalse((boolean)this.impl.mayReturnStaleWhileRevalidating(entry, this.now));
    }
}

