/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.cache.CacheKeyGenerator;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHeaderIterator;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCacheKeyGenerator {
    private static final BasicHttpRequest REQUEST_FULL_EPISODES = new BasicHttpRequest("GET", "/full_episodes");
    private static final BasicHttpRequest REQUEST_ROOT = new BasicHttpRequest("GET", "/");
    CacheKeyGenerator extractor;
    private HttpHost defaultHost;
    private HttpCacheEntry mockEntry;
    private HttpRequest mockRequest;

    @Before
    public void setUp() throws Exception {
        this.defaultHost = new HttpHost("foo.example.com");
        this.mockEntry = (HttpCacheEntry)Mockito.mock(HttpCacheEntry.class);
        this.mockRequest = (HttpRequest)Mockito.mock(HttpRequest.class);
        this.extractor = new CacheKeyGenerator();
    }

    @Test
    public void testExtractsUriFromAbsoluteUriInRequest() {
        HttpHost host = new HttpHost("bar.example.com");
        HttpGet req = new HttpGet("http://foo.example.com/");
        Assert.assertEquals((Object)"http://foo.example.com:80/", (Object)this.extractor.generateKey(host, (HttpRequest)req));
    }

    @Test
    public void testGetURIWithDefaultPortAndScheme() {
        Assert.assertEquals((Object)"http://www.comcast.net:80/", (Object)this.extractor.generateKey(new HttpHost("www.comcast.net"), (HttpRequest)REQUEST_ROOT));
        Assert.assertEquals((Object)"http://www.fancast.com:80/full_episodes", (Object)this.extractor.generateKey(new HttpHost("www.fancast.com"), (HttpRequest)REQUEST_FULL_EPISODES));
    }

    @Test
    public void testGetURIWithDifferentScheme() {
        Assert.assertEquals((Object)"https://www.comcast.net:443/", (Object)this.extractor.generateKey(new HttpHost("www.comcast.net", -1, "https"), (HttpRequest)REQUEST_ROOT));
        Assert.assertEquals((Object)"myhttp://www.fancast.com/full_episodes", (Object)this.extractor.generateKey(new HttpHost("www.fancast.com", -1, "myhttp"), (HttpRequest)REQUEST_FULL_EPISODES));
    }

    @Test
    public void testGetURIWithDifferentPort() {
        Assert.assertEquals((Object)"http://www.comcast.net:8080/", (Object)this.extractor.generateKey(new HttpHost("www.comcast.net", 8080), (HttpRequest)REQUEST_ROOT));
        Assert.assertEquals((Object)"http://www.fancast.com:9999/full_episodes", (Object)this.extractor.generateKey(new HttpHost("www.fancast.com", 9999), (HttpRequest)REQUEST_FULL_EPISODES));
    }

    @Test
    public void testGetURIWithDifferentPortAndScheme() {
        Assert.assertEquals((Object)"https://www.comcast.net:8080/", (Object)this.extractor.generateKey(new HttpHost("www.comcast.net", 8080, "https"), (HttpRequest)REQUEST_ROOT));
        Assert.assertEquals((Object)"myhttp://www.fancast.com:9999/full_episodes", (Object)this.extractor.generateKey(new HttpHost("www.fancast.com", 9999, "myhttp"), (HttpRequest)REQUEST_FULL_EPISODES));
    }

    @Test
    public void testGetURIWithQueryParameters() {
        Assert.assertEquals((Object)"http://www.comcast.net:80/?foo=bar", (Object)this.extractor.generateKey(new HttpHost("www.comcast.net", -1, "http"), (HttpRequest)new BasicHttpRequest("GET", "/?foo=bar")));
        Assert.assertEquals((Object)"http://www.fancast.com:80/full_episodes?foo=bar", (Object)this.extractor.generateKey(new HttpHost("www.fancast.com", -1, "http"), (HttpRequest)new BasicHttpRequest("GET", "/full_episodes?foo=bar")));
    }

    @Test
    public void testGetVariantURIWithNoVaryHeaderReturnsNormalURI() {
        String theURI = "theURI";
        Mockito.when((Object)this.mockEntry.hasVariants()).thenReturn((Object)false);
        this.extractor = new CacheKeyGenerator(){

            public String generateKey(HttpHost h, HttpRequest req) {
                Assert.assertSame((Object)TestCacheKeyGenerator.this.defaultHost, (Object)h);
                Assert.assertSame((Object)TestCacheKeyGenerator.this.mockRequest, (Object)req);
                return "theURI";
            }
        };
        String result = this.extractor.generateVariantURI(this.defaultHost, this.mockRequest, this.mockEntry);
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).hasVariants();
        Assert.assertSame((Object)"theURI", (Object)result);
    }

    @Test
    public void testGetVariantURIWithSingleValueVaryHeaderPrepends() {
        String theURI = "theURI";
        Header[] varyHeaders = new Header[]{new BasicHeader("Vary", (Object)"Accept-Encoding")};
        Header[] encHeaders = new Header[]{new BasicHeader("Accept-Encoding", (Object)"gzip")};
        this.extractor = new CacheKeyGenerator(){

            public String generateKey(HttpHost h, HttpRequest req) {
                Assert.assertSame((Object)TestCacheKeyGenerator.this.defaultHost, (Object)h);
                Assert.assertSame((Object)TestCacheKeyGenerator.this.mockRequest, (Object)req);
                return "theURI";
            }
        };
        Mockito.when((Object)this.mockEntry.hasVariants()).thenReturn((Object)true);
        Mockito.when((Object)this.mockEntry.headerIterator("Vary")).thenReturn((Object)new BasicHeaderIterator(varyHeaders, "Vary"));
        Mockito.when((Object)this.mockRequest.getHeaders("Accept-Encoding")).thenReturn((Object)encHeaders);
        String result = this.extractor.generateVariantURI(this.defaultHost, this.mockRequest, this.mockEntry);
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).hasVariants();
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).headerIterator("Vary");
        ((HttpRequest)Mockito.verify((Object)this.mockRequest)).getHeaders("Accept-Encoding");
        Assert.assertEquals((Object)"{Accept-Encoding=gzip}theURI", (Object)result);
    }

    @Test
    public void testGetVariantURIWithMissingRequestHeader() {
        String theURI = "theURI";
        Header[] noHeaders = new Header[]{};
        Header[] varyHeaders = new Header[]{new BasicHeader("Vary", (Object)"Accept-Encoding")};
        this.extractor = new CacheKeyGenerator(){

            public String generateKey(HttpHost h, HttpRequest req) {
                Assert.assertSame((Object)TestCacheKeyGenerator.this.defaultHost, (Object)h);
                Assert.assertSame((Object)TestCacheKeyGenerator.this.mockRequest, (Object)req);
                return "theURI";
            }
        };
        Mockito.when((Object)this.mockEntry.hasVariants()).thenReturn((Object)true);
        Mockito.when((Object)this.mockEntry.headerIterator("Vary")).thenReturn((Object)new BasicHeaderIterator(varyHeaders, "Vary"));
        Mockito.when((Object)this.mockRequest.getHeaders("Accept-Encoding")).thenReturn((Object)noHeaders);
        String result = this.extractor.generateVariantURI(this.defaultHost, this.mockRequest, this.mockEntry);
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).hasVariants();
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).headerIterator("Vary");
        ((HttpRequest)Mockito.verify((Object)this.mockRequest)).getHeaders("Accept-Encoding");
        Assert.assertEquals((Object)"{Accept-Encoding=}theURI", (Object)result);
    }

    @Test
    public void testGetVariantURIAlphabetizesWithMultipleVaryingHeaders() {
        String theURI = "theURI";
        Header[] varyHeaders = new Header[]{new BasicHeader("Vary", (Object)"User-Agent, Accept-Encoding")};
        Header[] encHeaders = new Header[]{new BasicHeader("Accept-Encoding", (Object)"gzip")};
        Header[] uaHeaders = new Header[]{new BasicHeader("User-Agent", (Object)"browser")};
        this.extractor = new CacheKeyGenerator(){

            public String generateKey(HttpHost h, HttpRequest req) {
                Assert.assertSame((Object)TestCacheKeyGenerator.this.defaultHost, (Object)h);
                Assert.assertSame((Object)TestCacheKeyGenerator.this.mockRequest, (Object)req);
                return "theURI";
            }
        };
        Mockito.when((Object)this.mockEntry.hasVariants()).thenReturn((Object)true);
        Mockito.when((Object)this.mockEntry.headerIterator("Vary")).thenReturn((Object)new BasicHeaderIterator(varyHeaders, "Vary"));
        Mockito.when((Object)this.mockRequest.getHeaders("Accept-Encoding")).thenReturn((Object)encHeaders);
        Mockito.when((Object)this.mockRequest.getHeaders("User-Agent")).thenReturn((Object)uaHeaders);
        String result = this.extractor.generateVariantURI(this.defaultHost, this.mockRequest, this.mockEntry);
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).hasVariants();
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).headerIterator("Vary");
        ((HttpRequest)Mockito.verify((Object)this.mockRequest)).getHeaders("Accept-Encoding");
        ((HttpRequest)Mockito.verify((Object)this.mockRequest)).getHeaders("User-Agent");
        Assert.assertEquals((Object)"{Accept-Encoding=gzip&User-Agent=browser}theURI", (Object)result);
    }

    @Test
    public void testGetVariantURIHandlesMultipleVaryHeaders() {
        String theURI = "theURI";
        Header[] varyHeaders = new Header[]{new BasicHeader("Vary", (Object)"User-Agent"), new BasicHeader("Vary", (Object)"Accept-Encoding")};
        Header[] encHeaders = new Header[]{new BasicHeader("Accept-Encoding", (Object)"gzip")};
        Header[] uaHeaders = new Header[]{new BasicHeader("User-Agent", (Object)"browser")};
        this.extractor = new CacheKeyGenerator(){

            public String generateKey(HttpHost h, HttpRequest req) {
                Assert.assertSame((Object)TestCacheKeyGenerator.this.defaultHost, (Object)h);
                Assert.assertSame((Object)TestCacheKeyGenerator.this.mockRequest, (Object)req);
                return "theURI";
            }
        };
        Mockito.when((Object)this.mockEntry.hasVariants()).thenReturn((Object)true);
        Mockito.when((Object)this.mockEntry.headerIterator("Vary")).thenReturn((Object)new BasicHeaderIterator(varyHeaders, "Vary"));
        Mockito.when((Object)this.mockRequest.getHeaders("Accept-Encoding")).thenReturn((Object)encHeaders);
        Mockito.when((Object)this.mockRequest.getHeaders("User-Agent")).thenReturn((Object)uaHeaders);
        String result = this.extractor.generateVariantURI(this.defaultHost, this.mockRequest, this.mockEntry);
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).hasVariants();
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).headerIterator("Vary");
        ((HttpRequest)Mockito.verify((Object)this.mockRequest)).getHeaders("Accept-Encoding");
        ((HttpRequest)Mockito.verify((Object)this.mockRequest)).getHeaders("User-Agent");
        Assert.assertEquals((Object)"{Accept-Encoding=gzip&User-Agent=browser}theURI", (Object)result);
    }

    @Test
    public void testGetVariantURIHandlesMultipleLineRequestHeaders() {
        String theURI = "theURI";
        Header[] varyHeaders = new Header[]{new BasicHeader("Vary", (Object)"User-Agent, Accept-Encoding")};
        Header[] encHeaders = new Header[]{new BasicHeader("Accept-Encoding", (Object)"gzip"), new BasicHeader("Accept-Encoding", (Object)"deflate")};
        Header[] uaHeaders = new Header[]{new BasicHeader("User-Agent", (Object)"browser")};
        this.extractor = new CacheKeyGenerator(){

            public String generateKey(HttpHost h, HttpRequest req) {
                Assert.assertSame((Object)TestCacheKeyGenerator.this.defaultHost, (Object)h);
                Assert.assertSame((Object)TestCacheKeyGenerator.this.mockRequest, (Object)req);
                return "theURI";
            }
        };
        Mockito.when((Object)this.mockEntry.hasVariants()).thenReturn((Object)true);
        Mockito.when((Object)this.mockEntry.headerIterator("Vary")).thenReturn((Object)new BasicHeaderIterator(varyHeaders, "Vary"));
        Mockito.when((Object)this.mockRequest.getHeaders("Accept-Encoding")).thenReturn((Object)encHeaders);
        Mockito.when((Object)this.mockRequest.getHeaders("User-Agent")).thenReturn((Object)uaHeaders);
        String result = this.extractor.generateVariantURI(this.defaultHost, this.mockRequest, this.mockEntry);
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).hasVariants();
        ((HttpCacheEntry)Mockito.verify((Object)this.mockEntry)).headerIterator("Vary");
        ((HttpRequest)Mockito.verify((Object)this.mockRequest)).getHeaders("Accept-Encoding");
        ((HttpRequest)Mockito.verify((Object)this.mockRequest)).getHeaders("User-Agent");
        Assert.assertEquals((Object)"{Accept-Encoding=gzip%2C+deflate&User-Agent=browser}theURI", (Object)result);
    }

    @Test
    public void testEmptyPortEquivalentToDefaultPortForHttp() {
        HttpHost host1 = new HttpHost("foo.example.com:");
        HttpHost host2 = new HttpHost("foo.example.com:80");
        BasicHttpRequest req = new BasicHttpRequest("GET", "/");
        Assert.assertEquals((Object)this.extractor.generateKey(host1, (HttpRequest)req), (Object)this.extractor.generateKey(host2, (HttpRequest)req));
    }

    @Test
    public void testEmptyPortEquivalentToDefaultPortForHttps() {
        HttpHost host1 = new HttpHost("foo.example.com", -1, "https");
        HttpHost host2 = new HttpHost("foo.example.com", 443, "https");
        BasicHttpRequest req = new BasicHttpRequest("GET", "/");
        String uri1 = this.extractor.generateKey(host1, (HttpRequest)req);
        String uri2 = this.extractor.generateKey(host2, (HttpRequest)req);
        Assert.assertEquals((Object)uri1, (Object)uri2);
    }

    @Test
    public void testEmptyPortEquivalentToDefaultPortForHttpsAbsoluteURI() {
        HttpHost host = new HttpHost("foo.example.com", -1, "https");
        HttpGet get1 = new HttpGet("https://bar.example.com:/");
        HttpGet get2 = new HttpGet("https://bar.example.com:443/");
        String uri1 = this.extractor.generateKey(host, (HttpRequest)get1);
        String uri2 = this.extractor.generateKey(host, (HttpRequest)get2);
        Assert.assertEquals((Object)uri1, (Object)uri2);
    }

    @Test
    public void testNotProvidedPortEquivalentToDefaultPortForHttpsAbsoluteURI() {
        HttpHost host = new HttpHost("foo.example.com", -1, "https");
        HttpGet get1 = new HttpGet("https://bar.example.com/");
        HttpGet get2 = new HttpGet("https://bar.example.com:443/");
        String uri1 = this.extractor.generateKey(host, (HttpRequest)get1);
        String uri2 = this.extractor.generateKey(host, (HttpRequest)get2);
        Assert.assertEquals((Object)uri1, (Object)uri2);
    }

    @Test
    public void testNotProvidedPortEquivalentToDefaultPortForHttp() {
        HttpHost host1 = new HttpHost("foo.example.com");
        HttpHost host2 = new HttpHost("foo.example.com:80");
        BasicHttpRequest req = new BasicHttpRequest("GET", "/");
        Assert.assertEquals((Object)this.extractor.generateKey(host1, (HttpRequest)req), (Object)this.extractor.generateKey(host2, (HttpRequest)req));
    }

    @Test
    public void testHostNameComparisonsAreCaseInsensitive() {
        HttpHost host1 = new HttpHost("foo.example.com");
        HttpHost host2 = new HttpHost("FOO.EXAMPLE.COM");
        BasicHttpRequest req = new BasicHttpRequest("GET", "/");
        Assert.assertEquals((Object)this.extractor.generateKey(host1, (HttpRequest)req), (Object)this.extractor.generateKey(host2, (HttpRequest)req));
    }

    @Test
    public void testSchemeNameComparisonsAreCaseInsensitive() {
        HttpHost host1 = new HttpHost("foo.example.com", -1, "http");
        HttpHost host2 = new HttpHost("foo.example.com", -1, "HTTP");
        BasicHttpRequest req = new BasicHttpRequest("GET", "/");
        Assert.assertEquals((Object)this.extractor.generateKey(host1, (HttpRequest)req), (Object)this.extractor.generateKey(host2, (HttpRequest)req));
    }

    @Test
    public void testEmptyAbsPathIsEquivalentToSlash() {
        HttpHost host = new HttpHost("foo.example.com");
        BasicHttpRequest req1 = new BasicHttpRequest("GET", "/");
        HttpGet req2 = new HttpGet("http://foo.example.com");
        Assert.assertEquals((Object)this.extractor.generateKey(host, (HttpRequest)req1), (Object)this.extractor.generateKey(host, (HttpRequest)req2));
    }

    @Test
    public void testExtraDotSegmentsAreIgnored() {
        HttpHost host = new HttpHost("foo.example.com");
        BasicHttpRequest req1 = new BasicHttpRequest("GET", "/");
        HttpGet req2 = new HttpGet("http://foo.example.com/./");
        Assert.assertEquals((Object)this.extractor.generateKey(host, (HttpRequest)req1), (Object)this.extractor.generateKey(host, (HttpRequest)req2));
    }

    @Test
    public void testExtraDotDotSegmentsAreIgnored() {
        HttpHost host = new HttpHost("foo.example.com");
        BasicHttpRequest req1 = new BasicHttpRequest("GET", "/");
        HttpGet req2 = new HttpGet("http://foo.example.com/.././../");
        Assert.assertEquals((Object)this.extractor.generateKey(host, (HttpRequest)req1), (Object)this.extractor.generateKey(host, (HttpRequest)req2));
    }

    @Test
    public void testIntermidateDotDotSegementsAreEquivalent() {
        HttpHost host = new HttpHost("foo.example.com");
        BasicHttpRequest req1 = new BasicHttpRequest("GET", "/home.html");
        BasicHttpRequest req2 = new BasicHttpRequest("GET", "/%7Esmith/../home.html");
        Assert.assertEquals((Object)this.extractor.generateKey(host, (HttpRequest)req1), (Object)this.extractor.generateKey(host, (HttpRequest)req2));
    }

    @Test
    public void testIntermidateEncodedDotDotSegementsAreEquivalent() {
        HttpHost host = new HttpHost("foo.example.com");
        BasicHttpRequest req1 = new BasicHttpRequest("GET", "/home.html");
        BasicHttpRequest req2 = new BasicHttpRequest("GET", "/%7Esmith%2F../home.html");
        Assert.assertEquals((Object)this.extractor.generateKey(host, (HttpRequest)req1), (Object)this.extractor.generateKey(host, (HttpRequest)req2));
    }

    @Test
    public void testIntermidateDotSegementsAreEquivalent() {
        HttpHost host = new HttpHost("foo.example.com");
        BasicHttpRequest req1 = new BasicHttpRequest("GET", "/~smith/home.html");
        BasicHttpRequest req2 = new BasicHttpRequest("GET", "/%7Esmith/./home.html");
        Assert.assertEquals((Object)this.extractor.generateKey(host, (HttpRequest)req1), (Object)this.extractor.generateKey(host, (HttpRequest)req2));
    }

    @Test
    public void testEquivalentPathEncodingsAreEquivalent() {
        HttpHost host = new HttpHost("foo.example.com");
        BasicHttpRequest req1 = new BasicHttpRequest("GET", "/~smith/home.html");
        BasicHttpRequest req2 = new BasicHttpRequest("GET", "/%7Esmith/home.html");
        Assert.assertEquals((Object)this.extractor.generateKey(host, (HttpRequest)req1), (Object)this.extractor.generateKey(host, (HttpRequest)req2));
    }

    @Test
    public void testEquivalentExtraPathEncodingsAreEquivalent() {
        HttpHost host = new HttpHost("foo.example.com");
        BasicHttpRequest req1 = new BasicHttpRequest("GET", "/~smith/home.html");
        BasicHttpRequest req2 = new BasicHttpRequest("GET", "/%7Esmith%2Fhome.html");
        Assert.assertEquals((Object)this.extractor.generateKey(host, (HttpRequest)req1), (Object)this.extractor.generateKey(host, (HttpRequest)req2));
    }

    @Test
    public void testEquivalentExtraPathEncodingsWithPercentAreEquivalent() {
        HttpHost host = new HttpHost("foo.example.com");
        BasicHttpRequest req1 = new BasicHttpRequest("GET", "/~smith/home%20folder.html");
        BasicHttpRequest req2 = new BasicHttpRequest("GET", "/%7Esmith%2Fhome%20folder.html");
        Assert.assertEquals((Object)this.extractor.generateKey(host, (HttpRequest)req1), (Object)this.extractor.generateKey(host, (HttpRequest)req2));
    }
}

