/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import java.util.Date;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.impl.cache.CacheEntryUpdater;
import org.apache.hc.client5.http.impl.cache.HttpTestUtils;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCacheEntryUpdater {
    private Date requestDate;
    private Date responseDate;
    private CacheEntryUpdater impl;
    private HttpCacheEntry entry;
    private Date now;
    private Date oneSecondAgo;
    private Date twoSecondsAgo;
    private Date eightSecondsAgo;
    private Date tenSecondsAgo;
    private HttpResponse response;

    @Before
    public void setUp() throws Exception {
        this.requestDate = new Date(System.currentTimeMillis() - 1000L);
        this.responseDate = new Date();
        this.now = new Date();
        this.oneSecondAgo = new Date(this.now.getTime() - 1000L);
        this.twoSecondsAgo = new Date(this.now.getTime() - 2000L);
        this.eightSecondsAgo = new Date(this.now.getTime() - 8000L);
        this.tenSecondsAgo = new Date(this.now.getTime() - 10000L);
        this.response = new BasicHttpResponse(304, "Not Modified");
        this.impl = new CacheEntryUpdater();
    }

    @Test
    public void testUpdateCacheEntryReturnsDifferentEntryInstance() throws IOException {
        this.entry = HttpTestUtils.makeCacheEntry();
        HttpCacheEntry newEntry = this.impl.updateCacheEntry(null, this.entry, this.requestDate, this.responseDate, this.response);
        Assert.assertNotSame((Object)newEntry, (Object)this.entry);
    }

    @Test
    public void testHeadersAreMergedCorrectly() throws IOException {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.responseDate)), new BasicHeader("ETag", (Object)"\"etag\"")};
        this.entry = HttpTestUtils.makeCacheEntry(headers);
        this.response.setHeaders(new Header[0]);
        HttpCacheEntry updatedEntry = this.impl.updateCacheEntry(null, this.entry, new Date(), new Date(), this.response);
        Header[] updatedHeaders = updatedEntry.getAllHeaders();
        Assert.assertEquals((long)2L, (long)updatedHeaders.length);
        this.headersContain(updatedHeaders, "Date", DateUtils.formatDate((Date)this.responseDate));
        this.headersContain(updatedHeaders, "ETag", "\"etag\"");
    }

    @Test
    public void testNewerHeadersReplaceExistingHeaders() throws IOException {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.requestDate)), new BasicHeader("Cache-Control", (Object)"private"), new BasicHeader("ETag", (Object)"\"etag\""), new BasicHeader("Last-Modified", (Object)DateUtils.formatDate((Date)this.requestDate)), new BasicHeader("Cache-Control", (Object)"max-age=0")};
        this.entry = HttpTestUtils.makeCacheEntry(headers);
        this.response.setHeaders(new Header[]{new BasicHeader("Last-Modified", (Object)DateUtils.formatDate((Date)this.responseDate)), new BasicHeader("Cache-Control", (Object)"public")});
        HttpCacheEntry updatedEntry = this.impl.updateCacheEntry(null, this.entry, new Date(), new Date(), this.response);
        Header[] updatedHeaders = updatedEntry.getAllHeaders();
        Assert.assertEquals((long)4L, (long)updatedHeaders.length);
        this.headersContain(updatedHeaders, "Date", DateUtils.formatDate((Date)this.requestDate));
        this.headersContain(updatedHeaders, "ETag", "\"etag\"");
        this.headersContain(updatedHeaders, "Last-Modified", DateUtils.formatDate((Date)this.responseDate));
        this.headersContain(updatedHeaders, "Cache-Control", "public");
    }

    @Test
    public void testNewHeadersAreAddedByMerge() throws IOException {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.requestDate)), new BasicHeader("ETag", (Object)"\"etag\"")};
        this.entry = HttpTestUtils.makeCacheEntry(headers);
        this.response.setHeaders(new Header[]{new BasicHeader("Last-Modified", (Object)DateUtils.formatDate((Date)this.responseDate)), new BasicHeader("Cache-Control", (Object)"public")});
        HttpCacheEntry updatedEntry = this.impl.updateCacheEntry(null, this.entry, new Date(), new Date(), this.response);
        Header[] updatedHeaders = updatedEntry.getAllHeaders();
        Assert.assertEquals((long)4L, (long)updatedHeaders.length);
        this.headersContain(updatedHeaders, "Date", DateUtils.formatDate((Date)this.requestDate));
        this.headersContain(updatedHeaders, "ETag", "\"etag\"");
        this.headersContain(updatedHeaders, "Last-Modified", DateUtils.formatDate((Date)this.responseDate));
        this.headersContain(updatedHeaders, "Cache-Control", "public");
    }

    @Test
    public void oldHeadersRetainedIfResponseOlderThanEntry() throws Exception {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.oneSecondAgo)), new BasicHeader("ETag", (Object)"\"new-etag\"")};
        this.entry = HttpTestUtils.makeCacheEntry(this.twoSecondsAgo, this.now, headers);
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo));
        this.response.setHeader("ETag", (Object)"\"old-etag\"");
        HttpCacheEntry result = this.impl.updateCacheEntry("A", this.entry, new Date(), new Date(), this.response);
        Assert.assertEquals((long)2L, (long)result.getAllHeaders().length);
        this.headersContain(result.getAllHeaders(), "Date", DateUtils.formatDate((Date)this.oneSecondAgo));
        this.headersContain(result.getAllHeaders(), "ETag", "\"new-etag\"");
    }

    @Test
    public void testUpdatedEntryHasLatestRequestAndResponseDates() throws IOException {
        this.entry = HttpTestUtils.makeCacheEntry(this.tenSecondsAgo, this.eightSecondsAgo);
        HttpCacheEntry updated = this.impl.updateCacheEntry(null, this.entry, this.twoSecondsAgo, this.oneSecondAgo, this.response);
        Assert.assertEquals((Object)this.twoSecondsAgo, (Object)updated.getRequestDate());
        Assert.assertEquals((Object)this.oneSecondAgo, (Object)updated.getResponseDate());
    }

    @Test
    public void entry1xxWarningsAreRemovedOnUpdate() throws Exception {
        Header[] headers = new Header[]{new BasicHeader("Warning", (Object)"110 fred \"Response is stale\""), new BasicHeader("ETag", (Object)"\"old\""), new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.eightSecondsAgo))};
        this.entry = HttpTestUtils.makeCacheEntry(this.tenSecondsAgo, this.eightSecondsAgo, headers);
        this.response.setHeader("ETag", (Object)"\"new\"");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.twoSecondsAgo));
        HttpCacheEntry updated = this.impl.updateCacheEntry(null, this.entry, this.twoSecondsAgo, this.oneSecondAgo, this.response);
        Assert.assertEquals((long)0L, (long)updated.getHeaders("Warning").length);
    }

    @Test
    public void entryWithMalformedDateIsStillUpdated() throws Exception {
        Header[] headers = new Header[]{new BasicHeader("ETag", (Object)"\"old\""), new BasicHeader("Date", (Object)"bad-date")};
        this.entry = HttpTestUtils.makeCacheEntry(this.tenSecondsAgo, this.eightSecondsAgo, headers);
        this.response.setHeader("ETag", (Object)"\"new\"");
        this.response.setHeader("Date", (Object)DateUtils.formatDate((Date)this.twoSecondsAgo));
        HttpCacheEntry updated = this.impl.updateCacheEntry(null, this.entry, this.twoSecondsAgo, this.oneSecondAgo, this.response);
        Assert.assertEquals((Object)"\"new\"", (Object)updated.getFirstHeader("ETag").getValue());
    }

    @Test
    public void entryIsStillUpdatedByResponseWithMalformedDate() throws Exception {
        Header[] headers = new Header[]{new BasicHeader("ETag", (Object)"\"old\""), new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.tenSecondsAgo))};
        this.entry = HttpTestUtils.makeCacheEntry(this.tenSecondsAgo, this.eightSecondsAgo, headers);
        this.response.setHeader("ETag", (Object)"\"new\"");
        this.response.setHeader("Date", (Object)"bad-date");
        HttpCacheEntry updated = this.impl.updateCacheEntry(null, this.entry, this.twoSecondsAgo, this.oneSecondAgo, this.response);
        Assert.assertEquals((Object)"\"new\"", (Object)updated.getFirstHeader("ETag").getValue());
    }

    @Test
    public void cannotUpdateFromANon304OriginResponse() throws Exception {
        this.entry = HttpTestUtils.makeCacheEntry();
        this.response = new BasicHttpResponse(200, "OK");
        try {
            this.impl.updateCacheEntry("A", this.entry, new Date(), new Date(), this.response);
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void headersContain(Header[] headers, String name, String value) {
        for (Header header : headers) {
            if (!header.getName().equals(name) || !header.getValue().equals(value)) continue;
            return;
        }
        Assert.fail((String)("Header [" + name + ": " + value + "] not found in headers."));
    }
}

