/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheStorageEntry;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.client5.http.impl.cache.ByteArrayCacheEntrySerializer;
import org.apache.hc.client5.http.impl.cache.HeapResource;
import org.apache.hc.client5.http.impl.cache.HttpCacheEntryMatcher;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestByteArrayCacheEntrySerializer {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private ByteArrayCacheEntrySerializer impl;

    @Before
    public void setUp() {
        this.impl = new ByteArrayCacheEntrySerializer();
    }

    @Test
    public void canSerializeEntriesWithVariantMaps() throws Exception {
        this.readWriteVerify(this.makeCacheEntryWithVariantMap("key"));
    }

    public void readWriteVerify(HttpCacheStorageEntry writeEntry) throws Exception {
        byte[] bytes = this.impl.serialize(writeEntry);
        HttpCacheStorageEntry readEntry = this.impl.deserialize(bytes);
        Assert.assertEquals((Object)readEntry.getKey(), (Object)writeEntry.getKey());
        Assert.assertThat((Object)readEntry.getContent(), HttpCacheEntryMatcher.equivalent(writeEntry.getContent()));
    }

    private HttpCacheStorageEntry makeCacheEntryWithVariantMap(String key) {
        Header[] headers = new Header[5];
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = new BasicHeader("header" + i, (Object)("value" + i));
        }
        String body = "Lorem ipsum dolor sit amet";
        HashMap<String, String> variantMap = new HashMap<String, String>();
        variantMap.put("test variant 1", "true");
        variantMap.put("test variant 2", "true");
        HttpCacheEntry cacheEntry = new HttpCacheEntry(new Date(), new Date(), 200, headers, (Resource)new HeapResource(Base64.decodeBase64((byte[])"Lorem ipsum dolor sit amet".getBytes(UTF8))), variantMap);
        return new HttpCacheStorageEntry(key, cacheEntry);
    }
}

