/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheStorage;
import org.apache.hc.client5.http.cache.ResourceFactory;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpTrace;
import org.apache.hc.client5.http.impl.cache.BasicHttpCache;
import org.apache.hc.client5.http.impl.cache.CacheKeyGenerator;
import org.apache.hc.client5.http.impl.cache.HeapResourceFactory;
import org.apache.hc.client5.http.impl.cache.HttpTestUtils;
import org.apache.hc.client5.http.impl.cache.SimpleHttpCacheStorage;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBasicHttpCache {
    private BasicHttpCache impl;
    private SimpleHttpCacheStorage backing;

    @Before
    public void setUp() throws Exception {
        this.backing = new SimpleHttpCacheStorage();
        this.impl = new BasicHttpCache((ResourceFactory)new HeapResourceFactory(), (HttpCacheStorage)this.backing);
    }

    @Test
    public void testDoNotFlushCacheEntriesOnGet() throws Exception {
        HttpHost host = new HttpHost("foo.example.com");
        HttpGet req = new HttpGet("/bar");
        String key = new CacheKeyGenerator().generateKey(host, (HttpRequest)req);
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry();
        this.backing.map.put(key, entry);
        this.impl.flushCacheEntriesFor(host, (HttpRequest)req);
        Assert.assertEquals((Object)entry, (Object)this.backing.map.get(key));
    }

    @Test
    public void testDoNotFlushCacheEntriesOnHead() throws Exception {
        HttpHost host = new HttpHost("foo.example.com");
        HttpHead req = new HttpHead("/bar");
        String key = new CacheKeyGenerator().generateKey(host, (HttpRequest)req);
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry();
        this.backing.map.put(key, entry);
        this.impl.flushCacheEntriesFor(host, (HttpRequest)req);
        Assert.assertEquals((Object)entry, (Object)this.backing.map.get(key));
    }

    @Test
    public void testDoNotFlushCacheEntriesOnOptions() throws Exception {
        HttpHost host = new HttpHost("foo.example.com");
        HttpOptions req = new HttpOptions("/bar");
        String key = new CacheKeyGenerator().generateKey(host, (HttpRequest)req);
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry();
        this.backing.map.put(key, entry);
        this.impl.flushCacheEntriesFor(host, (HttpRequest)req);
        Assert.assertEquals((Object)entry, (Object)this.backing.map.get(key));
    }

    @Test
    public void testDoNotFlushCacheEntriesOnTrace() throws Exception {
        HttpHost host = new HttpHost("foo.example.com");
        HttpTrace req = new HttpTrace("/bar");
        String key = new CacheKeyGenerator().generateKey(host, (HttpRequest)req);
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry();
        this.backing.map.put(key, entry);
        this.impl.flushCacheEntriesFor(host, (HttpRequest)req);
        Assert.assertEquals((Object)entry, (Object)this.backing.map.get(key));
    }

    @Test
    public void testFlushContentLocationEntryIfUnSafeRequest() throws Exception {
        HttpHost host = new HttpHost("foo.example.com");
        HttpPost req = new HttpPost("/foo");
        ClassicHttpResponse resp = HttpTestUtils.make200Response();
        resp.setHeader("Content-Location", (Object)"/bar");
        resp.setHeader("ETag", (Object)"\"etag\"");
        String key = new CacheKeyGenerator().generateKey(host, (HttpRequest)new HttpGet("/bar"));
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)new Date())), new BasicHeader("ETag", (Object)"\"old-etag\"")});
        this.backing.map.put(key, entry);
        this.impl.flushInvalidatedCacheEntriesFor(host, (HttpRequest)req, (HttpResponse)resp);
        Assert.assertNull((Object)this.backing.map.get(key));
    }

    @Test
    public void testDoNotFlushContentLocationEntryIfSafeRequest() throws Exception {
        HttpHost host = new HttpHost("foo.example.com");
        HttpGet req = new HttpGet("/foo");
        ClassicHttpResponse resp = HttpTestUtils.make200Response();
        resp.setHeader("Content-Location", (Object)"/bar");
        String key = new CacheKeyGenerator().generateKey(host, (HttpRequest)new HttpGet("/bar"));
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry(new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)new Date())), new BasicHeader("ETag", (Object)"\"old-etag\"")});
        this.backing.map.put(key, entry);
        this.impl.flushInvalidatedCacheEntriesFor(host, (HttpRequest)req, (HttpResponse)resp);
        Assert.assertEquals((Object)entry, (Object)this.backing.map.get(key));
    }

    @Test
    public void testCanFlushCacheEntriesAtUri() throws Exception {
        HttpHost host = new HttpHost("foo.example.com");
        HttpDelete req = new HttpDelete("/bar");
        String key = new CacheKeyGenerator().generateKey(host, (HttpRequest)req);
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry();
        this.backing.map.put(key, entry);
        this.impl.flushCacheEntriesFor(host, (HttpRequest)req);
        Assert.assertNull((Object)this.backing.map.get(key));
    }

    @Test
    public void testCacheUpdateAddsVariantURIToParentEntry() throws Exception {
        String parentCacheKey = "parentCacheKey";
        String variantCacheKey = "variantCacheKey";
        String existingVariantKey = "existingVariantKey";
        String newVariantCacheKey = "newVariantCacheKey";
        String newVariantKey = "newVariantKey";
        HashMap<String, String> existingVariants = new HashMap<String, String>();
        existingVariants.put("existingVariantKey", "variantCacheKey");
        HttpCacheEntry parent = HttpTestUtils.makeCacheEntry(existingVariants);
        HttpCacheEntry variant = HttpTestUtils.makeCacheEntry();
        HttpCacheEntry result = this.impl.doGetUpdatedParentEntry("parentCacheKey", parent, variant, "newVariantKey", "newVariantCacheKey");
        Map resultMap = result.getVariantMap();
        Assert.assertEquals((long)2L, (long)resultMap.size());
        Assert.assertEquals((Object)"variantCacheKey", resultMap.get("existingVariantKey"));
        Assert.assertEquals((Object)"newVariantCacheKey", resultMap.get("newVariantKey"));
    }

    @Test
    public void testStoreInCachePutsNonVariantEntryInPlace() throws Exception {
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry();
        Assert.assertFalse((boolean)entry.hasVariants());
        HttpHost host = new HttpHost("foo.example.com");
        HttpGet req = new HttpGet("http://foo.example.com/bar");
        String key = new CacheKeyGenerator().generateKey(host, (HttpRequest)req);
        this.impl.storeInCache(host, (HttpRequest)req, entry);
        Assert.assertSame((Object)entry, (Object)this.backing.map.get(key));
    }

    @Test
    public void testGetCacheEntryReturnsNullOnCacheMiss() throws Exception {
        HttpHost host = new HttpHost("foo.example.com");
        HttpGet request = new HttpGet("http://foo.example.com/bar");
        HttpCacheEntry result = this.impl.getCacheEntry(host, (HttpRequest)request);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testGetCacheEntryFetchesFromCacheOnCacheHitIfNoVariants() throws Exception {
        HttpCacheEntry entry = HttpTestUtils.makeCacheEntry();
        Assert.assertFalse((boolean)entry.hasVariants());
        HttpHost host = new HttpHost("foo.example.com");
        HttpGet request = new HttpGet("http://foo.example.com/bar");
        String key = new CacheKeyGenerator().generateKey(host, (HttpRequest)request);
        this.backing.map.put(key, entry);
        HttpCacheEntry result = this.impl.getCacheEntry(host, (HttpRequest)request);
        Assert.assertSame((Object)entry, (Object)result);
    }

    @Test
    public void testGetCacheEntryReturnsNullIfNoVariantInCache() throws Exception {
        HttpHost host = new HttpHost("foo.example.com");
        HttpGet origRequest = new HttpGet("http://foo.example.com/bar");
        origRequest.setHeader("Accept-Encoding", (Object)"gzip");
        ByteArrayBuffer buf = HttpTestUtils.getRandomBuffer(128);
        BasicHttpResponse origResponse = new BasicHttpResponse(200, "OK");
        origResponse.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        origResponse.setHeader("Cache-Control", (Object)"max-age=3600, public");
        origResponse.setHeader("ETag", (Object)"\"etag\"");
        origResponse.setHeader("Vary", (Object)"Accept-Encoding");
        origResponse.setHeader("Content-Encoding", (Object)"gzip");
        this.impl.createCacheEntry(host, (HttpRequest)origRequest, (HttpResponse)origResponse, buf, new Date(), new Date());
        HttpGet request = new HttpGet("http://foo.example.com/bar");
        HttpCacheEntry result = this.impl.getCacheEntry(host, (HttpRequest)request);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testGetCacheEntryReturnsVariantIfPresentInCache() throws Exception {
        HttpHost host = new HttpHost("foo.example.com");
        HttpGet origRequest = new HttpGet("http://foo.example.com/bar");
        origRequest.setHeader("Accept-Encoding", (Object)"gzip");
        ByteArrayBuffer buf = HttpTestUtils.getRandomBuffer(128);
        BasicHttpResponse origResponse = new BasicHttpResponse(200, "OK");
        origResponse.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        origResponse.setHeader("Cache-Control", (Object)"max-age=3600, public");
        origResponse.setHeader("ETag", (Object)"\"etag\"");
        origResponse.setHeader("Vary", (Object)"Accept-Encoding");
        origResponse.setHeader("Content-Encoding", (Object)"gzip");
        this.impl.createCacheEntry(host, (HttpRequest)origRequest, (HttpResponse)origResponse, buf, new Date(), new Date());
        HttpGet request = new HttpGet("http://foo.example.com/bar");
        request.setHeader("Accept-Encoding", (Object)"gzip");
        HttpCacheEntry result = this.impl.getCacheEntry(host, (HttpRequest)request);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetVariantCacheEntriesReturnsEmptySetOnNoVariants() throws Exception {
        HttpHost host = new HttpHost("foo.example.com");
        HttpGet request = new HttpGet("http://foo.example.com/bar");
        Map variants = this.impl.getVariantCacheEntriesWithEtags(host, (HttpRequest)request);
        Assert.assertNotNull((Object)variants);
        Assert.assertEquals((long)0L, (long)variants.size());
    }

    @Test
    public void testGetVariantCacheEntriesReturnsAllVariants() throws Exception {
        HttpHost host = new HttpHost("foo.example.com");
        HttpGet req1 = new HttpGet("http://foo.example.com/bar");
        req1.setHeader("Accept-Encoding", (Object)"gzip");
        ClassicHttpResponse resp1 = HttpTestUtils.make200Response();
        resp1.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        resp1.setHeader("Cache-Control", (Object)"max-age=3600, public");
        resp1.setHeader("ETag", (Object)"\"etag1\"");
        resp1.setHeader("Vary", (Object)"Accept-Encoding");
        resp1.setHeader("Content-Encoding", (Object)"gzip");
        resp1.setHeader("Vary", (Object)"Accept-Encoding");
        HttpGet req2 = new HttpGet("http://foo.example.com/bar");
        req2.setHeader("Accept-Encoding", (Object)"identity");
        ClassicHttpResponse resp2 = HttpTestUtils.make200Response();
        resp2.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        resp2.setHeader("Cache-Control", (Object)"max-age=3600, public");
        resp2.setHeader("ETag", (Object)"\"etag2\"");
        resp2.setHeader("Vary", (Object)"Accept-Encoding");
        resp2.setHeader("Content-Encoding", (Object)"gzip");
        resp2.setHeader("Vary", (Object)"Accept-Encoding");
        this.impl.createCacheEntry(host, (HttpRequest)req1, (HttpResponse)resp1, null, new Date(), new Date());
        this.impl.createCacheEntry(host, (HttpRequest)req2, (HttpResponse)resp2, null, new Date(), new Date());
        Map variants = this.impl.getVariantCacheEntriesWithEtags(host, (HttpRequest)req1);
        Assert.assertNotNull((Object)variants);
        Assert.assertEquals((long)2L, (long)variants.size());
    }
}

