/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.cache.AsynchronousValidationRequest;
import org.apache.hc.client5.http.impl.cache.AsynchronousValidator;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CachingExec;
import org.apache.hc.client5.http.impl.cache.ImmediateSchedulingStrategy;
import org.apache.hc.client5.http.impl.cache.SchedulingStrategy;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHeaderIterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestAsynchronousValidator {
    private AsynchronousValidator impl;
    private CachingExec mockClient;
    private HttpHost host;
    private HttpRoute route;
    private ClassicHttpRequest request;
    private HttpClientContext context;
    private ExecChain.Scope scope;
    private ExecChain mockExecChain;
    private ExecRuntime mockEndpoint;
    private HttpCacheEntry mockCacheEntry;
    private SchedulingStrategy mockSchedulingStrategy;

    @Before
    public void setUp() {
        this.mockClient = (CachingExec)Mockito.mock(CachingExec.class);
        this.host = new HttpHost("foo.example.com", 80);
        this.route = new HttpRoute(this.host);
        this.request = new HttpGet("/");
        this.context = HttpClientContext.create();
        this.mockExecChain = (ExecChain)Mockito.mock(ExecChain.class);
        this.mockEndpoint = (ExecRuntime)Mockito.mock(ExecRuntime.class);
        this.mockCacheEntry = (HttpCacheEntry)Mockito.mock(HttpCacheEntry.class);
        this.mockSchedulingStrategy = (SchedulingStrategy)Mockito.mock(SchedulingStrategy.class);
        this.scope = new ExecChain.Scope("test", this.route, this.request, this.mockEndpoint, this.context);
    }

    @Test
    public void testRevalidateCacheEntrySchedulesExecutionAndPopulatesIdentifier() {
        this.impl = new AsynchronousValidator(this.mockSchedulingStrategy);
        Mockito.when((Object)this.mockCacheEntry.hasVariants()).thenReturn((Object)false);
        this.impl.revalidateCacheEntry(this.mockClient, this.host, this.request, this.scope, this.mockExecChain, this.mockCacheEntry);
        ((HttpCacheEntry)Mockito.verify((Object)this.mockCacheEntry)).hasVariants();
        ((SchedulingStrategy)Mockito.verify((Object)this.mockSchedulingStrategy)).schedule((AsynchronousValidationRequest)ArgumentMatchers.isA(AsynchronousValidationRequest.class));
        Assert.assertEquals((long)1L, (long)this.impl.getScheduledIdentifiers().size());
    }

    @Test
    public void testMarkCompleteRemovesIdentifier() {
        this.impl = new AsynchronousValidator(this.mockSchedulingStrategy);
        Mockito.when((Object)this.mockCacheEntry.hasVariants()).thenReturn((Object)false);
        this.impl.revalidateCacheEntry(this.mockClient, this.host, this.request, this.scope, this.mockExecChain, this.mockCacheEntry);
        ArgumentCaptor cap = ArgumentCaptor.forClass(AsynchronousValidationRequest.class);
        ((HttpCacheEntry)Mockito.verify((Object)this.mockCacheEntry)).hasVariants();
        ((SchedulingStrategy)Mockito.verify((Object)this.mockSchedulingStrategy)).schedule((AsynchronousValidationRequest)cap.capture());
        Assert.assertEquals((long)1L, (long)this.impl.getScheduledIdentifiers().size());
        this.impl.markComplete(((AsynchronousValidationRequest)cap.getValue()).getIdentifier());
        Assert.assertEquals((long)0L, (long)this.impl.getScheduledIdentifiers().size());
    }

    @Test
    public void testRevalidateCacheEntryDoesNotPopulateIdentifierOnRejectedExecutionException() {
        this.impl = new AsynchronousValidator(this.mockSchedulingStrategy);
        Mockito.when((Object)this.mockCacheEntry.hasVariants()).thenReturn((Object)false);
        ((SchedulingStrategy)Mockito.doThrow((Throwable[])new Throwable[]{new RejectedExecutionException()}).when((Object)this.mockSchedulingStrategy)).schedule((AsynchronousValidationRequest)ArgumentMatchers.isA(AsynchronousValidationRequest.class));
        this.impl.revalidateCacheEntry(this.mockClient, this.host, this.request, this.scope, this.mockExecChain, this.mockCacheEntry);
        ((HttpCacheEntry)Mockito.verify((Object)this.mockCacheEntry)).hasVariants();
        Assert.assertEquals((long)0L, (long)this.impl.getScheduledIdentifiers().size());
        ((SchedulingStrategy)Mockito.verify((Object)this.mockSchedulingStrategy)).schedule((AsynchronousValidationRequest)ArgumentMatchers.isA(AsynchronousValidationRequest.class));
    }

    @Test
    public void testRevalidateCacheEntryProperlyCollapsesRequest() {
        this.impl = new AsynchronousValidator(this.mockSchedulingStrategy);
        Mockito.when((Object)this.mockCacheEntry.hasVariants()).thenReturn((Object)false);
        this.impl.revalidateCacheEntry(this.mockClient, this.host, this.request, this.scope, this.mockExecChain, this.mockCacheEntry);
        this.impl.revalidateCacheEntry(this.mockClient, this.host, this.request, this.scope, this.mockExecChain, this.mockCacheEntry);
        ((HttpCacheEntry)Mockito.verify((Object)this.mockCacheEntry, (VerificationMode)Mockito.times((int)2))).hasVariants();
        ((SchedulingStrategy)Mockito.verify((Object)this.mockSchedulingStrategy)).schedule((AsynchronousValidationRequest)ArgumentMatchers.isA(AsynchronousValidationRequest.class));
        Assert.assertEquals((long)1L, (long)this.impl.getScheduledIdentifiers().size());
    }

    @Test
    public void testVariantsBothRevalidated() {
        this.impl = new AsynchronousValidator(this.mockSchedulingStrategy);
        HttpGet req1 = new HttpGet("/");
        req1.addHeader((Header)new BasicHeader("Accept-Encoding", (Object)"identity"));
        HttpGet req2 = new HttpGet("/");
        req2.addHeader((Header)new BasicHeader("Accept-Encoding", (Object)"gzip"));
        Header[] variantHeaders = new Header[]{new BasicHeader("Vary", (Object)"Accept-Encoding")};
        Mockito.when((Object)this.mockCacheEntry.hasVariants()).thenReturn((Object)true);
        Mockito.when((Object)this.mockCacheEntry.headerIterator("Vary")).thenReturn((Object)new BasicHeaderIterator(variantHeaders, "Vary"));
        this.mockSchedulingStrategy.schedule((AsynchronousValidationRequest)ArgumentMatchers.isA(AsynchronousValidationRequest.class));
        this.impl.revalidateCacheEntry(this.mockClient, this.host, (ClassicHttpRequest)req1, new ExecChain.Scope("test", this.route, (ClassicHttpRequest)req1, this.mockEndpoint, this.context), this.mockExecChain, this.mockCacheEntry);
        this.impl.revalidateCacheEntry(this.mockClient, this.host, (ClassicHttpRequest)req2, new ExecChain.Scope("test", this.route, (ClassicHttpRequest)req2, this.mockEndpoint, this.context), this.mockExecChain, this.mockCacheEntry);
        ((HttpCacheEntry)Mockito.verify((Object)this.mockCacheEntry, (VerificationMode)Mockito.times((int)2))).hasVariants();
        ((HttpCacheEntry)Mockito.verify((Object)this.mockCacheEntry, (VerificationMode)Mockito.times((int)2))).headerIterator("Vary");
        ((SchedulingStrategy)Mockito.verify((Object)this.mockSchedulingStrategy, (VerificationMode)Mockito.times((int)2))).schedule((AsynchronousValidationRequest)ArgumentMatchers.isA(AsynchronousValidationRequest.class));
        Assert.assertEquals((long)2L, (long)this.impl.getScheduledIdentifiers().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRevalidateCacheEntryEndToEnd() throws Exception {
        CacheConfig config = CacheConfig.custom().setAsynchronousWorkersMax(1).setAsynchronousWorkersCore(1).build();
        ImmediateSchedulingStrategy schedulingStrategy = new ImmediateSchedulingStrategy(config);
        this.impl = new AsynchronousValidator((SchedulingStrategy)schedulingStrategy);
        Mockito.when((Object)this.mockCacheEntry.hasVariants()).thenReturn((Object)false);
        Mockito.when((Object)this.mockClient.revalidateCacheEntry(this.host, this.request, this.scope, this.mockExecChain, this.mockCacheEntry)).thenReturn(null);
        this.impl.revalidateCacheEntry(this.mockClient, this.host, this.request, this.scope, this.mockExecChain, this.mockCacheEntry);
        try {
            schedulingStrategy.close();
            schedulingStrategy.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            ((HttpCacheEntry)Mockito.verify((Object)this.mockCacheEntry)).hasVariants();
            ((CachingExec)Mockito.verify((Object)this.mockClient)).revalidateCacheEntry(this.host, this.request, this.scope, this.mockExecChain, this.mockCacheEntry);
            Assert.assertEquals((long)0L, (long)this.impl.getScheduledIdentifiers().size());
        }
    }

    @Test
    public void testSchedulingStrategyShutdownOnClose() throws IOException {
        this.impl = new AsynchronousValidator(this.mockSchedulingStrategy);
        this.impl.close();
        ((SchedulingStrategy)Mockito.verify((Object)this.mockSchedulingStrategy)).close();
    }
}

