/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.cache.AsynchronousValidationRequest;
import org.apache.hc.client5.http.impl.cache.AsynchronousValidator;
import org.apache.hc.client5.http.impl.cache.CachingExec;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.BasicHeader;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAsynchronousValidationRequest {
    private AsynchronousValidator mockParent;
    private CachingExec mockClient;
    private HttpHost host;
    private HttpRoute route;
    private ClassicHttpRequest request;
    private HttpClientContext context;
    private ExecChain.Scope scope;
    private ExecChain execChain;
    private ExecRuntime mockEndpoint;
    private HttpCacheEntry mockCacheEntry;
    private ClassicHttpResponse mockResponse;

    @Before
    public void setUp() {
        this.mockParent = (AsynchronousValidator)Mockito.mock(AsynchronousValidator.class);
        this.mockClient = (CachingExec)Mockito.mock(CachingExec.class);
        this.host = new HttpHost("foo.example.com", 80);
        this.route = new HttpRoute(this.host);
        this.request = new HttpGet("/");
        this.context = HttpClientContext.create();
        this.mockEndpoint = (ExecRuntime)Mockito.mock(ExecRuntime.class);
        this.execChain = (ExecChain)Mockito.mock(ExecChain.class);
        this.mockCacheEntry = (HttpCacheEntry)Mockito.mock(HttpCacheEntry.class);
        this.mockResponse = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        this.scope = new ExecChain.Scope("test", this.route, this.request, this.mockEndpoint, this.context);
    }

    @Test
    public void testRunCallsCachingClientAndRemovesIdentifier() throws Exception {
        String identifier = "foo";
        AsynchronousValidationRequest impl = new AsynchronousValidationRequest(this.mockParent, this.mockClient, this.host, this.request, this.scope, this.execChain, this.mockCacheEntry, "foo", 0);
        Mockito.when((Object)this.mockClient.revalidateCacheEntry(this.host, this.request, this.scope, this.execChain, this.mockCacheEntry)).thenReturn((Object)this.mockResponse);
        Mockito.when((Object)this.mockResponse.getCode()).thenReturn((Object)200);
        impl.run();
        ((CachingExec)Mockito.verify((Object)this.mockClient)).revalidateCacheEntry(this.host, this.request, this.scope, this.execChain, this.mockCacheEntry);
        ((AsynchronousValidator)Mockito.verify((Object)this.mockParent)).markComplete("foo");
        ((AsynchronousValidator)Mockito.verify((Object)this.mockParent)).jobSuccessful("foo");
    }

    @Test
    public void testRunReportsJobFailedForServerError() throws Exception {
        String identifier = "foo";
        AsynchronousValidationRequest impl = new AsynchronousValidationRequest(this.mockParent, this.mockClient, this.host, this.request, this.scope, this.execChain, this.mockCacheEntry, "foo", 0);
        Mockito.when((Object)this.mockClient.revalidateCacheEntry(this.host, this.request, this.scope, this.execChain, this.mockCacheEntry)).thenReturn((Object)this.mockResponse);
        Mockito.when((Object)this.mockResponse.getCode()).thenReturn((Object)200);
        impl.run();
        ((CachingExec)Mockito.verify((Object)this.mockClient)).revalidateCacheEntry(this.host, this.request, this.scope, this.execChain, this.mockCacheEntry);
        ((AsynchronousValidator)Mockito.verify((Object)this.mockParent)).markComplete("foo");
        ((AsynchronousValidator)Mockito.verify((Object)this.mockParent)).jobSuccessful("foo");
    }

    @Test
    public void testRunReportsJobFailedForStaleResponse() throws Exception {
        String identifier = "foo";
        Header[] warning = new Header[]{new BasicHeader("Warning", (Object)"110 localhost \"Response is stale\"")};
        AsynchronousValidationRequest impl = new AsynchronousValidationRequest(this.mockParent, this.mockClient, this.host, this.request, this.scope, this.execChain, this.mockCacheEntry, "foo", 0);
        Mockito.when((Object)this.mockClient.revalidateCacheEntry(this.host, this.request, this.scope, this.execChain, this.mockCacheEntry)).thenReturn((Object)this.mockResponse);
        Mockito.when((Object)this.mockResponse.getCode()).thenReturn((Object)200);
        Mockito.when((Object)this.mockResponse.getHeaders("Warning")).thenReturn((Object)warning);
        impl.run();
        ((CachingExec)Mockito.verify((Object)this.mockClient)).revalidateCacheEntry(this.host, this.request, this.scope, this.execChain, this.mockCacheEntry);
        ((ClassicHttpResponse)Mockito.verify((Object)this.mockResponse)).getHeaders("Warning");
        ((AsynchronousValidator)Mockito.verify((Object)this.mockParent)).markComplete("foo");
        ((AsynchronousValidator)Mockito.verify((Object)this.mockParent)).jobFailed("foo");
    }

    @Test
    public void testRunGracefullyHandlesProtocolException() throws Exception {
        String identifier = "foo";
        AsynchronousValidationRequest impl = new AsynchronousValidationRequest(this.mockParent, this.mockClient, this.host, this.request, this.scope, this.execChain, this.mockCacheEntry, "foo", 0);
        Mockito.when((Object)this.mockClient.revalidateCacheEntry(this.host, this.request, this.scope, this.execChain, this.mockCacheEntry)).thenThrow(new Throwable[]{new ProtocolException()});
        impl.run();
        ((CachingExec)Mockito.verify((Object)this.mockClient)).revalidateCacheEntry(this.host, this.request, this.scope, this.execChain, this.mockCacheEntry);
        ((AsynchronousValidator)Mockito.verify((Object)this.mockParent)).markComplete("foo");
        ((AsynchronousValidator)Mockito.verify((Object)this.mockParent)).jobFailed("foo");
    }

    @Test
    public void testRunGracefullyHandlesIOException() throws Exception {
        String identifier = "foo";
        AsynchronousValidationRequest impl = new AsynchronousValidationRequest(this.mockParent, this.mockClient, this.host, this.request, this.scope, this.execChain, this.mockCacheEntry, "foo", 0);
        Mockito.when((Object)this.mockClient.revalidateCacheEntry(this.host, this.request, this.scope, this.execChain, this.mockCacheEntry)).thenThrow(new Throwable[]{new IOException()});
        impl.run();
        ((CachingExec)Mockito.verify((Object)this.mockClient)).revalidateCacheEntry(this.host, this.request, this.scope, this.execChain, this.mockCacheEntry);
        ((AsynchronousValidator)Mockito.verify((Object)this.mockParent)).markComplete("foo");
        ((AsynchronousValidator)Mockito.verify((Object)this.mockParent)).jobFailed("foo");
    }

    @Test
    public void testRunGracefullyHandlesRuntimeException() throws Exception {
        String identifier = "foo";
        AsynchronousValidationRequest impl = new AsynchronousValidationRequest(this.mockParent, this.mockClient, this.host, this.request, this.scope, this.execChain, this.mockCacheEntry, "foo", 0);
        Mockito.when((Object)this.mockClient.revalidateCacheEntry(this.host, this.request, this.scope, this.execChain, this.mockCacheEntry)).thenThrow(new Throwable[]{new RuntimeException()});
        impl.run();
        ((CachingExec)Mockito.verify((Object)this.mockClient)).revalidateCacheEntry(this.host, this.request, this.scope, this.execChain, this.mockCacheEntry);
        ((AsynchronousValidator)Mockito.verify((Object)this.mockParent)).markComplete("foo");
        ((AsynchronousValidator)Mockito.verify((Object)this.mockParent)).jobFailed("foo");
    }
}

