/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheStorageEntry;
import org.apache.hc.client5.http.cache.HttpCacheUpdateCallback;
import org.apache.hc.client5.http.cache.HttpCacheUpdateException;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.impl.cache.AbstractBinaryCacheStorage;
import org.apache.hc.client5.http.impl.cache.ByteArrayCacheEntrySerializer;
import org.apache.hc.client5.http.impl.cache.HttpCacheEntryMatcher;
import org.apache.hc.client5.http.impl.cache.HttpTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestAbstractSerializingCacheStorage {
    private AbstractBinaryCacheStorage<String> impl;

    public static byte[] serialize(String key, HttpCacheEntry value) throws ResourceIOException {
        return ByteArrayCacheEntrySerializer.INSTANCE.serialize(new HttpCacheStorageEntry(key, value));
    }

    @Before
    public void setUp() {
        this.impl = (AbstractBinaryCacheStorage)Mockito.mock(AbstractBinaryCacheStorage.class, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)Answers.CALLS_REAL_METHODS).useConstructor(new Object[]{3}));
    }

    @Test
    public void testCachePut() throws Exception {
        String key = "foo";
        HttpCacheEntry value = HttpTestUtils.makeCacheEntry();
        Mockito.when((Object)this.impl.digestToStorageKey("foo")).thenReturn((Object)"bar");
        this.impl.putEntry("foo", value);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(byte[].class);
        ((AbstractBinaryCacheStorage)Mockito.verify(this.impl)).store((String)ArgumentMatchers.eq((Object)"bar"), argumentCaptor.capture());
        Assert.assertArrayEquals((byte[])TestAbstractSerializingCacheStorage.serialize("foo", value), (byte[])((byte[])argumentCaptor.getValue()));
    }

    @Test
    public void testCacheGetNullEntry() throws Exception {
        String key = "foo";
        Mockito.when((Object)this.impl.digestToStorageKey("foo")).thenReturn((Object)"bar");
        Mockito.when((Object)this.impl.restore("bar")).thenReturn(null);
        HttpCacheEntry resultingEntry = this.impl.getEntry("foo");
        ((AbstractBinaryCacheStorage)Mockito.verify(this.impl)).restore("bar");
        Assert.assertThat((Object)resultingEntry, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testCacheGet() throws Exception {
        String key = "foo";
        HttpCacheEntry value = HttpTestUtils.makeCacheEntry();
        Mockito.when((Object)this.impl.digestToStorageKey("foo")).thenReturn((Object)"bar");
        Mockito.when((Object)this.impl.restore("bar")).thenReturn((Object)TestAbstractSerializingCacheStorage.serialize("foo", value));
        HttpCacheEntry resultingEntry = this.impl.getEntry("foo");
        ((AbstractBinaryCacheStorage)Mockito.verify(this.impl)).restore("bar");
        Assert.assertThat((Object)resultingEntry, HttpCacheEntryMatcher.equivalent(value));
    }

    @Test
    public void testCacheGetKeyMismatch() throws Exception {
        String key = "foo";
        HttpCacheEntry value = HttpTestUtils.makeCacheEntry();
        Mockito.when((Object)this.impl.digestToStorageKey("foo")).thenReturn((Object)"bar");
        Mockito.when((Object)this.impl.restore("bar")).thenReturn((Object)TestAbstractSerializingCacheStorage.serialize("not-foo", value));
        HttpCacheEntry resultingEntry = this.impl.getEntry("foo");
        ((AbstractBinaryCacheStorage)Mockito.verify(this.impl)).restore("bar");
        Assert.assertThat((Object)resultingEntry, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testCacheRemove() throws Exception {
        String key = "foo";
        Mockito.when((Object)this.impl.digestToStorageKey("foo")).thenReturn((Object)"bar");
        this.impl.removeEntry("foo");
        ((AbstractBinaryCacheStorage)Mockito.verify(this.impl)).delete("bar");
    }

    @Test
    public void testCacheUpdateNullEntry() throws Exception {
        String key = "foo";
        final HttpCacheEntry updatedValue = HttpTestUtils.makeCacheEntry();
        Mockito.when((Object)this.impl.digestToStorageKey("foo")).thenReturn((Object)"bar");
        Mockito.when((Object)this.impl.getForUpdateCAS("bar")).thenReturn(null);
        this.impl.updateEntry("foo", new HttpCacheUpdateCallback(){

            public HttpCacheEntry update(HttpCacheEntry existing) throws ResourceIOException {
                Assert.assertThat((Object)existing, (Matcher)CoreMatchers.nullValue());
                return updatedValue;
            }
        });
        ((AbstractBinaryCacheStorage)Mockito.verify(this.impl)).getForUpdateCAS("bar");
        ((AbstractBinaryCacheStorage)Mockito.verify(this.impl)).store((String)Mockito.eq((Object)"bar"), Mockito.any());
    }

    @Test
    public void testCacheCASUpdate() throws Exception {
        String key = "foo";
        HttpCacheEntry existingValue = HttpTestUtils.makeCacheEntry();
        final HttpCacheEntry updatedValue = HttpTestUtils.makeCacheEntry();
        Mockito.when((Object)this.impl.digestToStorageKey("foo")).thenReturn((Object)"bar");
        Mockito.when((Object)this.impl.getForUpdateCAS("bar")).thenReturn((Object)"stuff");
        Mockito.when((Object)this.impl.getStorageObject((Object)"stuff")).thenReturn((Object)TestAbstractSerializingCacheStorage.serialize("foo", existingValue));
        Mockito.when((Object)this.impl.updateCAS((String)Mockito.eq((Object)"bar"), Mockito.eq((Object)"stuff"), Mockito.any())).thenReturn((Object)true);
        this.impl.updateEntry("foo", new HttpCacheUpdateCallback(){

            public HttpCacheEntry update(HttpCacheEntry existing) throws ResourceIOException {
                return updatedValue;
            }
        });
        ((AbstractBinaryCacheStorage)Mockito.verify(this.impl)).getForUpdateCAS("bar");
        ((AbstractBinaryCacheStorage)Mockito.verify(this.impl)).getStorageObject((Object)"stuff");
        ((AbstractBinaryCacheStorage)Mockito.verify(this.impl)).updateCAS((String)Mockito.eq((Object)"bar"), Mockito.eq((Object)"stuff"), Mockito.any());
    }

    @Test
    public void testCacheCASUpdateKeyMismatch() throws Exception {
        String key = "foo";
        HttpCacheEntry existingValue = HttpTestUtils.makeCacheEntry();
        final HttpCacheEntry updatedValue = HttpTestUtils.makeCacheEntry();
        Mockito.when((Object)this.impl.digestToStorageKey("foo")).thenReturn((Object)"bar");
        Mockito.when((Object)this.impl.getForUpdateCAS("bar")).thenReturn((Object)"stuff");
        Mockito.when((Object)this.impl.getStorageObject((Object)"stuff")).thenReturn((Object)TestAbstractSerializingCacheStorage.serialize("not-foo", existingValue));
        Mockito.when((Object)this.impl.updateCAS((String)Mockito.eq((Object)"bar"), Mockito.eq((Object)"stuff"), Mockito.any())).thenReturn((Object)true);
        this.impl.updateEntry("foo", new HttpCacheUpdateCallback(){

            public HttpCacheEntry update(HttpCacheEntry existing) throws ResourceIOException {
                Assert.assertThat((Object)existing, (Matcher)CoreMatchers.nullValue());
                return updatedValue;
            }
        });
        ((AbstractBinaryCacheStorage)Mockito.verify(this.impl)).getForUpdateCAS("bar");
        ((AbstractBinaryCacheStorage)Mockito.verify(this.impl)).getStorageObject((Object)"stuff");
        ((AbstractBinaryCacheStorage)Mockito.verify(this.impl)).store((String)Mockito.eq((Object)"bar"), Mockito.any());
    }

    @Test
    public void testSingleCacheUpdateRetry() throws Exception {
        String key = "foo";
        HttpCacheEntry existingValue = HttpTestUtils.makeCacheEntry();
        final HttpCacheEntry updatedValue = HttpTestUtils.makeCacheEntry();
        Mockito.when((Object)this.impl.digestToStorageKey("foo")).thenReturn((Object)"bar");
        Mockito.when((Object)this.impl.getForUpdateCAS("bar")).thenReturn((Object)"stuff");
        Mockito.when((Object)this.impl.getStorageObject((Object)"stuff")).thenReturn((Object)TestAbstractSerializingCacheStorage.serialize("foo", existingValue));
        Mockito.when((Object)this.impl.updateCAS((String)Mockito.eq((Object)"bar"), Mockito.eq((Object)"stuff"), Mockito.any())).thenReturn((Object)false, (Object[])new Boolean[]{true});
        this.impl.updateEntry("foo", new HttpCacheUpdateCallback(){

            public HttpCacheEntry update(HttpCacheEntry existing) throws ResourceIOException {
                return updatedValue;
            }
        });
        ((AbstractBinaryCacheStorage)Mockito.verify(this.impl, (VerificationMode)Mockito.times((int)2))).getForUpdateCAS("bar");
        ((AbstractBinaryCacheStorage)Mockito.verify(this.impl, (VerificationMode)Mockito.times((int)2))).getStorageObject((Object)"stuff");
        ((AbstractBinaryCacheStorage)Mockito.verify(this.impl, (VerificationMode)Mockito.times((int)2))).updateCAS((String)Mockito.eq((Object)"bar"), Mockito.eq((Object)"stuff"), Mockito.any());
    }

    @Test
    public void testCacheUpdateFail() throws Exception {
        String key = "foo";
        HttpCacheEntry existingValue = HttpTestUtils.makeCacheEntry();
        final HttpCacheEntry updatedValue = HttpTestUtils.makeCacheEntry();
        Mockito.when((Object)this.impl.digestToStorageKey("foo")).thenReturn((Object)"bar");
        Mockito.when((Object)this.impl.getForUpdateCAS("bar")).thenReturn((Object)"stuff");
        Mockito.when((Object)this.impl.getStorageObject((Object)"stuff")).thenReturn((Object)TestAbstractSerializingCacheStorage.serialize("foo", existingValue));
        Mockito.when((Object)this.impl.updateCAS((String)Mockito.eq((Object)"bar"), Mockito.eq((Object)"stuff"), Mockito.any())).thenReturn((Object)false, (Object[])new Boolean[]{false, false, true});
        try {
            this.impl.updateEntry("foo", new HttpCacheUpdateCallback(){

                public HttpCacheEntry update(HttpCacheEntry existing) throws ResourceIOException {
                    return updatedValue;
                }
            });
            Assert.fail((String)"HttpCacheUpdateException expected");
        }
        catch (HttpCacheUpdateException ignore) {
            // empty catch block
        }
        ((AbstractBinaryCacheStorage)Mockito.verify(this.impl, (VerificationMode)Mockito.times((int)3))).getForUpdateCAS("bar");
        ((AbstractBinaryCacheStorage)Mockito.verify(this.impl, (VerificationMode)Mockito.times((int)3))).getStorageObject((Object)"stuff");
        ((AbstractBinaryCacheStorage)Mockito.verify(this.impl, (VerificationMode)Mockito.times((int)3))).updateCAS((String)Mockito.eq((Object)"bar"), Mockito.eq((Object)"stuff"), Mockito.any());
    }
}

