/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.client5.http.impl.cache.HeapResource;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.apache.hc.core5.util.LangUtils;
import org.junit.Assert;

public class HttpTestUtils {
    private static final String[] HOP_BY_HOP_HEADERS = new String[]{"Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade"};
    private static final String[] MULTI_HEADERS = new String[]{"Accept", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Allow", "Cache-Control", "Connection", "Content-Encoding", "Content-Language", "Expect", "Pragma", "Proxy-Authenticate", "TE", "Trailer", "Transfer-Encoding", "Upgrade", "Via", "Warning", "WWW-Authenticate"};
    private static final String[] SINGLE_HEADERS = new String[]{"Accept-Ranges", "Age", "Authorization", "Content-Length", "Content-Location", "Content-MD5", "Content-Range", "Content-Type", "Date", "ETag", "Expires", "From", "Host", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since", "Last-Modified", "Location", "Max-Forwards", "Proxy-Authorization", "Range", "Referer", "Retry-After", "Server", "User-Agent", "Vary"};
    public static final String[] ENTITY_HEADERS = new String[]{"Allow", "Content-Encoding", "Content-Language", "Content-Length", "Content-Location", "Content-MD5", "Content-Range", "Content-Type", "Expires", "Last-Modified"};

    public static boolean isHopByHopHeader(String name) {
        for (String s : HOP_BY_HOP_HEADERS) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMultiHeader(String name) {
        for (String s : MULTI_HEADERS) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSingleHeader(String name) {
        for (String s : SINGLE_HEADERS) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean equivalent(HttpEntity e1, HttpEntity e2) throws Exception {
        InputStream i1 = e1.getContent();
        InputStream i2 = e2.getContent();
        if (i1 == null && i2 == null) {
            return true;
        }
        if (i1 == null || i2 == null) {
            return false;
        }
        int b1 = -1;
        while ((b1 = i1.read()) != -1) {
            if (b1 == i2.read()) continue;
            return false;
        }
        return -1 == i2.read();
    }

    public static String getCanonicalHeaderValue(HttpMessage r, String name) {
        if (HttpTestUtils.isSingleHeader(name)) {
            Header h = r.getFirstHeader(name);
            return h != null ? h.getValue() : null;
        }
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (Header h : r.getHeaders(name)) {
            if (!first) {
                buf.append(", ");
            }
            buf.append(h.getValue().trim());
            first = false;
        }
        return buf.toString();
    }

    public static boolean isEndToEndHeaderSubset(HttpMessage r1, HttpMessage r2) {
        for (Header h : r1.getAllHeaders()) {
            String r2val;
            String r1val;
            if (HttpTestUtils.isHopByHopHeader(h.getName()) || (r1val = HttpTestUtils.getCanonicalHeaderValue(r1, h.getName())).equals(r2val = HttpTestUtils.getCanonicalHeaderValue(r2, h.getName()))) continue;
            return false;
        }
        return true;
    }

    public static boolean semanticallyTransparent(ClassicHttpResponse r1, ClassicHttpResponse r2) throws Exception {
        boolean statusLinesEquivalent;
        boolean entitiesEquivalent = HttpTestUtils.equivalent(r1.getEntity(), r2.getEntity());
        if (!entitiesEquivalent) {
            return false;
        }
        boolean bl = statusLinesEquivalent = LangUtils.equals((Object)r1.getReasonPhrase(), (Object)r2.getReasonPhrase()) && r1.getCode() == r2.getCode();
        if (!statusLinesEquivalent) {
            return false;
        }
        return HttpTestUtils.isEndToEndHeaderSubset((HttpMessage)r1, (HttpMessage)r2);
    }

    public static boolean equivalent(ProtocolVersion v1, ProtocolVersion v2) {
        return LangUtils.equals((Object)(v1 != null ? v1 : HttpVersion.DEFAULT), (Object)(v2 != null ? v2 : HttpVersion.DEFAULT));
    }

    public static boolean equivalent(HttpRequest r1, HttpRequest r2) {
        return HttpTestUtils.equivalent(r1.getVersion(), r2.getVersion()) && LangUtils.equals((Object)r1.getMethod(), (Object)r2.getMethod()) && LangUtils.equals((Object)r1.getRequestUri(), (Object)r2.getRequestUri()) && HttpTestUtils.isEndToEndHeaderSubset((HttpMessage)r1, (HttpMessage)r2);
    }

    public static boolean equivalent(HttpResponse r1, HttpResponse r2) {
        return HttpTestUtils.equivalent(r1.getVersion(), r2.getVersion()) && r1.getCode() == r2.getCode() && LangUtils.equals((Object)r1.getReasonPhrase(), (Object)r2.getReasonPhrase()) && HttpTestUtils.isEndToEndHeaderSubset((HttpMessage)r1, (HttpMessage)r2);
    }

    public static byte[] getRandomBytes(int nbytes) {
        byte[] bytes = new byte[nbytes];
        new Random().nextBytes(bytes);
        return bytes;
    }

    public static ByteArrayBuffer getRandomBuffer(int nbytes) {
        ByteArrayBuffer buf = new ByteArrayBuffer(nbytes);
        buf.setLength(nbytes);
        new Random().nextBytes(buf.array());
        return buf;
    }

    public static HttpEntity makeBody(int nbytes) {
        return new ByteArrayEntity(HttpTestUtils.getRandomBytes(nbytes));
    }

    public static HttpCacheEntry makeCacheEntry(Date requestDate, Date responseDate) {
        Date when = new Date((responseDate.getTime() + requestDate.getTime()) / 2L);
        return HttpTestUtils.makeCacheEntry(requestDate, responseDate, HttpTestUtils.getStockHeaders(when));
    }

    public static Header[] getStockHeaders(Date when) {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)when)), new BasicHeader("Server", (Object)"MockServer/1.0")};
        return headers;
    }

    public static HttpCacheEntry makeCacheEntry(Date requestDate, Date responseDate, Header[] headers) {
        byte[] bytes = HttpTestUtils.getRandomBytes(128);
        return HttpTestUtils.makeCacheEntry(requestDate, responseDate, headers, bytes);
    }

    public static HttpCacheEntry makeCacheEntry(Date requestDate, Date responseDate, Header[] headers, byte[] bytes) {
        Map<String, String> variantMap = null;
        return HttpTestUtils.makeCacheEntry(requestDate, responseDate, headers, bytes, variantMap);
    }

    public static HttpCacheEntry makeCacheEntry(Map<String, String> variantMap) {
        Date now = new Date();
        return HttpTestUtils.makeCacheEntry(now, now, HttpTestUtils.getStockHeaders(now), HttpTestUtils.getRandomBytes(128), variantMap);
    }

    public static HttpCacheEntry makeCacheEntry(Date requestDate, Date responseDate, Header[] headers, byte[] bytes, Map<String, String> variantMap) {
        return new HttpCacheEntry(requestDate, responseDate, 200, headers, (Resource)new HeapResource(bytes), variantMap);
    }

    public static HttpCacheEntry makeCacheEntry(Header[] headers, byte[] bytes) {
        Date now = new Date();
        return HttpTestUtils.makeCacheEntry(now, now, headers, bytes);
    }

    public static HttpCacheEntry makeCacheEntry(byte[] bytes) {
        return HttpTestUtils.makeCacheEntry(HttpTestUtils.getStockHeaders(new Date()), bytes);
    }

    public static HttpCacheEntry makeCacheEntry(Header[] headers) {
        return HttpTestUtils.makeCacheEntry(headers, HttpTestUtils.getRandomBytes(128));
    }

    public static HttpCacheEntry makeCacheEntry() {
        Date now = new Date();
        return HttpTestUtils.makeCacheEntry(now, now);
    }

    public static HttpCacheEntry makeCacheEntryWithNoRequestMethodOrEntity(Header[] headers) {
        Date now = new Date();
        return new HttpCacheEntry(now, now, 200, headers, null, null);
    }

    public static HttpCacheEntry makeCacheEntryWithNoRequestMethod(Header[] headers) {
        Date now = new Date();
        return new HttpCacheEntry(now, now, 200, headers, (Resource)new HeapResource(HttpTestUtils.getRandomBytes(128)), null);
    }

    public static HttpCacheEntry make204CacheEntryWithNoRequestMethod(Header[] headers) {
        Date now = new Date();
        return new HttpCacheEntry(now, now, 204, headers, null, null);
    }

    public static HttpCacheEntry makeHeadCacheEntry(Header[] headers) {
        Date now = new Date();
        return new HttpCacheEntry(now, now, 200, headers, null, null);
    }

    public static HttpCacheEntry makeHeadCacheEntryWithNoRequestMethod(Header[] headers) {
        Date now = new Date();
        return new HttpCacheEntry(now, now, 200, headers, null, null);
    }

    public static ClassicHttpResponse make200Response() {
        BasicClassicHttpResponse out = new BasicClassicHttpResponse(200, "OK");
        out.setHeader("Date", (Object)DateUtils.formatDate((Date)new Date()));
        out.setHeader("Server", (Object)"MockOrigin/1.0");
        out.setHeader("Content-Length", (Object)"128");
        out.setEntity(HttpTestUtils.makeBody(128));
        return out;
    }

    public static final ClassicHttpResponse make200Response(Date date, String cacheControl) {
        ClassicHttpResponse response = HttpTestUtils.make200Response();
        response.setHeader("Date", (Object)DateUtils.formatDate((Date)date));
        response.setHeader("Cache-Control", (Object)cacheControl);
        response.setHeader("Etag", (Object)"\"etag\"");
        return response;
    }

    public static ClassicHttpResponse make304Response() {
        return new BasicClassicHttpResponse(304, "Not modified");
    }

    public static final void assert110WarningFound(HttpResponse response) {
        boolean found110Warning = false;
        Iterator it = MessageSupport.iterate((MessageHeaders)response, (String)"Warning");
        while (it.hasNext()) {
            HeaderElement elt = (HeaderElement)it.next();
            String[] parts = elt.getName().split("\\s");
            if (!"110".equals(parts[0])) continue;
            found110Warning = true;
            break;
        }
        Assert.assertTrue((boolean)found110Warning);
    }

    public static ClassicHttpRequest makeDefaultRequest() {
        return new BasicClassicHttpRequest("GET", "/");
    }

    public static ClassicHttpRequest makeDefaultHEADRequest() {
        return new BasicClassicHttpRequest("HEAD", "/");
    }

    public static ClassicHttpResponse make500Response() {
        return new BasicClassicHttpResponse(500, "Internal Server Error");
    }

    public static Map<String, String> makeDefaultVariantMap(String key, String value) {
        HashMap<String, String> variants = new HashMap<String, String>();
        variants.put(key, value);
        return variants;
    }
}

