/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public class HttpCacheEntryMatcher
extends BaseMatcher<HttpCacheEntry> {
    private final HttpCacheEntry expectedValue;

    public HttpCacheEntryMatcher(HttpCacheEntry expectedValue) {
        this.expectedValue = expectedValue;
    }

    public boolean matches(Object item) {
        if (item instanceof HttpCacheEntry) {
            try {
                byte[] otherContent;
                Object[] otherHeaders;
                Date otherResponseDate;
                Date otherRequestDate;
                HttpCacheEntry otherValue = (HttpCacheEntry)item;
                int expectedStatus = this.expectedValue.getStatus();
                int otherStatus = otherValue.getStatus();
                if (expectedStatus != otherStatus) {
                    return false;
                }
                Date expectedRequestDate = this.expectedValue.getRequestDate();
                if (!Objects.equals(expectedRequestDate, otherRequestDate = otherValue.getRequestDate())) {
                    return false;
                }
                Date expectedResponseDate = this.expectedValue.getResponseDate();
                if (!Objects.equals(expectedResponseDate, otherResponseDate = otherValue.getResponseDate())) {
                    return false;
                }
                Object[] expectedHeaders = this.expectedValue.getAllHeaders();
                if (!Arrays.deepEquals(expectedHeaders, otherHeaders = otherValue.getAllHeaders())) {
                    return false;
                }
                Resource expectedResource = this.expectedValue.getResource();
                byte[] expectedContent = expectedResource != null ? expectedResource.get() : null;
                Resource otherResource = otherValue.getResource();
                byte[] byArray = otherContent = otherResource != null ? otherResource.get() : null;
                if (!Arrays.equals(expectedContent, otherContent)) {
                    return false;
                }
            }
            catch (ResourceIOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendValue((Object)this.expectedValue);
    }

    @Factory
    public static Matcher<HttpCacheEntry> equivalent(HttpCacheEntry target) {
        return new HttpCacheEntryMatcher(target);
    }
}

