/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.impl.cache.BasicHttpCache;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CachingExec;
import org.apache.hc.client5.http.impl.cache.HttpCache;
import org.apache.hc.client5.http.impl.cache.HttpTestUtils;
import org.apache.hc.client5.http.impl.cache.RequestEquivalent;
import org.apache.hc.client5.http.impl.cache.ResponseEquivalent;
import org.apache.hc.client5.http.impl.classic.ClassicRequestCopier;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.easymock.IExpectationSetters;
import org.junit.Before;

public abstract class AbstractProtocolTest {
    protected static final int MAX_BYTES = 1024;
    protected static final int MAX_ENTRIES = 100;
    protected int entityLength = 128;
    protected HttpHost host;
    protected HttpRoute route;
    protected HttpEntity body;
    protected HttpClientContext context;
    protected ExecChain mockExecChain;
    protected ExecRuntime mockEndpoint;
    protected HttpCache mockCache;
    protected ClassicHttpRequest request;
    protected ClassicHttpResponse originResponse;
    protected CacheConfig config;
    protected ExecChainHandler impl;
    protected HttpCache cache;

    public static ClassicHttpRequest eqRequest(ClassicHttpRequest in) {
        EasyMock.reportMatcher((IArgumentMatcher)new RequestEquivalent((HttpRequest)in));
        return null;
    }

    public static HttpResponse eqResponse(HttpResponse in) {
        EasyMock.reportMatcher((IArgumentMatcher)new ResponseEquivalent(in));
        return null;
    }

    public static ClassicHttpResponse eqCloseableResponse(ClassicHttpResponse in) {
        EasyMock.reportMatcher((IArgumentMatcher)new ResponseEquivalent((HttpResponse)in));
        return null;
    }

    @Before
    public void setUp() {
        this.host = new HttpHost("foo.example.com", 80);
        this.route = new HttpRoute(this.host);
        this.body = HttpTestUtils.makeBody(this.entityLength);
        this.request = new BasicClassicHttpRequest("GET", "/foo");
        this.context = HttpClientContext.create();
        this.originResponse = HttpTestUtils.make200Response();
        this.config = CacheConfig.custom().setMaxCacheEntries(100).setMaxObjectSize(1024L).build();
        this.cache = new BasicHttpCache(this.config);
        this.mockExecChain = (ExecChain)EasyMock.createNiceMock(ExecChain.class);
        this.mockEndpoint = (ExecRuntime)EasyMock.createNiceMock(ExecRuntime.class);
        this.mockCache = (HttpCache)EasyMock.createNiceMock(HttpCache.class);
        this.impl = this.createCachingExecChain(this.cache, this.config);
    }

    public ClassicHttpResponse execute(ClassicHttpRequest request) throws IOException, HttpException {
        return this.impl.execute(ClassicRequestCopier.INSTANCE.copy(request), new ExecChain.Scope("test", this.route, request, this.mockEndpoint, this.context), this.mockExecChain);
    }

    protected ExecChainHandler createCachingExecChain(HttpCache cache, CacheConfig config) {
        return new CachingExec(cache, config);
    }

    protected boolean supportsRangeAndContentRangeHeaders(ExecChainHandler impl) {
        return impl instanceof CachingExec && ((CachingExec)impl).supportsRangeAndContentRangeHeaders();
    }

    protected void replayMocks() {
        EasyMock.replay((Object[])new Object[]{this.mockExecChain});
        EasyMock.replay((Object[])new Object[]{this.mockCache});
    }

    protected void verifyMocks() {
        EasyMock.verify((Object[])new Object[]{this.mockExecChain});
        EasyMock.verify((Object[])new Object[]{this.mockCache});
    }

    protected IExpectationSetters<ClassicHttpResponse> backendExpectsAnyRequest() throws Exception {
        ClassicHttpResponse resp = this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class));
        return EasyMock.expect((Object)resp);
    }

    protected IExpectationSetters<ClassicHttpResponse> backendExpectsAnyRequestAndReturn(ClassicHttpResponse response) throws Exception {
        ClassicHttpResponse resp = this.mockExecChain.proceed((ClassicHttpRequest)EasyMock.isA(ClassicHttpRequest.class), (ExecChain.Scope)EasyMock.isA(ExecChain.Scope.class));
        return EasyMock.expect((Object)resp).andReturn((Object)response);
    }

    protected void emptyMockCacheExpectsNoPuts() throws Exception {
        this.mockExecChain = (ExecChain)EasyMock.createNiceMock(ExecChain.class);
        this.mockCache = (HttpCache)EasyMock.createNiceMock(HttpCache.class);
        this.impl = new CachingExec(this.mockCache, this.config);
        EasyMock.expect((Object)this.mockCache.getCacheEntry((HttpHost)EasyMock.isA(HttpHost.class), (HttpRequest)EasyMock.isA(HttpRequest.class))).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.mockCache.getVariantCacheEntriesWithEtags((HttpHost)EasyMock.isA(HttpHost.class), (HttpRequest)EasyMock.isA(HttpRequest.class))).andReturn(new HashMap()).anyTimes();
        this.mockCache.flushCacheEntriesFor((HttpHost)EasyMock.isA(HttpHost.class), (HttpRequest)EasyMock.isA(HttpRequest.class));
        EasyMock.expectLastCall().anyTimes();
        this.mockCache.flushCacheEntriesFor((HttpHost)EasyMock.isA(HttpHost.class), (HttpRequest)EasyMock.isA(HttpRequest.class));
        EasyMock.expectLastCall().anyTimes();
        this.mockCache.flushInvalidatedCacheEntriesFor((HttpHost)EasyMock.isA(HttpHost.class), (HttpRequest)EasyMock.isA(HttpRequest.class));
        EasyMock.expectLastCall().anyTimes();
        this.mockCache.flushInvalidatedCacheEntriesFor((HttpHost)EasyMock.isA(HttpHost.class), (HttpRequest)EasyMock.isA(HttpRequest.class), (HttpResponse)EasyMock.isA(HttpResponse.class));
        EasyMock.expectLastCall().anyTimes();
    }

    protected void behaveAsNonSharedCache() {
        this.config = CacheConfig.custom().setMaxCacheEntries(100).setMaxObjectSize(1024L).setSharedCache(false).build();
        this.impl = new CachingExec(this.cache, this.config);
    }
}

