/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.cache;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHttpCacheEntry {
    private Date now;
    private Date elevenSecondsAgo;
    private Date nineSecondsAgo;
    private Resource mockResource;
    private HttpCacheEntry entry;

    @Before
    public void setUp() {
        this.now = new Date();
        this.elevenSecondsAgo = new Date(this.now.getTime() - 11000L);
        this.nineSecondsAgo = new Date(this.now.getTime() - 9000L);
        this.mockResource = (Resource)Mockito.mock(Resource.class);
    }

    private HttpCacheEntry makeEntry(Header[] headers) {
        return new HttpCacheEntry(this.elevenSecondsAgo, this.nineSecondsAgo, 200, headers, this.mockResource);
    }

    @Test
    public void testGetHeadersReturnsCorrectHeaders() {
        Header[] headers = new Header[]{new BasicHeader("foo", (Object)"fooValue"), new BasicHeader("bar", (Object)"barValue1"), new BasicHeader("bar", (Object)"barValue2")};
        this.entry = this.makeEntry(headers);
        Assert.assertEquals((long)2L, (long)this.entry.getHeaders("bar").length);
    }

    @Test
    public void testGetFirstHeaderReturnsCorrectHeader() {
        Header[] headers = new Header[]{new BasicHeader("foo", (Object)"fooValue"), new BasicHeader("bar", (Object)"barValue1"), new BasicHeader("bar", (Object)"barValue2")};
        this.entry = this.makeEntry(headers);
        Assert.assertEquals((Object)"barValue1", (Object)this.entry.getFirstHeader("bar").getValue());
    }

    @Test
    public void testGetHeadersReturnsEmptyArrayIfNoneMatch() {
        Header[] headers = new Header[]{new BasicHeader("foo", (Object)"fooValue"), new BasicHeader("bar", (Object)"barValue1"), new BasicHeader("bar", (Object)"barValue2")};
        this.entry = this.makeEntry(headers);
        Assert.assertEquals((long)0L, (long)this.entry.getHeaders("baz").length);
    }

    @Test
    public void testGetFirstHeaderReturnsNullIfNoneMatch() {
        Header[] headers = new Header[]{new BasicHeader("foo", (Object)"fooValue"), new BasicHeader("bar", (Object)"barValue1"), new BasicHeader("bar", (Object)"barValue2")};
        this.entry = this.makeEntry(headers);
        Assert.assertEquals(null, (Object)this.entry.getFirstHeader("quux"));
    }

    @Test
    public void testCacheEntryWithNoVaryHeaderDoesNotHaveVariants() {
        Header[] headers = new Header[]{};
        this.entry = this.makeEntry(headers);
        Assert.assertFalse((boolean)this.entry.hasVariants());
    }

    @Test
    public void testCacheEntryWithOneVaryHeaderHasVariants() {
        Header[] headers = new Header[]{new BasicHeader("Vary", (Object)"User-Agent")};
        this.entry = this.makeEntry(headers);
        Assert.assertTrue((boolean)this.entry.hasVariants());
    }

    @Test
    public void testCacheEntryWithMultipleVaryHeadersHasVariants() {
        Header[] headers = new Header[]{new BasicHeader("Vary", (Object)"User-Agent"), new BasicHeader("Vary", (Object)"Accept-Encoding")};
        this.entry = this.makeEntry(headers);
        Assert.assertTrue((boolean)this.entry.hasVariants());
    }

    @Test
    public void testCacheEntryWithVaryStarHasVariants() {
        Header[] headers = new Header[]{new BasicHeader("Vary", (Object)"*")};
        this.entry = this.makeEntry(headers);
        Assert.assertTrue((boolean)this.entry.hasVariants());
    }

    @Test
    public void mustProvideRequestDate() {
        try {
            new HttpCacheEntry(null, new Date(), 200, new Header[0], this.mockResource);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void mustProvideResponseDate() {
        try {
            new HttpCacheEntry(new Date(), null, 200, new Header[0], this.mockResource);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void mustProvideResponseHeaders() {
        try {
            new HttpCacheEntry(new Date(), new Date(), 200, null, this.mockResource);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void statusCodeComesFromOriginalStatusLine() {
        this.entry = new HttpCacheEntry(new Date(), new Date(), 200, new Header[0], this.mockResource);
        Assert.assertEquals((long)200L, (long)this.entry.getStatus());
    }

    @Test
    public void canGetOriginalRequestDate() {
        Date requestDate = new Date();
        this.entry = new HttpCacheEntry(requestDate, new Date(), 200, new Header[0], this.mockResource);
        Assert.assertSame((Object)requestDate, (Object)this.entry.getRequestDate());
    }

    @Test
    public void canGetOriginalResponseDate() {
        Date responseDate = new Date();
        this.entry = new HttpCacheEntry(new Date(), responseDate, 200, new Header[0], this.mockResource);
        Assert.assertSame((Object)responseDate, (Object)this.entry.getResponseDate());
    }

    @Test
    public void canGetOriginalResource() {
        this.entry = new HttpCacheEntry(new Date(), new Date(), 200, new Header[0], this.mockResource);
        Assert.assertSame((Object)this.mockResource, (Object)this.entry.getResource());
    }

    @Test
    public void canGetOriginalHeaders() {
        Header[] headers = new Header[]{new BasicHeader("Server", (Object)"MockServer/1.0"), new BasicHeader("Date", (Object)DateUtils.formatDate((Date)this.now))};
        this.entry = new HttpCacheEntry(new Date(), new Date(), 200, headers, this.mockResource);
        Header[] result = this.entry.getAllHeaders();
        Assert.assertEquals((long)headers.length, (long)result.length);
        for (int i = 0; i < headers.length; ++i) {
            Assert.assertEquals((Object)headers[i], (Object)result[i]);
        }
    }

    @Test
    public void canConstructWithoutVariants() {
        new HttpCacheEntry(new Date(), new Date(), 200, new Header[0], this.mockResource);
    }

    @Test
    public void canProvideVariantMap() {
        new HttpCacheEntry(new Date(), new Date(), 200, new Header[0], this.mockResource, new HashMap());
    }

    @Test
    public void canRetrieveOriginalVariantMap() {
        HashMap<String, String> variantMap = new HashMap<String, String>();
        variantMap.put("A", "B");
        variantMap.put("C", "D");
        this.entry = new HttpCacheEntry(new Date(), new Date(), 200, new Header[0], this.mockResource, variantMap);
        Map result = this.entry.getVariantMap();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)"B", result.get("A"));
        Assert.assertEquals((Object)"D", result.get("C"));
    }

    @Test
    public void retrievedVariantMapIsNotModifiable() {
        HashMap<String, String> variantMap = new HashMap<String, String>();
        variantMap.put("A", "B");
        variantMap.put("C", "D");
        this.entry = new HttpCacheEntry(new Date(), new Date(), 200, new Header[0], this.mockResource, variantMap);
        Map result = this.entry.getVariantMap();
        try {
            result.remove("A");
            Assert.fail((String)"Should have thrown exception");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            result.put("E", "F");
            Assert.fail((String)"Should have thrown exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void canConvertToString() {
        this.entry = new HttpCacheEntry(new Date(), new Date(), 200, new Header[0], this.mockResource);
        Assert.assertNotNull((Object)this.entry.toString());
        Assert.assertFalse((boolean)"".equals(this.entry.toString()));
    }

    @Test
    public void testMissingDateHeaderIsIgnored() {
        Header[] headers = new Header[]{};
        this.entry = new HttpCacheEntry(new Date(), new Date(), 200, headers, this.mockResource);
        Assert.assertNull((Object)this.entry.getDate());
    }

    @Test
    public void testMalformedDateHeaderIsIgnored() {
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)"asdf")};
        this.entry = new HttpCacheEntry(new Date(), new Date(), 200, headers, this.mockResource);
        Assert.assertNull((Object)this.entry.getDate());
    }

    @Test
    public void testValidDateHeaderIsParsed() {
        long nowMs = System.currentTimeMillis();
        Date date = new Date(nowMs - nowMs % 1000L);
        Header[] headers = new Header[]{new BasicHeader("Date", (Object)DateUtils.formatDate((Date)date))};
        this.entry = new HttpCacheEntry(new Date(), new Date(), 200, headers, this.mockResource);
        Date dateHeaderValue = this.entry.getDate();
        Assert.assertNotNull((Object)dateHeaderValue);
        Assert.assertEquals((long)date.getTime(), (long)dateHeaderValue.getTime());
    }

    @Test
    public void testGetMethodReturnsCorrectRequestMethod() {
        Header[] headers = new Header[]{new BasicHeader("foo", (Object)"fooValue"), new BasicHeader("bar", (Object)"barValue1"), new BasicHeader("bar", (Object)"barValue2")};
        this.entry = this.makeEntry(headers);
        Assert.assertEquals((Object)"GET", (Object)this.entry.getRequestMethod());
    }
}

