/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.Map;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.impl.cache.Variant;
import org.apache.hc.client5.http.methods.HttpRequestWrapper;
import org.apache.hc.core5.annotation.Immutable;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ProtocolException;

@Immutable
class ConditionalRequestBuilder {
    ConditionalRequestBuilder() {
    }

    public HttpRequestWrapper buildConditionalRequest(HttpRequestWrapper request, HttpCacheEntry cacheEntry) throws ProtocolException {
        Header lastModified;
        HttpRequestWrapper newRequest = HttpRequestWrapper.wrap((HttpRequest)request.getOriginal(), (HttpHost)request.getTarget());
        newRequest.setHeaders(request.getAllHeaders());
        Header eTag = cacheEntry.getFirstHeader("ETag");
        if (eTag != null) {
            newRequest.setHeader("If-None-Match", (Object)eTag.getValue());
        }
        if ((lastModified = cacheEntry.getFirstHeader("Last-Modified")) != null) {
            newRequest.setHeader("If-Modified-Since", (Object)lastModified.getValue());
        }
        boolean mustRevalidate = false;
        block0: for (Header h : cacheEntry.getHeaders("Cache-Control")) {
            for (HeaderElement elt : h.getElements()) {
                if (!"must-revalidate".equalsIgnoreCase(elt.getName()) && !"proxy-revalidate".equalsIgnoreCase(elt.getName())) continue;
                mustRevalidate = true;
                continue block0;
            }
        }
        if (mustRevalidate) {
            newRequest.addHeader("Cache-Control", (Object)"max-age=0");
        }
        return newRequest;
    }

    public HttpRequestWrapper buildConditionalRequestFromVariants(HttpRequestWrapper request, Map<String, Variant> variants) {
        HttpRequestWrapper newRequest = HttpRequestWrapper.wrap((HttpRequest)request.getOriginal(), (HttpHost)request.getTarget());
        newRequest.setHeaders(request.getAllHeaders());
        StringBuilder etags = new StringBuilder();
        boolean first = true;
        for (String etag : variants.keySet()) {
            if (!first) {
                etags.append(",");
            }
            first = false;
            etags.append(etag);
        }
        newRequest.setHeader("If-None-Match", (Object)etags.toString());
        return newRequest;
    }

    public HttpRequestWrapper buildUnconditionalRequest(HttpRequestWrapper request, HttpCacheEntry entry) {
        HttpRequestWrapper newRequest = HttpRequestWrapper.wrap((HttpRequest)request.getOriginal(), (HttpHost)request.getTarget());
        newRequest.setHeaders(request.getAllHeaders());
        newRequest.addHeader("Cache-Control", (Object)"no-cache");
        newRequest.addHeader("Pragma", (Object)"no-cache");
        newRequest.removeHeaders("If-Range");
        newRequest.removeHeaders("If-Match");
        newRequest.removeHeaders("If-None-Match");
        newRequest.removeHeaders("If-Unmodified-Since");
        newRequest.removeHeaders("If-Modified-Since");
        return newRequest;
    }
}

