/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.core5.annotation.NotThreadSafe;
import org.apache.hc.core5.http.entity.AbstractHttpEntity;
import org.apache.hc.core5.util.Args;

@NotThreadSafe
class CombinedEntity
extends AbstractHttpEntity {
    private final Resource resource;
    private final InputStream combinedStream;

    CombinedEntity(Resource resource, InputStream instream) throws IOException {
        this.resource = resource;
        this.combinedStream = new SequenceInputStream(new ResourceStream(resource.getInputStream()), instream);
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isStreaming() {
        return true;
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        return this.combinedStream;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        Args.notNull((Object)outstream, (String)"Output stream");
        try (InputStream instream = this.getContent();){
            int l;
            byte[] tmp = new byte[2048];
            while ((l = instream.read(tmp)) != -1) {
                outstream.write(tmp, 0, l);
            }
        }
    }

    private void dispose() {
        this.resource.dispose();
    }

    class ResourceStream
    extends FilterInputStream {
        protected ResourceStream(InputStream in) {
            super(in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                CombinedEntity.this.dispose();
            }
        }
    }
}

