/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.sql.store;

import org.apache.gora.sql.store.SqlTypeInterface;

public class Column {
    private String tableName;
    private String name;
    private SqlTypeInterface.JdbcType jdbcType;
    private String sqlType;
    private boolean isPrimaryKey;
    private int length = -1;
    private int scale = -1;
    private MappingStrategy mappingStrategy;

    public Column() {
    }

    public Column(String name) {
        this.name = name;
    }

    public Column(String name, boolean isPrimaryKey, SqlTypeInterface.JdbcType jdbcType, String sqlType, int length, int scale) {
        this.name = name;
        this.isPrimaryKey = isPrimaryKey;
        this.jdbcType = jdbcType;
        this.length = length;
        this.scale = scale;
        this.mappingStrategy = MappingStrategy.SERIALIZED;
        this.sqlType = sqlType == null ? jdbcType.getSqlType() : sqlType;
    }

    public Column(String name, boolean isPrimaryKey, SqlTypeInterface.JdbcType jdbcType, int length, int scale) {
        this(name, isPrimaryKey, jdbcType, null, length, scale);
    }

    public Column(String name, boolean isPrimaryKey) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SqlTypeInterface.JdbcType getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(SqlTypeInterface.JdbcType jdbcType) {
        this.jdbcType = jdbcType;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getScaleOrLength() {
        return this.length > 0 ? this.length : this.scale;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public MappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    public void setMappingStrategy(MappingStrategy mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public static enum MappingStrategy {
        SERIALIZED,
        JOIN_TABLE,
        SECONDARY_TABLE;

    }
}

