/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.sql.statement;

import java.util.ArrayList;
import org.apache.gora.sql.statement.Where;
import org.apache.gora.util.StringUtils;

public class SelectStatement {
    private String selectStatement;
    private ArrayList<String> selectList;
    private String from;
    private Where where;
    private String groupBy;
    private String having;
    private String orderBy;
    private boolean orderByAsc = true;
    private long offset = -1L;
    private long limit = -1L;
    private boolean semicolon = true;

    public SelectStatement() {
        this.selectList = new ArrayList();
    }

    public SelectStatement(String from) {
        this();
        this.from = from;
    }

    public SelectStatement(String selectList, String from, String where, String orderBy) {
        this.selectStatement = selectList;
        this.from = from;
        this.setWhere(where);
        this.orderBy = orderBy;
    }

    public SelectStatement(String selectList, String from, Where where, String groupBy, String having, String orderBy, boolean orderByAsc, int offset, int limit, boolean semicolon) {
        this.selectStatement = selectList;
        this.from = from;
        this.where = where;
        this.groupBy = groupBy;
        this.having = having;
        this.orderBy = orderBy;
        this.orderByAsc = orderByAsc;
        this.offset = offset;
        this.limit = limit;
        this.semicolon = semicolon;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SELECT ");
        if (this.selectStatement != null) {
            builder.append(this.selectStatement);
        } else {
            StringUtils.join((StringBuilder)builder, this.selectList);
        }
        SelectStatement.append(builder, "FROM", this.from);
        SelectStatement.append(builder, "WHERE", this.where);
        SelectStatement.append(builder, "GROUP BY", this.groupBy);
        SelectStatement.append(builder, "HAVING", this.having);
        SelectStatement.append(builder, "ORDER BY", this.orderBy);
        if (this.orderBy != null) {
            builder.append(" ").append(this.orderByAsc ? " ASC " : " DESC ");
        }
        if (this.limit > 0L) {
            builder.append(" LIMIT ").append(this.limit);
        }
        if (this.offset >= 0L) {
            builder.append(" OFFSET ").append(this.offset);
        }
        if (this.semicolon) {
            builder.append(";");
        }
        return builder.toString();
    }

    public void addWhere(String part) {
        if (this.where == null) {
            this.where = new Where();
        }
        this.where.addPart(part);
    }

    static void append(StringBuilder builder, String sqlClause, Object clause) {
        if (clause != null && !clause.toString().equals("")) {
            builder.append(" ").append(sqlClause).append(" ").append(clause.toString());
        }
    }

    public void setSelectStatement(String selectStatement) {
        this.selectStatement = selectStatement;
    }

    public String getSelectStatement() {
        return this.selectStatement;
    }

    public ArrayList<String> getSelectList() {
        return this.selectList;
    }

    public void setSelectList(ArrayList<String> selectList) {
        this.selectList = selectList;
    }

    public void addToSelectList(String selectField) {
        this.selectList.add(selectField);
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public Where getWhere() {
        return this.where;
    }

    public void setWhere(Where where) {
        this.where = where;
    }

    public void setWhere(String where) {
        this.where = new Where(where);
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public String getHaving() {
        return this.having;
    }

    public void setHaving(String having) {
        this.having = having;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public boolean isOrderByAsc() {
        return this.orderByAsc;
    }

    public void setOrderByAsc(boolean orderByAsc) {
        this.orderByAsc = orderByAsc;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public boolean isSemicolon() {
        return this.semicolon;
    }

    public void setSemicolon(boolean semicolon) {
        this.semicolon = semicolon;
    }
}

