/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.sql.statement;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.sql.statement.InsertUpdateStatement;
import org.apache.gora.sql.store.Column;
import org.apache.gora.sql.store.SqlMapping;
import org.apache.gora.sql.store.SqlStore;
import org.apache.gora.util.StringUtils;

public class MySqlInsertUpdateStatement<K, V extends PersistentBase>
extends InsertUpdateStatement<K, V> {
    public MySqlInsertUpdateStatement(SqlStore<K, V> store, SqlMapping mapping, String tableName) {
        super(store, mapping, tableName);
    }

    @Override
    public PreparedStatement toStatement(Connection connection) throws SQLException {
        int i = 0;
        StringBuilder builder = new StringBuilder("INSERT INTO ");
        builder.append(this.tableName);
        StringUtils.join((StringBuilder)builder.append(" ("), this.columnMap.keySet()).append(" )");
        builder.append("VALUES (");
        for (i = 0; i < this.columnMap.size(); ++i) {
            if (i != 0) {
                builder.append(",");
            }
            builder.append("?");
        }
        builder.append(") ON DUPLICATE KEY UPDATE ");
        Column primaryColumn = this.mapping.getPrimaryColumn();
        Object key = ((InsertUpdateStatement.ColumnData)this.columnMap.get((Object)primaryColumn.getName())).object;
        i = 0;
        for (String s : this.columnMap.keySet()) {
            if (s.equals(primaryColumn.getName())) continue;
            if (i != 0) {
                builder.append(",");
            }
            builder.append(s).append("=").append("?");
            ++i;
        }
        builder.append(";");
        PreparedStatement insert = connection.prepareStatement(builder.toString());
        int psIndex = 1;
        for (int count = 0; count < 2; ++count) {
            for (Map.Entry e : this.columnMap.entrySet()) {
                InsertUpdateStatement.ColumnData columnData = (InsertUpdateStatement.ColumnData)e.getValue();
                Column column = columnData.column;
                Schema fieldSchema = columnData.schema;
                Object fieldValue = columnData.object;
                if (column.getName().equals(primaryColumn.getName())) {
                    if (count == 1) continue;
                    if (primaryColumn.getScaleOrLength() > 0) {
                        insert.setObject(psIndex++, key, primaryColumn.getJdbcType().getOrder(), primaryColumn.getScaleOrLength());
                        continue;
                    }
                    insert.setObject(psIndex++, key, primaryColumn.getJdbcType().getOrder());
                    continue;
                }
                try {
                    this.store.setObject(insert, psIndex++, fieldValue, fieldSchema, column);
                }
                catch (IOException ex) {
                    throw new SQLException(ex);
                }
            }
        }
        return insert;
    }
}

