/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.sql.statement;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.sql.statement.InsertUpdateStatement;
import org.apache.gora.sql.store.Column;
import org.apache.gora.sql.store.SqlMapping;
import org.apache.gora.sql.store.SqlStore;

public class HSqlInsertUpdateStatement<K, T extends PersistentBase>
extends InsertUpdateStatement<K, T> {
    public HSqlInsertUpdateStatement(SqlStore<K, T> store, SqlMapping mapping, String tableName) {
        super(store, mapping, tableName);
    }

    private String getVariable(String columnName) {
        return "v_" + columnName;
    }

    @Override
    public PreparedStatement toStatement(Connection connection) throws SQLException {
        StringBuilder buf = new StringBuilder("MERGE INTO ");
        buf.append(this.tableName).append(" USING (VALUES(");
        int i = 0;
        for (Map.Entry e : this.columnMap.entrySet()) {
            Column column = ((InsertUpdateStatement.ColumnData)e.getValue()).column;
            if (i != 0) {
                buf.append(",");
            }
            buf.append("CAST(? AS ");
            buf.append(column.getJdbcType().toString());
            if (column.getScaleOrLength() > 0) {
                buf.append("(").append(column.getScaleOrLength()).append(")");
            }
            buf.append(")");
            ++i;
        }
        buf.append(")) AS vals(");
        i = 0;
        for (String columnName : this.columnMap.keySet()) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(this.getVariable(columnName));
            ++i;
        }
        buf.append(") ON ").append(this.tableName).append(".").append(this.mapping.getPrimaryColumnName()).append("=vals.");
        buf.append(this.getVariable(this.mapping.getPrimaryColumnName()));
        buf.append(" WHEN MATCHED THEN UPDATE SET ");
        i = 0;
        for (String columnName : this.columnMap.keySet()) {
            if (columnName.equals(this.mapping.getPrimaryColumnName())) continue;
            if (i != 0) {
                buf.append(",");
            }
            buf.append(this.tableName).append(".").append(columnName).append("=vals.");
            buf.append(this.getVariable(columnName));
            ++i;
        }
        buf.append(" WHEN NOT MATCHED THEN INSERT (");
        i = 0;
        for (String columnName : this.columnMap.keySet()) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(columnName);
            ++i;
        }
        i = 0;
        buf.append(") VALUES ");
        for (String columnName : this.columnMap.keySet()) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append("vals.").append(this.getVariable(columnName));
            ++i;
        }
        Column primaryColumn = this.mapping.getPrimaryColumn();
        PreparedStatement insert = connection.prepareStatement(buf.toString());
        int psIndex = 1;
        for (Map.Entry e : this.columnMap.entrySet()) {
            InsertUpdateStatement.ColumnData cd = (InsertUpdateStatement.ColumnData)e.getValue();
            Column column = cd.column;
            if (column.getName().equals(primaryColumn.getName())) {
                Object key = ((InsertUpdateStatement.ColumnData)this.columnMap.get((Object)primaryColumn.getName())).object;
                if (primaryColumn.getScaleOrLength() > 0) {
                    insert.setObject(psIndex++, key, primaryColumn.getJdbcType().getOrder(), primaryColumn.getScaleOrLength());
                    continue;
                }
                insert.setObject(psIndex++, key, primaryColumn.getJdbcType().getOrder());
                continue;
            }
            try {
                this.store.setObject(insert, psIndex++, cd.object, cd.schema, cd.column);
            }
            catch (IOException ex) {
                throw new SQLException(ex);
            }
        }
        return insert;
    }
}

