/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.sql.query;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.gora.query.Query;
import org.apache.gora.query.impl.ResultBase;
import org.apache.gora.sql.store.SqlStore;
import org.apache.gora.sql.util.SqlUtils;
import org.apache.gora.store.DataStore;

public class SqlResult<K, T extends PersistentBase>
extends ResultBase<K, T> {
    private ResultSet resultSet;
    private PreparedStatement statement;

    public SqlResult(DataStore<K, T> dataStore, Query<K, T> query, ResultSet resultSet, PreparedStatement statement) {
        super(dataStore, query);
        this.resultSet = resultSet;
        this.statement = statement;
    }

    protected boolean nextInner() throws IOException {
        try {
            if (!this.resultSet.next()) {
                this.close();
                return false;
            }
            SqlStore sqlStore = (SqlStore)this.dataStore;
            this.key = sqlStore.readPrimaryKey(this.resultSet);
            this.persistent = sqlStore.readObject(this.resultSet, (PersistentBase)this.persistent, this.query.getFields());
            return true;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public void close() throws IOException {
        SqlUtils.close(this.resultSet);
        SqlUtils.close(this.statement);
    }

    public float getProgress() throws IOException {
        return 0.0f;
    }
}

