/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gora.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.gora.GoraTestDriver;
import org.apache.gora.sql.store.SqlStore;
import org.apache.gora.util.ClassLoadingUtils;
import org.apache.hadoop.util.StringUtils;
import org.hsqldb.Server;

public class GoraSqlTestDriver
extends GoraTestDriver {
    protected static final String DRIVER_CLASS_PROPERTY = "jdbc.driver";
    protected static final String URL_PROPERTY = "jdbc.url";
    protected static final String USERNAME_PROPERTY = "jdbc.user";
    protected static final String PASSWORD_PROPERTY = "jdbc.password";
    private static final String HSQLDB_PORT = System.getProperty("hsqldb.port") != null ? System.getProperty("hsqldb.port") : "9001";
    private static final String JDBC_URL = String.format("jdbc:hsqldb:hsql://localhost:%s/goratest", HSQLDB_PORT);
    private static final String JDBC_DRIVER_CLASS = "org.hsqldb.jdbcDriver";
    private Server server;
    private boolean initialized = false;
    private boolean startHsqldb = true;

    public GoraSqlTestDriver() {
        super(SqlStore.class);
    }

    private void startHsqldbServer() {
        log.info("Starting HSQLDB server");
        this.server = new Server();
        this.server.setDatabasePath(0, System.getProperty("test.build.data", "/tmp") + "/goratest");
        this.server.setDatabaseName(0, "goratest");
        this.server.setDaemon(true);
        this.server.setPort(Integer.parseInt(HSQLDB_PORT));
        this.server.start();
    }

    public void setUpClass() throws Exception {
        super.setUpClass();
        if (!this.initialized && this.startHsqldb) {
            this.startHsqldbServer();
            this.initialized = true;
        }
    }

    public void tearDownClass() throws Exception {
        super.tearDownClass();
        try {
            if (this.server != null) {
                this.server.shutdown();
            }
        }
        catch (Throwable ex) {
            log.warn("Exception occurred while shutting down HSQLDB :" + StringUtils.stringifyException((Throwable)ex));
        }
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    private Connection createConnection(String driverClassName, String url) throws Exception {
        ClassLoadingUtils.loadClass((String)driverClassName);
        Connection connection = DriverManager.getConnection(url);
        connection.setAutoCommit(false);
        return connection;
    }

    protected void setProperties(Properties properties) {
        super.setProperties(properties);
        properties.setProperty("gora.sqlstore.jdbc.driver", JDBC_DRIVER_CLASS);
        properties.setProperty("gora.sqlstore.jdbc.url", JDBC_URL);
        properties.remove("gora.sqlstore.jdbc.user");
        properties.remove("gora.sqlstore.jdbc.password");
    }
}

